/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.bo.finance;

import cn.hutool.core.collection.CollectionUtil;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceBillStatusUpdateServiceReqBo;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceBillStatusUpdateServiceRspBo;
import com.tydic.fsc.common.busi.api.finance.FscFinanceRefundStatusUpdateBusiService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscFinancePayItemMapper;
import com.tydic.fsc.dao.FscFinanceRefundItemMapper;
import com.tydic.fsc.dao.FscOrdStateChgLogMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscRefundFinanceMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscFinancePayItemPO;
import com.tydic.fsc.po.FscFinanceRefundItemPO;
import com.tydic.fsc.po.FscOrdStateChgLogPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscRefundFinancePO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscFinanceRefundStatusUpdateBusiServiceImpl
implements FscFinanceRefundStatusUpdateBusiService {
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscRefundFinanceMapper fscRefundFinanceMapper;
    @Autowired
    private FscOrdStateChgLogMapper fscOrdStateChgLogMapper;
    @Autowired
    private FscFinanceRefundItemMapper fscFinanceRefundItemMapper;
    @Autowired
    private FscFinancePayItemMapper fscFinancePayItemMapper;

    @Override
    public FscFinanceBillStatusUpdateServiceRspBo dealRefundStatusUpdate(FscFinanceBillStatusUpdateServiceReqBo reqBo) {
        ArrayList<Long> refundIds = new ArrayList<Long>(reqBo.getBillIds().size());
        for (String billId : reqBo.getBillIds()) {
            refundIds.add(Long.valueOf(billId));
        }
        FscRefundFinancePO refundFinancePO = new FscRefundFinancePO();
        refundFinancePO.setRefundIds(refundIds);
        refundFinancePO.setPostingStatus(Integer.valueOf(reqBo.getBillStatus()));
        refundFinancePO.setPostingDate(new Date());
        this.fscRefundFinanceMapper.updatePostStatus(refundFinancePO);
        FscOrderRefundPO orderRefundPO = new FscOrderRefundPO();
        orderRefundPO.setRefundIdList(refundIds);
        orderRefundPO.setRefundStatus(FscConstants.RefundInvoiceStatus.FINANCE_POST);
        this.fscOrderRefundMapper.updateByRefundIds(orderRefundPO);
        ArrayList<FscOrdStateChgLogPO> chgLogPOList = new ArrayList<FscOrdStateChgLogPO>();
        for (String billId : reqBo.getBillIds()) {
            FscOrdStateChgLogPO chgLogPO = new FscOrdStateChgLogPO();
            chgLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            chgLogPO.setFscOrderId(Long.valueOf(billId));
            chgLogPO.setChgTime(new Date());
            chgLogPO.setOldState(FscConstants.RefundInvoiceStatus.FINANCE_AUDITED);
            chgLogPO.setOperId(reqBo.getOperAccount());
            chgLogPO.setNewState(FscConstants.RefundInvoiceStatus.FINANCE_POST);
            chgLogPOList.add(chgLogPO);
        }
        this.fscOrdStateChgLogMapper.insertBatch(chgLogPOList);
        if (reqBo.getBillType().equals(5)) {
            int count = this.fscOrderRefundMapper.checkStatus(refundIds, FscConstants.RefundInvoiceStatus.FINANCE_AUDITED);
            if (count != reqBo.getBillIds().size()) {
                throw new FscBusinessException("190000", "\u5f53\u524d\u9000\u7968\u5355\u72b6\u6001\u4e0d\u5141\u8bb8\u8fc7\u5e10\uff01");
            }
            FscFinanceRefundItemPO refundItemQueryPO = new FscFinanceRefundItemPO();
            refundItemQueryPO.setRefundIds(refundIds);
            List financerefundItemList = this.fscFinanceRefundItemMapper.getList(refundItemQueryPO);
            if (!CollectionUtil.isEmpty((Collection)financerefundItemList)) {
                ArrayList<FscFinancePayItemPO> refundingItemList = new ArrayList<FscFinancePayItemPO>(financerefundItemList.size());
                ArrayList<FscFinancePayItemPO> refundItemList = new ArrayList<FscFinancePayItemPO>(financerefundItemList.size());
                for (FscFinanceRefundItemPO financeRefundItemPO : financerefundItemList) {
                    FscFinancePayItemPO refundItemPO = new FscFinancePayItemPO();
                    refundItemPO.setFinancePayItemId(financeRefundItemPO.getPayItemId());
                    refundItemPO.setRefundAmt(financeRefundItemPO.getRefundAmt());
                    refundItemPO.setRefundAmtLocal(financeRefundItemPO.getRefundAmtLocal());
                    refundItemList.add(refundItemPO);
                    FscFinancePayItemPO refundingItemPO = new FscFinancePayItemPO();
                    refundingItemPO.setFinancePayItemId(financeRefundItemPO.getPayItemId());
                    refundingItemPO.setRefundAmt(financeRefundItemPO.getRefundAmt().negate());
                    refundingItemPO.setRefundAmtLocal(financeRefundItemPO.getRefundAmtLocal().negate());
                    refundingItemList.add(refundingItemPO);
                }
                count = this.fscFinancePayItemMapper.updateRefundAmtBatch(refundItemList);
                if (count != refundItemList.size()) {
                    throw new FscBusinessException("190000", "\u66f4\u65b0\u5df2\u9000\u6b3e\u91d1\u989d\u5931\u8d25\uff01");
                }
                count = this.fscFinancePayItemMapper.updateRefundingAmtBatch(refundingItemList);
                if (count != refundingItemList.size()) {
                    throw new FscBusinessException("190000", "\u66f4\u65b0\u9000\u6b3e\u4e2d\u91d1\u989d\u5931\u8d25\uff01");
                }
            }
        }
        FscFinanceBillStatusUpdateServiceRspBo rspBo = new FscFinanceBillStatusUpdateServiceRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

