/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Joiner;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameReqBO;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameRspBO;
import com.tydic.authority.busi.bo.UserBO;
import com.tydic.fsc.bo.FscApprovalTaskQueryBO;
import com.tydic.fsc.busibase.atom.api.FscSendNotificationExtAtomService;
import com.tydic.fsc.busibase.atom.bo.FscSendNotificationExtAtomReqBO;
import com.tydic.fsc.common.busi.api.FscAccountRegulationCreateBusiService;
import com.tydic.fsc.common.busi.bo.FscAccountRegulationCreateBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscAccountRegulationCreateBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscAccountRegulationMapper;
import com.tydic.fsc.dao.FscTaskCandidateMapper;
import com.tydic.fsc.enums.FscRegulationStatusEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscAccountRegulationPO;
import com.tydic.fsc.po.FscTaskCandidatePO;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscAccountRegulationCreateBusiServiceImpl
implements FscAccountRegulationCreateBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscAccountRegulationCreateBusiServiceImpl.class);
    @Autowired
    private FscAccountRegulationMapper fscAccountRegulationMapper;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private FscTaskCandidateMapper fscTaskCandidateMapper;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    @Autowired
    private FscSendNotificationExtAtomService fscSendNotificationExtAtomService;

    @Override
    public FscAccountRegulationCreateBusiRspBO dealAccountRegulation(FscAccountRegulationCreateBusiReqBO reqBO) {
        FscAccountPO queryVo = new FscAccountPO();
        queryVo.setId(reqBO.getAccountIdIn());
        queryVo.setBusiType(reqBO.getBusiTypeIn().toString());
        FscAccountPO accountIn = this.fscAccountMapper.getModelBy(queryVo);
        if (accountIn == null) {
            throw new FscBusinessException("190000", "\u8c03\u5165\u8d26\u6237\u4e0d\u5b58\u5728\uff01");
        }
        queryVo.setId(reqBO.getAccountIdOut());
        FscAccountPO accountOut = this.fscAccountMapper.getModelBy(queryVo);
        if (accountOut == null) {
            throw new FscBusinessException("190000", "\u8c03\u51fa\u8d26\u6237\u4e0d\u5b58\u5728\uff01");
        }
        if (reqBO.getRegulationAmount().compareTo(accountOut.getAdvanceAmount().subtract(accountOut.getFreezeAmount()).subtract(accountOut.getUseAmount())) > 0) {
            throw new FscBusinessException("190000", "\u8c03\u51fa\u8d26\u6237\u53ef\u7528\u8d44\u91d1\u4e0d\u8db3\uff01");
        }
        accountIn.setFreezeAmount(accountIn.getFreezeAmount().add(reqBO.getRegulationAmount()));
        accountOut.setFreezeAmount(accountOut.getFreezeAmount().subtract(reqBO.getRegulationAmount()));
        FscAccountRegulationPO fscAccountRegulationPo = new FscAccountRegulationPO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)fscAccountRegulationPo);
        fscAccountRegulationPo.setRegulationId(Long.valueOf(Sequence.getInstance().nextId()));
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setEncodedRuleCode("REGULATION_NO");
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(1));
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        fscAccountRegulationPo.setRegulationNo((String)encodedSerialGetServiceRspBO.getSerialNoList().get(0));
        fscAccountRegulationPo.setApplyDate(new Date());
        fscAccountRegulationPo.setUserName(reqBO.getName());
        long sequenceId = Sequence.getInstance().nextId();
        fscAccountRegulationPo.setRegulationId(Long.valueOf(sequenceId));
        this.fscAccountMapper.updateAmount(accountIn);
        this.fscAccountMapper.updateAmount(accountOut);
        this.invokeUacTask(reqBO, sequenceId);
        FscTaskCandidatePO taskPo = new FscTaskCandidatePO();
        taskPo.setFscOrderId(Long.valueOf(sequenceId));
        List pendAuditPostIdList = this.fscTaskCandidateMapper.getPendAuditPostIdList(taskPo);
        if (!CollectionUtils.isEmpty((Collection)pendAuditPostIdList)) {
            List auditedPostIdList = pendAuditPostIdList.stream().map(FscApprovalTaskQueryBO::getTaskOperId).distinct().collect(Collectors.toList());
            fscAccountRegulationPo.setRegulationStation(Joiner.on((String)",").join(auditedPostIdList) + ",");
            DycStationOrgSelectUserNameReqBO dycStationOrgSelectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
            dycStationOrgSelectUserNameReqBO.setStationId(Long.valueOf(((FscApprovalTaskQueryBO)pendAuditPostIdList.get(0)).getTaskOperId()));
            DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.dycStationOrgSelectUserNameService.selectUserName(dycStationOrgSelectUserNameReqBO);
            if (dycStationOrgSelectUserNameRspBO != null && !CollectionUtils.isEmpty((Collection)dycStationOrgSelectUserNameRspBO.getUserList())) {
                FscSendNotificationExtAtomReqBO fscSendNotificationExtAtomReqBO = new FscSendNotificationExtAtomReqBO();
                fscSendNotificationExtAtomReqBO.setTitel(fscAccountRegulationPo.getRegulationNo() + "\u9519\u8d26\u8c03\u8d26\u7533\u8bf7\u5355" + "\u5f85\u5ba1\u6279");
                fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u5f85\u5ba1\u6279\u7684\u9519\u8d26\u8c03\u8d26\u7533\u8bf7\u5355" + fscAccountRegulationPo.getRegulationNo() + "\u5df2\u63d0\u4ea4\u81f3\u60a8\u5904\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
                fscSendNotificationExtAtomReqBO.setUserId(reqBO.getUserId());
                fscSendNotificationExtAtomReqBO.setReceiveIds(dycStationOrgSelectUserNameRspBO.getUserList().stream().map(UserBO::getUserId).distinct().collect(Collectors.toList()));
                this.fscSendNotificationExtAtomService.sendNotification(fscSendNotificationExtAtomReqBO);
            }
        }
        fscAccountRegulationPo.setStatus(FscRegulationStatusEnum.TO_APPROVED.getCode());
        int count = this.fscAccountRegulationMapper.insert(fscAccountRegulationPo);
        if (count < 0) {
            throw new FscBusinessException("190000", "\u65b0\u589e\u8c03\u8d26\u7533\u8bf7\u5931\u8d25\uff01");
        }
        FscAccountRegulationCreateBusiRspBO rspBO = new FscAccountRegulationCreateBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void invokeUacTask(FscAccountRegulationCreateBusiReqBO reqBO, Long sequenceId) {
        UacNoTaskAuditCreateReqBO auditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        auditCreateReqBO.setCreateOperId(reqBO.getUserId().toString());
        auditCreateReqBO.setCreateOperName(reqBO.getName());
        auditCreateReqBO.setCreateOperDept(reqBO.getOrgName());
        auditCreateReqBO.setOrgId(reqBO.getOrgId().toString());
        auditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        auditCreateReqBO.setMenuId("M001005");
        ArrayList<UacNoTaskAuditCreateInfoReqBO> createBusiReqBO = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(FscConstants.AuditObjType.ACCOUNT_REGULATION_APPROVAL);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(sequenceId);
        ArrayList<ApprovalObjBO> approvalObjBOList = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjId(sequenceId.toString());
        approvalObjBO.setObjName("\u8c03\u8d26\u5ba1\u6279");
        approvalObjBO.setObjType(FscConstants.AuditObjType.ACCOUNT_REGULATION_APPROVAL);
        approvalObjBOList.add(approvalObjBO);
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjBOList);
        createBusiReqBO.add(uacNoTaskAuditCreateInfoReqBO);
        auditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(auditCreateReqBO);
        log.info("\u8c03\u7528\u5ba1\u6279\u51fa\u53c2================" + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new FscBusinessException("194203", uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        if (uacNoTaskAuditCreateRspBO.getNotFindFlag().booleanValue()) {
            throw new FscBusinessException("190000", "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u4ed8\u6b3e\u5ba1\u6279\u6d41\uff01");
        }
    }
}

