/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.common.ability.bo.FscOrderItemTempAddAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscOrderItemTempAddAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscOrderItemTempAddBO;
import com.tydic.fsc.common.busi.api.FscOrderItemTempAddBusiService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentTempMapper;
import com.tydic.fsc.dao.FscOrderItemTempMapper;
import com.tydic.fsc.dao.FscOrderRelationTempMapper;
import com.tydic.fsc.enums.FscPayTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentTempPO;
import com.tydic.fsc.po.FscOrderItemTempPO;
import com.tydic.fsc.po.FscOrderRelationTempPO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscOrderItemTempAddBusiServiceImpl
implements FscOrderItemTempAddBusiService {
    @Autowired
    private FscOrderRelationTempMapper fscOrderRelationTempMapper;
    @Autowired
    private FscOrderItemTempMapper fscOrderItemTempMapper;
    @Autowired
    private FscAttachmentTempMapper fscAttachmentTempMapper;

    @Override
    public FscOrderItemTempAddAbilityRspBO orderItemTempAdd(FscOrderItemTempAddAbilityReqBO reqBO) {
        Map<Long, List<FscOrderItemTempAddBO>> collect;
        if (reqBO.getFscOrderId() == null) {
            reqBO.setFscOrderId(Long.valueOf(Sequence.getInstance().nextId()));
        }
        if (Objects.nonNull(reqBO.getFscOrderId()) && Objects.nonNull(reqBO.getContractId())) {
            FscAttachmentTempPO fscAttachmentTempPO = new FscAttachmentTempPO();
            fscAttachmentTempPO.setFscOrderId(reqBO.getFscOrderId());
            fscAttachmentTempPO.setObjId(reqBO.getContractId());
            this.fscAttachmentTempMapper.deleteBy(fscAttachmentTempPO);
            FscOrderRelationTempPO fscOrderRelationTempPO = new FscOrderRelationTempPO();
            fscOrderRelationTempPO.setFscOrderId(reqBO.getFscOrderId());
            fscOrderRelationTempPO.setContractId(reqBO.getContractId());
            this.fscOrderRelationTempMapper.deleteBy(fscOrderRelationTempPO);
            FscOrderItemTempPO fscOrderItemTempPO = new FscOrderItemTempPO();
            fscOrderItemTempPO.setFscOrderId(reqBO.getFscOrderId());
            fscOrderItemTempPO.setContractId(reqBO.getContractId());
            this.fscOrderItemTempMapper.deleteBy(fscOrderItemTempPO);
        }
        if ((collect = reqBO.getRows().stream().collect(Collectors.groupingBy(FscOrderItemTempAddBO::getOrderPayItemId))).keySet().size() != reqBO.getRows().size()) {
            throw new FscBusinessException("198888", "\u5b58\u5728\u76f8\u540c\u7684\u3010\u7ed3\u7b97\u9636\u6bb5\u3011");
        }
        ArrayList<FscOrderRelationTempPO> fscOrderRelationTempPOS = new ArrayList<FscOrderRelationTempPO>();
        for (Long l : collect.keySet()) {
            FscOrderRelationTempPO fscOrderRelationTempPO = new FscOrderRelationTempPO();
            fscOrderRelationTempPO.setContractSegmentName(reqBO.getContractSegmentName());
            fscOrderRelationTempPO.setContractSegmentCode(reqBO.getContractSegmentCode());
            fscOrderRelationTempPO.setEstimateBillGuid(reqBO.getEstimateBillGuid());
            fscOrderRelationTempPO.setEstimateBillCode(reqBO.getEstimateBillCode());
            fscOrderRelationTempPO.setEstimateBizTypeCode(reqBO.getEstimateBizTypeCode());
            fscOrderRelationTempPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscOrderRelationTempPO.setFscOrderId(reqBO.getFscOrderId());
            fscOrderRelationTempPO.setOrderId(l);
            fscOrderRelationTempPO.setAcceptOrderId(l);
            fscOrderRelationTempPO.setContractId(reqBO.getContractId());
            fscOrderRelationTempPO.setContractNo(reqBO.getContractNo());
            fscOrderRelationTempPO.setContractName(reqBO.getContractName());
            fscOrderRelationTempPO.setContractType("2");
            fscOrderRelationTempPO.setContractCategory(reqBO.getContractCategory());
            fscOrderRelationTempPO.setBusinessType(reqBO.getBusinessType());
            if (collect.get(l).get(0).getSettleAmt() != null) {
                List settleAmtList = collect.get(l).stream().map(FscOrderItemTempAddBO::getSettleAmt).collect(Collectors.toList());
                BigDecimal amount = new BigDecimal(0);
                for (BigDecimal each : settleAmtList) {
                    amount = amount.add(each);
                }
                fscOrderRelationTempPO.setSettleAmt(amount);
                fscOrderRelationTempPO.setAmount(amount);
            }
            fscOrderRelationTempPO.setContractRemark(reqBO.getContractRemark());
            if (FscPayTypeEnum.WARRANTY.getCode().toString().equals(collect.get(l).get(0).getContractSettleState())) {
                fscOrderRelationTempPO.setQualityAmt(fscOrderRelationTempPO.getSettleAmt());
            }
            fscOrderRelationTempPOS.add(fscOrderRelationTempPO);
        }
        this.fscOrderRelationTempMapper.insertBatch(fscOrderRelationTempPOS);
        ArrayList<FscOrderItemTempPO> orderItemTempPOS = new ArrayList<FscOrderItemTempPO>();
        for (FscOrderItemTempAddBO each : reqBO.getRows()) {
            FscOrderItemTempPO orderItemTempPO = new FscOrderItemTempPO();
            BeanUtils.copyProperties((Object)each, (Object)orderItemTempPO);
            orderItemTempPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            orderItemTempPO.setFscOrderId(reqBO.getFscOrderId());
            orderItemTempPO.setOrderId(each.getOrderPayItemId());
            orderItemTempPO.setOrderItemId(each.getOrderPayItemId());
            orderItemTempPO.setAcceptOrderId(each.getOrderPayItemId());
            orderItemTempPO.setPrice(each.getPayAmount());
            orderItemTempPO.setTotalAmt(each.getPayAmount());
            orderItemTempPO.setAmt(each.getSettleAmt());
            orderItemTempPO.setTotalNum(new BigDecimal(1));
            orderItemTempPO.setContractId(reqBO.getContractId());
            orderItemTempPO.setContractNo(reqBO.getContractNo());
            orderItemTempPO.setContractName(reqBO.getContractName());
            orderItemTempPO.setTaxRate(each.getTaxRate());
            orderItemTempPO.setUntaxAmt(orderItemTempPO.getAmt().divide(new BigDecimal(1).add(each.getTaxRate()), 2, RoundingMode.HALF_UP));
            orderItemTempPO.setTaxAmt(orderItemTempPO.getAmt().subtract(orderItemTempPO.getUntaxAmt()));
            if (FscPayTypeEnum.WARRANTY.getCode().toString().equals(orderItemTempPO.getContractSettleState())) {
                orderItemTempPO.setQualityAmt(orderItemTempPO.getAmt());
            }
            orderItemTempPOS.add(orderItemTempPO);
        }
        this.fscOrderItemTempMapper.insertBatch(orderItemTempPOS);
        if (!CollectionUtils.isEmpty((Collection)reqBO.getAttachmentList())) {
            ArrayList<FscAttachmentTempPO> arrayList = new ArrayList<FscAttachmentTempPO>();
            for (AttachmentBO attachmentBO : reqBO.getAttachmentList()) {
                FscAttachmentTempPO fscAttachmentPO = new FscAttachmentTempPO();
                BeanUtils.copyProperties((Object)attachmentBO, (Object)fscAttachmentPO);
                fscAttachmentPO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                fscAttachmentPO.setAttachmentType(FscConstants.AttachmentType.FSC_ORDER);
                fscAttachmentPO.setObjId(reqBO.getContractId());
                fscAttachmentPO.setObjType(FscConstants.AttachmentObjType.FSC_ORDER);
                fscAttachmentPO.setFscOrderId(reqBO.getFscOrderId());
                arrayList.add(fscAttachmentPO);
            }
            this.fscAttachmentTempMapper.insertBatch(arrayList);
        }
        FscOrderItemTempAddAbilityRspBO fscOrderItemTempAddAbilityRspBO = new FscOrderItemTempAddAbilityRspBO();
        fscOrderItemTempAddAbilityRspBO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderItemTempAddAbilityRspBO.setRespCode("0000");
        fscOrderItemTempAddAbilityRspBO.setRespDesc("\u6210\u529f");
        return fscOrderItemTempAddAbilityRspBO;
    }
}

