/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl.finance;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.ability.api.FscBillSettlAndOrderItemListQueryAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillSettlAndOrderItemListQueryAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillSettlAndOrderItemListQueryAbilityRspBO;
import com.tydic.fsc.common.ability.api.FscComInvoiceListPageQueryAbilityService;
import com.tydic.fsc.common.ability.api.FscComRefundAbnormalOrderListQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscComInvoiceListQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComInvoiceListQueryAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscComRefundAbnormalOrderListQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComRefundAbnormalOrderListQueryAbilityRspBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceSaveRefundInvoiceTempAbnormalListBo;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceSaveRefundInvoiceTempInvoiceListBo;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceSaveRefundInvoiceTempReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceSaveRefundInvoiceTempRspBO;
import com.tydic.fsc.common.ability.bo.finance.FscRefundInvoiceDetailBO;
import com.tydic.fsc.common.busi.api.finance.FscFinanceSaveRefundInvoiceTempCreateBusiService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentTempMapper;
import com.tydic.fsc.dao.FscInvoiceRefundRelationTempMapper;
import com.tydic.fsc.dao.FscOrderRelationTempMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentTempPO;
import com.tydic.fsc.po.FscInvoiceRefundRelationTempPo;
import com.tydic.fsc.po.FscOrderRelationTempPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscFinanceSaveRefundInvoiceTempCreateBusiServiceImpl
implements FscFinanceSaveRefundInvoiceTempCreateBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceSaveRefundInvoiceTempCreateBusiServiceImpl.class);
    @Autowired
    private FscInvoiceRefundRelationTempMapper fscInvoiceRefundRelationTempMapper;
    @Autowired
    private FscOrderRelationTempMapper fscOrderRelationTempMapper;
    @Autowired
    private FscAttachmentTempMapper fscAttachmentTempMapper;
    @Autowired
    private FscComInvoiceListPageQueryAbilityService fscComInvoiceListPageQueryAbilityService;
    @Autowired
    private FscComRefundAbnormalOrderListQueryAbilityService fscComRefundAbnormalOrderListQueryAbilityService;
    @Autowired
    private FscBillSettlAndOrderItemListQueryAbilityService fscBillSettlAndOrderItemListQueryAbilityService;

    @Override
    public FscFinanceSaveRefundInvoiceTempRspBO saveRefundInvoiceTemp(FscFinanceSaveRefundInvoiceTempReqBO reqBO) {
        int attachmentResult;
        int abnormalOrderRelationTempResult;
        int invoiceRefundRelationTempResult;
        this.valid(reqBO);
        ArrayList invoiceRefundRelationTempPoAddList = new ArrayList();
        ArrayList abnormalOrderRelationTempPOAddList = new ArrayList();
        ArrayList fscAttachmentTempPOAddList = new ArrayList();
        for (FscRefundInvoiceDetailBO detailBO : reqBO.getDetailBOList()) {
            List invoiceList;
            String invoiceTempString;
            List invoiceRefundRelationTempPOList;
            FscComInvoiceListQueryAbilityReqBO invoiceReq = new FscComInvoiceListQueryAbilityReqBO();
            invoiceReq.setFscOrderId(detailBO.getFscOrderId());
            invoiceReq.setContractId(detailBO.getContractId());
            FscComInvoiceListQueryAbilityRspBO invoiceListPageQuery = this.fscComInvoiceListPageQueryAbilityService.getComInvoiceListPageQuery(invoiceReq);
            if (!CollectionUtils.isEmpty((Collection)invoiceListPageQuery.getRows()) && !CollectionUtils.isEmpty((Collection)(invoiceRefundRelationTempPOList = JSONObject.parseArray((String)(invoiceTempString = JSONObject.toJSONString(invoiceList = invoiceListPageQuery.getRows().stream().filter(item -> item.getStatus() != 2 && item.getStatus() != 3).collect(Collectors.toList()))), FscInvoiceRefundRelationTempPo.class)))) {
                invoiceRefundRelationTempPOList.stream().forEach(invoiceRefundRelationTempPO -> {
                    invoiceRefundRelationTempPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                    invoiceRefundRelationTempPO.setTempId(detailBO.getTempId());
                    invoiceRefundRelationTempPO.setFscOrderId(detailBO.getFscOrderId());
                    invoiceRefundRelationTempPO.setCreateTime(new Date());
                });
                invoiceRefundRelationTempPoAddList.addAll(invoiceRefundRelationTempPOList);
            }
            FscComRefundAbnormalOrderListQueryAbilityReqBO relationReq = new FscComRefundAbnormalOrderListQueryAbilityReqBO();
            relationReq.setFscOrderId(detailBO.getFscOrderId());
            relationReq.setContractId(detailBO.getContractId());
            FscComRefundAbnormalOrderListQueryAbilityRspBO relationListPageQuery = this.fscComRefundAbnormalOrderListQueryAbilityService.qryRefundAbnormalOrderList(relationReq);
            String abnormalTempString = JSONObject.toJSONString((Object)relationListPageQuery.getRows());
            List fscOrderRelationTempPOList = JSONObject.parseArray((String)abnormalTempString, FscOrderRelationTempPO.class);
            if (!CollectionUtils.isEmpty((Collection)fscOrderRelationTempPOList)) {
                fscOrderRelationTempPOList.stream().forEach(orderRelationTempPO -> {
                    orderRelationTempPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                    orderRelationTempPO.setTempId(detailBO.getTempId());
                    orderRelationTempPO.setRefundId(detailBO.getRefundId());
                });
                abnormalOrderRelationTempPOAddList.addAll(fscOrderRelationTempPOList);
            }
            FscBillSettlAndOrderItemListQueryAbilityReqBO attachmentReq = new FscBillSettlAndOrderItemListQueryAbilityReqBO();
            attachmentReq.setFscOrderId(detailBO.getFscOrderId());
            attachmentReq.setContractId(detailBO.getContractId());
            FscBillSettlAndOrderItemListQueryAbilityRspBO attachmentListPageQuery = this.fscBillSettlAndOrderItemListQueryAbilityService.querySettlAndOrderItemList(attachmentReq);
            String attachmentString = JSONObject.toJSONString((Object)attachmentListPageQuery.getAttachmentList());
            List attachmentTempPOList = JSONObject.parseArray((String)attachmentString, FscAttachmentTempPO.class);
            if (CollectionUtils.isEmpty((Collection)attachmentTempPOList)) continue;
            attachmentTempPOList.stream().forEach(attachmentTempPO -> {
                attachmentTempPO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                attachmentTempPO.setFscOrderId(detailBO.getTempId());
                attachmentTempPO.setObjId(detailBO.getContractId());
                attachmentTempPO.setAttachmentType(FscConstants.AttachmentType.REFUND_INVOICE);
                attachmentTempPO.setObjType(FscConstants.AttachmentObjType.REFUND_INVOICE);
            });
            fscAttachmentTempPOAddList.addAll(attachmentTempPOList);
        }
        if (!CollectionUtils.isEmpty(invoiceRefundRelationTempPoAddList) && (invoiceRefundRelationTempResult = this.fscInvoiceRefundRelationTempMapper.insertBatch(invoiceRefundRelationTempPoAddList)) != invoiceRefundRelationTempPoAddList.size()) {
            throw new FscBusinessException("198888", "\u63d2\u5165\u51b2\u9500\u53d1\u7968\u4e34\u65f6\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (!CollectionUtils.isEmpty(abnormalOrderRelationTempPOAddList) && (abnormalOrderRelationTempResult = this.fscOrderRelationTempMapper.insertBatch(abnormalOrderRelationTempPOAddList)) != abnormalOrderRelationTempPOAddList.size()) {
            throw new FscBusinessException("198888", "\u63d2\u5165\u51b2\u9500\u8ba2\u5355\u5f02\u5e38\u53d8\u66f4\u4e34\u65f6\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (!CollectionUtils.isEmpty(fscAttachmentTempPOAddList) && (attachmentResult = this.fscAttachmentTempMapper.insertBatch(fscAttachmentTempPOAddList)) != fscAttachmentTempPOAddList.size()) {
            throw new FscBusinessException("198888", "\u63d2\u5165\u9644\u4ef6\u96c6\u5408\u4e34\u65f6\u4fe1\u606f\u5931\u8d25\uff01");
        }
        FscFinanceSaveRefundInvoiceTempRspBO rspBO = new FscFinanceSaveRefundInvoiceTempRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void valid(FscFinanceSaveRefundInvoiceTempReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getDetailBOList())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u6570\u636e\u96c6\u5408[detailBOList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (FscRefundInvoiceDetailBO detailBO : reqBO.getDetailBOList()) {
            if (detailBO.getTempId() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u4e34\u65f6ID[tempId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (detailBO.getFscOrderId() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u7ed3\u7b97\u5355ID[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!CollectionUtils.isEmpty((Collection)detailBO.getInvoiceList())) {
                for (FscFinanceSaveRefundInvoiceTempInvoiceListBo invoiceTemp : detailBO.getInvoiceList()) {
                    if (invoiceTemp.getInvoiceId() == null) {
                        throw new FscBusinessException("191000", "\u5165\u53c2\u53d1\u7968ID[invoiceId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (invoiceTemp.getContractId() != null) continue;
                    throw new FscBusinessException("191000", "\u5165\u53c2\u5408\u540cID[contractId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
            }
            if (CollectionUtils.isEmpty((Collection)detailBO.getAbnormalList())) continue;
            for (FscFinanceSaveRefundInvoiceTempAbnormalListBo abnormal : detailBO.getAbnormalList()) {
                if (abnormal.getOrderId() == null) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u8ba2\u5355ID[orderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (abnormal.getContractId() == null) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u5408\u540cID[contractId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (abnormal.getContractNo() == null) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u5408\u540c\u7f16\u53f7[contractNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (abnormal.getContractName() != null) continue;
                throw new FscBusinessException("191000", "\u5165\u53c2\u5408\u540c\u540d\u79f0[contractName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
    }
}

