/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.tydic.fsc.common.ability.api.FscCheckZnQryAbilityService;
import com.tydic.fsc.common.ability.bo.FscCheckZnQryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscCheckZnQryAbilityRspBO;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscCheckZnQryAbilityService"})
public class FscCheckZnQryAbilityServiceImpl
implements FscCheckZnQryAbilityService {
    @Autowired
    private FscOrderMapper fscOrderMapper;

    @PostMapping(value={"qryCheckZn"})
    public FscCheckZnQryAbilityRspBO qryCheckZn(@RequestBody FscCheckZnQryAbilityReqBO reqBO) {
        if (Objects.isNull(reqBO.getOrderId())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[orderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getFuncAccountId())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[funcAccountId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getUnifyDeptId())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[unifyDeptId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ArrayList<String> orderNumbers = new ArrayList<String>();
        this.processOrders(this.fscOrderMapper.getCheckOrderNo(reqBO.getOrderId()), reqBO, orderNumbers);
        this.processOrders(this.fscOrderMapper.getCheckFKOrderNo(reqBO.getOrderId()), reqBO, orderNumbers);
        FscCheckZnQryAbilityRspBO rspBO = new FscCheckZnQryAbilityRspBO();
        rspBO.setOrderNoList(orderNumbers);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void processOrders(List<FscOrderPO> orders, FscCheckZnQryAbilityReqBO reqBO, List<String> result) {
        if (orders == null || orders.isEmpty()) {
            return;
        }
        orders.stream().filter(x -> !reqBO.getFuncAccountId().equals(Long.toString(x.getUnifyOrgId())) || !reqBO.getUnifyDeptId().equals(Long.toString(x.getUnifyDeptId()))).forEach(x -> result.add(x.getOrderNo()));
    }
}

