/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.FscDealOrderSettleStatusAbilityService;
import com.tydic.fsc.common.ability.bo.FscDealOrderSettleStatusAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscDealOrderSettleStatusAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscPayLogMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscPayLogPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.uoc.common.ability.api.PebUpdateOrderAbilityService;
import com.tydic.uoc.common.ability.api.UocSalesSingleDetailsListQueryAbilityService;
import com.tydic.uoc.common.ability.bo.PebUpdateOrderReqBO;
import com.tydic.uoc.common.ability.bo.PebUpdateOrderRspBO;
import com.tydic.uoc.common.ability.bo.UocPebChildOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocPebOrderItemAbilityBO;
import com.tydic.uoc.common.ability.bo.UocPebUpperOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscDealOrderSettleStatusAbilityService"})
public class FscDealOrderSettleStatusAbilityServiceImpl
implements FscDealOrderSettleStatusAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscDealOrderSettleStatusAbilityServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;
    public static final Integer TAB_ID = 30001;
    @Autowired
    private PebUpdateOrderAbilityService pebUpdateOrderAbilityService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscPayLogMapper fscPayLogMapper;
    @Autowired
    private UocSalesSingleDetailsListQueryAbilityService uocSalesSingleDetailsListQueryAbilityService;

    @PostMapping(value={"dealOrderSettleStatus"})
    public FscDealOrderSettleStatusAbilityRspBO dealOrderSettleStatus(@RequestBody FscDealOrderSettleStatusAbilityReqBO reqBO) {
        if (reqBO.getOrderId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[orderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscOrderPO querVo = new FscOrderPO();
        querVo.setOrderId(reqBO.getOrderId());
        querVo.setPayeeId(this.operationOrgId);
        BigDecimal invoiceAmt = this.fscOrderMapper.getInvoiceStatisticalByOrderId(reqBO.getOrderId(), this.operationOrgId);
        BigDecimal payAmt = this.fscOrderMapper.getPayStatisticalInfoByOrderId(reqBO.getOrderId(), this.operationOrgId);
        if (payAmt == null || BigDecimal.ZERO.compareTo(payAmt) == 0) {
            FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
            fscShouldPayPO.setOrderId(reqBO.getOrderId());
            fscShouldPayPO.setPayeeId(this.operationOrgId);
            List shouldList = this.fscShouldPayMapper.getList(fscShouldPayPO);
            if (CollectionUtils.isEmpty((Collection)shouldList)) {
                BigDecimal claimAmt = BigDecimal.ZERO;
                FscClaimDetailPO claimDetailPO = new FscClaimDetailPO();
                claimDetailPO.setOrderId(reqBO.getOrderId());
                claimDetailPO.setStatus("1");
                claimDetailPO.setClaimType("4");
                List fscClaimDetailPOS = this.fscClaimDetailMapper.queryAll(claimDetailPO);
                if (!CollectionUtils.isEmpty((Collection)fscClaimDetailPOS)) {
                    Iterator iterator = fscClaimDetailPOS.iterator();
                    while (iterator.hasNext()) {
                        FscClaimDetailPO e = (FscClaimDetailPO)iterator.next();
                        if (e.getClaimAmt() == null) continue;
                        claimAmt = claimAmt.add(e.getClaimAmt());
                    }
                }
                payAmt = claimAmt;
            }
        }
        BigDecimal orderAmt = BigDecimal.ZERO;
        UocSalesSingleDetailsListQueryReqBO uocSalesSingleDetailsListQueryReqBO = new UocSalesSingleDetailsListQueryReqBO();
        uocSalesSingleDetailsListQueryReqBO.setOrderId(reqBO.getOrderId());
        uocSalesSingleDetailsListQueryReqBO.setTabId(TAB_ID);
        uocSalesSingleDetailsListQueryReqBO.setPageSize(1000000);
        UocSalesSingleDetailsListQueryRspBO salesListRspBO = this.uocSalesSingleDetailsListQueryAbilityService.getUocSalesSingleDetailsListQuery(uocSalesSingleDetailsListQueryReqBO);
        if (!"0000".equals(salesListRspBO.getRespCode())) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff01");
        }
        FscDealOrderSettleStatusAbilityRspBO rspBO = new FscDealOrderSettleStatusAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (CollectionUtils.isEmpty((Collection)salesListRspBO.getRows()) || CollectionUtils.isEmpty((Collection)((UocPebUpperOrderAbilityBO)salesListRspBO.getRows().get(0)).getChildOrderList())) {
            return rspBO;
        }
        for (UocPebUpperOrderAbilityBO orderAbilityBO : salesListRspBO.getRows()) {
            for (UocPebOrderItemAbilityBO itemAbilityBO : ((UocPebChildOrderAbilityBO)orderAbilityBO.getChildOrderList().get(0)).getOrderItemList()) {
                BigDecimal orderNum = new BigDecimal(itemAbilityBO.getPurchaseCount()).subtract(new BigDecimal(itemAbilityBO.getReturnCount())).subtract(new BigDecimal(itemAbilityBO.getRefuseCount()));
                orderAmt = orderAmt.add(new BigDecimal(itemAbilityBO.getPurchasingPrice()).multiply(orderNum));
            }
        }
        log.debug("---------------\u540c\u6b65\u8ba2\u5355\u76f8\u5173\u7ed3\u7b97\u72b6\u6001\uff0c\u8ba2\u5355\u53f7\uff1a{}\uff1b\u8ba2\u5355\u91d1\u989d\uff1a{}", (Object)reqBO.getOrderId(), (Object)orderAmt);
        Integer payType = ((UocPebChildOrderAbilityBO)((UocPebUpperOrderAbilityBO)salesListRspBO.getRows().get(0)).getChildOrderList().get(0)).getPayType();
        String orderTye = ((UocPebChildOrderAbilityBO)((UocPebUpperOrderAbilityBO)salesListRspBO.getRows().get(0)).getChildOrderList().get(0)).getOrderType();
        if (Objects.nonNull(payType) && payType == 3) {
            payAmt = orderAmt;
        }
        log.debug("---------------\u540c\u6b65\u8ba2\u5355\u76f8\u5173\u7ed3\u7b97\u72b6\u6001\uff0c\u652f\u4ed8\u65b9\u5f0f\uff1a{}\uff1b\u8ba2\u5355\u7c7b\u578b\uff1a{} \u4ed8\u6b3e\u91d1\u989d\uff1a{}", new Object[]{payType, orderTye, payAmt});
        if (payType != null && payType == 4 && "0".equals(orderTye) && payAmt.compareTo(BigDecimal.ZERO) == 0) {
            BigDecimal reimbursementAmount = BigDecimal.ZERO;
            FscPayLogPO fscPayLogPO = new FscPayLogPO();
            fscPayLogPO.setBusiOrderId(reqBO.getOrderId());
            ArrayList<Integer> busiCategoryList = new ArrayList<Integer>();
            busiCategoryList.add(FscConstants.FscBusiCategory.ADVANCE_PAY);
            fscPayLogPO.setBusiCategoryList(busiCategoryList);
            List fscPayLogPOList = this.fscPayLogMapper.getList(fscPayLogPO);
            if (!CollectionUtils.isEmpty((Collection)fscPayLogPOList)) {
                for (FscPayLogPO po : fscPayLogPOList) {
                    reimbursementAmount = reimbursementAmount.add(po.getReimbursementAmount() == null ? BigDecimal.ZERO : po.getReimbursementAmount());
                    reimbursementAmount = reimbursementAmount.add(po.getAdvanceAmt() == null ? BigDecimal.ZERO : po.getAdvanceAmt());
                }
            }
            payAmt = reimbursementAmount;
        }
        if (invoiceAmt.compareTo(BigDecimal.ZERO) == 0 && payAmt.compareTo(BigDecimal.ZERO) == 0) {
            return new FscDealOrderSettleStatusAbilityRspBO();
        }
        String statusType = "";
        if (invoiceAmt.compareTo(BigDecimal.ZERO) > 0 && invoiceAmt.compareTo(orderAmt) < 0) {
            statusType = "5";
            if (payAmt.compareTo(BigDecimal.ZERO) > 0 && invoiceAmt.compareTo(orderAmt) < 0) {
                statusType = "6";
            } else if (payAmt.compareTo(orderAmt) >= 0) {
                statusType = "7";
            }
        } else if (invoiceAmt.compareTo(orderAmt) >= 0) {
            statusType = "8";
            if (payAmt.compareTo(BigDecimal.ZERO) > 0 && invoiceAmt.compareTo(orderAmt) < 0) {
                statusType = "9";
            } else if (payAmt.compareTo(orderAmt) >= 0) {
                statusType = "10";
            }
        } else if (payAmt.compareTo(BigDecimal.ZERO) > 0 && invoiceAmt.compareTo(orderAmt) < 0 && payAmt.compareTo(orderAmt) < 0) {
            statusType = "3";
        } else if (payAmt.compareTo(orderAmt) >= 0) {
            statusType = "4";
        }
        log.debug("---------------\u540c\u6b65\u8ba2\u5355\u76f8\u5173\u7ed3\u7b97\u72b6\u6001\uff0c\u540c\u6b65\u72b6\u6001=" + statusType);
        if (!StringUtils.isEmpty((Object)statusType)) {
            PebUpdateOrderReqBO orderReqBO = new PebUpdateOrderReqBO();
            orderReqBO.setOrderId(reqBO.getOrderId());
            Map stateMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_STATUS");
            orderReqBO.setFscStatus((String)stateMap.get(statusType));
            orderReqBO.setFscStatusType(statusType);
            PebUpdateOrderRspBO pebUpdateOrderRspBO = this.pebUpdateOrderAbilityService.updateFscStatus(orderReqBO);
            if (!pebUpdateOrderRspBO.getRespCode().equals("0000")) {
                throw new FscBusinessException(pebUpdateOrderRspBO.getRespCode(), pebUpdateOrderRspBO.getRespDesc());
            }
        }
        return rspBO;
    }
}

