/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.common.ability.api.FscGetPayOrderContractCapitalPlanListAbilityService;
import com.tydic.fsc.common.ability.bo.FscGetContractCapitalPlanListAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscGetContractCapitalPlanListAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscGetContractCapitalPlanListBo;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscPlanPayItemMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscPlanPayItemPo;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.utils.BigDecimalConvert;
import com.tydic.uac.exception.BusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscGetPayOrderContractCapitalPlanListAbilityService"})
public class FscGetPayOrderContractCapitalPlanListAbilityServiceImpl
implements FscGetPayOrderContractCapitalPlanListAbilityService {
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscPlanPayItemMapper fscPlanPayItemMapper;

    @BigDecimalConvert(value=2)
    @PostMapping(value={"getPayOrderContractCapitalPlanList"})
    public FscGetContractCapitalPlanListAbilityRspBO getPayOrderContractCapitalPlanList(@RequestBody FscGetContractCapitalPlanListAbilityReqBO reqBO) {
        FscGetContractCapitalPlanListAbilityRspBO rspBO = new FscGetContractCapitalPlanListAbilityRspBO();
        if (reqBO.getFscOrderId() == null) {
            throw new BusinessException("8888", "\u4ed8\u6b3e\u5355Id\u4e3a\u7a7a");
        }
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(reqBO.getFscOrderId());
        List list = this.fscOrderMapper.getList(orderPO);
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u4ed8\u6b3e\u5355\u4fe1\u606f");
        }
        FscShouldPayPO fscShouldPayPo = new FscShouldPayPO();
        fscShouldPayPo.setFscOrderIds(Arrays.asList(reqBO.getFscOrderId()));
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List shouldPayPOList = this.fscShouldPayMapper.getListPageWhthPayItem(fscShouldPayPo, page);
        if (CollectionUtils.isEmpty((Collection)shouldPayPOList)) {
            throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u5e94\u4ed8\u5355\u4fe1\u606f");
        }
        List shouldIds = shouldPayPOList.stream().filter(e -> e.getShouldPayStatus() != null && e.getShouldPayStatus() != 8).map(e -> e.getShouldPayId()).collect(Collectors.toList());
        Map shouldPayPOMap = shouldPayPOList.stream().filter(e -> e.getShouldPayStatus() != null && e.getShouldPayStatus() != 8).collect(Collectors.toMap(e -> e.getShouldPayId(), Function.identity(), (e1, e2) -> e2));
        FscPlanPayItemPo planPayItemPo = new FscPlanPayItemPo();
        planPayItemPo.setFscOrderId(reqBO.getFscOrderId());
        planPayItemPo.setShouldPayIds(shouldIds);
        List planPayItems = this.fscPlanPayItemMapper.getPlanPayList(planPayItemPo);
        if (!CollectionUtils.isEmpty((Collection)planPayItems)) {
            ArrayList<FscGetContractCapitalPlanListBo> row = new ArrayList<FscGetContractCapitalPlanListBo>();
            Map<Long, List<FscPlanPayItemPo>> planItemMap = planPayItems.stream().collect(Collectors.groupingBy(e -> e.getShouldPayId()));
            for (Long key : planItemMap.keySet()) {
                String s;
                FscGetContractCapitalPlanListBo bo = new FscGetContractCapitalPlanListBo();
                List<FscPlanPayItemPo> planPayItemList = planItemMap.get(key);
                BigDecimal planAmt = BigDecimal.ZERO;
                BigDecimal reAmt = BigDecimal.ZERO;
                BigDecimal useAmt = BigDecimal.ZERO;
                BigDecimal selfAmt = BigDecimal.ZERO;
                StringBuilder schedulePlan = new StringBuilder();
                for (FscPlanPayItemPo itemPo : planPayItemList) {
                    planAmt = planAmt.add(itemPo.getPlanAmount() == null ? BigDecimal.ZERO : itemPo.getPlanAmount());
                    useAmt = useAmt.add(itemPo.getExeAmount() == null ? BigDecimal.ZERO : itemPo.getExeAmount()).add(itemPo.getOccAmount() == null ? BigDecimal.ZERO : itemPo.getOccAmount());
                    reAmt = reAmt.add(itemPo.getAmount() == null ? BigDecimal.ZERO : itemPo.getAmount());
                    selfAmt = selfAmt.add(itemPo.getSelfOccAmount() == null ? BigDecimal.ZERO : itemPo.getSelfOccAmount());
                    if (StringUtils.isEmpty((Object)itemPo.getPeriod())) continue;
                    schedulePlan = schedulePlan.append(itemPo.getPeriod()).append(",");
                }
                bo.setPlanAmount(planAmt);
                bo.setUserAmount(useAmt);
                bo.setAmount(reAmt);
                bo.setId(planPayItemList.get(0).getContractCapitalPlanId());
                bo.setSelfOccAmount(selfAmt);
                bo.setContractNum(planPayItemList.get(0).getContractNum());
                if (shouldPayPOMap.containsKey(key)) {
                    bo.setOrderCode(((FscShouldPayPO)shouldPayPOMap.get(key)).getOrderCodeStr());
                    bo.setOrderId(((FscShouldPayPO)shouldPayPOMap.get(key)).getOrderId());
                }
                if (!StringUtils.isEmpty((Object)(s = schedulePlan.toString()))) {
                    String substring = s.substring(0, s.length() - 1);
                    bo.setPeriod(substring);
                }
                bo.setItemName(planPayItemList.get(0).getItemName());
                row.add(bo);
            }
            rspBO.setRows(row);
            rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        } else {
            rspBO.setRespDesc("\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a");
            rspBO.setRespCode("0000");
        }
        return rspBO;
    }
}

