/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.FscRefundInvoiceTempQryListAbilityService;
import com.tydic.fsc.common.ability.bo.FscRefundInvoiceTempQryListAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscRefundInvoiceTempQryListAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscRefundInvoiceTempQryListBO;
import com.tydic.fsc.dao.FscAttachmentTempMapper;
import com.tydic.fsc.dao.FscContractSettlementDetailMapper;
import com.tydic.fsc.dao.FscInvoiceRefundRelationTempMapper;
import com.tydic.fsc.dao.FscOrderRelationTempMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentTempPO;
import com.tydic.fsc.po.FscContractSettlementDetailPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscInvoiceRefundRelationTempPo;
import com.tydic.fsc.po.FscOrderRelationTempPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscRefundInvoiceTempQryListAbilityService"})
public class FscRefundInvoiceTempQryListAbilityServiceImpl
implements FscRefundInvoiceTempQryListAbilityService {
    @Autowired
    private FscContractSettlementDetailMapper fscContractSettlementDetailMapper;
    @Autowired
    private FscOrderRelationTempMapper fscOrderRelationTempMapper;
    @Autowired
    private FscInvoiceRefundRelationTempMapper fscInvoiceRefundRelationTempMapper;
    @Autowired
    private FscAttachmentTempMapper fscAttachmentTempMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;

    @PostMapping(value={"refundInvoiceTempQryList"})
    public FscRefundInvoiceTempQryListAbilityRspBO refundInvoiceTempQryList(@RequestBody FscRefundInvoiceTempQryListAbilityReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getFscOrderId())) {
            throw new FscBusinessException("198888", "\u3010fscOrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FscRefundInvoiceTempQryListAbilityRspBO rspBO = new FscRefundInvoiceTempQryListAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        List fscContractSettlementDetailPOS = this.fscContractSettlementDetailMapper.queryPayNodeByFscOrderId(reqBO.getFscOrderId());
        if (!CollectionUtils.isEmpty((Collection)fscContractSettlementDetailPOS)) {
            Map<Integer, String> collect = fscContractSettlementDetailPOS.stream().collect(Collectors.toMap(e -> Integer.parseInt(e.getPanelPointCode()), FscContractSettlementDetailPO::getPanelPointName, (o1, o2) -> o1));
            rspBO.setPayNodeStrMap(collect);
        }
        if (reqBO.getRefundId() == null || reqBO.getContractId() == null) {
            return rspBO;
        }
        FscInvoiceRefundRelationTempPo qryPO = new FscInvoiceRefundRelationTempPo();
        qryPO.setRefundId(reqBO.getRefundId());
        qryPO.setFscOrderId(reqBO.getFscOrderId());
        qryPO.setContractId(reqBO.getContractId());
        List invoiceList = this.fscInvoiceRefundRelationTempMapper.getInvoiceList(qryPO);
        if (!CollectionUtils.isEmpty((Collection)invoiceList)) {
            Map invoiceCategoryMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_INVOICE_CATEGORY");
            Map invoiceTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_INVOICE_TYPE");
            ArrayList<FscRefundInvoiceTempQryListBO> rows = new ArrayList<FscRefundInvoiceTempQryListBO>();
            for (FscInvoicePO each : invoiceList) {
                FscRefundInvoiceTempQryListBO row = (FscRefundInvoiceTempQryListBO)JUtil.js((Object)each, FscRefundInvoiceTempQryListBO.class);
                if (each.getInvoiceType() != null && invoiceTypeMap != null && invoiceTypeMap.containsKey(each.getInvoiceType())) {
                    row.setInvoiceType((String)invoiceTypeMap.get(each.getInvoiceType()));
                }
                if (each.getInvoiceCategory() != null && invoiceCategoryMap != null && invoiceCategoryMap.containsKey(each.getInvoiceCategory().toString())) {
                    row.setInvoiceCategoryStr((String)invoiceCategoryMap.get(each.getInvoiceCategory().toString()));
                }
                rows.add(row);
            }
            rspBO.setRows(rows);
            FscOrderRelationTempPO fscOrderRelationTempPO = new FscOrderRelationTempPO();
            fscOrderRelationTempPO.setFscOrderId(reqBO.getFscOrderId());
            fscOrderRelationTempPO.setRefundId(reqBO.getRefundId());
            fscOrderRelationTempPO.setContractId(reqBO.getContractId());
            List fscOrderRelationTempPOList = this.fscOrderRelationTempMapper.getList(fscOrderRelationTempPO);
            if (!CollectionUtils.isEmpty((Collection)fscOrderRelationTempPOList)) {
                rspBO.setContractRemark(((FscOrderRelationTempPO)fscOrderRelationTempPOList.get(0)).getContractRemark());
                rspBO.setContractSegmentName(((FscOrderRelationTempPO)fscOrderRelationTempPOList.get(0)).getContractSegmentName());
                rspBO.setContractSegmentCode(((FscOrderRelationTempPO)fscOrderRelationTempPOList.get(0)).getContractSegmentCode());
                rspBO.setEstimateBillGuid(((FscOrderRelationTempPO)fscOrderRelationTempPOList.get(0)).getEstimateBillGuid());
                rspBO.setEstimateBillCode(((FscOrderRelationTempPO)fscOrderRelationTempPOList.get(0)).getEstimateBillCode());
                rspBO.setEstimateBizTypeCode(((FscOrderRelationTempPO)fscOrderRelationTempPOList.get(0)).getEstimateBizTypeCode());
            }
            rspBO.setRefundAmtCount(rspBO.getRows().stream().map(FscRefundInvoiceTempQryListBO::getRefundAmt).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        FscAttachmentTempPO fscAttachmentTempPO = new FscAttachmentTempPO();
        fscAttachmentTempPO.setFscOrderId(reqBO.getFscOrderId());
        fscAttachmentTempPO.setObjId(reqBO.getContractId());
        List fscAttachmentTempPOList = this.fscAttachmentTempMapper.getList(fscAttachmentTempPO);
        if (!CollectionUtils.isEmpty((Collection)fscAttachmentTempPOList)) {
            rspBO.setAttachmentList(JSON.parseArray((String)JSON.toJSONString((Object)fscAttachmentTempPOList), AttachmentBO.class));
        }
        return rspBO;
    }
}

