/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.busi.api.FscBillAddPushLogBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillAddPushLogBusiReqBO;
import com.tydic.fsc.common.ability.api.FscComInvoiceSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComRefundInvoiceReopenAbilityService;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscSyncSaleSettleChargeAgainstResultAbilityService;
import com.tydic.fsc.common.ability.bo.FscComInvoiceListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComRefundInvoiceReopenAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscSaleSettleChargeResultInvoiceBO;
import com.tydic.fsc.common.ability.bo.FscSaleSettleChargeResultInvoiceItemBO;
import com.tydic.fsc.common.ability.bo.FscSyncSaleSettleChargeAgainstResultAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscSyncSaleSettleChargeAgainstResultAbilityRspBO;
import com.tydic.fsc.common.busi.api.FscSyncSaleSettleChargeAgainstResultBusiService;
import com.tydic.fsc.common.busi.bo.FscSaleSettleChargeAgainstResultBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscSaleSettleChargeAgainstResultBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscInvoiceRefundRelationMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscInvoiceItemPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscInvoiceRefundRelationPO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscSyncSaleSettleChargeAgainstResultAbilityService"})
public class FscSyncSaleSettleChargeAgainstResultAbilityServiceImpl
implements FscSyncSaleSettleChargeAgainstResultAbilityService {
    @Autowired
    private FscSyncSaleSettleChargeAgainstResultBusiService fscSyncSaleSettleChargeAgainstResultBusiService;
    @Autowired
    private FscComInvoiceSyncAbilityService fscComInvoiceSyncAbilityService;
    @Autowired
    private FscBillAddPushLogBusiService fscBillAddPushLogBusiService;
    @Autowired
    private FscComRefundSyncAbilityService fscComRefundSyncAbilityService;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscComRefundInvoiceReopenAbilityService fscComRefundInvoiceReopenAbilityService;
    @Autowired
    private FscInvoiceRefundRelationMapper fscInvoiceRefundRelationMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;

    @PostMapping(value={"dealSaleSettleChargeResult"})
    public FscSyncSaleSettleChargeAgainstResultAbilityRspBO dealSaleSettleChargeResult(@RequestBody FscSyncSaleSettleChargeAgainstResultAbilityReqBO reqBO) {
        this.valid(reqBO);
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(reqBO.getChargeId());
        refundPO = this.fscOrderRefundMapper.getModelBy(refundPO);
        if (refundPO == null) {
            throw new FscBusinessException("198888", reqBO.getChargeId() + "\u672a\u67e5\u8be2\u5230\u9000\u7968\u51b2\u9500\u5355\u76f8\u5173\u4fe1\u606f[" + reqBO.getChargeNo() + "]!");
        }
        FscBillAddPushLogBusiReqBO logBusiReqBO = new FscBillAddPushLogBusiReqBO();
        logBusiReqBO.setObjectId(reqBO.getChargeId());
        logBusiReqBO.setObjectNo(refundPO.getRefundNo());
        logBusiReqBO.setObjData(JSONObject.toJSONString((Object)reqBO));
        logBusiReqBO.setCreateTime(new Date());
        logBusiReqBO.setType(FscConstants.FscPushType.REFUND_INVOICE_RESULT);
        this.fscBillAddPushLogBusiService.addPushLog(logBusiReqBO);
        if (!FscConstants.RefundInvoiceStatus.AUDIT_PASS.equals(refundPO.getRefundStatus()) && !FscConstants.RefundInvoiceStatus.REFUND.equals(refundPO.getRefundStatus())) {
            throw new FscBusinessException("198888", "\u5f53\u524d\u9000\u7968\u5355\u72b6\u6001\u4e0d\u5141\u8bb8\u8fdb\u884c\u64cd\u4f5c\uff01");
        }
        FscOrderInvoicePO orderInvoicePO = new FscOrderInvoicePO();
        orderInvoicePO.setFscOrderId(refundPO.getFscOrderId());
        orderInvoicePO = this.fscOrderInvoiceMapper.getModelBy(orderInvoicePO);
        Map<String, FscInvoicePO> invoicNoMap = this.getInvoicNoMap(refundPO);
        ArrayList<FscInvoicePO> invoiceList = new ArrayList<FscInvoicePO>();
        ArrayList<FscInvoiceItemPO> invoiceItemList = new ArrayList<FscInvoiceItemPO>();
        ArrayList<FscAttachmentPO> fileList = new ArrayList<FscAttachmentPO>();
        for (FscSaleSettleChargeResultInvoiceBO resultInvoiceBO : reqBO.getInvoiceList()) {
            this.validInvoice(resultInvoiceBO);
            FscInvoicePO invoicePO = new FscInvoicePO();
            if (invoicNoMap.containsKey(resultInvoiceBO.getPreInvoiceNo())) {
                FscInvoicePO fscInvoicePO = invoicNoMap.get(resultInvoiceBO.getPreInvoiceNo());
                invoicePO.setPreInvoiceId(fscInvoicePO.getInvoiceId());
                invoicePO.setContractId(fscInvoicePO.getContractId());
            }
            invoicePO.setInvoiceId(Long.valueOf(Sequence.getInstance().nextId()));
            invoicePO.setFscOrderId(null);
            invoicePO.setMailId(null);
            invoicePO.setBillDate(resultInvoiceBO.getRedInvoiceDate());
            invoicePO.setTaxAmt(resultInvoiceBO.getRedInvoiceTaxAmt());
            invoicePO.setUntaxAmt(resultInvoiceBO.getRedInvoiceUntaxAmt());
            invoicePO.setAmt(resultInvoiceBO.getRedInvoiceAmt());
            if (resultInvoiceBO.getRedInvoiceNo().length() == 20) {
                invoicePO.setFullElecNo(resultInvoiceBO.getRedInvoiceNo());
                invoicePO.setInvoiceNo(resultInvoiceBO.getRedInvoiceNo().substring(resultInvoiceBO.getRedInvoiceNo().length() - 8));
                invoicePO.setInvoiceCode(resultInvoiceBO.getRedInvoiceNo().substring(0, resultInvoiceBO.getRedInvoiceNo().length() - 8));
            } else {
                invoicePO.setInvoiceNo(resultInvoiceBO.getRedInvoiceNo());
                invoicePO.setInvoiceCode(resultInvoiceBO.getRedInvoiceCode());
            }
            invoicePO.setBuyName(resultInvoiceBO.getCustomerName());
            invoicePO.setTaxNo(orderInvoicePO.getTaxNo());
            invoicePO.setInvoiceType(orderInvoicePO.getInvoiceType());
            invoicePO.setInvoiceCategory(orderInvoicePO.getInvoiceCategory());
            invoicePO.setBank(orderInvoicePO.getBank());
            invoicePO.setAccount(orderInvoicePO.getAccount());
            invoicePO.setAddress(orderInvoicePO.getAddress());
            invoicePO.setPhone(orderInvoicePO.getPhone());
            invoicePO.setStatus(FscConstants.FscInvoiceStatus.VALID);
            invoicePO.setCreateTime(new Date());
            invoicePO.setRefundId(refundPO.getRefundId());
            if (refundPO.getSettlePlatform() != null && refundPO.getSettlePlatform() == 3) {
                invoicePO.setUploadShareStatus(FscConstants.FinanceInvoiceUploadShareStatus.NO_UPLOAD);
                invoicePO.setUploadShareFailNum(Integer.valueOf(0));
            }
            invoiceList.add(invoicePO);
            if (!StringUtils.isEmpty((Object)resultInvoiceBO.getRedInvoiceUrl())) {
                FscAttachmentPO attachmentPO = new FscAttachmentPO();
                attachmentPO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                attachmentPO.setObjId(refundPO.getRefundId());
                attachmentPO.setFscOrderId(invoicePO.getInvoiceId());
                attachmentPO.setAttachmentType(FscConstants.AttachmentType.REFUND_RED_INVOICE);
                attachmentPO.setObjType(FscConstants.AttachmentType.REFUND_RED_INVOICE);
                attachmentPO.setCreateTime(new Date());
                attachmentPO.setAttachmentName("\u7535\u5b50\u53d1\u7968");
                attachmentPO.setAttachmentUrl(resultInvoiceBO.getRedInvoiceUrl());
                fileList.add(attachmentPO);
            }
            List orderItemIdList = resultInvoiceBO.getInvoiceItemList().stream().map(FscSaleSettleChargeResultInvoiceItemBO::getOrderItemId).collect(Collectors.toList());
            FscOrderItemPO orderItemPO = new FscOrderItemPO();
            orderItemPO.setFscOrderId(refundPO.getFscOrderId());
            orderItemPO.setIds(orderItemIdList);
            List orderItemList = this.fscOrderItemMapper.getListNoPage(orderItemPO);
            Map<Long, FscOrderItemPO> orderItemMap = orderItemList.stream().collect(Collectors.toMap(FscOrderItemPO::getId, e -> e));
            for (FscSaleSettleChargeResultInvoiceItemBO resultInvoiceItemBO : resultInvoiceBO.getInvoiceItemList()) {
                this.validInvoiceItem(resultInvoiceItemBO);
                FscOrderItemPO fscOrderItemPO = orderItemMap.get(resultInvoiceItemBO.getOrderItemId());
                if (fscOrderItemPO == null) {
                    throw new FscBusinessException("198888", resultInvoiceItemBO.getOrderItemId() + "\u83b7\u53d6\u539f\u7ed3\u7b97\u884c\u660e\u7ec6\u4fe1\u606f\u5931\u8d25\uff01");
                }
                FscInvoiceItemPO invoiceItemPO = new FscInvoiceItemPO();
                invoiceItemPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                invoiceItemPO.setOrderId(fscOrderItemPO.getOrderId());
                invoiceItemPO.setAcceptOrderId(fscOrderItemPO.getAcceptOrderId());
                invoiceItemPO.setFscOrderId(null);
                invoiceItemPO.setOrderItemId(resultInvoiceItemBO.getOrderItemId());
                invoiceItemPO.setInvoiceId(invoicePO.getInvoiceId());
                invoiceItemPO.setSkuId(fscOrderItemPO.getSkuId());
                invoiceItemPO.setSkuName(resultInvoiceItemBO.getSkuName());
                invoiceItemPO.setSpec(resultInvoiceItemBO.getSpec());
                invoiceItemPO.setModel("");
                invoiceItemPO.setTaxAmt(resultInvoiceItemBO.getTaxAmt());
                invoiceItemPO.setUnit(resultInvoiceItemBO.getUnit());
                invoiceItemPO.setTaxCode(resultInvoiceItemBO.getTaxCode());
                invoiceItemPO.setNum(resultInvoiceItemBO.getNum());
                invoiceItemPO.setPrice(resultInvoiceItemBO.getPrice());
                invoiceItemPO.setAmt(resultInvoiceItemBO.getAmt());
                invoiceItemPO.setUntaxAmt(resultInvoiceItemBO.getUntaxAmt());
                invoiceItemPO.setTaxRate(resultInvoiceItemBO.getTaxRate());
                invoiceItemPO.setItemNo(resultInvoiceItemBO.getItemNo());
                invoiceItemList.add(invoiceItemPO);
            }
        }
        FscSaleSettleChargeAgainstResultBusiReqBO busiReqBO = new FscSaleSettleChargeAgainstResultBusiReqBO();
        busiReqBO.setRefundId(refundPO.getRefundId());
        busiReqBO.setInvoiceList(invoiceList);
        busiReqBO.setInvoiceItemList(invoiceItemList);
        busiReqBO.setFileList(fileList);
        FscSaleSettleChargeAgainstResultBusiRspBO busiRspBO = this.fscSyncSaleSettleChargeAgainstResultBusiService.dealSaleSettleChargeResult(busiReqBO);
        if ("0000".equals(busiRspBO.getRespCode())) {
            this.syncEs(refundPO);
            if (refundPO.getIsInvoiceChange() != null && refundPO.getIsInvoiceChange() == 1 && FscConstants.FscOrderReceiveType.INDIVIDUAL.equals(refundPO.getReceiveType())) {
                FscComRefundInvoiceReopenAbilityReqBO refundInvoiceReopenAbilityReqBO = new FscComRefundInvoiceReopenAbilityReqBO();
                refundInvoiceReopenAbilityReqBO.setRefundId(refundPO.getRefundId());
                this.fscComRefundInvoiceReopenAbilityService.sendMsg(refundInvoiceReopenAbilityReqBO);
            }
        }
        return (FscSyncSaleSettleChargeAgainstResultAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBO)), FscSyncSaleSettleChargeAgainstResultAbilityRspBO.class);
    }

    private Map<String, FscInvoicePO> getInvoicNoMap(FscOrderRefundPO refundPO) {
        HashMap<String, FscInvoicePO> invoicNoMap = new HashMap<String, FscInvoicePO>();
        if (refundPO.getRefundId() != null) {
            List preInvoiceIds;
            FscInvoiceRefundRelationPO searchRefundRelationPO = new FscInvoiceRefundRelationPO();
            searchRefundRelationPO.setRefundId(refundPO.getRefundId());
            List fscInvoiceRefundRelationPOS = this.fscInvoiceRefundRelationMapper.getList(searchRefundRelationPO);
            if (!CollectionUtils.isEmpty((Collection)fscInvoiceRefundRelationPOS) && !CollectionUtils.isEmpty(preInvoiceIds = fscInvoiceRefundRelationPOS.stream().filter(e -> e.getInvoiceId() != null).map(FscInvoiceRefundRelationPO::getInvoiceId).collect(Collectors.toList()))) {
                FscInvoicePO searchInvoicePO = new FscInvoicePO();
                searchInvoicePO.setFscOrderId(refundPO.getFscOrderId());
                searchInvoicePO.setInvoiceIds(preInvoiceIds);
                List beforeInvoiceList = this.fscInvoiceMapper.getList(searchInvoicePO);
                if (!CollectionUtils.isEmpty((Collection)beforeInvoiceList)) {
                    for (FscInvoicePO invoicePO : beforeInvoiceList) {
                        String invoiceNo = "";
                        invoiceNo = FscConstants.FscInvoiceCategory.FULL.equals(invoicePO.getInvoiceCategory()) ? (!StringUtils.isEmpty((Object)invoicePO.getInvoiceCode()) ? invoicePO.getInvoiceCode() + invoicePO.getInvoiceNo() : invoicePO.getInvoiceNo()) : invoicePO.getInvoiceNo();
                        if (StringUtils.isEmpty((Object)invoiceNo) || invoicNoMap.containsKey(invoiceNo)) continue;
                        invoicNoMap.put(invoiceNo, invoicePO);
                    }
                }
            }
        }
        return invoicNoMap;
    }

    private void validInvoiceItem(FscSaleSettleChargeResultInvoiceItemBO resultInvoiceItemBO) {
        if (resultInvoiceItemBO.getOrderItemId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[orderItemId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (resultInvoiceItemBO.getTaxRate() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[taxRate]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (resultInvoiceItemBO.getNum() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[num]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (resultInvoiceItemBO.getPrice() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[price]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (resultInvoiceItemBO.getAmt() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[amt]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (resultInvoiceItemBO.getUntaxAmt() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[untaxAmt]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (resultInvoiceItemBO.getTaxAmt() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[taxAmt]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)resultInvoiceItemBO.getTaxCode())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[taxCode]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)resultInvoiceItemBO.getSkuName())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[skuName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)resultInvoiceItemBO.getUnit())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[unit]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)resultInvoiceItemBO.getItemNo())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[itemNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void validInvoice(FscSaleSettleChargeResultInvoiceBO resultInvoiceBO) {
        if (resultInvoiceBO.getRedInvoiceAmt() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[redInvoiceAmt]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (resultInvoiceBO.getRedInvoiceTaxAmt() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[redInvoiceTaxAmt]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (resultInvoiceBO.getRedInvoiceUntaxAmt() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[redInvoiceUntaxAmt]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (resultInvoiceBO.getRedInvoiceId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[redInvoiceId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)resultInvoiceBO.getRedInvoiceNo())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[redInvoiceNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)resultInvoiceBO.getRedInvoiceDate())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[redInvoiceDate]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)resultInvoiceBO.getInvoiceItemList())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[invoiceItemList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void valid(FscSyncSaleSettleChargeAgainstResultAbilityReqBO reqBO) {
        if (reqBO.getChargeId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[chargeId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getChargeNo())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[chargeNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getInvoiceList())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[invoiceList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void syncEs(FscOrderRefundPO refundPO) {
        FscComRefundSyncAbilityReqBO syncAbilityReqBO = new FscComRefundSyncAbilityReqBO();
        syncAbilityReqBO.setRefundIds(Collections.singletonList(refundPO.getRefundId()));
        this.fscComRefundSyncAbilityService.syncRefund(syncAbilityReqBO);
        FscComInvoiceListSyncAbilityReqBO fscComInvoiceListSyncAbilityReqBO = new FscComInvoiceListSyncAbilityReqBO();
        fscComInvoiceListSyncAbilityReqBO.setFscOrderId(refundPO.getFscOrderId());
        this.fscComInvoiceSyncAbilityService.dealComOrderSyncEs(fscComInvoiceListSyncAbilityReqBO);
        FscComInvoiceListSyncAbilityReqBO refundInvoiceListSyncAbilityReqBO = new FscComInvoiceListSyncAbilityReqBO();
        refundInvoiceListSyncAbilityReqBO.setFscOrderId(refundPO.getRefundId());
        refundInvoiceListSyncAbilityReqBO.setSyncType(FscConstants.FscSyncType.REFUND);
        this.fscComInvoiceSyncAbilityService.dealComOrderSyncEs(refundInvoiceListSyncAbilityReqBO);
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(refundPO.getFscOrderId());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }
}

