/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.busibase.busi.api.FscUocOrderRelUpdateBusiService;
import com.tydic.fsc.busibase.busi.bo.FscUocOrderRelUpdateBusiReqBO;
import com.tydic.fsc.busibase.busi.bo.FscUocOrderRelUpdateBusiRspBO;
import com.tydic.fsc.common.ability.api.FscUocOrderRelUpdateBatchAbilityService;
import com.tydic.fsc.common.ability.bo.FscUocOrderRelUpdateBatchReqBO;
import com.tydic.fsc.common.ability.bo.FscUocOrderRelUpdateBatchRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscUocOrderRelUpdateBatchAbilityService"})
public class FscUocOrderRelUpdateBatchAbilityServiceImpl
implements FscUocOrderRelUpdateBatchAbilityService {
    @Autowired
    private FscUocOrderRelUpdateBusiService fscUocOrderRelUpdateBusiService;
    private static final Integer DEAL_TYPE = 2;

    @PostMapping(value={"dealRelUpdateBatch"})
    public FscUocOrderRelUpdateBatchRspBO dealRelUpdateBatch(@RequestBody FscUocOrderRelUpdateBatchReqBO reqBO) {
        this.valid(reqBO);
        String reqString = JSONObject.toJSONString((Object)reqBO);
        FscUocOrderRelUpdateBusiReqBO busiReqBO = (FscUocOrderRelUpdateBusiReqBO)JSONObject.parseObject((String)reqString, FscUocOrderRelUpdateBusiReqBO.class);
        busiReqBO.setDealType(DEAL_TYPE);
        StringBuilder sb = new StringBuilder();
        for (Long fscOrderId : reqBO.getFscOrderIds()) {
            busiReqBO.setFscOrderId(fscOrderId);
            FscUocOrderRelUpdateBusiRspBO busiRspBO = this.fscUocOrderRelUpdateBusiService.dealRelUpdate(busiReqBO);
            if (busiRspBO.getRespCode().equals("0000")) continue;
            sb.append("\u7ed3\u7b97\u5355[").append(fscOrderId).append("]\u540c\u6b65\u5931\u8d25\uff1a").append(busiRspBO.getRespDesc());
        }
        FscUocOrderRelUpdateBatchRspBO rspBO = new FscUocOrderRelUpdateBatchRspBO();
        if (StringUtils.isEmpty((Object)sb.toString())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        } else {
            rspBO.setRespCode("190000");
            rspBO.setRespDesc(sb.toString());
        }
        return rspBO;
    }

    private void valid(FscUocOrderRelUpdateBatchReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u539f\u5b50\u670d\u52a1\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getOperType()) {
            throw new FscBusinessException("191000", "\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u539f\u5b50\u670d\u52a1\u5165\u53c2\u64cd\u4f5c\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (FscConstants.FscRelUpdateAtomOperType.FSC_ORDER.equals(reqBO.getOperType())) {
            if (CollectionUtils.isEmpty((Collection)reqBO.getFscOrderIds())) {
                throw new FscBusinessException("191000", "\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u539f\u5b50\u670d\u52a1\u5165\u53c2\u7ed3\u7b97\u5355ID\u96c6\u5408[fscOrderIds]\u4e3a\u7a7a");
            }
        } else if (FscConstants.FscRelUpdateAtomOperType.ORDER.equals(reqBO.getOperType())) {
            if (!CollectionUtils.isEmpty((Collection)reqBO.getFscOrderRelUpdateBOS())) {
                throw new FscBusinessException("191000", "\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u539f\u5b50\u670d\u52a1\u5165\u53c2\u8ba2\u5355\u5bf9\u8c61\u4e3a\u7a7a");
            }
        } else {
            throw new FscBusinessException("191000", "\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u539f\u5b50\u670d\u52a1\u5165\u53c2\u64cd\u4f5c\u7c7b\u578b\u672a\u5b9a\u4e49");
        }
    }
}

