/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl.finance;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.agreement.ability.api.AgrFinanceSelectAgreementAbilityService;
import com.tydic.agreement.ability.bo.AgrFinanceSelectAgreementReqBo;
import com.tydic.agreement.ability.bo.AgrFinanceSelectAgreementRspBo;
import com.tydic.contract.ability.FscFinanceSelectContractAbilityService;
import com.tydic.contract.ability.bo.FscFinanceSelectContractReqBo;
import com.tydic.contract.ability.bo.FscFinanceSelectContractRspBo;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.fsc.common.ability.api.finance.FscFinanceRefundablePayContractListQryAbilityService;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceRefundablePayContractListQryReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceRefundablePayContractListQryRspBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceRefundablePayContractListQryRspListBO;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderRelationPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.finance.FscFinanceRefundablePayContractListQryAbilityService"})
public class FscFinanceRefundablePayContractListQryAbilityServiceImpl
implements FscFinanceRefundablePayContractListQryAbilityService {
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscFinanceSelectContractAbilityService fscFinanceSelectContractAbilityService;
    @Autowired
    private AgrFinanceSelectAgreementAbilityService agrFinanceSelectAgreementAbilityService;

    @PostMapping(value={"qryRefundablePayContractList"})
    public FscFinanceRefundablePayContractListQryRspBO qryRefundablePayContractList(@RequestBody FscFinanceRefundablePayContractListQryReqBO reqBo) {
        FscFinanceRefundablePayContractListQryRspBO rspBO = new FscFinanceRefundablePayContractListQryRspBO();
        if (null == reqBo.getRefundId()) {
            throw new FscBusinessException("191000", "\u8bf7\u6c42\u53c2\u6570[refundId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FscOrderRelationPO fscOrderRelationPo = new FscOrderRelationPO();
        fscOrderRelationPo.setRefundId(reqBo.getRefundId());
        List list = this.fscOrderRelationMapper.getList(fscOrderRelationPo);
        if (CollUtil.isEmpty((Collection)list)) {
            return rspBO;
        }
        List contractIdList = list.stream().map(FscOrderRelationPO::getContractId).collect(Collectors.toList());
        if (CollUtil.isNotEmpty((Collection)reqBo.getFilterContractIds())) {
            contractIdList.removeAll(reqBo.getFilterContractIds());
        }
        if (CollUtil.isEmpty(contractIdList)) {
            rspBO.setRespCode("0000");
            rspBO.setRows(new ArrayList());
            return rspBO;
        }
        if ("2".equals(reqBo.getContractType())) {
            AgrFinanceSelectAgreementReqBo queryReq = (AgrFinanceSelectAgreementReqBo)JUtil.js((Object)reqBo, AgrFinanceSelectAgreementReqBo.class);
            queryReq.setAgreementIds(contractIdList);
            AgrFinanceSelectAgreementRspBo agreementRspBo = this.agrFinanceSelectAgreementAbilityService.selectAgreementPage(queryReq);
            rspBO.setRows(JSON.parseArray((String)JSON.toJSONString((Object)agreementRspBo.getRows()), FscFinanceRefundablePayContractListQryRspListBO.class));
            rspBO.setTotal(agreementRspBo.getTotal());
            rspBO.setPageNo(agreementRspBo.getPageNo());
            rspBO.setRecordsTotal(agreementRspBo.getRecordsTotal());
            rspBO.setRespCode(agreementRspBo.getRespCode());
            rspBO.setRespDesc(agreementRspBo.getRespDesc());
        } else {
            FscFinanceSelectContractReqBo queryReq = (FscFinanceSelectContractReqBo)JUtil.js((Object)reqBo, FscFinanceSelectContractReqBo.class);
            queryReq.setContractList(contractIdList);
            FscFinanceSelectContractRspBo fscFinanceSelectContractRspBo = this.fscFinanceSelectContractAbilityService.selectContractPage(queryReq);
            rspBO.setRows(JSON.parseArray((String)JSON.toJSONString((Object)fscFinanceSelectContractRspBo.getRows()), FscFinanceRefundablePayContractListQryRspListBO.class));
            rspBO.setTotal(fscFinanceSelectContractRspBo.getTotal());
            rspBO.setPageNo(fscFinanceSelectContractRspBo.getPageNo());
            rspBO.setRecordsTotal(fscFinanceSelectContractRspBo.getRecordsTotal());
            rspBO.setRespCode(fscFinanceSelectContractRspBo.getRespCode());
            rspBO.setRespDesc(fscFinanceSelectContractRspBo.getRespDesc());
        }
        return rspBO;
    }
}

