/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscClaimDetailBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetErpCustInfoReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetErpCustInfoRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushNewYcClaimRefundBillReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushNewYcClaimRefundBillRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushYcRecvClaimChangeRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleDecryptionReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleDecryptionRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleEncryPtionReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleEncryPtionRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscGetErpCustInfoService;
import com.tydic.fsc.busibase.external.api.esb.FscPushNewYcClaimRefundBillService;
import com.tydic.fsc.busibase.external.api.esb.FscUnifySettleRelatedInterfacesAtomService;
import com.tydic.fsc.common.ability.api.FscSyncPushYcAttachmentAbilityService;
import com.tydic.fsc.common.ability.bo.FscNewYcClaimRefundBillBO;
import com.tydic.fsc.common.ability.bo.FscNewYcClaimRefundBillLineBO;
import com.tydic.fsc.common.ability.bo.FscPushYcAttachmentAbilityReqBO;
import com.tydic.fsc.common.busi.api.FscPushClaimChangeRefundBusiService;
import com.tydic.fsc.common.busi.bo.FscPushClaimChangeRefundBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscPushClaimChangeRefundBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscClaimChangeOrginalDetailMapper;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscDicDictionaryExernalMapper;
import com.tydic.fsc.dao.FscPushLogMapper;
import com.tydic.fsc.dao.FscRecvClaimChangeMapper;
import com.tydic.fsc.dao.FscRecvClaimMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscClaimChangeOrginalDetailPO;
import com.tydic.fsc.po.FscDicDictionaryExernalPO;
import com.tydic.fsc.po.FscPushLogPO;
import com.tydic.fsc.po.FscRecvClaimChangePO;
import com.tydic.fsc.po.FscRecvClaimPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.util.FscCommonUtils;
import com.tydic.uoc.common.ability.api.PebExtUnifySettlePersonQryAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityRspBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscPushClaimChangeRefundBusiServiceImpl
implements FscPushClaimChangeRefundBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscPushClaimChangeRefundBusiServiceImpl.class);
    @Autowired
    private FscRecvClaimChangeMapper fscRecvClaimChangeMapper;
    @Autowired
    private FscPushLogMapper fscPushLogMapper;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscRecvClaimMapper fscRecvClaimMapper;
    @Autowired
    private FscClaimChangeOrginalDetailMapper fscClaimChangeOrginalDetailMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscDicDictionaryExernalMapper fscDicDictionaryExernalMapper;
    @Autowired
    private FscSyncPushYcAttachmentAbilityService fscSyncPushYcAttachmentAbilityService;
    @Autowired
    private FscUnifySettleRelatedInterfacesAtomService fscUnifySettleRelatedInterfacesAtomService;
    @Autowired
    private PebExtUnifySettlePersonQryAbilityService pebExtUnifySettlePersonQryAbilityService;
    @Autowired
    private FscPushNewYcClaimRefundBillService fscPushNewYcClaimRefundBillService;
    @Autowired
    private FscGetErpCustInfoService fscGetErpCustInfoService;
    @Value(value="${OPER_ORG_ID}")
    private String operationOrgId;
    @Value(value="${OPER_ORG_NAME}")
    private String operOrgName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FscPushClaimChangeRefundBusiRspBO pushClaimChange(FscPushClaimChangeRefundBusiReqBO reqBO) {
        FscRecvClaimChangePO fscRecvClaimChangePO = this.fscRecvClaimChangeMapper.queryById(reqBO.getChangeId());
        if (fscRecvClaimChangePO == null) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u76f8\u5173\u8ba4\u9886\u53d8\u66f4\u5355\u4fe1\u606f\uff01");
        }
        if (FscConstants.FscClaimChangePushStatus.SUCCESS.equals(fscRecvClaimChangePO.getPushStatus())) {
            throw new FscBusinessException("190000", "\u53d8\u66f4\u5355" + fscRecvClaimChangePO.getChangeNo() + "\u5df2\u63a8\u9001\uff01");
        }
        FscPushClaimChangeRefundBusiRspBO rspBO = new FscPushClaimChangeRefundBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        FscPushLogPO pushLogPo = new FscPushLogPO();
        pushLogPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
        pushLogPo.setObjectId(reqBO.getChangeId());
        pushLogPo.setObjectNo(fscRecvClaimChangePO.getChangeNo());
        pushLogPo.setType(FscConstants.FscPushType.CLAIM_CHANGE);
        pushLogPo.setStatus(FscConstants.FscPushStatus.FAIL);
        pushLogPo.setCreateTime(new Date());
        fscRecvClaimChangePO.setChangeId(reqBO.getChangeId());
        fscRecvClaimChangePO.setPushStatus(FscConstants.FscClaimChangePushStatus.FAIL);
        fscRecvClaimChangePO.setPushDate(new Date());
        try {
            FscNewYcClaimRefundBillBO REREC = new FscNewYcClaimRefundBillBO();
            ArrayList<FscNewYcClaimRefundBillLineBO> REREC_LINE = new ArrayList<FscNewYcClaimRefundBillLineBO>();
            this.buildClaimRefundBillInfo(reqBO.getChangeId(), fscRecvClaimChangePO, REREC, REREC_LINE);
            FscPushYcRecvClaimChangeRspBO pushRsp = this.dealParamToYc(reqBO.getAgentAccount(), pushLogPo, REREC, REREC_LINE);
            if (!"0000".equals(pushRsp.getRespCode())) {
                fscRecvClaimChangePO.setFailReason(pushRsp.getData());
                rspBO.setRespCode("190000");
                rspBO.setRespDesc(pushRsp.getData());
            } else {
                fscRecvClaimChangePO.setPushStatus(FscConstants.FscClaimChangePushStatus.SUCCESS);
                pushLogPo.setStatus(FscConstants.FscPushStatus.SUCCESS);
                this.pushFile(reqBO, fscRecvClaimChangePO);
            }
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u4e1a\u8d22\u8ba4\u9886\u53d8\u66f4\u5355\u9000\u6b3e\u5931\u8d25\uff01" + FscCommonUtils.dealStackTrace((Exception)e));
            fscRecvClaimChangePO.setFailReason(e.getMessage());
            pushLogPo.setRespData(e.getMessage());
        }
        finally {
            this.fscRecvClaimChangeMapper.updatePushStatus(fscRecvClaimChangePO);
            this.fscPushLogMapper.insert(pushLogPo);
        }
        return rspBO;
    }

    private void buildClaimRefundBillInfo(Long changeId, FscRecvClaimChangePO fscRecvClaimChangePO, FscNewYcClaimRefundBillBO rerec, List<FscNewYcClaimRefundBillLineBO> rerecLine) {
        FscClaimChangeOrginalDetailPO orginalDetailPO = new FscClaimChangeOrginalDetailPO();
        orginalDetailPO.setChangeId(fscRecvClaimChangePO.getChangeId());
        List orginalDetailPOS = this.fscClaimChangeOrginalDetailMapper.selectList(orginalDetailPO);
        FscRecvClaimPO recvClaimPO = this.fscRecvClaimMapper.queryById(((FscClaimChangeOrginalDetailPO)orginalDetailPOS.get(0)).getClaimId());
        List fscClaimDetailBOS = this.fscClaimDetailMapper.selectClaimInfoListByCliaimId(((FscClaimChangeOrginalDetailPO)orginalDetailPOS.get(0)).getClaimId());
        Map<Long, FscClaimDetailBO> detailBOMap = fscClaimDetailBOS.stream().collect(Collectors.toMap(FscClaimDetailBO::getClaimDetailId, i -> i));
        FscGetErpCustInfoReqBO custInfoReqBO = new FscGetErpCustInfoReqBO();
        custInfoReqBO.setCustomerName(fscRecvClaimChangePO.getCustomerName());
        FscGetErpCustInfoRspBO custInfoRspBO = this.fscGetErpCustInfoService.getErpCustInfo(custInfoReqBO);
        if (!custInfoRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(custInfoRspBO.getRespCode(), custInfoRspBO.getRespDesc());
        }
        FscDicDictionaryExernalPO eternalPo = new FscDicDictionaryExernalPO();
        eternalPo.setPCode("FSC_YC_CLAIM_TYPE");
        Map<String, FscDicDictionaryExernalPO> dicMapE = this.getDicMap(eternalPo);
        FscDicDictionaryExernalPO eternalPo1 = new FscDicDictionaryExernalPO();
        eternalPo1.setPCode("RECEIVABLES_CLAIM_BANK_ID");
        Map<String, FscDicDictionaryExernalPO> dicMap1 = this.getDicMap(eternalPo1);
        rerec.setREC_ID(recvClaimPO.getClaimId() + "");
        rerec.setREC_NUM(recvClaimPO.getClaimNo());
        rerec.setORG_ID(this.operationOrgId);
        rerec.setORG_NAME(this.operOrgName);
        rerec.setPERSON_ID(fscRecvClaimChangePO.getChangeUserId());
        rerec.setPERSON_NAME(fscRecvClaimChangePO.getChangeUserName());
        rerec.setDEPT_ID(fscRecvClaimChangePO.getChangeDeptId());
        rerec.setDEPT_NAME(fscRecvClaimChangePO.getChangeDeptName());
        rerec.setBILL_DATE(DateUtil.dateToStr((Date)fscRecvClaimChangePO.getCreateTime(), (String)"yyyy-MM-dd"));
        rerec.setSTATUS("Y");
        rerec.setGENERAL_STATUS("V");
        rerec.setVENDOR_ID(custInfoRspBO.getCustAccountId());
        rerec.setVENDOR_NAME(custInfoRspBO.getCustAccountName());
        if (dicMap1.get(recvClaimPO.getBankAccount()) != null) {
            rerec.setBANK_ID(dicMap1.get(recvClaimPO.getBankAccount()).getExernalCode());
        } else {
            rerec.setBANK_ID(recvClaimPO.getBankId() + "");
        }
        rerec.setBANK_NAME(recvClaimPO.getAccountBranch());
        rerec.setBANK_ACC(recvClaimPO.getBankAccount());
        rerec.setREC_AMOUNT(recvClaimPO.getRecvAmt().setScale(2, RoundingMode.HALF_UP));
        rerec.setREFUND_AMOUNT(orginalDetailPOS.stream().map(FscClaimChangeOrginalDetailPO::getChangeAmount).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP));
        rerec.setDESCRIPTIONS(fscRecvClaimChangePO.getRemark());
        rerec.setEG_TESCO_ID(fscRecvClaimChangePO.getChangeId());
        rerec.setEG_BILL_NUM(fscRecvClaimChangePO.getChangeNo());
        rerec.setTASK_FLAG("Y");
        orginalDetailPOS.forEach(x -> {
            FscNewYcClaimRefundBillLineBO bo = new FscNewYcClaimRefundBillLineBO();
            bo.setEG_TESCO_ID(x.getId() + "");
            bo.setREC_LINE_ID(x.getClaimDetailId() + "");
            bo.setCLAIM_TYPE(((FscDicDictionaryExernalPO)dicMapE.get(x.getClaimType())).getExernalCode());
            bo.setCLAIM_TYPE_DIS(((FscDicDictionaryExernalPO)dicMapE.get(x.getClaimType())).getExernalTitle());
            bo.setAMOUNT(x.getChangeAmount());
            bo.setTY_AMOUNT(x.getVariableAmount());
            bo.setCLAIM_AMOUNT(x.getClaimAmt());
            FscClaimDetailBO fscClaimDetailBO = (FscClaimDetailBO)detailBOMap.get(x.getClaimDetailId());
            if (Objects.nonNull(fscClaimDetailBO.getFscOrderId())) {
                bo.setBALANCE_ID(fscClaimDetailBO.getFscOrderId() + "");
                bo.setBALANCE_NUM(fscClaimDetailBO.getFscOrderNo());
            }
            bo.setPERSON_ID(fscClaimDetailBO.getHandleUserId());
            bo.setPERSON_NAME(fscClaimDetailBO.getHandleUserName());
            bo.setDEPT_ID(fscClaimDetailBO.getHandleDeptId());
            bo.setDEPT_NAME(fscClaimDetailBO.getHandleDeptName());
            bo.setBANK_BILL_ID(recvClaimPO.getLedgerId());
            bo.setBANK_BILL_NUM(recvClaimPO.getSerialNumber());
            rerecLine.add(bo);
        });
    }

    private FscPushYcRecvClaimChangeRspBO dealParamToYc(String agentAccount, FscPushLogPO fscPushLogPo, FscNewYcClaimRefundBillBO REREC, List<FscNewYcClaimRefundBillLineBO> REREC_LINE) {
        FscPushYcRecvClaimChangeRspBO rspBO = new FscPushYcRecvClaimChangeRspBO();
        PebExtUnifySettleTokenQryAbilityReqBO tokenQryAbilityReqBO = new PebExtUnifySettleTokenQryAbilityReqBO();
        tokenQryAbilityReqBO.setUserId(agentAccount);
        PebExtUnifySettleTokenQryAbilityRspBO tokenQryAbilityRspBO = this.pebExtUnifySettlePersonQryAbilityService.qryUnifyPersonToken(tokenQryAbilityReqBO);
        if (!tokenQryAbilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(tokenQryAbilityRspBO.getRespCode(), "\u83b7\u53d6\u7edf\u4e00\u7ed3\u7b97\u7528\u6237token\u4fe1\u606f\u5931\u8d25\uff1a" + tokenQryAbilityRspBO.getMsg());
        }
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("REREC", (Object)REREC);
        jsonObject.put("REREC_LINE", REREC_LINE);
        jsonArray.add((Object)jsonObject);
        FscUnifySettleEncryPtionReqBO encryptionAbilityReqBO = new FscUnifySettleEncryPtionReqBO();
        encryptionAbilityReqBO.setData(jsonArray.toString());
        FscUnifySettleEncryPtionRspBO encryPtionRspBO = this.fscUnifySettleRelatedInterfacesAtomService.dealArrayEncryption(encryptionAbilityReqBO);
        fscPushLogPo.setObjData(jsonArray.toJSONString());
        fscPushLogPo.setPushParseData(encryPtionRspBO.getData());
        FscPushNewYcClaimRefundBillReqBO pushReq = new FscPushNewYcClaimRefundBillReqBO();
        pushReq.setData(encryPtionRspBO.getData());
        pushReq.setToken(tokenQryAbilityRspBO.getData());
        FscPushNewYcClaimRefundBillRspBO pushRsp = this.fscPushNewYcClaimRefundBillService.pushNewYcClaimRefundBill(pushReq);
        FscUnifySettleDecryptionReqBO decryptionAbilityReqBO = new FscUnifySettleDecryptionReqBO();
        decryptionAbilityReqBO.setData("0000".equals(pushRsp.getRespCode()) ? pushRsp.getData() : pushRsp.getMsg());
        FscUnifySettleDecryptionRspBO decryptionAbilityRspBO = this.fscUnifySettleRelatedInterfacesAtomService.dealParamDecryption(decryptionAbilityReqBO);
        fscPushLogPo.setRespData(decryptionAbilityRspBO.getData());
        fscPushLogPo.setRespParseData(pushRsp.getRspData());
        rspBO.setRespCode(pushRsp.getRespCode());
        rspBO.setData(decryptionAbilityRspBO.getData());
        return rspBO;
    }

    private void pushFile(FscPushClaimChangeRefundBusiReqBO reqBO, FscRecvClaimChangePO fscRecvClaimPo) {
        try {
            FscAttachmentPO searchAttachmentPO = new FscAttachmentPO();
            searchAttachmentPO.setObjId(reqBO.getChangeId());
            searchAttachmentPO.setAttachmentType(FscConstants.AttachmentType.CLAIM_CHANGE);
            List attachmentPOS = this.fscAttachmentMapper.getList(searchAttachmentPO);
            if (!CollectionUtils.isEmpty((Collection)attachmentPOS)) {
                List fileList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)attachmentPOS), AttachmentBO.class);
                FscPushYcAttachmentAbilityReqBO fscPushYcAttachmentAbilityReqBO = new FscPushYcAttachmentAbilityReqBO();
                fscPushYcAttachmentAbilityReqBO.setObjId(reqBO.getChangeId());
                fscPushYcAttachmentAbilityReqBO.setObjNo(fscRecvClaimPo.getChangeNo());
                fscPushYcAttachmentAbilityReqBO.setObjType(FscConstants.FSC_YC_FILE_TYPE.CLAIM_CHANGE);
                fscPushYcAttachmentAbilityReqBO.setAgentName(fscRecvClaimPo.getHandleUserName());
                fscPushYcAttachmentAbilityReqBO.setAgentAccount(reqBO.getAgentAccount());
                if (fscRecvClaimPo.getHandleUserId() != null) {
                    fscPushYcAttachmentAbilityReqBO.setUserId(fscRecvClaimPo.getHandleUserId().toString());
                } else {
                    fscPushYcAttachmentAbilityReqBO.setUserId(reqBO.getAgentAccount());
                }
                fscPushYcAttachmentAbilityReqBO.setFileList(fileList);
                this.fscSyncPushYcAttachmentAbilityService.syncPushYcAttachment(fscPushYcAttachmentAbilityReqBO);
            }
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u9644\u4ef6\u62a5\u9519" + e.getMessage());
        }
    }

    private Map<String, FscDicDictionaryExernalPO> getDicMap(FscDicDictionaryExernalPO eternalPo) {
        List listByCondition = this.fscDicDictionaryExernalMapper.getListByCondition(eternalPo);
        if (CollectionUtils.isEmpty((Collection)listByCondition)) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u7c7b\u578b\u5b57\u5178\uff01");
        }
        return listByCondition.stream().collect(Collectors.toMap(FscDicDictionaryExernalPO::getCode, Function.identity()));
    }
}

