/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.ability.ContractHtQryListAbilityService;
import com.tydic.contract.ability.bo.ContractHtQryListAbilityReqBO;
import com.tydic.contract.ability.bo.ContractHtQryListAbilityRspBO;
import com.tydic.fsc.bo.UocApprovalLogBO;
import com.tydic.fsc.common.atom.api.FscPushContractAtomService;
import com.tydic.fsc.common.atom.bo.FscPushContractAtomReqBO;
import com.tydic.fsc.common.atom.bo.FscPushContractAtomRspBO;
import com.tydic.fsc.common.atom.bo.FscPushContractParamAtomReqBO;
import com.tydic.fsc.common.atom.bo.FscPushContractParamPayAtomReqBO;
import com.tydic.fsc.common.atom.bo.FscPushContractPayAtomReqBO;
import com.tydic.fsc.common.atom.bo.FscPushContractPayAtomRspBO;
import com.tydic.fsc.common.busi.api.FscPushContractBusiService;
import com.tydic.fsc.common.busi.bo.FscPushContractBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscPushContractBusiRspBO;
import com.tydic.fsc.common.busi.bo.FscPushContractPayBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscPushContractPayBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscPushLogMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.dao.UocApprovalLogMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscPushLogPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.po.UocApprovalLogPO;
import com.tydic.umc.general.ability.api.UmcEnterpriseQryListAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgDetailBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseQryListAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseQryListAbilityRspBO;
import com.tydic.uoc.common.ability.api.PebQryOrderIsPushHtAbilityService;
import com.tydic.uoc.common.ability.bo.PebQryOrderIsPushHtAbilityBO;
import com.tydic.uoc.common.ability.bo.PebQryOrderIsPushHtAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebQryOrderIsPushHtAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscPushContractBusiServiceImpl
implements FscPushContractBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscPushContractBusiServiceImpl.class);
    @Resource
    private FscOrderMapper fscOrderMapper;
    @Resource
    private FscOrderItemMapper fscOrderItemMapper;
    @Resource
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Resource
    private FscPushLogMapper fscPushLogMapper;
    @Resource
    private FscShouldPayMapper fscShouldPayMapper;
    @Resource
    private UocApprovalLogMapper uocApprovalLogMapper;
    @Autowired
    private FscPushContractAtomService fscPushContractAtomService;
    @Autowired
    private ContractHtQryListAbilityService contractHtQryListAbilityService;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;
    @Autowired
    private PebQryOrderIsPushHtAbilityService pebQryOrderIsPushHtAbilityService;
    @Autowired
    private UmcEnterpriseQryListAbilityService umcEnterpriseQryListAbilityService;

    @Override
    public FscPushContractBusiRspBO dealPushContract(FscPushContractBusiReqBO reqBO) {
        FscPushContractBusiRspBO rspBO = new FscPushContractBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (Objects.isNull((Object)reqBO) || Objects.isNull(reqBO.getFscOrderId())) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        FscOrderPO fscOrderPO = this.fscOrderMapper.qryByFscOrderId(reqBO.getFscOrderId());
        if (Objects.isNull(fscOrderPO) || !FscConstants.OrderFlow.INVOICE.equals(fscOrderPO.getOrderFlow())) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u4fe1\u606f!");
        }
        if (reqBO.getIsContractBack() == null || reqBO.getIsContractBack() != 1) {
            this.fscOrderMapper.updateAlreadyHtNode(reqBO.getFscOrderId());
        }
        boolean upFlag = FscConstants.FscTradeMode.TRADE_MODEL.equals(fscOrderPO.getTradeMode()) && FscConstants.FscOrderReceiveType.OPERATION.equals(fscOrderPO.getReceiveType()) && FscConstants.FscOrderMakeType.SUPPLIER.equals(fscOrderPO.getMakeType());
        FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
        fscOrderRelationPO.setFscOrderId(reqBO.getFscOrderId());
        List relationPOList = this.fscOrderRelationMapper.getList(fscOrderRelationPO);
        if (CollectionUtils.isEmpty((Collection)relationPOList)) {
            log.error("\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u5173\u8054\u4fe1\u606f");
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u5173\u8054\u4fe1\u606f");
        }
        Integer isPushOutHt = 0;
        ArrayList<Long> pushOrderIds = new ArrayList<Long>();
        String pushContractCode = null;
        String contractUuid = null;
        List qryOrderIds = relationPOList.stream().filter(e -> e.getOrderId() != null).map(FscOrderRelationPO::getOrderId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(qryOrderIds)) {
            PebQryOrderIsPushHtAbilityReqBO pushHtAbilityReqBO = new PebQryOrderIsPushHtAbilityReqBO();
            pushHtAbilityReqBO.setOrderIds(qryOrderIds);
            PebQryOrderIsPushHtAbilityRspBO pebQryOrderIsPushHtAbilityRspBO = this.pebQryOrderIsPushHtAbilityService.qryOrderIsPushHt(pushHtAbilityReqBO);
            if (!CollectionUtils.isEmpty((Collection)pebQryOrderIsPushHtAbilityRspBO.getOrderInFoList())) {
                for (PebQryOrderIsPushHtAbilityBO bo : pebQryOrderIsPushHtAbilityRspBO.getOrderInFoList()) {
                    if (bo.getIsPushOutHt() == null || bo.getIsPushOutHt() != 1) continue;
                    isPushOutHt = 1;
                    pushOrderIds.add(bo.getOrderId());
                    if (StringUtils.isEmpty((Object)bo.getContractCode())) continue;
                    pushContractCode = bo.getContractCode();
                    contractUuid = bo.getContractUuid();
                }
            }
        }
        if (isPushOutHt == 0 || StringUtils.isEmpty(pushContractCode)) {
            log.info("\u5f53\u524d\u7ed3\u7b97\u5355\u4e0d\u6765\u6e90\u4e8e\u5408\u540c\uff0c\u65e0\u9700\u63a8\u9001\u5408\u540c\u4e2d\u5fc3");
            return rspBO;
        }
        fscOrderRelationPO.setOrderIds(pushOrderIds);
        List validRelationList = this.fscOrderRelationMapper.getList(fscOrderRelationPO);
        if (CollectionUtils.isEmpty((Collection)validRelationList)) {
            log.error("\u672a\u67e5\u8be2\u5230\u6709\u6548\u7684\u7ed3\u7b97\u5355\u5173\u8054\u5408\u540c\u4fe1\u606f\uff01");
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u6709\u6548\u7684\u7ed3\u7b97\u5355\u5173\u8054\u5408\u540c\u4fe1\u606f\uff01");
        }
        List orderIdList = validRelationList.stream().map(FscOrderRelationPO::getOrderId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(orderIdList)) {
            log.error("\u672a\u67e5\u8be2\u5230\u6709\u6548\u7684\u7ed3\u7b97\u5355\u5173\u8054\u8ba2\u5355\u4fe1\u606f\uff01");
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u6709\u6548\u7684\u7ed3\u7b97\u5355\u5173\u8054\u8ba2\u5355\u4fe1\u606f\uff01");
        }
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderItemPO.setOrderIds(orderIdList);
        List fscOrderItemPOList = this.fscOrderItemMapper.getByOrderIdList(fscOrderItemPO);
        if (CollectionUtils.isEmpty((Collection)fscOrderItemPOList)) {
            log.error("\u672a\u67e5\u8be2\u5230\u6709\u6548\u7684\u7ed3\u7b97\u5355\u660e\u7ec6\u4fe1\u606f\uff01");
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u6709\u6548\u7684\u7ed3\u7b97\u5355\u660e\u7ec6\u4fe1\u606f\uff01");
        }
        this.pushSettle(fscOrderPO, validRelationList, fscOrderItemPOList, upFlag, pushContractCode, contractUuid);
        return rspBO;
    }

    @Override
    public FscPushContractPayBusiRspBO dealPushContractPay(FscPushContractPayBusiReqBO reqBO) {
        PebQryOrderIsPushHtAbilityBO pebQryOrderIsPushHtAbilityBO;
        FscPushContractPayBusiRspBO rspBO = new FscPushContractPayBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (Objects.isNull((Object)reqBO) || Objects.isNull(reqBO.getFscOrderId())) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        FscOrderPO fscOrderPO = this.fscOrderMapper.qryByFscOrderId(reqBO.getFscOrderId());
        if (Objects.isNull(fscOrderPO) || !FscConstants.OrderFlow.PAY.equals(fscOrderPO.getOrderFlow())) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u4ed8\u6b3e\u5355\u4fe1\u606f!");
        }
        if (reqBO.getIsContractBack() == null || reqBO.getIsContractBack() != 1) {
            this.fscOrderMapper.updateAlreadyHtNode(reqBO.getFscOrderId());
        }
        boolean upFlag = this.operationOrgId.equals(fscOrderPO.getPayerId());
        FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
        fscShouldPayPO.setFscOrderId(reqBO.getFscOrderId());
        List shouldPayPOList = this.fscShouldPayMapper.getContractList(fscShouldPayPO);
        if (CollectionUtils.isEmpty((Collection)shouldPayPOList)) {
            log.error("\u672a\u67e5\u8be2\u5230\u4ed8\u6b3e\u5355\u5e94\u4ed8\u4fe1\u606f");
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u4ed8\u6b3e\u5355\u5e94\u4ed8\u4fe1\u606f");
        }
        Integer isPushOutHt = 0;
        String pushContractCode = null;
        String contractUuid = null;
        String orderCodeStr = ((FscShouldPayPO)shouldPayPOList.get(0)).getOrderCodeStr();
        if (StringUtils.isEmpty((Object)orderCodeStr)) {
            log.info("\u5f53\u524d\u4ed8\u6b3e\u5355\u6ca1\u6709\u8ba2\u5355\u7f16\u53f7\uff0c\u65e0\u9700\u63a8\u9001\u5408\u540c\u4e2d\u5fc3");
            return rspBO;
        }
        PebQryOrderIsPushHtAbilityReqBO pebQryOrderIsPushHtAbilityReqBO = new PebQryOrderIsPushHtAbilityReqBO();
        pebQryOrderIsPushHtAbilityReqBO.setOrderCodeStr(orderCodeStr);
        PebQryOrderIsPushHtAbilityRspBO pebQryOrderIsPushHtAbilityRspBO = this.pebQryOrderIsPushHtAbilityService.qryOrderIsPushHt(pebQryOrderIsPushHtAbilityReqBO);
        if (!CollectionUtils.isEmpty((Collection)pebQryOrderIsPushHtAbilityRspBO.getOrderInFoList()) && (pebQryOrderIsPushHtAbilityBO = (PebQryOrderIsPushHtAbilityBO)pebQryOrderIsPushHtAbilityRspBO.getOrderInFoList().get(0)).getIsPushOutHt() != null) {
            isPushOutHt = pebQryOrderIsPushHtAbilityBO.getIsPushOutHt();
            pushContractCode = pebQryOrderIsPushHtAbilityBO.getContractCode();
            contractUuid = pebQryOrderIsPushHtAbilityBO.getContractUuid();
        }
        if (isPushOutHt == 0 || StringUtils.isEmpty(pushContractCode)) {
            log.info("\u5f53\u524d\u7ed3\u7b97\u5355\u4e0d\u6765\u6e90\u4e8e\u5408\u540c\uff0c\u65e0\u9700\u63a8\u9001\u5408\u540c\u4e2d\u5fc3");
            return rspBO;
        }
        Date approveDate = null;
        UocApprovalLogBO uocApprovalLogBO = new UocApprovalLogBO();
        uocApprovalLogBO.setOrderId(reqBO.getFscOrderId());
        uocApprovalLogBO.setFinish(Integer.valueOf(1));
        uocApprovalLogBO.setAuditResult(Integer.valueOf(0));
        List approvalLogPOList = this.uocApprovalLogMapper.listByParam(uocApprovalLogBO);
        if (!CollectionUtils.isEmpty((Collection)approvalLogPOList)) {
            approveDate = ((UocApprovalLogPO)approvalLogPOList.get(0)).getDealTime();
        }
        Map<Long, UmcEnterpriseOrgDetailBO> orgIdMap = this.getOrgInfo(fscOrderPO);
        this.pushPay(fscOrderPO, shouldPayPOList, approveDate, upFlag, pushContractCode, orgIdMap, contractUuid);
        return rspBO;
    }

    private Map<Long, UmcEnterpriseOrgDetailBO> getOrgInfo(FscOrderPO fscOrderPO) {
        Map<Long, UmcEnterpriseOrgDetailBO> orgIdMap = new HashMap<Long, UmcEnterpriseOrgDetailBO>();
        ArrayList<Long> orgIdWebList = new ArrayList<Long>();
        if (fscOrderPO.getPayerId() != null) {
            orgIdWebList.add(fscOrderPO.getPayerId());
        }
        if (fscOrderPO.getPayeeId() != null) {
            orgIdWebList.add(fscOrderPO.getPayeeId());
        }
        if (!CollectionUtils.isEmpty(orgIdWebList)) {
            UmcEnterpriseQryListAbilityReqBO abilityReqBO = new UmcEnterpriseQryListAbilityReqBO();
            abilityReqBO.setOrgIdWebList(orgIdWebList);
            UmcEnterpriseQryListAbilityRspBO abilityRspBO = this.umcEnterpriseQryListAbilityService.qryList(abilityReqBO);
            if (!CollectionUtils.isEmpty((Collection)abilityRspBO.getRows())) {
                orgIdMap = abilityRspBO.getRows().stream().collect(Collectors.toMap(UmcEnterpriseOrgDetailBO::getOrgId, o -> o));
            }
        }
        return orgIdMap;
    }

    private void pushSettle(FscOrderPO fscOrderPO, List<FscOrderRelationPO> validRelationList, List<FscOrderItemPO> fscOrderItemPOList, boolean upFlag, String pushContractCode, String contractUuid) {
        FscPushContractAtomReqBO pushContractAtomReqBO = new FscPushContractAtomReqBO();
        ArrayList<FscPushContractParamAtomReqBO> paramAtomReqBOList = new ArrayList<FscPushContractParamAtomReqBO>();
        pushContractAtomReqBO.setBillingNum(fscOrderPO.getOrderNo());
        pushContractAtomReqBO.setType(upFlag ? 2 : 1);
        Map relationPOMap = validRelationList.stream().collect(Collectors.toMap(FscOrderRelationPO::getOrderId, Function.identity(), (k1, k2) -> k1));
        fscOrderItemPOList.forEach(e -> {
            FscPushContractParamAtomReqBO paramAtomReqBO = new FscPushContractParamAtomReqBO();
            paramAtomReqBO.setBillingLineUuid(e.getId());
            paramAtomReqBO.setOrderLineUuid(e.getOrdItemId());
            paramAtomReqBO.setBillingPrice(e.getAmt());
            if (!CollectionUtils.isEmpty((Map)relationPOMap) && relationPOMap.containsKey(e.getOrderId())) {
                paramAtomReqBO.setContractNum(pushContractCode);
                paramAtomReqBO.setContractUuid(contractUuid);
                paramAtomReqBO.setOrderNum(((FscOrderRelationPO)relationPOMap.get(e.getOrderId())).getOrderNo());
            }
            paramAtomReqBOList.add(paramAtomReqBO);
        });
        pushContractAtomReqBO.setBillingList(paramAtomReqBOList);
        FscPushContractAtomRspBO fscPushContractAtomRspBO = this.fscPushContractAtomService.pushContract(pushContractAtomReqBO);
        int pushStatus = 0;
        String rspData = "";
        if (Objects.nonNull(fscPushContractAtomRspBO)) {
            if ("0000".equals(fscPushContractAtomRspBO.getRespCode())) {
                pushStatus = 1;
            }
            rspData = fscPushContractAtomRspBO.getRespData();
        }
        this.insertLog(fscOrderPO, pushStatus, JSON.toJSONString((Object)pushContractAtomReqBO), rspData, FscConstants.FscPushType.PUSH_CONTRACT_SETTLE);
    }

    public ContractHtQryListAbilityRspBO getOutContractInfo(List<Long> contractIdList) {
        ContractHtQryListAbilityReqBO contractHtQryListAbilityReqBO = new ContractHtQryListAbilityReqBO();
        contractHtQryListAbilityReqBO.setContractIds(contractIdList);
        log.info("\u67e5\u8be2\u5408\u540c\u4e2d\u5fc3\u83b7\u53d6\u5916\u90e8\u5408\u540c\u7f16\u53f7\u8bf7\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString((Object)contractHtQryListAbilityReqBO));
        ContractHtQryListAbilityRspBO contractHtQryListAbilityRspBO = this.contractHtQryListAbilityService.qryHTList(contractHtQryListAbilityReqBO);
        if (Objects.isNull(contractHtQryListAbilityRspBO)) {
            log.error("\u67e5\u8be2\u5408\u540c\u4e2d\u5fc3\u83b7\u53d6\u5916\u90e8\u5408\u540c\u7f16\u53f7\u5931\u8d25\uff01\uff0c\u63a5\u53e3\u672a\u8fd4\u56de\u7ed3\u679c\uff01");
            throw new FscBusinessException("190000", "\u67e5\u8be2\u5408\u540c\u4e2d\u5fc3\u83b7\u53d6\u5916\u90e8\u5408\u540c\u7f16\u53f7\u5931\u8d25\uff01");
        }
        log.info("\u67e5\u8be2\u5408\u540c\u4e2d\u5fc3\u83b7\u53d6\u5916\u90e8\u5408\u540c\u7f16\u53f7\u8bf7\u6c42\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)contractHtQryListAbilityRspBO));
        if (!"0000".equals(contractHtQryListAbilityRspBO.getRespCode())) {
            log.error("\u67e5\u8be2\u5408\u540c\u4e2d\u5fc3\u83b7\u53d6\u5916\u90e8\u5408\u540c\u7f16\u53f7\u5931\u8d25\uff1a" + contractHtQryListAbilityRspBO.getRespDesc());
            throw new FscBusinessException("190000", "\u67e5\u8be2\u5408\u540c\u4e2d\u5fc3\u83b7\u53d6\u5916\u90e8\u5408\u540c\u7f16\u53f7\u5931\u8d25\uff1a" + contractHtQryListAbilityRspBO.getRespDesc());
        }
        return contractHtQryListAbilityRspBO;
    }

    private void pushPay(FscOrderPO fscOrderPO, List<FscShouldPayPO> validShouldPayPOList, Date approveDate, boolean upFlag, String pushContractCode, Map<Long, UmcEnterpriseOrgDetailBO> orgIdMap, String contractUuid) {
        FscPushContractPayAtomReqBO fscPushContractPayAtomReqBO = new FscPushContractPayAtomReqBO();
        fscPushContractPayAtomReqBO.setPaymentNum(fscOrderPO.getOrderNo());
        fscPushContractPayAtomReqBO.setCreationTime(fscOrderPO.getCreateTime());
        fscPushContractPayAtomReqBO.setApprovalTime(approveDate);
        fscPushContractPayAtomReqBO.setPaymentTime(fscOrderPO.getPayTime());
        fscPushContractPayAtomReqBO.setType(upFlag ? 2 : 1);
        ArrayList<FscPushContractParamPayAtomReqBO> lineList = new ArrayList<FscPushContractParamPayAtomReqBO>();
        validShouldPayPOList.forEach(e -> {
            FscPushContractParamPayAtomReqBO paramBO = new FscPushContractParamPayAtomReqBO();
            paramBO.setPaymentLineUuid(e.getOrderPayItemId());
            paramBO.setPaymentPrice(e.getPayAmount());
            paramBO.setContractNum(pushContractCode);
            paramBO.setContractUuid(contractUuid);
            lineList.add(paramBO);
        });
        fscPushContractPayAtomReqBO.setPayerName(fscOrderPO.getPayerName());
        if (fscOrderPO.getPayerId() != null && orgIdMap.containsKey(fscOrderPO.getPayerId())) {
            fscPushContractPayAtomReqBO.setPayerNo(orgIdMap.get(fscOrderPO.getPayerId()).getOrgCode());
            fscPushContractPayAtomReqBO.setPayerErpNo(orgIdMap.get(fscOrderPO.getPayerId()).getErpOrgCode());
            fscPushContractPayAtomReqBO.setPayerName(orgIdMap.get(fscOrderPO.getPayerId()).getOrgName());
        }
        fscPushContractPayAtomReqBO.setPayeeName(fscOrderPO.getPayeeName());
        if (fscOrderPO.getPayeeId() != null && orgIdMap.containsKey(fscOrderPO.getPayeeId())) {
            fscPushContractPayAtomReqBO.setPayeeNo(orgIdMap.get(fscOrderPO.getPayeeId()).getOrgCode());
            fscPushContractPayAtomReqBO.setPayeeErpNo(orgIdMap.get(fscOrderPO.getPayeeId()).getErpOrgCode());
            fscPushContractPayAtomReqBO.setPayeeName(orgIdMap.get(fscOrderPO.getPayeeId()).getOrgName());
        }
        fscPushContractPayAtomReqBO.setLineList(lineList);
        FscPushContractPayAtomRspBO fscPushContractPayAtomRspBO = this.fscPushContractAtomService.pushContractPay(fscPushContractPayAtomReqBO);
        int pushStatus = 0;
        String rspData = "";
        if (Objects.nonNull(fscPushContractPayAtomRspBO)) {
            if ("0000".equals(fscPushContractPayAtomRspBO.getRespCode())) {
                pushStatus = 1;
            }
            rspData = fscPushContractPayAtomRspBO.getRespData();
        }
        this.insertLog(fscOrderPO, pushStatus, JSON.toJSONString((Object)fscPushContractPayAtomReqBO), rspData, FscConstants.FscPushType.PUSH_CONTRACT_PAY);
    }

    private void insertLog(FscOrderPO fscOrderPO, int pushStatus, String reqData, String rspData, Integer type) {
        FscPushLogPO fscPushLogPO = new FscPushLogPO();
        fscPushLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        fscPushLogPO.setObjectId(fscOrderPO.getFscOrderId());
        fscPushLogPO.setObjectNo(fscOrderPO.getOrderNo());
        fscPushLogPO.setStatus(Integer.valueOf(pushStatus));
        fscPushLogPO.setCreateTime(new Date());
        HashMap<String, String> reqMap = new HashMap<String, String>();
        reqMap.put("payload", reqData);
        fscPushLogPO.setObjData(JSONObject.toJSONString(reqMap));
        fscPushLogPO.setType(type);
        fscPushLogPO.setRespData(rspData);
        this.fscPushLogMapper.insert(fscPushLogPO);
    }
}

