/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl.finance;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.excel.util.CollectionUtils;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.common.busi.api.finance.FscFinancePayRefundTempSyncBatchBusiService;
import com.tydic.fsc.common.busi.bo.finance.FscFinancePayRefundTempSyncBatchBusiReqBO;
import com.tydic.fsc.common.busi.bo.finance.FscFinancePayRefundTempSyncBatchBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscAttachmentTempMapper;
import com.tydic.fsc.dao.FscFinanceBankStatementMapper;
import com.tydic.fsc.dao.FscFinanceBankStatementTempMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoTempMapper;
import com.tydic.fsc.dao.FscFinanceRefundItemMapper;
import com.tydic.fsc.dao.FscFinanceRefundItemTempMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscAttachmentTempPO;
import com.tydic.fsc.po.FscFinanceBankStatementPO;
import com.tydic.fsc.po.FscFinanceBankStatementTempPO;
import com.tydic.fsc.po.FscFinanceDraftInfoPO;
import com.tydic.fsc.po.FscFinanceDraftInfoTempPO;
import com.tydic.fsc.po.FscFinanceRefundItemPO;
import com.tydic.fsc.po.FscFinanceRefundItemTempPO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class FscFinancePayRefundTempSyncBatchBusiServiceImpl
implements FscFinancePayRefundTempSyncBatchBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscFinancePayRefundTempSyncBatchBusiServiceImpl.class);
    @Resource
    private FscFinanceDraftInfoTempMapper fscFinanceDraftInfoTempMapper;
    @Resource
    private FscFinanceDraftInfoMapper fscFinanceDraftInfoMapper;
    @Resource
    private FscFinanceBankStatementTempMapper fscFinanceBankStatementTempMapper;
    @Resource
    private FscFinanceBankStatementMapper fscFinanceBankStatementMapper;
    @Resource
    private FscFinanceRefundItemTempMapper fscFinanceRefundItemTempMapper;
    @Resource
    private FscFinanceRefundItemMapper fscFinanceRefundItemMapper;
    @Resource
    private FscAttachmentTempMapper fscAttachmentTempMapper;
    @Resource
    private FscAttachmentMapper fscAttachmentMapper;

    @Override
    public FscFinancePayRefundTempSyncBatchBusiRspBO dealFinancePayRefundTempSyncBatch(FscFinancePayRefundTempSyncBatchBusiReqBO reqBO) {
        FscFinancePayRefundTempSyncBatchBusiRspBO rspBO = new FscFinancePayRefundTempSyncBatchBusiRspBO();
        this.valid(reqBO);
        this.deleteAllByContractIdAndTempId(reqBO);
        this.saveRefundItem(reqBO);
        this.saveDraftInfo(reqBO);
        this.saveBankStatement(reqBO);
        this.saveAttachment(reqBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public void deleteAllByContractIdAndTempId(FscFinancePayRefundTempSyncBatchBusiReqBO reqBo) {
        Long tempId = reqBo.getTempId();
        FscFinanceRefundItemTempPO fscFinanceRefundItemTempPO = new FscFinanceRefundItemTempPO();
        fscFinanceRefundItemTempPO.setTempId(tempId);
        this.fscFinanceRefundItemTempMapper.deleteBy(fscFinanceRefundItemTempPO);
        FscFinanceDraftInfoTempPO draftInfoTempPO = new FscFinanceDraftInfoTempPO();
        draftInfoTempPO.setTempId(tempId);
        this.fscFinanceDraftInfoTempMapper.deleteBy(draftInfoTempPO);
        FscFinanceBankStatementTempPO fscFinanceBankStatementTempPO = new FscFinanceBankStatementTempPO();
        fscFinanceBankStatementTempPO.setTempId(tempId);
        this.fscFinanceBankStatementTempMapper.deleteBy(fscFinanceBankStatementTempPO);
        FscAttachmentTempPO attachmentTempPO = new FscAttachmentTempPO();
        attachmentTempPO.setFscOrderId(tempId);
        attachmentTempPO.setAttachmentType(FscConstants.AttachmentType.REFUND_PAY);
        this.fscAttachmentTempMapper.deleteBy(attachmentTempPO);
    }

    private void saveRefundItem(FscFinancePayRefundTempSyncBatchBusiReqBO reqBO) {
        int count;
        FscFinanceRefundItemPO fscFinanceRefundItemPO = new FscFinanceRefundItemPO();
        fscFinanceRefundItemPO.setRefundId(reqBO.getRefundId());
        List list = this.fscFinanceRefundItemMapper.getList(fscFinanceRefundItemPO);
        ArrayList<FscFinanceRefundItemTempPO> tempList = new ArrayList<FscFinanceRefundItemTempPO>(list.size());
        for (FscFinanceRefundItemPO financeBankStatementPO : list) {
            FscFinanceRefundItemTempPO tempPO = new FscFinanceRefundItemTempPO();
            BeanUtils.copyProperties((Object)financeBankStatementPO, (Object)tempPO);
            tempPO.setTempId(reqBO.getTempId());
            tempPO.setRefundItemTempId(Long.valueOf(Sequence.getInstance().nextId()));
            tempList.add(tempPO);
        }
        if (CollUtil.isNotEmpty(tempList) && (count = this.fscFinanceRefundItemTempMapper.insertBatch(tempList)) != tempList.size()) {
            throw new FscBusinessException("190000", "\u5b58\u50a8\u9000\u6b3e\u660e\u7ec6\u4e34\u65f6\u4fe1\u606f\u5931\u8d25\uff01");
        }
    }

    private Map<Long, FscFinanceRefundItemPO> queryContractByFinanceRefundItemIds(List<Long> financePayItemIds) {
        FscFinanceRefundItemPO fscFinanceRefundItemPO = new FscFinanceRefundItemPO();
        fscFinanceRefundItemPO.setFinanceRefundItemIds(financePayItemIds);
        List fscFinanceRefundItemPOList = this.fscFinanceRefundItemMapper.getList(fscFinanceRefundItemPO);
        return fscFinanceRefundItemPOList.stream().collect(Collectors.toMap(FscFinanceRefundItemPO::getFinanceRefundItemId, Function.identity()));
    }

    private void saveDraftInfo(FscFinancePayRefundTempSyncBatchBusiReqBO reqBO) {
        int count;
        FscFinanceDraftInfoPO fscFinanceDraftInfoPO = new FscFinanceDraftInfoPO();
        fscFinanceDraftInfoPO.setRefundId(reqBO.getRefundId());
        List list = this.fscFinanceDraftInfoMapper.getList(fscFinanceDraftInfoPO);
        List<Long> financePayItemIds = list.stream().map(FscFinanceDraftInfoPO::getFinanceRefundItemId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<Long, FscFinanceRefundItemPO> fscFinanceRefundItemPOMap = this.queryContractByFinanceRefundItemIds(financePayItemIds);
        ArrayList<FscFinanceDraftInfoTempPO> tempList = new ArrayList<FscFinanceDraftInfoTempPO>(list.size());
        for (FscFinanceDraftInfoPO financeDraftInfoPO : list) {
            FscFinanceDraftInfoTempPO tempPO = new FscFinanceDraftInfoTempPO();
            BeanUtils.copyProperties((Object)financeDraftInfoPO, (Object)tempPO);
            tempPO.setTempId(reqBO.getTempId());
            tempPO.setFinanceDraftTempId(Long.valueOf(Sequence.getInstance().nextId()));
            FscFinanceRefundItemPO financeRefundItemPO = fscFinanceRefundItemPOMap.get(financeDraftInfoPO.getFinanceRefundItemId());
            tempPO.setContractId(financeRefundItemPO.getContractId());
            tempList.add(tempPO);
        }
        if (CollUtil.isNotEmpty(tempList) && (count = this.fscFinanceDraftInfoTempMapper.insertBatch(tempList)) != tempList.size()) {
            throw new FscBusinessException("190000", "\u5b58\u50a8\u9000\u6b3e\u7968\u636e\u4e34\u65f6\u4fe1\u606f\u5931\u8d25\uff01");
        }
    }

    private void saveBankStatement(FscFinancePayRefundTempSyncBatchBusiReqBO reqBO) {
        int count;
        FscFinanceBankStatementPO fscFinanceBankStatementPO = new FscFinanceBankStatementPO();
        fscFinanceBankStatementPO.setRefundId(reqBO.getRefundId());
        List list = this.fscFinanceBankStatementMapper.getList(fscFinanceBankStatementPO);
        List<Long> financePayItemIds = list.stream().map(FscFinanceBankStatementPO::getFinanceRefundItemId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<Long, FscFinanceRefundItemPO> fscFinanceRefundItemPOMap = this.queryContractByFinanceRefundItemIds(financePayItemIds);
        ArrayList<FscFinanceBankStatementTempPO> tempList = new ArrayList<FscFinanceBankStatementTempPO>(list.size());
        for (FscFinanceBankStatementPO financeBankStatementPO : list) {
            FscFinanceBankStatementTempPO tempPO = new FscFinanceBankStatementTempPO();
            BeanUtils.copyProperties((Object)financeBankStatementPO, (Object)tempPO);
            tempPO.setTempId(reqBO.getTempId());
            tempPO.setStatementTempId(Long.valueOf(Sequence.getInstance().nextId()));
            FscFinanceRefundItemPO fscFinanceRefundItemPO = fscFinanceRefundItemPOMap.get(financeBankStatementPO.getFinanceRefundItemId());
            tempPO.setContractId(fscFinanceRefundItemPO.getContractId());
            tempList.add(tempPO);
        }
        if (CollUtil.isNotEmpty(tempList) && (count = this.fscFinanceBankStatementTempMapper.insertBatch(tempList)) != tempList.size()) {
            throw new FscBusinessException("190000", "\u5b58\u50a8\u9000\u6b3e\u6d41\u6c34\u4e34\u65f6\u4fe1\u606f\u5931\u8d25\uff01");
        }
    }

    private void saveAttachment(FscFinancePayRefundTempSyncBatchBusiReqBO reqBO) {
        int count;
        FscAttachmentPO attachmentPO = new FscAttachmentPO();
        attachmentPO.setFscOrderId(reqBO.getRefundId());
        List attachmentPOList = this.fscAttachmentMapper.getList(attachmentPO);
        ArrayList<FscAttachmentTempPO> attachmentTempList = new ArrayList<FscAttachmentTempPO>(attachmentPOList.size());
        for (FscAttachmentPO fscAttachmentPO : attachmentPOList) {
            FscAttachmentTempPO tempPO = new FscAttachmentTempPO();
            BeanUtils.copyProperties((Object)fscAttachmentPO, (Object)tempPO);
            tempPO.setFscOrderId(reqBO.getTempId());
            tempPO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
            attachmentTempList.add(tempPO);
        }
        if (!CollectionUtils.isEmpty(attachmentTempList) && (count = this.fscAttachmentTempMapper.insertBatch(attachmentTempList)) != attachmentTempList.size()) {
            throw new FscBusinessException("190000", "\u5b58\u50a8\u9644\u4ef6\u4fe1\u606f\u5931\u8d25\uff01");
        }
    }

    private void valid(FscFinancePayRefundTempSyncBatchBusiReqBO reqBO) {
        if (reqBO == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getTempId() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e34\u65f6ID[tempId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getRefundId() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u9000\u7968\u5355ID[refundId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

