/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl.finance;

import com.tydic.fsc.bill.ability.api.FscBillAddPushLogAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillDealPushLogAbilityReqBO;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinancePushRefundPayBillReqBO;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinancePushRefundPayBillRspBO;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinancePushRefundPayBillService;
import com.tydic.fsc.common.busi.api.finance.FscFinancePushRefundPayBusiService;
import com.tydic.fsc.common.busi.bo.finance.FscFinancePushRefundPayBusiReqBO;
import com.tydic.fsc.common.busi.bo.finance.FscFinancePushRefundPayBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscRefundFinanceMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscRefundFinancePO;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscFinancePushRefundPayBusiServiceImpl
implements FscFinancePushRefundPayBusiService {
    @Autowired
    private FscRefundFinanceMapper fscRefundFinanceMapper;
    @Autowired
    private FscFinancePushRefundPayBillService fscFinancePushRefundPayBillService;
    @Autowired
    private FscBillAddPushLogAbilityService fscBillAddPushLogAbilityService;

    @Override
    public FscFinancePushRefundPayBusiRspBO dealPushRefundPay(FscFinancePushRefundPayBusiReqBO reqBO) {
        FscRefundFinancePO refundFinancePO = new FscRefundFinancePO();
        refundFinancePO.setRefundId(reqBO.getRefundId());
        refundFinancePO = this.fscRefundFinanceMapper.getModelBy(refundFinancePO);
        if (FscConstants.FscPushStatus.SUCCESS.equals(refundFinancePO.getPushFinanceStatus())) {
            throw new FscBusinessException("198888", "\u5f53\u524d\u5355\u636e\u5df2\u63a8\u9001\u6210\u529f,\u8bf7\u52ff\u91cd\u590d\u63a8\u9001\uff01");
        }
        FscFinancePushRefundPayBusiRspBO rspBO = new FscFinancePushRefundPayBusiRspBO();
        FscFinancePushRefundPayBillReqBO payBillReqBO = new FscFinancePushRefundPayBillReqBO();
        payBillReqBO.setRefundMethod(reqBO.getRefundMethod());
        payBillReqBO.setReqData(reqBO.getReqData());
        payBillReqBO.setToken(reqBO.getToken());
        FscFinancePushRefundPayBillRspBO payBillRspBO = this.fscFinancePushRefundPayBillService.pushRefundPayBill(payBillReqBO);
        FscRefundFinancePO updatePo = new FscRefundFinancePO();
        updatePo.setRefundId(reqBO.getRefundId());
        if ("0000".equals(payBillRspBO.getRespCode())) {
            updatePo.setPushFinanceStatus(FscConstants.FscPushStatus.SUCCESS);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        } else {
            updatePo.setPushFinanceStatus(FscConstants.FscPushStatus.FAIL);
            updatePo.setPushFinanceRemark(payBillRspBO.getRespDesc());
            rspBO.setRespCode("190000");
            rspBO.setRespDesc(payBillRspBO.getRespDesc());
        }
        this.fscRefundFinanceMapper.updateById(updatePo);
        FscBillDealPushLogAbilityReqBO abilityReqBO = new FscBillDealPushLogAbilityReqBO();
        abilityReqBO.setCreateTime(new Date());
        if (FscConstants.PaymentMethod.PRE_PAY.toString().equals(reqBO.getRefundMethod())) {
            abilityReqBO.setType(FscConstants.FscPurchasePushType.REFUND_PRE_PAY);
        } else {
            abilityReqBO.setType(FscConstants.FscPurchasePushType.REFUND_BEL_PAY);
        }
        abilityReqBO.setObjectId(reqBO.getRefundId());
        abilityReqBO.setObjectNo(reqBO.getRefundNo());
        abilityReqBO.setPushData(reqBO.getReqData().toJSONString());
        abilityReqBO.setPushStatus(updatePo.getPushFinanceStatus());
        abilityReqBO.setRespData(payBillRspBO.getRespData());
        this.fscBillAddPushLogAbilityService.savePurchasePushLog(abilityReqBO);
        return rspBO;
    }

    @Override
    public FscFinancePushRefundPayBusiRspBO updateFailLog(FscFinancePushRefundPayBusiReqBO reqBO) {
        if (!StringUtils.isEmpty((String)reqBO.getFailRemark()) && reqBO.getFailRemark().length() > 500) {
            reqBO.setFailRemark(reqBO.getFailRemark().substring(0, 500));
        }
        FscRefundFinancePO financePO = new FscRefundFinancePO();
        financePO.setRefundId(reqBO.getRefundId());
        financePO.setPushFinanceStatus(FscConstants.FscPushStatus.FAIL);
        financePO.setUpdateTime(new Date());
        financePO.setPushFinanceRemark(reqBO.getFailRemark());
        this.fscRefundFinanceMapper.updateById(financePO);
        FscFinancePushRefundPayBusiRspBO rspBO = new FscFinancePushRefundPayBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

