/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl.finance;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.common.busi.api.finance.FscFinanceRefundInvoiceFallBackBusiService;
import com.tydic.fsc.common.busi.bo.finance.FscFinanceRefundInvoiceFallBackBusiReqBO;
import com.tydic.fsc.common.busi.bo.finance.FscFinanceRefundInvoiceFallBackBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrdStateChgLogMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscRefundFinanceMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrdStateChgLogPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscRefundFinancePO;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscFinanceRefundInvoiceFallBackBusiServiceImpl
implements FscFinanceRefundInvoiceFallBackBusiService {
    @Autowired
    private FscRefundFinanceMapper fscRefundFinanceMapper;
    @Autowired
    private FscOrdStateChgLogMapper fscOrdStateChgLogMapper;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;

    @Override
    public FscFinanceRefundInvoiceFallBackBusiRspBO dealRefundPayFallBack(FscFinanceRefundInvoiceFallBackBusiReqBO reqBO) {
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(Long.valueOf(reqBO.getBillId()));
        refundPO = this.fscOrderRefundMapper.getModelBy(refundPO);
        if (refundPO == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u9000\u6b3e\u5355\u636e\u4fe1\u606f\uff01");
        }
        if (!refundPO.getRefundStatus().equals(FscConstants.RefundInvoiceStatus.FINANCE_AUDITED)) {
            throw new FscBusinessException("198888", "\u5f53\u524d\u9000\u7968\u5355\u72b6\u6001\u4e0d\u5141\u8bb8\u56de\u9000\uff01");
        }
        FscRefundFinancePO financePO = new FscRefundFinancePO();
        financePO.setRefundId(refundPO.getRefundId());
        financePO.setPushFinanceStatus(FscConstants.FscPushStatus.BACK);
        financePO.setExt1(reqBO.getBackRemark());
        this.fscRefundFinanceMapper.updateById(financePO);
        FscOrderRefundPO updatePO = new FscOrderRefundPO();
        updatePO.setRefundId(refundPO.getRefundId());
        updatePO.setRefundStatus(FscConstants.RefundInvoiceStatus.FINANCE_BACK);
        this.fscOrderRefundMapper.updateById(updatePO);
        FscOrdStateChgLogPO chgLogPO = new FscOrdStateChgLogPO();
        chgLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        chgLogPO.setFscOrderId(refundPO.getRefundId());
        chgLogPO.setChgTime(new Date());
        chgLogPO.setOldState(refundPO.getRefundStatus());
        chgLogPO.setOperId(reqBO.getOperAccount());
        chgLogPO.setNewState(FscConstants.RefundInvoiceStatus.FINANCE_BACK);
        this.fscOrdStateChgLogMapper.insert(chgLogPO);
        FscFinanceRefundInvoiceFallBackBusiRspBO rspBO = new FscFinanceRefundInvoiceFallBackBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRefundId(refundPO.getRefundId());
        return rspBO;
    }
}

