/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl.finance;

import com.tydic.fsc.common.ability.bo.finance.FscFinanceRefundInvoiceRelationTempDeleteReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceRefundInvoiceRelationTempDeleteRspBO;
import com.tydic.fsc.common.busi.api.finance.FscFinanceRefundInvoiceRelationTempDeleteBusiService;
import com.tydic.fsc.dao.FscAttachmentTempMapper;
import com.tydic.fsc.dao.FscInvoiceRefundRelationTempMapper;
import com.tydic.fsc.dao.FscOrderRelationTempMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentTempPO;
import com.tydic.fsc.po.FscInvoiceRefundRelationTempPo;
import com.tydic.fsc.po.FscOrderRelationTempPO;
import java.util.Collection;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscFinanceRefundInvoiceRelationTempDeleteBusiServiceImpl
implements FscFinanceRefundInvoiceRelationTempDeleteBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceRefundInvoiceRelationTempDeleteBusiServiceImpl.class);
    @Autowired
    private FscOrderRelationTempMapper fscOrderRelationTempMapper;
    @Autowired
    private FscInvoiceRefundRelationTempMapper fscInvoiceRefundRelationTempMapper;
    @Autowired
    private FscAttachmentTempMapper fscAttachmentTempMapper;

    @Override
    public FscFinanceRefundInvoiceRelationTempDeleteRspBO dealFinanceRefundInvoiceRelationTempDelete(FscFinanceRefundInvoiceRelationTempDeleteReqBO reqBo) {
        int result;
        this.valid(reqBo);
        if (!CollectionUtils.isEmpty((Collection)reqBo.getInvoiceIdList())) {
            FscInvoiceRefundRelationTempPo relationTempPo = new FscInvoiceRefundRelationTempPo();
            relationTempPo.setInvoiceIdList(reqBo.getInvoiceIdList());
            relationTempPo.setTempId(reqBo.getTempId());
            relationTempPo.setContractId(reqBo.getContractId());
            result = this.fscInvoiceRefundRelationTempMapper.deleteByIds(relationTempPo);
            if (result <= 0 || result != reqBo.getInvoiceIdList().size()) {
                throw new FscBusinessException("\u5931\u8d25", "\u9000\u7968\u7ed3\u7b97\u5355\u53d1\u7968\u4e34\u65f6\u8868\u5220\u9664\u5931\u8d25\uff01");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getAbnormalIdList())) {
            FscOrderRelationTempPO orderRelationTempPO = new FscOrderRelationTempPO();
            orderRelationTempPO.setAbnormalIdList(reqBo.getAbnormalIdList());
            orderRelationTempPO.setTempId(reqBo.getTempId());
            orderRelationTempPO.setContractId(reqBo.getContractId());
            result = this.fscOrderRelationTempMapper.deleteByIds(orderRelationTempPO);
            if (result <= 0 || result != reqBo.getAbnormalIdList().size()) {
                throw new FscBusinessException("\u5931\u8d25", "\u5f02\u5e38\u8ba2\u5355\u660e\u7ec6\u4e34\u65f6\u8868\u5220\u9664\u5931\u8d25\uff01");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getAttachmentIdList())) {
            FscAttachmentTempPO attachmentTempPO = new FscAttachmentTempPO();
            attachmentTempPO.setAttachmentIdList(reqBo.getAttachmentIdList());
            attachmentTempPO.setFscOrderId(reqBo.getTempId());
            attachmentTempPO.setObjId(reqBo.getContractId());
            result = this.fscAttachmentTempMapper.deleteByIds(attachmentTempPO);
            if (result <= 0 || result != reqBo.getAttachmentIdList().size()) {
                throw new FscBusinessException("\u5931\u8d25", "\u9644\u4ef6\u4fe1\u606f\u4e34\u65f6\u8868\u5220\u9664\u5931\u8d25\uff01");
            }
        }
        FscFinanceRefundInvoiceRelationTempDeleteRspBO rspBO = new FscFinanceRefundInvoiceRelationTempDeleteRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void valid(FscFinanceRefundInvoiceRelationTempDeleteReqBO reqBO) {
        if (Objects.isNull(reqBO.getContractId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5408\u540cID[contractId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

