/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl.finance;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceSaveRefundInvoiceTempAbnormalListBo;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceSaveRefundInvoiceTempInvoiceListBo;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceUpdateRefundInvoiceTempReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceUpdateRefundInvoiceTempRspBO;
import com.tydic.fsc.common.ability.bo.finance.FscRefundInvoiceDetailBO;
import com.tydic.fsc.common.busi.api.finance.FscFinanceRefundInvoiceTempUpdateBatchBusiService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentTempMapper;
import com.tydic.fsc.dao.FscInvoiceRefundRelationTempMapper;
import com.tydic.fsc.dao.FscOrderRelationTempMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentTempPO;
import com.tydic.fsc.po.FscInvoiceRefundRelationTempPo;
import com.tydic.fsc.po.FscOrderRelationTempPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscFinanceRefundInvoiceTempUpdateBatchBusiServiceImpl
implements FscFinanceRefundInvoiceTempUpdateBatchBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceRefundInvoiceTempUpdateBatchBusiServiceImpl.class);
    @Autowired
    private FscInvoiceRefundRelationTempMapper fscInvoiceRefundRelationTempMapper;
    @Autowired
    private FscOrderRelationTempMapper fscOrderRelationTempMapper;
    @Autowired
    private FscAttachmentTempMapper fscAttachmentTempMapper;

    @Override
    public FscFinanceUpdateRefundInvoiceTempRspBO dealRefundInvoiceTempUpdateBatch(FscFinanceUpdateRefundInvoiceTempReqBO reqBO) {
        this.valid(reqBO);
        for (FscRefundInvoiceDetailBO detailBO : reqBO.getDetailBOList()) {
            if (detailBO.getTempId() == null || detailBO.getContractId() == null) continue;
            this.fscInvoiceRefundRelationTempMapper.deleteBatchByTempId(detailBO.getTempId(), detailBO.getContractId());
            this.fscOrderRelationTempMapper.deleteBatchByTempId(detailBO.getTempId(), detailBO.getContractId());
            this.fscAttachmentTempMapper.deleteByTempIdAndAttachmentTypeAndContractId(Collections.singletonList(detailBO.getTempId()), FscConstants.AttachmentType.REFUND_INVOICE, detailBO.getContractId());
        }
        ArrayList invoiceRefundRelationTempPoUpdateList = new ArrayList();
        ArrayList abnormalOrderRelationTempPOUpdateList = new ArrayList();
        ArrayList fscAttachmentTempPOUpdateList = new ArrayList();
        for (FscRefundInvoiceDetailBO detailBO : reqBO.getDetailBOList()) {
            String attachmentString;
            List attachmentTempPOList;
            String abnormalTempString;
            List fscOrderRelationTempPOList;
            String invoiceTempString = JSONObject.toJSONString((Object)detailBO.getInvoiceList());
            List invoiceRefundRelationTempPOList = JSONObject.parseArray((String)invoiceTempString, FscInvoiceRefundRelationTempPo.class);
            if (!CollectionUtils.isEmpty((Collection)invoiceRefundRelationTempPOList)) {
                invoiceRefundRelationTempPOList.stream().forEach(invoiceRefundRelationTempPO -> {
                    invoiceRefundRelationTempPO.setTempId(detailBO.getTempId());
                    invoiceRefundRelationTempPO.setFscOrderId(detailBO.getFscOrderId());
                    if (invoiceRefundRelationTempPO.getId() == null) {
                        invoiceRefundRelationTempPO.setCreateTime(new Date());
                    }
                });
                invoiceRefundRelationTempPoUpdateList.addAll(invoiceRefundRelationTempPOList);
            }
            if (!CollectionUtils.isEmpty((Collection)(fscOrderRelationTempPOList = JSONObject.parseArray((String)(abnormalTempString = JSONObject.toJSONString((Object)detailBO.getAbnormalList())), FscOrderRelationTempPO.class)))) {
                fscOrderRelationTempPOList.stream().forEach(orderRelationTempPO -> {
                    orderRelationTempPO.setTempId(detailBO.getTempId());
                    orderRelationTempPO.setFscOrderId(detailBO.getFscOrderId());
                });
                abnormalOrderRelationTempPOUpdateList.addAll(fscOrderRelationTempPOList);
            }
            if (CollectionUtils.isEmpty((Collection)(attachmentTempPOList = JSONObject.parseArray((String)(attachmentString = JSONObject.toJSONString((Object)detailBO.getAttachmentList())), FscAttachmentTempPO.class)))) continue;
            attachmentTempPOList.stream().forEach(attachmentTempPO -> {
                attachmentTempPO.setFscOrderId(detailBO.getTempId());
                attachmentTempPO.setObjId(detailBO.getContractId());
                if (Objects.isNull(attachmentTempPO.getAttachmentId())) {
                    attachmentTempPO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                    attachmentTempPO.setAttachmentType(FscConstants.AttachmentType.REFUND_INVOICE);
                    attachmentTempPO.setObjType(FscConstants.AttachmentType.REFUND_INVOICE);
                }
            });
            fscAttachmentTempPOUpdateList.addAll(attachmentTempPOList);
        }
        if (!CollectionUtils.isEmpty(invoiceRefundRelationTempPoUpdateList)) {
            this.fscInvoiceRefundRelationTempMapper.insertOrUpdateBatch(invoiceRefundRelationTempPoUpdateList);
        }
        if (!CollectionUtils.isEmpty(abnormalOrderRelationTempPOUpdateList)) {
            this.fscOrderRelationTempMapper.insertOrUpdateBatch(abnormalOrderRelationTempPOUpdateList);
        }
        if (!CollectionUtils.isEmpty(fscAttachmentTempPOUpdateList)) {
            this.fscAttachmentTempMapper.insertOrUpdateBatch(fscAttachmentTempPOUpdateList);
        }
        FscFinanceUpdateRefundInvoiceTempRspBO rspBO = new FscFinanceUpdateRefundInvoiceTempRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void valid(FscFinanceUpdateRefundInvoiceTempReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getDetailBOList())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u6570\u636e\u96c6\u5408[detailBOList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (FscRefundInvoiceDetailBO detailBO : reqBO.getDetailBOList()) {
            if (detailBO.getTempId() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u4e34\u65f6ID[tempId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (detailBO.getFscOrderId() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u7ed3\u7b97\u5355ID[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!CollectionUtils.isEmpty((Collection)detailBO.getInvoiceList())) {
                for (FscFinanceSaveRefundInvoiceTempInvoiceListBo invoiceTemp : detailBO.getInvoiceList()) {
                    if (invoiceTemp.getInvoiceId() == null) {
                        throw new FscBusinessException("191000", "\u5165\u53c2\u53d1\u7968ID[invoiceId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (invoiceTemp.getContractId() != null) continue;
                    throw new FscBusinessException("191000", "\u5165\u53c2\u5408\u540cID[contractId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
            }
            if (CollectionUtils.isEmpty((Collection)detailBO.getAbnormalList())) continue;
            for (FscFinanceSaveRefundInvoiceTempAbnormalListBo abnormal : detailBO.getAbnormalList()) {
                if (abnormal.getOrderId() == null) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u8ba2\u5355ID[orderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (abnormal.getContractId() == null) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u5408\u540cID[contractId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (abnormal.getContractNo() == null) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u5408\u540c\u7f16\u53f7[contractNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (abnormal.getContractName() != null) continue;
                throw new FscBusinessException("191000", "\u5165\u53c2\u5408\u540c\u540d\u79f0[contractName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
    }
}

