/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.exception.FscBusinessException;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FscFinanceProjectSegmentUtil {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceProjectSegmentUtil.class);
    private static final String ALGORITHM = "DESede";

    private static SecretKey createKey(String key) {
        SecretKeySpec deskey = null;
        try {
            deskey = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), ALGORITHM);
        }
        catch (Exception e) {
            throw new FscBusinessException("190000", "\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u7cfb\u7edf-\u516b\u5927\u6bb5-\u751f\u6210\u5bc6\u94a5\u5931\u8d25");
        }
        return deskey;
    }

    public static String getDecString(String strMi, String key) {
        log.info("\u516b\u5927\u6bb5-\u8bf7\u6c42\u53c2\u6570(\u89e3\u5bc6\u524d)\uff1a{} key:{}", (Object)strMi, (Object)key);
        if (StringUtils.isBlank((CharSequence)strMi)) {
            return "";
        }
        Base64.Decoder decoder = Base64.getMimeDecoder();
        byte[] byteMing = null;
        byte[] byteMi = null;
        String strMing = "";
        try {
            byteMi = decoder.decode(strMi);
            byteMing = FscFinanceProjectSegmentUtil.decryptMode(key, byteMi);
            strMing = new String(byteMing, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new FscBusinessException("190000", String.format("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u7cfb\u7edf-\u516b\u5927\u6bb5-\u751f\u6210\u5bc6\u94a5\u5931\u8d25 %s", e.getMessage()));
        }
        return strMing;
    }

    private static byte[] decryptMode(String key, byte[] src) {
        try {
            SecretKey desKey = FscFinanceProjectSegmentUtil.createKey(key);
            Cipher c1 = Cipher.getInstance(ALGORITHM);
            c1.init(2, desKey);
            return c1.doFinal(src);
        }
        catch (NoSuchAlgorithmException e1) {
            throw new FscBusinessException("190000", "\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u7cfb\u7edf-\u516b\u5927\u6bb5-\u751f\u6210\u5bc6\u94a5\u5931\u8d25 \u52a0\u5bc6\u7b97\u6cd5\u4e0d\u5b58\u5728");
        }
        catch (NoSuchPaddingException e2) {
            throw new FscBusinessException("190000", "\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u7cfb\u7edf-\u516b\u5927\u6bb5-\u751f\u6210\u5bc6\u94a5\u5931\u8d25 \u6307\u5b9a\u7684\u586b\u5145\u65b9\u6848\u4e0d\u5b58\u5728\u6216\u4e0d\u652f\u6301");
        }
        catch (Exception e3) {
            throw new FscBusinessException("190000", String.format("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u7cfb\u7edf-\u516b\u5927\u6bb5-\u751f\u6210\u5bc6\u94a5\u5931\u8d25 %s", e3.getMessage()));
        }
    }

    public static JSONObject getReqInfo(String reqBo) {
        JSONObject jsonObject = JSON.parseObject((String)reqBo);
        if (jsonObject == null) {
            throw new FscBusinessException("190000", "\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
        }
        JSONObject data = jsonObject.getJSONObject("DATA");
        if (data == null) {
            throw new FscBusinessException("190000", "\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
        }
        JSONObject datainfos = data.getJSONObject("DATAINFOS");
        if (datainfos == null) {
            throw new FscBusinessException("190000", "\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
        }
        return datainfos;
    }
}

