/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.common.ability.api.FscAccountAdvanceChangeAbilityService;
import com.tydic.fsc.common.ability.bo.FscAccountAdvanceChangeAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscAccountAdvanceChangeAbilityRspBO;
import com.tydic.fsc.common.busi.api.FscAccountAdvanceChangeBusiService;
import com.tydic.fsc.common.busi.bo.FscAccountAdvanceChangeBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscAccountAdvanceChangeBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscPayLogMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscPayLogPO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscAccountAdvanceChangeAbilityService"})
public class FscAccountAdvanceChangeAbilityServiceImpl
implements FscAccountAdvanceChangeAbilityService {
    @Autowired
    private FscAccountAdvanceChangeBusiService fscAccountAdvanceChangeBusiService;
    @Autowired
    private FscPayLogMapper fscPayLogMapper;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;

    @PostMapping(value={"dealAdvanceChange"})
    public FscAccountAdvanceChangeAbilityRspBO dealAdvanceChange(@RequestBody FscAccountAdvanceChangeAbilityReqBO reqBO) {
        this.valid(reqBO);
        if (reqBO.getObjId() != null) {
            FscPayLogPO payLogPO = new FscPayLogPO();
            payLogPO.setPayeeId(this.operationOrgId);
            payLogPO.setBusiCategory(FscConstants.FscBusiCategory.ADVANCE_CHANGE);
            payLogPO.setBusiOrderNo(reqBO.getOrderNo());
            payLogPO.setObjId(reqBO.getObjId());
            int count = this.fscPayLogMapper.getCheckBy(payLogPO);
            if (count > 0) {
                FscAccountAdvanceChangeAbilityRspBO rspBO = new FscAccountAdvanceChangeAbilityRspBO();
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u8be5\u5355\u636e\u5df2\u5b8c\u6210\u5f02\u5e38\u53d8\u66f4\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002");
                return rspBO;
            }
        }
        FscAccountAdvanceChangeBusiReqBO busiReqBO = (FscAccountAdvanceChangeBusiReqBO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscAccountAdvanceChangeBusiReqBO.class));
        FscAccountAdvanceChangeBusiRspBO busiRspBO = this.fscAccountAdvanceChangeBusiService.dealAdvanceChange(busiReqBO);
        return (FscAccountAdvanceChangeAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBO)), FscAccountAdvanceChangeAbilityRspBO.class);
    }

    private void valid(FscAccountAdvanceChangeAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getOrderNo())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u8ba2\u5355\u7f16\u53f7[orderNo]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((Object)reqBO.getOrderAmt())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u91d1\u989d[orderAmt]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }
}

