/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderFailLogUpdateBusiReqBO;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityRspBO;
import com.tydic.fsc.common.consumer.FscEsSyncRefundServiceConsumer;
import com.tydic.fsc.common.consumer.bo.FscSyncReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscComRefundSyncAbilityServiceImpl
implements FscComRefundSyncAbilityService {
    @Resource(name="fscSyncRefundListMqServiceProvider")
    private ProxyMessageProducer fscSyncOrderListMqServiceProvider;
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Value(value="${es.FSC_REFUND_SYNC_TOPIC:FSC_REFUND_SYNC_TOPIC}")
    private String topic;
    @Value(value="${es.FSC_REFUND_SYNC_TAG:FSC_REFUND_SYNC_TAG}")
    private String tag;
    @Autowired
    private FscEsSyncRefundServiceConsumer fscEsSyncRefundServiceConsumer;

    public FscComRefundSyncAbilityRspBO syncRefund(FscComRefundSyncAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getRefundIds())) {
            throw new UocProBusinessException("8888", "\u5165\u53c2refundIds\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (Long refundId : reqBO.getRefundIds()) {
            FscSyncReqBO fscSyncReqBO = new FscSyncReqBO();
            fscSyncReqBO.setRefundId(refundId);
            ProxySendResult proxySendResult = this.fscSyncOrderListMqServiceProvider.send(new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)fscSyncReqBO)));
            if ("SEND_OK".equals(proxySendResult.getStatus())) continue;
            this.writeFailLog(refundId, JSONObject.toJSONString((Object)proxySendResult));
        }
        return new FscComRefundSyncAbilityRspBO();
    }

    public FscComRefundSyncAbilityRspBO syncRefundAll(FscComRefundSyncAbilityReqBO reqBO) {
        List refundIds = this.fscOrderRefundMapper.getAllId();
        for (Long refundId : refundIds) {
            FscSyncReqBO fscSyncReqBO = new FscSyncReqBO();
            fscSyncReqBO.setRefundId(refundId);
            ProxySendResult proxySendResult = this.fscSyncOrderListMqServiceProvider.send(new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)fscSyncReqBO)));
            if ("SEND_OK".equals(proxySendResult.getStatus())) continue;
            this.writeFailLog(refundId, JSONObject.toJSONString((Object)proxySendResult));
        }
        return new FscComRefundSyncAbilityRspBO();
    }

    private void writeFailLog(Long refundId, String errDesc) {
        FscOrderFailLogUpdateBusiReqBO fscOrderFailLogUpdateBusiReqBO = new FscOrderFailLogUpdateBusiReqBO();
        fscOrderFailLogUpdateBusiReqBO.setObjId(refundId);
        fscOrderFailLogUpdateBusiReqBO.setBusiFailDesc(errDesc);
        fscOrderFailLogUpdateBusiReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.FSC_ORDER_SYNC_ES);
        this.fscOrderFailLogUpdateBusiService.dealInsert(fscOrderFailLogUpdateBusiReqBO);
    }

    public FscComRefundSyncAbilityRspBO syncTbRefundAll(FscComRefundSyncAbilityReqBO reqBO) {
        FscSyncReqBO fscSyncReqBO = new FscSyncReqBO();
        fscSyncReqBO.setRefundId((Long)reqBO.getRefundIds().get(0));
        ProxyMessage message = new ProxyMessage();
        message.setContent(JSONObject.toJSONString((Object)fscSyncReqBO));
        this.fscEsSyncRefundServiceConsumer.onMessage(message);
        return new FscComRefundSyncAbilityRspBO();
    }
}

