/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.busibase.busi.api.FscEsQryComOrderListBusiService;
import com.tydic.fsc.busibase.busi.bo.FscComOrderListPageQueryBusiReqBO;
import com.tydic.fsc.busibase.busi.bo.FscComOrderListPageQueryBusiRspBO;
import com.tydic.fsc.common.ability.api.FscFinanceWriteOffPageAbilityService;
import com.tydic.fsc.common.ability.bo.FscFinanceWriteOffAdjustBO;
import com.tydic.fsc.common.ability.bo.FscFinanceWriteOffAdjustPageReqBO;
import com.tydic.fsc.common.ability.bo.FscFinanceWriteOffAdjustPageRspBO;
import com.tydic.fsc.common.ability.bo.FscFinanceWriteOffPageReqBo;
import com.tydic.fsc.common.ability.bo.FscFinanceWriteOffPageRspBo;
import com.tydic.fsc.common.ability.bo.FscFinanceWriteOffPageRspBoList;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscFinanceWriteOffAdjustMapper;
import com.tydic.fsc.dao.FscFinanceWriteOffMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscFinanceWriteOffAdjustPO;
import com.tydic.fsc.po.FscFinanceWriteOffPO;
import com.tydic.fsc.po.FscFinanceWriteOffPageRspVO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.uoc.base.constants.PebExtConstant;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscFinanceWriteOffPageAbilityService"})
public class FscFinanceWriteOffPageAbilityServiceImpl
implements FscFinanceWriteOffPageAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceWriteOffPageAbilityServiceImpl.class);
    @Autowired
    private FscEsQryComOrderListBusiService fscEsQryComOrderListBusiService;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscFinanceWriteOffAdjustMapper fscFinanceWriteOffAdjustMapper;
    @Autowired
    private FscFinanceWriteOffMapper fscFinanceWriteOffMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;

    @PostMapping(value={"financeWriteOffQryPage"})
    public FscFinanceWriteOffPageRspBo financeWriteOffQryPage(@RequestBody FscFinanceWriteOffPageReqBo reqBO) {
        ArrayList<Integer> orderTypeList;
        if (null == reqBO.getBillType()) {
            throw new FscBusinessException("190000", "\u5355\u636e\u7c7b\u578bbillType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FscComOrderListPageQueryBusiReqBO qryReqBO = (FscComOrderListPageQueryBusiReqBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscComOrderListPageQueryBusiReqBO.class);
        if (reqBO.getOrderBusiType() != null && reqBO.getOrderBusiType().toString().equals("1")) {
            orderTypeList = new ArrayList<Integer>();
            orderTypeList.add(PebExtConstant.OrderType.CX_AGR_GOODS);
            orderTypeList.add(PebExtConstant.OrderType.CX_AGR);
            qryReqBO.setOrderTypeList(orderTypeList);
            qryReqBO.setNoSettlePlatform(Integer.valueOf(2));
        } else if (reqBO.getOrderBusiType() != null && reqBO.getOrderBusiType().toString().equals("2")) {
            orderTypeList = new ArrayList();
            orderTypeList.add(PebExtConstant.OrderType.TH);
            orderTypeList.add(PebExtConstant.OrderType.GC);
            orderTypeList.add(PebExtConstant.OrderType.FL);
            qryReqBO.setOrderTypeList(orderTypeList);
        } else if (reqBO.getOrderBusiType() != null) {
            orderTypeList = new ArrayList();
            orderTypeList.add(reqBO.getOrderBusiType());
            qryReqBO.setOrderTypeList(orderTypeList);
        }
        if (FscConstants.FinanceWriteOffType.CANCELED.equals(reqBO.getBillType())) {
            Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
            FscFinanceWriteOffPageRspVO writeOffPageRspPO = new FscFinanceWriteOffPageRspVO();
            BeanUtil.copyProperties((Object)reqBO, (Object)writeOffPageRspPO);
            writeOffPageRspPO.setOrderTypeList(qryReqBO.getOrderTypeList());
            List list = this.fscFinanceWriteOffMapper.queryCanceledPage(writeOffPageRspPO, page);
            List rows = JSON.parseArray((String)JSONObject.toJSONString((Object)list), FscFinanceWriteOffPageRspBoList.class);
            for (FscFinanceWriteOffPageRspBoList row : rows) {
                if (null != row.getBusinessType()) {
                    Map orderMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_TYPE");
                    row.setBusinessTypeStr((String)orderMap.get(row.getBusinessType().toString()));
                }
                FscFinanceWriteOffAdjustPO adjustPO = new FscFinanceWriteOffAdjustPO();
                adjustPO.setFscOrderId(row.getFscOrderId());
                adjustPO.setBillType(FscConstants.FinanceWriteOffType.CANCELED);
                List adjustIds = this.fscFinanceWriteOffAdjustMapper.getAdjustIds(adjustPO);
                row.setAdjustIds(adjustIds);
                FscFinanceWriteOffPO writeOffPO = new FscFinanceWriteOffPO();
                writeOffPO.setFscOrderId(row.getFscOrderId());
                List writeOffPOList = this.fscFinanceWriteOffMapper.getList(writeOffPO);
                List payItemIds = writeOffPOList.stream().map(FscFinanceWriteOffPO::getOrderPayItemId).collect(Collectors.toList());
                FscOrderPayItemPO fscOrderPayItemPo = new FscOrderPayItemPO();
                fscOrderPayItemPo.setPayItemIds(payItemIds);
                fscOrderPayItemPo = this.fscOrderPayItemMapper.getPreAmtByItemIds(fscOrderPayItemPo);
                if (null == fscOrderPayItemPo) continue;
                row.setPaidWriteOffAmount(fscOrderPayItemPo.getPurWriteOffAmount());
                row.setPaidAmount(fscOrderPayItemPo.getPaidAmount());
                row.setRemainWriteOffAmount(fscOrderPayItemPo.getPaidAmount().subtract(fscOrderPayItemPo.getPurWriteOffAmount()));
            }
            FscFinanceWriteOffPageRspBo rspBO = new FscFinanceWriteOffPageRspBo();
            rspBO.setRows(rows);
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        qryReqBO.setSettlePlatform(FscConstants.SettlePlatform.FINANCE);
        qryReqBO.setFinanceWriteOffFlag(reqBO.getBillType());
        qryReqBO.setStatus(Arrays.asList(FscConstants.FscInvoiceOrderState.TY_POSTING_PASS));
        FscComOrderListPageQueryBusiRspBO orderList = this.fscEsQryComOrderListBusiService.esQryComOrderList(qryReqBO);
        FscFinanceWriteOffPageRspBo rspBO = new FscFinanceWriteOffPageRspBo();
        List collect = orderList.getRows().stream().map(e -> {
            log.info("FscComOrderListBO:{}", e);
            FscFinanceWriteOffPageRspBoList bo = (FscFinanceWriteOffPageRspBoList)BeanUtil.copyProperties((Object)e, FscFinanceWriteOffPageRspBoList.class);
            bo.setCreateOperTime(e.getCreateTime());
            bo.setBusinessType(e.getOrderType());
            bo.setBusinessTypeStr(e.getOrderTypeStr());
            FscFinanceWriteOffAdjustPO adjustPO = new FscFinanceWriteOffAdjustPO();
            adjustPO.setFscOrderId(e.getFscOrderId());
            adjustPO.setBillType(reqBO.getBillType());
            List adjustIds = this.fscFinanceWriteOffAdjustMapper.getAdjustIds(adjustPO);
            bo.setAdjustIds(adjustIds);
            FscOrderRelationPO relationPO = new FscOrderRelationPO();
            relationPO.setFscOrderId(e.getFscOrderId());
            List list = this.fscOrderRelationMapper.getList(relationPO);
            if (CollectionUtil.isNotEmpty((Collection)list)) {
                bo.setContractNo(StringUtils.join((Iterable)list.stream().map(FscOrderRelationPO::getContractNo).collect(Collectors.toList()), (String)","));
                bo.setContractName(StringUtils.join((Iterable)list.stream().map(FscOrderRelationPO::getContractName).collect(Collectors.toList()), (String)","));
            }
            bo.setBillAmount(null == e.getTotalChargeBill() ? BigDecimal.ZERO : e.getTotalChargeBill().setScale(2, 4));
            if (null == e.getPurPrePayAmount() || null == e.getPurWriteOffAmount()) {
                bo.setPaidAmount(BigDecimal.ZERO);
                bo.setPaidWriteOffAmount(BigDecimal.ZERO);
                bo.setRemainWriteOffAmount(BigDecimal.ZERO);
                return bo;
            }
            bo.setRemainWriteOffAmount(e.getPurNotWriteOffAmount().setScale(2, 4));
            bo.setPaidWriteOffAmount(e.getPurWriteOffAmount().setScale(2, 4));
            bo.setPaidAmount(e.getPurPrePayAmount().setScale(2, 4));
            return bo;
        }).collect(Collectors.toList());
        rspBO.setRows(collect);
        rspBO.setTotal(orderList.getTotal());
        rspBO.setPageNo(orderList.getPageNo());
        rspBO.setRecordsTotal(orderList.getRecordsTotal());
        return rspBO;
    }

    @PostMapping(value={"financeWriteOffAdjustQryPage"})
    public FscFinanceWriteOffAdjustPageRspBO financeWriteOffAdjustQryPage(@RequestBody FscFinanceWriteOffAdjustPageReqBO reqBo) {
        FscFinanceWriteOffAdjustPO fscFinanceWriteOffAdjustPO = this.checkThis(reqBo);
        Page page = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        List list = this.fscFinanceWriteOffAdjustMapper.financeWriteOffAdjustQryPage(fscFinanceWriteOffAdjustPO, page);
        List rows = JSON.parseArray((String)JSONObject.toJSONString((Object)list), FscFinanceWriteOffAdjustBO.class);
        FscFinanceWriteOffAdjustPageRspBO rspBO = new FscFinanceWriteOffAdjustPageRspBO();
        rspBO.setRows(rows);
        rspBO.setPageNo(reqBo.getPageNo());
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private FscFinanceWriteOffAdjustPO checkThis(FscFinanceWriteOffAdjustPageReqBO reqBo) {
        if (reqBo.getTabId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[tabId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBo.getBillType()) {
            throw new FscBusinessException("190000", "\u5355\u636e\u7c7b\u578bbillType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FscFinanceWriteOffAdjustPO fscFinanceWriteOffAdjustPO = (FscFinanceWriteOffAdjustPO)JSON.parseObject((String)JSONObject.toJSONString((Object)reqBo), FscFinanceWriteOffAdjustPO.class);
        ArrayList<Integer> billStatusList = new ArrayList<Integer>();
        if (reqBo.getTabId() == 1) {
            billStatusList.add(FscConstants.WriteOffBillStatus.TO_AUDIT);
            fscFinanceWriteOffAdjustPO.setBillStatusList(billStatusList);
        } else if (reqBo.getTabId() == 2) {
            billStatusList.add(FscConstants.WriteOffBillStatus.AUDIT_FAIL);
            fscFinanceWriteOffAdjustPO.setBillStatusList(billStatusList);
        }
        return fscFinanceWriteOffAdjustPO;
    }
}

