/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameReqBO;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameRspBO;
import com.tydic.authority.busi.bo.UserBO;
import com.tydic.fsc.bo.FscApprovalprocessListBO;
import com.tydic.fsc.bo.FscComOrderListBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.busibase.busi.api.FscEsQryComOrderListBusiService;
import com.tydic.fsc.busibase.busi.bo.FscComOrderListPageQueryBusiReqBO;
import com.tydic.fsc.busibase.busi.bo.FscComOrderListPageQueryBusiRspBO;
import com.tydic.fsc.busibase.busi.bo.FscSaleOrderListPageQueryBusiReqBO;
import com.tydic.fsc.busibase.busi.bo.FscSaleOrderListPageQueryBusiRspBO;
import com.tydic.fsc.busibase.external.api.pay.FscPayTransPayInsService;
import com.tydic.fsc.busibase.external.api.pay.bo.FscPayTransPayInsReqBo;
import com.tydic.fsc.busibase.external.api.pay.bo.FscPayTransPayInsRspBo;
import com.tydic.fsc.common.ability.api.FscComApprovalprocessListQryAbilityService;
import com.tydic.fsc.common.ability.api.FscDictionaryAbilityService;
import com.tydic.fsc.common.ability.api.FscOrderApprovalListPageAbilityService;
import com.tydic.fsc.common.ability.bo.FscComApprovalprocessListQryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComApprovalprocessListQryAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscOrderApprovalListPageAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscOrderApprovalListPageAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscSaleOrderApprovalListPageAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscSaleOrderApprovalListPageAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscOrderFlowEnum;
import com.tydic.fsc.constants.FscOrderSourceEnum;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscInvoicePostMapper;
import com.tydic.fsc.dao.FscOrderExtMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.enums.FscOrderTypeEnum;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscInvoicePostPO;
import com.tydic.fsc.po.FscOrderExtPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.utils.BigDecimalConvert;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscOrderApprovalListPageAbilityService"})
public class FscOrderApprovalListPageAbilityServiceImpl
implements FscOrderApprovalListPageAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscOrderApprovalListPageAbilityServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscInvoicePostMapper fscInvoicePostMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscPayTransPayInsService fscPayTransPayInsService;
    @Autowired
    private FscDictionaryAbilityService fscDictionaryAbilityService;
    @Autowired
    private FscComApprovalprocessListQryAbilityService fscComApprovalprocessListQryAbilityService;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    @Autowired
    private FscEsQryComOrderListBusiService fscEsQryComOrderListBusiService;
    @Autowired
    private FscOrderExtMapper fscOrderExtMapper;
    private final Integer DSP = 1001;
    private final Integer SPTG = 1002;
    private final Integer SPBH = 1003;

    @BigDecimalConvert(value=2)
    @PostMapping(value={"getFscOrderApprovalListPage"})
    public FscOrderApprovalListPageAbilityRspBO getFscOrderApprovalListPage(@RequestBody FscOrderApprovalListPageAbilityReqBO reqBO) {
        log.error("getFscOrderApprovalListPage\u65b9\u6cd5\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        System.out.println("\u91c7\u8d2d\u5355\u4f4d:" + reqBO.getCreateOrgName());
        if (CollectionUtils.isEmpty((Collection)reqBO.getStationsList())) {
            return new FscOrderApprovalListPageAbilityRspBO();
        }
        FscComOrderListPageQueryBusiReqBO qryReqBO = (FscComOrderListPageQueryBusiReqBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscComOrderListPageQueryBusiReqBO.class);
        qryReqBO.setReceiveType(FscConstants.FscOrderReceiveType.OPERATION);
        if (Objects.nonNull(reqBO.getOrderBusiType())) {
            if (FscConstants.FSC_BUSI_TYPE.ELECTRIC.equals(reqBO.getOrderBusiType())) {
                qryReqBO.setOrderSource(FscOrderSourceEnum.ELECTRIC_MARKET.getCode());
            }
            if (FscConstants.FSC_BUSI_TYPE.AGREE.equals(reqBO.getOrderBusiType())) {
                qryReqBO.setOrderSource(FscOrderSourceEnum.ELECTRIC_AREA.getCode());
            }
            if (FscConstants.FSC_BUSI_TYPE.NO_AGREE.equals(reqBO.getOrderBusiType())) {
                qryReqBO.setOrderSource(FscOrderSourceEnum.CONSULT_PRICE_FRAME.getCode());
            }
            if (FscConstants.FSC_BUSI_TYPE.EMPLOYEE.equals(reqBO.getOrderBusiType())) {
                qryReqBO.setOrderType(FscConstants.FSC_BUSI_TYPE.EMPLOYEE);
            }
        }
        if (reqBO.getQueryType().equals(FscConstants.SignQueryType.noAudit)) {
            if (CollectionUtils.isEmpty((Collection)reqBO.getStationsList())) {
                return new FscOrderApprovalListPageAbilityRspBO();
            }
            List<String> stationIds = this.parseTaskId(reqBO.getStationsList());
            qryReqBO.setOrderStates(Collections.singletonList(FscConstants.FscInvoiceOrderState.BILL_APPLY));
            qryReqBO.setTaskOperIdList(stationIds);
        } else if (reqBO.getQueryType().equals(FscConstants.SignQueryType.audited)) {
            qryReqBO.setAuditedTaskOperIdList(Collections.singletonList(reqBO.getUserId().toString()));
        } else {
            qryReqBO.setAuditedTaskOperIdList(Collections.singletonList(reqBO.getUserId().toString()));
        }
        FscComOrderListPageQueryBusiRspBO qryRspBO = this.fscEsQryComOrderListBusiService.getFscPurOrderApprovalListPage(qryReqBO);
        Map fscBusiType = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_BUSI_TYPE");
        Map fscBusiTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_SOURCE_TYPE");
        qryRspBO.getRows().forEach(e -> {
            if (reqBO.getQueryType() == 0) {
                if (FscConstants.FscInvoiceOrderState.BILL_APPLY.equals(e.getOrderState())) {
                    e.setOrderStateStr("\u5ba1\u6279\u4e2d");
                } else if (!FscConstants.FscInvoiceOrderState.BILL_REFUSE.equals(e.getOrderState())) {
                    e.setOrderStateStr("\u5ba1\u6279\u901a\u8fc7");
                }
            } else if (reqBO.getQueryType() == 1) {
                e.setOrderStateStr("\u5ba1\u6279\u4e2d");
            }
            if (Objects.nonNull(e.getOrderSource())) {
                if (FscOrderSourceEnum.CONSULT_PRICE_FRAME.getCode().toString().equals(e.getOrderSource())) {
                    e.setOrderBusiType(FscConstants.FSC_BUSI_TYPE.NO_AGREE.toString());
                    e.setOrderBusiTypeStr((String)fscBusiType.get(FscConstants.FSC_BUSI_TYPE.NO_AGREE.toString()));
                } else if (FscOrderTypeEnum.INDIVIDUAL_SUPERMARKET.getCode().equals(e.getOrderType()) || FscOrderTypeEnum.INDIVIDUALLY.getCode().equals(e.getOrderType())) {
                    e.setOrderBusiType(FscConstants.FSC_BUSI_TYPE.EMPLOYEE.toString());
                    e.setOrderBusiTypeStr((String)fscBusiType.get(FscConstants.FSC_BUSI_TYPE.EMPLOYEE.toString()));
                } else {
                    e.setOrderBusiType(e.getOrderSource());
                    e.setOrderBusiTypeStr((String)fscBusiTypeMap.get(e.getOrderSource()));
                }
            }
        });
        this.buildDetail(qryRspBO);
        FscOrderApprovalListPageAbilityRspBO rspBO = new FscOrderApprovalListPageAbilityRspBO();
        rspBO.setPageNo(qryRspBO.getPageNo());
        rspBO.setTotal(qryRspBO.getTotal());
        rspBO.setRecordsTotal(qryRspBO.getRecordsTotal());
        rspBO.setRows(qryRspBO.getRows());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void buildDetail(FscComOrderListPageQueryBusiRspBO qryRspBO) {
        try {
            if (Objects.isNull(qryRspBO) || CollectionUtils.isEmpty((Collection)qryRspBO.getRows()) || 0 == qryRspBO.getRows().size()) {
                return;
            }
            List fscOrderIds = qryRspBO.getRows().stream().map(FscComOrderListBO::getFscOrderId).collect(Collectors.toList());
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setFscOrderIds(fscOrderIds);
            List fscPayOrderInfo = this.fscOrderMapper.getList(fscOrderPO);
            Map<Object, Object> fscMap = new HashMap();
            Map<Object, Object> fscExtMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)fscPayOrderInfo)) {
                fscMap = fscPayOrderInfo.stream().collect(Collectors.groupingBy(FscOrderPO::getFscOrderId));
            }
            FscOrderExtPO fscOrderExtPo = new FscOrderExtPO();
            fscOrderExtPo.setFscOrderIds(fscOrderIds);
            List list = this.fscOrderExtMapper.getList(fscOrderExtPo);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                fscExtMap = list.stream().collect(Collectors.groupingBy(FscOrderExtPO::getFscOrderId));
            }
            Map<Object, Object> finalFscMap = fscMap;
            HashMap finalFscExtMap = fscExtMap;
            qryRspBO.getRows().forEach(item -> {
                List fscOrderPOS = (List)finalFscMap.get(item.getFscOrderId());
                item.setThisPayAmount(CollectionUtils.isEmpty((Collection)fscOrderPOS) ? null : ((FscOrderPO)fscOrderPOS.get(0)).getTotalCharge());
                List fscOrderExtPOS = (List)finalFscExtMap.get(item.getFscOrderId());
                item.setUnifyDeptName(CollectionUtils.isEmpty((Collection)fscOrderExtPOS) ? null : ((FscOrderExtPO)fscOrderExtPOS.get(0)).getUnifyDeptName());
            });
        }
        catch (Exception e) {
            log.error("\u91c7\u8d2d\u7ed3\u7b97\u5ba1\u6279\u5217\u8868 \u7ec4\u88c5\u53c2\u6570error:{}", (Throwable)e);
        }
    }

    private List<String> parseTaskId(List<Long> stationsList) {
        ArrayList<String> stationIds = new ArrayList<String>(stationsList.size());
        for (Long stationId : stationsList) {
            stationIds.add(stationId.toString());
        }
        return stationIds;
    }

    @BigDecimalConvert(value=2)
    @PostMapping(value={"getFscSaleOrderApprovalListPage"})
    public FscSaleOrderApprovalListPageAbilityRspBO getFscSaleOrderApprovalListPage(@RequestBody FscSaleOrderApprovalListPageAbilityReqBO reqBO) {
        FscSaleOrderApprovalListPageAbilityRspBO rspBO = new FscSaleOrderApprovalListPageAbilityRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getStationsList())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u8be5\u8d26\u53f7\u65e0\u5ba1\u6279\u6743\u9650\uff01");
            return rspBO;
        }
        FscSaleOrderListPageQueryBusiReqBO fscSaleOrderListPageQueryBusiReqBO = (FscSaleOrderListPageQueryBusiReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscSaleOrderListPageQueryBusiReqBO.class);
        if (Objects.nonNull(reqBO.getOrderBusiType())) {
            if (FscConstants.FSC_BUSI_TYPE.ELECTRIC.equals(reqBO.getOrderBusiType())) {
                fscSaleOrderListPageQueryBusiReqBO.setOrderSource(FscOrderSourceEnum.ELECTRIC_MARKET.getCode());
            }
            if (FscConstants.FSC_BUSI_TYPE.AGREE.equals(reqBO.getOrderBusiType())) {
                fscSaleOrderListPageQueryBusiReqBO.setOrderSource(FscOrderSourceEnum.ELECTRIC_AREA.getCode());
            }
            if (FscConstants.FSC_BUSI_TYPE.NO_AGREE.equals(reqBO.getOrderBusiType())) {
                fscSaleOrderListPageQueryBusiReqBO.setOrderSource(FscOrderSourceEnum.CONSULT_PRICE_FRAME.getCode());
            }
            if (FscConstants.FSC_BUSI_TYPE.EMPLOYEE.equals(reqBO.getOrderBusiType())) {
                fscSaleOrderListPageQueryBusiReqBO.setOrderType(FscConstants.FSC_BUSI_TYPE.EMPLOYEE);
            }
        }
        fscSaleOrderListPageQueryBusiReqBO.setSendOperName(reqBO.getAuditOperName());
        if (StringUtils.isEmpty((Object)fscSaleOrderListPageQueryBusiReqBO.getSendOperName()) && StringUtils.isEmpty((Object)fscSaleOrderListPageQueryBusiReqBO.getAuditedTaskOperNameList())) {
            fscSaleOrderListPageQueryBusiReqBO.setSendOperId(reqBO.getUserId() == null ? "" : reqBO.getUserId().toString());
        }
        FscSaleOrderListPageQueryBusiRspBO fscSaleOrderListPageQueryBusiRspBO = this.fscEsQryComOrderListBusiService.getFscSaleOrderApprovalListPage(fscSaleOrderListPageQueryBusiReqBO);
        Map fscBusiTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_SOURCE_TYPE");
        Map fscBusiType = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_BUSI_TYPE");
        fscSaleOrderListPageQueryBusiRspBO.getRows().forEach(e -> {
            if (reqBO.getQueryType() == 2 && FscConstants.FscServiceOrderState.WAIT_BILL_INVOICE.equals(e.getSendState())) {
                e.setSendStateStr("\u5ba1\u6279\u901a\u8fc7");
            }
            if (Objects.nonNull(e.getOrderSource())) {
                if (FscOrderSourceEnum.CONSULT_PRICE_FRAME.getCode().toString().equals(e.getOrderSource())) {
                    e.setOrderBusiType(FscConstants.FSC_BUSI_TYPE.NO_AGREE.toString());
                    e.setOrderBusiTypeStr((String)fscBusiType.get(FscConstants.FSC_BUSI_TYPE.NO_AGREE.toString()));
                } else if (FscOrderTypeEnum.INDIVIDUAL_SUPERMARKET.getCode().equals(e.getOrderType()) || FscOrderTypeEnum.INDIVIDUALLY.getCode().equals(e.getOrderType())) {
                    e.setOrderBusiType(FscConstants.FSC_BUSI_TYPE.EMPLOYEE.toString());
                    e.setOrderBusiTypeStr((String)fscBusiType.get(FscConstants.FSC_BUSI_TYPE.EMPLOYEE.toString()));
                } else {
                    e.setOrderBusiType(e.getOrderSource());
                    e.setOrderBusiTypeStr((String)fscBusiTypeMap.get(e.getOrderSource()));
                }
            }
            if (Integer.valueOf(20).equals(e.getOrderFlow())) {
                if (this.SPBH.equals(e.getSendState())) {
                    e.setSendStateStr("\u5ba1\u6279\u9a73\u56de");
                } else if (this.SPTG.equals(e.getSendState())) {
                    e.setSendStateStr("\u5ba1\u6279\u901a\u8fc7");
                } else if (this.DSP.equals(e.getSendState())) {
                    e.setSendStateStr("\u5f85\u5ba1\u6279");
                }
            }
        });
        rspBO.setPageNo(fscSaleOrderListPageQueryBusiRspBO.getPageNo());
        rspBO.setTotal(fscSaleOrderListPageQueryBusiRspBO.getTotal());
        rspBO.setRecordsTotal(fscSaleOrderListPageQueryBusiRspBO.getRecordsTotal());
        rspBO.setRows(fscSaleOrderListPageQueryBusiRspBO.getRows());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void getOrderInfo(FscComOrderListBO fscComOrderListBO) {
        FscInvoicePO fscInvoicePo = new FscInvoicePO();
        fscInvoicePo.setFscOrderId(fscComOrderListBO.getFscOrderId());
        List fscInvoicePOS = this.fscInvoiceMapper.getList(fscInvoicePo);
        Map buildActionMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_BUILD_ACTION");
        Map orderSourceMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_SOURCE");
        Map shouldPayTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("SHOULD_PAY_TYPE");
        Map payTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_CFC_PAY_TYPE_ALLOW");
        Map busiCategoryMap = this.fscDictionaryBusiService.queryBypCodeBackMap("BUSI_CATEGORY");
        Map signStateMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_SIGN_APPROVAL");
        Map sendStateMap = this.fscDictionaryAbilityService.queryBypCodeBackMap("FSC_ORDER_INVOICE_APPROVAL");
        if (null != fscComOrderListBO.getPayChannel()) {
            FscPayTransPayInsReqBo fscPayTransPayInsReqBo = new FscPayTransPayInsReqBo();
            fscPayTransPayInsReqBo.setPaymentInsId(Collections.singletonList(Long.parseLong(fscComOrderListBO.getPayChannel())));
            FscPayTransPayInsRspBo fscPayTransPayInsRspBo = this.fscPayTransPayInsService.tranPayIns(fscPayTransPayInsReqBo);
            if (!StringUtils.isEmpty((Object)fscPayTransPayInsRspBo)) {
                if (!StringUtils.isEmpty((Object)fscPayTransPayInsRspBo.getPayInsMap())) {
                    fscComOrderListBO.setPayChannelStr((String)fscPayTransPayInsRspBo.getPayInsMap().get(fscComOrderListBO.getPayChannel()));
                }
                if (!StringUtils.isEmpty((Object)fscPayTransPayInsRspBo.getPayMethodMap())) {
                    fscComOrderListBO.setPayMethodStr((String)fscPayTransPayInsRspBo.getPayMethodMap().get(fscComOrderListBO.getPayMethod()));
                }
            }
        }
        BigDecimal totalChargeBill = new BigDecimal("0");
        StringBuilder invoiceNo = new StringBuilder();
        StringBuilder invoiceCode = new StringBuilder();
        if (!CollectionUtils.isEmpty((Collection)fscInvoicePOS)) {
            String invoiceCodeStr;
            ArrayList<Long> mailIdList = new ArrayList<Long>(fscInvoicePOS.size());
            ArrayList<String> billDate = new ArrayList<String>(fscInvoicePOS.size());
            for (FscInvoicePO fscInvoicePO : fscInvoicePOS) {
                totalChargeBill = totalChargeBill.add(fscInvoicePO.getAmt());
                mailIdList.add(fscInvoicePO.getMailId());
                invoiceNo.append(",").append(fscInvoicePO.getInvoiceNo());
                invoiceCode.append(",").append(fscInvoicePO.getInvoiceCode());
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)fscInvoicePO.getBillDate())) continue;
                billDate.add(fscInvoicePO.getBillDate());
            }
            fscComOrderListBO.setTotalChargeBill(totalChargeBill);
            String invoiceNoStr = invoiceNo.toString();
            if (invoiceNoStr.startsWith(",")) {
                invoiceNoStr = invoiceNoStr.replaceFirst(",", "");
            }
            if ((invoiceCodeStr = invoiceCode.toString()).startsWith(",")) {
                invoiceCodeStr = invoiceCodeStr.replaceFirst(",", "");
            }
            fscComOrderListBO.setInvoiceNo(invoiceNoStr);
            fscComOrderListBO.setInvoiceCode(invoiceCodeStr);
            fscComOrderListBO.setBillDate((String)billDate.get(0));
            List InvoicePostPOList = this.fscInvoicePostMapper.getListByIds(mailIdList);
            if (!CollectionUtils.isEmpty((Collection)InvoicePostPOList)) {
                ArrayList<String> sendInfoStr = new ArrayList<String>(InvoicePostPOList.size());
                for (FscInvoicePostPO fscInvoicePostPO : InvoicePostPOList) {
                    String sendCompany = fscInvoicePostPO.getSendCompany();
                    String sendOrder = fscInvoicePostPO.getSendOrder();
                    if (StringUtils.isEmpty((Object)sendCompany) || StringUtils.isEmpty((Object)sendOrder)) continue;
                    sendInfoStr.add((String)sendCompany + "," + sendOrder);
                }
                fscComOrderListBO.setSendInfoStr(sendInfoStr);
            }
        }
        Map InvoiceCategoryMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_INVOICE_CATEGORY");
        Map invoiceTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_INVOICE_TYPE");
        if (!StringUtils.isEmpty((Object)fscComOrderListBO.getInvoiceCategory())) {
            fscComOrderListBO.setInvoiceCategoryStr((String)InvoiceCategoryMap.get(String.valueOf(fscComOrderListBO.getInvoiceCategory())));
        }
        if (!StringUtils.isEmpty((Object)fscComOrderListBO.getInvoiceType())) {
            fscComOrderListBO.setInvoiceTypeStr((String)invoiceTypeMap.get(fscComOrderListBO.getInvoiceType()));
        }
        FscAttachmentPO fscAttachmentPo = new FscAttachmentPO();
        fscAttachmentPo.setFscOrderId(fscComOrderListBO.getFscOrderId());
        List fscAttachmentPOS = this.fscAttachmentMapper.getList(fscAttachmentPo);
        ArrayList<String> attUrls = null;
        if (!CollectionUtils.isEmpty((Collection)fscAttachmentPOS)) {
            attUrls = new ArrayList<String>(fscAttachmentPOS.size());
            for (FscAttachmentPO fscAttachmentPO : fscAttachmentPOS) {
                attUrls.add(fscAttachmentPO.getAttachmentUrl());
            }
        }
        fscComOrderListBO.setOrderFlowStr(Objects.requireNonNull(FscOrderFlowEnum.getInstance((Integer)fscComOrderListBO.getOrderFlow())).getDescr());
        fscComOrderListBO.setBusiCategoryStr((String)busiCategoryMap.get(fscComOrderListBO.getBusiCategory() + ""));
        fscComOrderListBO.setBuildActionStr((String)buildActionMap.get(fscComOrderListBO.getBuildAction() + ""));
        String orderState = (String)signStateMap.get(fscComOrderListBO.getOrderState() + "");
        fscComOrderListBO.setOrderStateStr(StringUtils.isEmpty((Object)orderState) ? "\u5ba1\u6838\u901a\u8fc7" : orderState);
        fscComOrderListBO.setShouldPayTypeStr((String)shouldPayTypeMap.get(fscComOrderListBO.getShouldPayType() + ""));
        fscComOrderListBO.setOrderSourceStr((String)orderSourceMap.get(fscComOrderListBO.getOrderSource() + ""));
        fscComOrderListBO.setPayTypeStr((String)payTypeMap.get(fscComOrderListBO.getPayType() + ""));
        fscComOrderListBO.setSendStateStr((String)sendStateMap.get(fscComOrderListBO.getSendState() + ""));
        fscComOrderListBO.setAttachmentList(attUrls);
        fscComOrderListBO.setPayEvidenceUrls(attUrls);
        FscComApprovalprocessListQryAbilityReqBO fscComApprovalprocessListQryAbilityReqBO = new FscComApprovalprocessListQryAbilityReqBO();
        fscComApprovalprocessListQryAbilityReqBO.setFscOrderId(fscComOrderListBO.getFscOrderId());
        fscComApprovalprocessListQryAbilityReqBO.setObjType(FscConstants.AuditObjType.ORDER_INVOICE_APPROVAL);
        FscComApprovalprocessListQryAbilityRspBO fscApprovalprocessListQry = this.fscComApprovalprocessListQryAbilityService.getFscApprovalprocessListQry(fscComApprovalprocessListQryAbilityReqBO);
        if (!CollectionUtils.isEmpty((Collection)fscApprovalprocessListQry.getRows())) {
            FscApprovalprocessListBO fscApprovalprocessListBO = (FscApprovalprocessListBO)fscApprovalprocessListQry.getRows().get(fscApprovalprocessListQry.getRows().size() - 1);
            if (fscApprovalprocessListBO.getFinish().equals(0)) {
                DycStationOrgSelectUserNameReqBO dycStationOrgSelectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
                dycStationOrgSelectUserNameReqBO.setStationId(Long.valueOf(fscApprovalprocessListBO.getNextStationId()));
                DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.dycStationOrgSelectUserNameService.selectUserName(dycStationOrgSelectUserNameReqBO);
                if (dycStationOrgSelectUserNameRspBO != null && !CollectionUtils.isEmpty((Collection)dycStationOrgSelectUserNameRspBO.getUserList())) {
                    String nextSendOperName = dycStationOrgSelectUserNameRspBO.getUserList().stream().map(UserBO::getName).collect(Collectors.joining(","));
                    fscComOrderListBO.setNextSendOperName(nextSendOperName);
                }
            } else if (fscApprovalprocessListBO.getFinish().equals(1)) {
                fscComOrderListBO.setNextSendOperName(fscApprovalprocessListBO.getOperName());
            }
        }
    }
}

