/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl.finance;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.bo.FscFinanceDraftInfoBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.finance.FscComOrderPayDetailQueryAbilityService;
import com.tydic.fsc.common.ability.bo.finance.FscComOrderPayDetailPayItemListBO;
import com.tydic.fsc.common.ability.bo.finance.FscComOrderPayDetailQueryReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscComOrderPayDetailQueryRspBO;
import com.tydic.fsc.dao.FscFinanceDraftInfoMapper;
import com.tydic.fsc.dao.FscFinancePayItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscFinancePayItemPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.finance.FscComOrderPayDetailQueryAbilityService"})
public class FscComOrderPayDetailQueryAbilityServiceImpl
implements FscComOrderPayDetailQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscComOrderPayDetailQueryAbilityServiceImpl.class);
    @Autowired
    private FscFinancePayItemMapper fscFinancePayItemMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscFinanceDraftInfoMapper fscFinanceDraftInfoMapper;

    @PostMapping(value={"qryOrderPayDetail"})
    public FscComOrderPayDetailQueryRspBO qryOrderPayDetail(@RequestBody FscComOrderPayDetailQueryReqBO reqBO) {
        this.valid(reqBO);
        FscComOrderPayDetailQueryRspBO rspBO = new FscComOrderPayDetailQueryRspBO();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        FscFinancePayItemPO fscFinancePayItemPO = new FscFinancePayItemPO();
        fscFinancePayItemPO.setFscOrderId(Long.valueOf(reqBO.getOrderId()));
        fscFinancePayItemPO.setContractId(reqBO.getContractId());
        List fscFinancePayItemPOList = this.fscFinancePayItemMapper.getListPage(fscFinancePayItemPO, page);
        if (CollectionUtils.isEmpty((Collection)fscFinancePayItemPOList)) {
            return new FscComOrderPayDetailQueryRspBO();
        }
        List financePayItemIds = fscFinancePayItemPOList.stream().map(FscFinancePayItemPO::getFinancePayItemId).collect(Collectors.toList());
        List draftInfoList = new ArrayList();
        if (!CollectionUtils.isEmpty(financePayItemIds)) {
            draftInfoList = this.fscFinanceDraftInfoMapper.getListWithPayItemIds(financePayItemIds);
        }
        List payDetailPayItemListPageBo = JSON.parseArray((String)JSON.toJSONString((Object)fscFinancePayItemPOList), FscComOrderPayDetailPayItemListBO.class);
        List fscFinanceDraftInfoBOList = JSON.parseArray((String)JSON.toJSONString(draftInfoList), FscFinanceDraftInfoBO.class);
        if (!CollectionUtils.isEmpty((Collection)payDetailPayItemListPageBo)) {
            Map currencTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_MONEY_UNIT");
            Map paymethodMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_FINANCE_PAY_METHOD");
            Map isReduceMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_IS_REDUCE");
            Map payStatusMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_PAY_ORDER_STATUS");
            Map isBuyExchangeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_PAY_IS_BUY_EXCHANGE");
            payDetailPayItemListPageBo.stream().forEach(item -> {
                if (!StringUtils.isEmpty((Object)item.getCurrency())) {
                    item.setCurrencyStr((String)currencTypeMap.get(item.getCurrency()));
                }
                if (!StringUtils.isEmpty((Object)item.getFinancePayMethod())) {
                    item.setFinancePayMethodStr((String)paymethodMap.get(item.getFinancePayMethod()));
                }
                if (Objects.nonNull(item.getIsReduce())) {
                    item.setIsReduceStr((String)isReduceMap.get(String.valueOf(item.getIsReduce())));
                }
                if (Objects.nonNull(item.getPayStatus())) {
                    item.setPayStatusStr((String)payStatusMap.get(String.valueOf(item.getPayStatus())));
                }
                if (!StringUtils.isEmpty((Object)item.getIsBuyExchange())) {
                    item.setIsBuyExchangeStr((String)isBuyExchangeMap.get(item.getIsBuyExchange()));
                }
                if (!CollectionUtils.isEmpty((Collection)fscFinanceDraftInfoBOList)) {
                    item.setDraftInfoList(fscFinanceDraftInfoBOList.stream().filter(draftInfo -> draftInfo.getFinancePayItemId().equals(item.getFinancePayItemId())).collect(Collectors.toList()));
                }
            });
        }
        rspBO.setRows(payDetailPayItemListPageBo);
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void valid(FscComOrderPayDetailQueryReqBO reqBO) {
        if (reqBO == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getOrderId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u5355id[orderId]\u4e3a\u7a7a");
        }
    }
}

