/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl.finance;

import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.common.ability.api.finance.FscFinanceProductSegmentListQryAbilityService;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceProductSegmentListQryReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceProductSegmentListQryRspBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceProductSegmentListQryRspBOSegmentList;
import com.tydic.fsc.common.ability.bo.finance.segment.FscFinanceProductSegmentDataInfoReqBO;
import com.tydic.fsc.common.ability.bo.finance.segment.FscSegmentRspBO;
import com.tydic.fsc.common.ability.bo.finance.segment.FscSyncContractSegmentAbilityReqBO;
import com.tydic.fsc.common.ability.bo.finance.segment.FscSyncSegmentDataInfoRspBO;
import com.tydic.fsc.common.ability.bo.finance.segment.FscSyncSegmentDataInfosRspBO;
import com.tydic.fsc.common.ability.bo.finance.segment.FscSyncSegmentDataRspBO;
import com.tydic.fsc.common.ability.bo.finance.segment.FscSyncSegmentEsbRspBO;
import com.tydic.fsc.common.busi.api.finance.FscFinanceDealAddSegmentDataBusiService;
import com.tydic.fsc.common.busi.bo.finance.FscFinanceDealAddSegmentDataBusiRspBO;
import com.tydic.fsc.dao.FscFinanceProductSegmentMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscFinanceProductSegmentPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.finance.FscFinanceProductSegmentListQryAbilityService"})
public class FscFinanceProductSegmentListQryAbilityServiceImpl
implements FscFinanceProductSegmentListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceProductSegmentListQryAbilityServiceImpl.class);
    @Autowired
    private FscFinanceProductSegmentMapper fscFinanceProductSegmentMapper;
    @Autowired
    private FscFinanceDealAddSegmentDataBusiService fscFinanceDealAddSegmentDataBusiService;

    @PostMapping(value={"qryFinanceProductSegmentList"})
    public FscFinanceProductSegmentListQryRspBO qryFinanceProductSegmentList(@RequestBody FscFinanceProductSegmentListQryReqBO reqBo) {
        FscFinanceProductSegmentListQryRspBO rsp = new FscFinanceProductSegmentListQryRspBO();
        FscFinanceProductSegmentPO po = new FscFinanceProductSegmentPO();
        po.setCODE(reqBo.getProductSegmentCode());
        po.setDESC1(reqBo.getProductSegmentName());
        Page page = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        List listPage = this.fscFinanceProductSegmentMapper.getListPage(po, page);
        List row = listPage.stream().map(l -> {
            FscFinanceProductSegmentListQryRspBOSegmentList segmentList = new FscFinanceProductSegmentListQryRspBOSegmentList();
            segmentList.setProductSegmentCode(l.getCODE());
            segmentList.setProductSegmentName(l.getDESC1());
            return segmentList;
        }).collect(Collectors.toList());
        rsp.setRows(row);
        rsp.setTotal(Integer.valueOf(page.getTotalPages()));
        rsp.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rsp.setPageNo(Integer.valueOf(page.getPageNo()));
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u6210\u529f");
        return rsp;
    }

    @PostMapping(value={"addFinanceSegmentData"})
    public FscSegmentRspBO addFinanceSegmentData(@RequestBody FscSyncContractSegmentAbilityReqBO<FscFinanceProductSegmentDataInfoReqBO> reqBO) {
        FscSegmentRspBO rspBO = new FscSegmentRspBO();
        FscSyncSegmentEsbRspBO fscSyncSegmentEsbRspBO = new FscSyncSegmentEsbRspBO();
        fscSyncSegmentEsbRspBO.setRESULT("S");
        String s = this.checkReq(reqBO);
        if (!StringUtils.isEmpty((String)s)) {
            fscSyncSegmentEsbRspBO.setDESC(s);
            fscSyncSegmentEsbRspBO.setRESULT("E");
            rspBO.setESB(fscSyncSegmentEsbRspBO);
            return rspBO;
        }
        fscSyncSegmentEsbRspBO.setDESC("\u6210\u529f");
        ArrayList<FscFinanceProductSegmentPO> poList = new ArrayList<FscFinanceProductSegmentPO>();
        ArrayList fscSyncSegmentDataInfoRspBOS = new ArrayList();
        try {
            FscFinanceDealAddSegmentDataBusiRspBO segmentDataBusiRspBo;
            List dataInfo = reqBO.getESB().getDATA().getDATAINFOS().getDATAINFO().stream().collect(Collectors.collectingAndThen(Collectors.toMap(FscFinanceProductSegmentDataInfoReqBO::getCODE, Function.identity(), (existing, replacement) -> existing), map -> new ArrayList(map.values())));
            dataInfo.forEach(e -> {
                FscFinanceProductSegmentPO segmentPO = new FscFinanceProductSegmentPO();
                BeanUtils.copyProperties((Object)e, (Object)segmentPO);
                segmentPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                segmentPO.setCreateUser(e.getDESC7());
                segmentPO.setCreateTime(new Date());
                segmentPO.setUpdateUser(e.getDESC7());
                segmentPO.setUpdateTime(new Date());
                poList.add(segmentPO);
                FscSyncSegmentDataInfoRspBO fscSyncSegmentDataInfoRspBO = new FscSyncSegmentDataInfoRspBO();
                fscSyncSegmentDataInfoRspBO.setCODE(e.getCODE());
                fscSyncSegmentDataInfoRspBO.setSYNSTATUS("0");
                fscSyncSegmentDataInfoRspBO.setUUID(e.getUUID());
                fscSyncSegmentDataInfoRspBO.setSYNRESULT("\u6210\u529f");
                fscSyncSegmentDataInfoRspBOS.add(fscSyncSegmentDataInfoRspBO);
            });
            if (!CollectionUtils.isEmpty(poList) && !(segmentDataBusiRspBo = this.fscFinanceDealAddSegmentDataBusiService.addProductSegment(poList)).getRespCode().equals("0000")) {
                throw new FscBusinessException(segmentDataBusiRspBo.getRespCode(), segmentDataBusiRspBo.getRespDesc());
            }
        }
        catch (Exception ex) {
            log.error("\u540c\u6b65\u9879\u76ee\u6bb5\u5f02\u5e38\uff1a" + ex);
            fscSyncSegmentEsbRspBO.setDESC(ex.getMessage());
            fscSyncSegmentEsbRspBO.setRESULT("E");
            rspBO.setESB(fscSyncSegmentEsbRspBO);
            return rspBO;
        }
        FscSyncSegmentDataRspBO fscSyncSegmentDataRspBO = new FscSyncSegmentDataRspBO();
        FscSyncSegmentDataInfosRspBO fscSyncSegmentDataInfosRspBO = new FscSyncSegmentDataInfosRspBO();
        fscSyncSegmentDataInfosRspBO.setPUUID(reqBO.getESB().getDATA().getDATAINFOS().getPUUID());
        fscSyncSegmentDataInfosRspBO.setSYNCODE(reqBO.getESB().getDATA().getDATAINFOS().getSYNCODE());
        fscSyncSegmentDataInfosRspBO.setDATAINFO(fscSyncSegmentDataInfoRspBOS);
        fscSyncSegmentDataRspBO.setDATAINFOS(fscSyncSegmentDataInfosRspBO);
        fscSyncSegmentEsbRspBO.setDATA(fscSyncSegmentDataRspBO);
        rspBO.setESB(fscSyncSegmentEsbRspBO);
        return rspBO;
    }

    private String checkReq(FscSyncContractSegmentAbilityReqBO<FscFinanceProductSegmentDataInfoReqBO> reqBO) {
        String s = "";
        if (reqBO.getESB() == null) {
            s = "\u672a\u83b7\u53d6\u5230\u5165\u53c2\u4fe1\u606f";
        } else if (reqBO.getESB().getDATA() == null) {
            s = "\u672a\u83b7\u53d6\u5230\u5165\u53c2\u4fe1\u606f";
        } else if (reqBO.getESB().getDATA().getDATAINFOS() == null) {
            s = "\u672a\u83b7\u53d6\u5230\u5165\u53c2\u4fe1\u606f";
        } else if (CollectionUtils.isEmpty((Collection)reqBO.getESB().getDATA().getDATAINFOS().getDATAINFO())) {
            s = "\u672a\u83b7\u53d6\u5230\u5165\u53c2\u4fe1\u606f";
        } else {
            if (reqBO.getESB().getDATA().getDATAINFOS().getDATAINFO().size() > 1000) {
                s = "\u6bcf\u6b21\u540c\u6b65\u6570\u636e\u4e0d\u80fd\u5927\u4e8e1000\u6761";
            }
            for (FscFinanceProductSegmentDataInfoReqBO dataInfoReqBO : reqBO.getESB().getDATA().getDATAINFOS().getDATAINFO()) {
                if (!StringUtils.isEmpty((String)dataInfoReqBO.getCODE()) && !StringUtils.isEmpty((String)dataInfoReqBO.getDESC1()) && !StringUtils.isEmpty((String)dataInfoReqBO.getUUID())) continue;
                s = "\u5165\u53c2\u4fe1\u606f\u9519\u8bef";
            }
        }
        return s;
    }
}

