/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl.finance;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSONObject;
import com.tydic.contract.ability.FscFinanceSelectContractAmountAbilityService;
import com.tydic.contract.ability.bo.FscFinanceSelectContractAmountReqBO;
import com.tydic.contract.ability.bo.FscFinanceSelectContractAmountRspBo;
import com.tydic.contract.ability.bo.FscFinanceSelectContractAmountRspBoList;
import com.tydic.fsc.bill.ability.api.finance.FscFinanceRedInvoiceUploadTaskAbilityService;
import com.tydic.fsc.bill.ability.bo.finance.FscFinanceRedInvoiceUploadTaskReqBO;
import com.tydic.fsc.bill.ability.bo.finance.FscFinanceRedInvoiceUploadTaskRspBO;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscFinanceAttachmentBO;
import com.tydic.fsc.bo.FscFinanceRefundErpOrderItemBO;
import com.tydic.fsc.bo.FscFinanceRefundInvoiceBO;
import com.tydic.fsc.bo.FscFinanceRefundInvoiceBaseBO;
import com.tydic.fsc.bo.FscFinanceRefundInvoiceContractBO;
import com.tydic.fsc.bo.FscFinanceRefundOrderItemBO;
import com.tydic.fsc.bo.FscPushFinanceAttachmentBO;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinanceShareTokenRspBO;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceShareRelatedInterfacesAtomService;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.api.finance.FscFinanceFileUploadAbilityService;
import com.tydic.fsc.common.ability.api.finance.FscFinancePushRefundInvoiceAbilityService;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceFileUploadAbilityReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceFileUploadAbilityRspBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinancePushRefundInvoiceAbilityReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinancePushRefundInvoiceAbilityRspBO;
import com.tydic.fsc.common.busi.api.finance.FscFinancePushRefundInvoiceBusiService;
import com.tydic.fsc.common.busi.bo.finance.FscFinancePushRefundInvoiceBusiReqBO;
import com.tydic.fsc.common.busi.bo.finance.FscFinancePushRefundInvoiceBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscFinanceWriteOffMapper;
import com.tydic.fsc.dao.FscInvoiceItemMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscRefundFinanceMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.dao.FscUocOrdRhDetailMapper;
import com.tydic.fsc.enums.FscFundsclaimBillTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscFinanceWriteOffPO;
import com.tydic.fsc.po.FscInvoiceItemPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscRefundFinancePO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.po.FscUocOrdRhDetailPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.common.ability.api.UocSalesSingleDetailsListQueryAbilityService;
import com.tydic.uoc.common.ability.bo.UocPebChildOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryRspBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.finance.FscFinancePushRefundInvoiceAbilityService"})
public class FscFinancePushRefundInvoiceAbilityServiceImpl
implements FscFinancePushRefundInvoiceAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscFinancePushRefundInvoiceAbilityServiceImpl.class);
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Autowired
    private FscRefundFinanceMapper fscRefundFinanceMapper;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscInvoiceItemMapper fscInvoiceItemMapper;
    @Autowired
    private FscUocOrdRhDetailMapper fscUocOrdRhDetailMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscFinanceWriteOffMapper fscFinanceWriteOffMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscFinanceFileUploadAbilityService fscFinanceFileUploadAbilityService;
    @Autowired
    private UocSalesSingleDetailsListQueryAbilityService uocSalesSingleDetailsListQueryAbilityService;
    @Autowired
    private FscFinanceSelectContractAmountAbilityService fscFinanceSelectContractAmountAbilityService;
    @Autowired
    private FscFinanceShareRelatedInterfacesAtomService fscFinanceShareRelatedInterfacesAtomService;
    @Autowired
    private FscFinancePushRefundInvoiceBusiService fscFinancePushRefundInvoiceBusiService;
    @Autowired
    private FscComRefundSyncAbilityService fscComRefundSyncAbilityService;
    @Value(value="${saleOrderTabId:30001}")
    private Integer SALE_ORDER_TAB_ID;
    @Autowired
    private FscFinanceRedInvoiceUploadTaskAbilityService fscFinanceRedInvoiceUploadTaskAbilityService;
    private static final String OFF_CONTRACT_CATEGORY_CODE = "EBXN01";
    private static final String OFF_CONTRACT_CATEGORY_NAME = "\u865a\u62df\u5408\u540c";

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealPushRefundInvoice"})
    public FscFinancePushRefundInvoiceAbilityRspBO dealPushRefundInvoice(@RequestBody FscFinancePushRefundInvoiceAbilityReqBO reqBO) {
        if (reqBO.getRefundId() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2[refundId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscRefundFinancePO refundFinancePO = new FscRefundFinancePO();
        refundFinancePO.setRefundId(reqBO.getRefundId());
        refundFinancePO = this.fscRefundFinanceMapper.getModelBy(refundFinancePO);
        if (refundFinancePO == null) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u5bf9\u63a5\u8d22\u52a1\u5171\u4eab\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        if (FscConstants.FscPushStatus.SUCCESS.equals(refundFinancePO.getPushFinanceStatus())) {
            throw new FscBusinessException("190000", "\u5f53\u524d\u5355\u636e\u5df2\u63a8\u9001\u6210\u529f,\u8bf7\u52ff\u91cd\u590d\u63a8\u9001\uff01");
        }
        return this.buildReqParam(refundFinancePO);
    }

    @PostMapping(value={"dealPushRefundInvoiceBatch"})
    public FscFinancePushRefundInvoiceAbilityRspBO dealPushRefundInvoiceBatch(@RequestBody FscFinancePushRefundInvoiceAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getRefundIds())) {
            throw new FscBusinessException("190000", "\u5165\u53c2[refundIds]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        StringBuffer sb = new StringBuffer();
        for (Long refundId : reqBO.getRefundIds()) {
            FscFinancePushRefundInvoiceAbilityReqBO abilityReqBO = new FscFinancePushRefundInvoiceAbilityReqBO();
            abilityReqBO.setRefundId(refundId);
            FscFinancePushRefundInvoiceAbilityRspBO abilityRspBO = this.dealPushRefundInvoice(abilityReqBO);
            if ("0000".equals(abilityRspBO.getRespCode())) continue;
            sb.append(refundId).append("\u63a8\u9001\u5931\u8d25\uff1a").append(abilityRspBO.getRespDesc());
        }
        FscFinancePushRefundInvoiceAbilityRspBO rspBO = new FscFinancePushRefundInvoiceAbilityRspBO();
        if (org.springframework.util.StringUtils.isEmpty((Object)sb.toString())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        } else {
            rspBO.setRespCode("190000");
            rspBO.setRespDesc(sb.toString());
        }
        return rspBO;
    }

    private FscFinancePushRefundInvoiceAbilityRspBO buildReqParam(FscRefundFinancePO refundFinancePO) {
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(refundFinancePO.getRefundId());
        refundPO = this.fscOrderRefundMapper.getModelBy(refundPO);
        try {
            FscOrderFinancePO orderFinancePO = new FscOrderFinancePO();
            orderFinancePO.setFscOrderId(refundPO.getFscOrderId());
            orderFinancePO = this.fscOrderFinanceMapper.getModelBy(orderFinancePO);
            FscFinanceRefundInvoiceBaseBO baseBO = this.buildInvoiceBaseBO(refundPO, refundFinancePO, orderFinancePO);
            List<FscFinanceRefundInvoiceContractBO> contractList = this.buildContractList(refundPO, refundFinancePO);
            FscAttachmentPO attachmentPO = new FscAttachmentPO();
            attachmentPO.setFscOrderId(refundPO.getRefundId());
            attachmentPO.setObjType(FscConstants.AttachmentObjType.REFUND_PAY);
            List attachmentPOList = this.fscAttachmentMapper.getList(attachmentPO);
            baseBO.setAttachmentNum(attachmentPOList.size());
            List<FscPushFinanceAttachmentBO> fileList = this.buildFileList(attachmentPOList, refundFinancePO);
            JSONObject object = new JSONObject();
            object.put("baseInfoData", (Object)baseBO);
            object.put("purSettleContractList", contractList);
            object.put("cmAttachmentList", fileList);
            FscFinancePushRefundInvoiceBusiReqBO busiReqBO = new FscFinancePushRefundInvoiceBusiReqBO();
            busiReqBO.setRefundId(refundPO.getRefundId());
            busiReqBO.setRefundNo(refundPO.getRefundNo());
            busiReqBO.setToken(this.getToken());
            busiReqBO.setObject(object);
            FscFinancePushRefundInvoiceBusiRspBO busiRspBO = this.fscFinancePushRefundInvoiceBusiService.dealPushRefundInvoice(busiReqBO);
            this.sendMq(refundPO.getRefundId());
            return (FscFinancePushRefundInvoiceAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBO)), FscFinancePushRefundInvoiceAbilityRspBO.class);
        }
        catch (Exception e) {
            log.error("\u6784\u5efa\u63a8\u9001\u53c2\u6570\u5931\u8d25\uff1a{}", (Throwable)e);
            FscFinancePushRefundInvoiceBusiReqBO busiReqBO = new FscFinancePushRefundInvoiceBusiReqBO();
            busiReqBO.setRefundId(refundPO.getRefundId());
            busiReqBO.setRefundNo(refundPO.getRefundNo());
            busiReqBO.setFailRemark("\u6784\u5efa\u63a8\u9001\u53c2\u6570\u5931\u8d25\uff1a{}" + e.getMessage());
            this.fscFinancePushRefundInvoiceBusiService.updatePushFail(busiReqBO);
            this.sendMq(refundPO.getRefundId());
            FscFinancePushRefundInvoiceAbilityRspBO abilityRspBO = new FscFinancePushRefundInvoiceAbilityRspBO();
            abilityRspBO.setRespCode("190000");
            abilityRspBO.setRespDesc(e.getMessage());
            return abilityRspBO;
        }
    }

    private List<FscFinanceRefundInvoiceBO> buildInvoiceList(Long refundId, Long contractId) {
        List invoicePOList = this.fscInvoiceMapper.getFinanceRefundList(refundId, contractId);
        if (CollectionUtils.isEmpty((Collection)invoicePOList)) {
            throw new FscBusinessException("190000", contractId + "\u67e5\u8be2\u5408\u540c\u53d1\u7968\u4fe1\u606f\u4e3a\u7a7a");
        }
        List redInvoiceIds = invoicePOList.stream().filter(o -> StringUtils.isBlank((CharSequence)o.getFinanceGuid())).map(FscInvoicePO::getInvoiceId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(redInvoiceIds)) {
            FscFinanceRedInvoiceUploadTaskReqBO fscFinanceRedInvoiceUploadTaskReqBO = new FscFinanceRedInvoiceUploadTaskReqBO();
            fscFinanceRedInvoiceUploadTaskReqBO.setInvoiceIdList(redInvoiceIds);
            fscFinanceRedInvoiceUploadTaskReqBO.setRefundIdList(Collections.singletonList(refundId));
            FscFinanceRedInvoiceUploadTaskRspBO fscFinanceRedInvoiceUploadTaskRspBO = this.fscFinanceRedInvoiceUploadTaskAbilityService.redInvoiceUploadShare(fscFinanceRedInvoiceUploadTaskReqBO);
            if (!"0000".equals(fscFinanceRedInvoiceUploadTaskRspBO.getRespCode())) {
                throw new FscBusinessException(fscFinanceRedInvoiceUploadTaskRspBO.getRespCode(), fscFinanceRedInvoiceUploadTaskRspBO.getRespDesc());
            }
            invoicePOList = this.fscInvoiceMapper.getFinanceRefundList(refundId, contractId);
        }
        ArrayList<FscFinanceRefundInvoiceBO> invoiceList = new ArrayList<FscFinanceRefundInvoiceBO>(invoicePOList.size());
        for (FscInvoicePO fscInvoicePO : invoicePOList) {
            FscFinanceRefundInvoiceBO invoiceBO = new FscFinanceRefundInvoiceBO();
            invoiceBO.setGuid(fscInvoicePO.getInvoiceId() + "");
            invoiceBO.setOriginGuid(fscInvoicePO.getFinanceGuid());
            if ("01".equals(fscInvoicePO.getInvoiceType()) && FscConstants.InvoiceCategory.PAPER.equals(fscInvoicePO.getInvoiceCategory())) {
                invoiceBO.setInvoiceType("1010100");
            } else if ("00".equals(fscInvoicePO.getInvoiceType()) && FscConstants.InvoiceCategory.PAPER.equals(fscInvoicePO.getInvoiceCategory())) {
                invoiceBO.setInvoiceType("1010101");
            } else if ("01".equals(fscInvoicePO.getInvoiceType()) && FscConstants.InvoiceCategory.ELECTRON.equals(fscInvoicePO.getInvoiceCategory())) {
                invoiceBO.setInvoiceType("1010102");
            } else if ("00".equals(fscInvoicePO.getInvoiceType()) && FscConstants.InvoiceCategory.FULL_ELECTRON.equals(fscInvoicePO.getInvoiceCategory())) {
                invoiceBO.setInvoiceType("1010107");
            } else if ("03".equals(fscInvoicePO.getInvoiceType()) && FscConstants.InvoiceCategory.FULL_ELECTRON.equals(fscInvoicePO.getInvoiceCategory())) {
                invoiceBO.setInvoiceType("1010108");
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)fscInvoicePO.getFullElecNo())) {
                invoiceBO.setInvoiceNo(fscInvoicePO.getFullElecNo());
                invoiceBO.setInvoiceCode(null);
            } else {
                invoiceBO.setInvoiceNo(fscInvoicePO.getInvoiceNo());
                invoiceBO.setInvoiceCode(fscInvoicePO.getInvoiceCode());
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)fscInvoicePO.getBillDate()) && fscInvoicePO.getBillDate().length() > 10) {
                invoiceBO.setInvoiceDate(fscInvoicePO.getBillDate().substring(0, 10));
            } else {
                invoiceBO.setInvoiceDate(fscInvoicePO.getBillDate());
            }
            invoiceBO.setInvoiceHeader(fscInvoicePO.getBuyName());
            invoiceBO.setRmbAmount(fscInvoicePO.getUntaxAmt().abs().negate());
            invoiceBO.setRmbTax(fscInvoicePO.getTaxAmt().abs().negate());
            invoiceBO.setRmbAmountTax(fscInvoicePO.getAmt().abs().negate());
            invoiceBO.setCurrOccAmount(fscInvoicePO.getUntaxAmt().abs().negate());
            invoiceBO.setCurrOccAmountTax(fscInvoicePO.getAmt().abs().negate());
            invoiceBO.setTaxRate(null);
            invoiceBO.setCurrOccTax(fscInvoicePO.getTaxAmt().abs().negate());
            invoiceBO.setRemainAmountTax(BigDecimal.ZERO);
            if (org.springframework.util.StringUtils.isEmpty((Object)fscInvoicePO.getPreFullElecNo())) {
                invoiceBO.setOldInvoiceNo(fscInvoicePO.getPreInvoiceNo());
                invoiceBO.setOldInvoiceCode(fscInvoicePO.getPreInvoiceCode());
            } else {
                invoiceBO.setOldInvoiceNo(fscInvoicePO.getPreFullElecNo());
            }
            invoiceList.add(invoiceBO);
        }
        return invoiceList;
    }

    private List<FscFinanceRefundInvoiceContractBO> buildContractList(FscOrderRefundPO refundPO, FscRefundFinancePO refundFinancePO) {
        FscOrderRelationPO relationQueryVo = new FscOrderRelationPO();
        relationQueryVo.setRefundId(refundPO.getRefundId());
        List relationList = this.fscOrderRelationMapper.getRefundInfo(relationQueryVo);
        if (CollectionUtils.isEmpty((Collection)relationList)) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u9000\u7968\u5173\u8054\u4fe1\u606f\u5931\u8d25\uff01");
        }
        Map relationPOMap = relationList.stream().sorted(Comparator.comparingLong(FscOrderRelationPO::getId)).collect(Collectors.toMap(FscOrderRelationPO::getContractId, Function.identity(), (k1, k2) -> k1));
        ArrayList<FscFinanceRefundInvoiceContractBO> contractList = new ArrayList<FscFinanceRefundInvoiceContractBO>(relationPOMap.size());
        List orderIds = relationList.stream().map(FscOrderRelationPO::getOrderId).collect(Collectors.toList());
        UocSalesSingleDetailsListQueryReqBO saleDetailsReqBO = new UocSalesSingleDetailsListQueryReqBO();
        saleDetailsReqBO.setOrderIdList(orderIds);
        saleDetailsReqBO.setTabId(this.SALE_ORDER_TAB_ID);
        saleDetailsReqBO.setPageSize(1000);
        saleDetailsReqBO.setIsAfterSales(Boolean.valueOf(false));
        UocSalesSingleDetailsListQueryRspBO saleDetailsRspBO = this.uocSalesSingleDetailsListQueryAbilityService.getUocSalesSingleDetailsListQuery(saleDetailsReqBO);
        if (!saleDetailsRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(saleDetailsRspBO.getRespCode(), "\u67e5\u8be2\u8ba2\u5355\u7269\u6599\u4fe1\u606f\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a" + saleDetailsRspBO.getRespDesc());
        }
        Map<String, UocPebChildOrderAbilityBO> orderInfoMap = saleDetailsRspBO.getRows().stream().map(e -> (UocPebChildOrderAbilityBO)e.getChildOrderList().get(0)).collect(Collectors.toMap(UocPebChildOrderAbilityBO::getOrderId, Function.identity(), (k1, k2) -> k1));
        List writeOffPOList = this.fscFinanceWriteOffMapper.sumAmtByContractId(refundPO.getFscOrderId());
        FscFinanceSelectContractAmountReqBO fscFinanceSelectContractAmountReqBO = new FscFinanceSelectContractAmountReqBO();
        fscFinanceSelectContractAmountReqBO.setContractIds(relationList.stream().map(FscOrderRelationPO::getContractId).collect(Collectors.toList()));
        FscFinanceSelectContractAmountRspBo fscFinanceSelectContractAmountRspBo = this.fscFinanceSelectContractAmountAbilityService.selectContractAmount(fscFinanceSelectContractAmountReqBO);
        if (Objects.nonNull(fscFinanceSelectContractAmountRspBo) && !"0000".equals(fscFinanceSelectContractAmountRspBo.getRespCode())) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u5408\u540c\u670d\u52a1\u5f02\u5e38\uff01");
        }
        Map<Object, Object> contractMap = CollectionUtils.isEmpty((Collection)fscFinanceSelectContractAmountRspBo.getRows()) ? new HashMap() : fscFinanceSelectContractAmountRspBo.getRows().stream().collect(Collectors.toMap(FscFinanceSelectContractAmountRspBoList::getContractId, Function.identity(), (k1, k2) -> k1));
        Map writeOffMap = writeOffPOList.stream().collect(Collectors.toMap(FscFinanceWriteOffPO::getContractId, Function.identity(), (k1, k2) -> k1));
        Map<Object, Object> contractShouldPayMap = new HashMap();
        FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
        fscShouldPayPO.setObjectId(refundPO.getFscOrderId());
        List fscShouldPayPOList = this.fscShouldPayMapper.getList(fscShouldPayPO);
        if (!CollectionUtils.isEmpty((Collection)fscShouldPayPOList)) {
            contractShouldPayMap = fscShouldPayPOList.stream().collect(Collectors.groupingBy(FscShouldPayPO::getContractId));
        }
        Map<Object, Object> contractInvoiceMap = new HashMap();
        FscInvoicePO fscInvoicePO = new FscInvoicePO();
        fscInvoicePO.setFscOrderId(refundPO.getFscOrderId());
        List fscInvoicePOList = this.fscInvoiceMapper.getList(fscInvoicePO);
        if (!CollectionUtils.isEmpty((Collection)fscInvoicePOList)) {
            contractInvoiceMap = fscInvoicePOList.stream().collect(Collectors.groupingBy(FscInvoicePO::getContractId));
        }
        Map<Object, Object> contractRefundInvoiceMap = new HashMap();
        FscInvoicePO refundInvoicePO = new FscInvoicePO();
        refundInvoicePO.setRefundId(refundPO.getRefundId());
        List refundInvoicePOList = this.fscInvoiceMapper.getList(refundInvoicePO);
        if (!CollectionUtils.isEmpty((Collection)refundInvoicePOList)) {
            contractRefundInvoiceMap = refundInvoicePOList.stream().collect(Collectors.groupingBy(FscInvoicePO::getContractId));
        }
        for (Long key : relationPOMap.keySet()) {
            FscFinanceWriteOffPO writeOffPO;
            FscOrderRelationPO relationPO = (FscOrderRelationPO)relationPOMap.get(key);
            FscFinanceRefundInvoiceContractBO contractBO = new FscFinanceRefundInvoiceContractBO();
            contractBO.setGuid(relationPO.getId() + "");
            contractBO.setContractCode(relationPO.getContractNo());
            contractBO.setContractName(relationPO.getContractName());
            FscFinanceSelectContractAmountRspBoList amountRspBoList = (FscFinanceSelectContractAmountRspBoList)contractMap.get(key);
            if (amountRspBoList != null) {
                contractBO.setContractAmt(amountRspBoList.getContractAmount().divide(BigDecimal.valueOf(10000L), 2, RoundingMode.HALF_UP));
            } else {
                contractBO.setContractAmt(null);
            }
            BigDecimal fscContractAmt = BigDecimal.ZERO;
            List fscInvoicePOS = (List)contractInvoiceMap.get(key);
            if (!CollectionUtils.isEmpty((Collection)fscInvoicePOS)) {
                for (FscInvoicePO invoicePO : fscInvoicePOS) {
                    fscContractAmt = fscContractAmt.add(invoicePO.getAmt());
                }
            }
            if ((writeOffPO = (FscFinanceWriteOffPO)writeOffMap.get(key)) == null) {
                writeOffPO = new FscFinanceWriteOffPO();
                writeOffPO.setWriteOffAmtLocal(BigDecimal.ZERO);
                writeOffPO.setWriteOffAmt(BigDecimal.ZERO);
            }
            BigDecimal shouldPayAmt = BigDecimal.ZERO;
            List fscShouldPayPOS = (List)contractShouldPayMap.get(key);
            if (!CollectionUtils.isEmpty((Collection)fscShouldPayPOS)) {
                for (FscShouldPayPO shouldPayPO : fscShouldPayPOS) {
                    shouldPayAmt = shouldPayAmt.add(shouldPayPO.getPaidAmount());
                }
            }
            BigDecimal toPaidAmt = fscContractAmt.subtract(writeOffPO.getWriteOffAmt()).subtract(shouldPayAmt);
            BigDecimal refundAmt = BigDecimal.ZERO;
            List refundInvoicePoList = (List)contractRefundInvoiceMap.get(key);
            if (!CollectionUtils.isEmpty((Collection)refundInvoicePoList)) {
                for (FscInvoicePO invoicePO : refundInvoicePoList) {
                    refundAmt = refundAmt.add(invoicePO.getAmt().abs());
                }
            }
            contractBO.setCheckAdvPayAmt(refundAmt.compareTo(toPaidAmt) > 0 ? toPaidAmt : refundAmt);
            if (contractBO.getCheckAdvPayAmt().compareTo(BigDecimal.ZERO) > 0) {
                contractBO.setCheckAdvPayLocalAmt(contractBO.getCheckAdvPayAmt().multiply(refundFinancePO.getExchangeRate()).setScale(2, RoundingMode.HALF_UP));
            } else {
                contractBO.setCheckAdvPayLocalAmt(BigDecimal.ZERO);
            }
            contractBO.setSegContractCode(relationPO.getContractSegmentCode());
            contractBO.setSegContractName(relationPO.getContractSegmentName());
            contractBO.setTaxRateCode(null);
            contractBO.setTaxRateName(null);
            contractBO.setTaxRateVal(null);
            contractBO.setContractId(null);
            contractBO.setInvoiceTaxRate(null);
            List<FscFinanceRefundInvoiceBO> invoiceList = this.buildInvoiceList(refundPO.getRefundId(), relationPO.getContractId());
            FscOrderItemPO orderItemQueryVo = new FscOrderItemPO();
            orderItemQueryVo.setRefundId(refundPO.getRefundId());
            orderItemQueryVo.setContractId(relationPO.getContractId());
            List orderItemPOList = this.fscOrderItemMapper.getFinanceList(orderItemQueryVo);
            ArrayList<FscFinanceRefundErpOrderItemBO> erpItemList = new ArrayList<FscFinanceRefundErpOrderItemBO>(orderItemPOList.size());
            ArrayList<FscFinanceRefundOrderItemBO> orderItemList = new ArrayList<FscFinanceRefundOrderItemBO>(orderItemPOList.size());
            this.buildOrderItemList(orderItemPOList, erpItemList, orderItemList, contractBO, refundFinancePO, orderInfoMap);
            contractBO.setInvoiceList(invoiceList);
            contractBO.setSettleEbdetailList(erpItemList);
            contractBO.setSettleNodetailList(orderItemList);
            if (!"2".equals(relationPO.getContractType())) {
                contractBO.setSegContractCode(OFF_CONTRACT_CATEGORY_CODE);
                contractBO.setSegContractName(OFF_CONTRACT_CATEGORY_NAME);
            }
            contractList.add(contractBO);
        }
        return contractList;
    }

    private List<FscPushFinanceAttachmentBO> buildFileList(List<FscAttachmentPO> fscAttachmentPOS, FscRefundFinancePO refundFinancePO) {
        if (CollectionUtils.isEmpty(fscAttachmentPOS)) {
            return new ArrayList<FscPushFinanceAttachmentBO>();
        }
        List boList = JSONObject.parseArray((String)JSONObject.toJSONString(fscAttachmentPOS), AttachmentBO.class);
        FscFinanceFileUploadAbilityReqBO abilityReqBO = new FscFinanceFileUploadAbilityReqBO();
        abilityReqBO.setFileList(boList);
        FscFinanceFileUploadAbilityRspBO abilityRspBO = this.fscFinanceFileUploadAbilityService.dealFinanceUpload(abilityReqBO);
        if (!"0000".equals(abilityRspBO.getRespCode())) {
            throw new FscBusinessException("198888", "\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u9644\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a" + abilityRspBO.getRespDesc());
        }
        ArrayList<FscPushFinanceAttachmentBO> fileList = new ArrayList<FscPushFinanceAttachmentBO>(abilityRspBO.getFileList().size());
        for (FscFinanceAttachmentBO bo : abilityRspBO.getFileList()) {
            FscPushFinanceAttachmentBO pushBo = new FscPushFinanceAttachmentBO();
            pushBo.setFileId(bo.getFileId());
            pushBo.setFileName(bo.getFileName());
            pushBo.setFileSize(bo.getFileSize());
            pushBo.setCreateUserName(refundFinancePO.getCreateUserName());
            pushBo.setCreateUser(refundFinancePO.getCreateUserAccount());
            fileList.add(pushBo);
        }
        return fileList;
    }

    private void buildOrderItemList(List<FscOrderItemPO> orderItemPOList, List<FscFinanceRefundErpOrderItemBO> erpItemList, List<FscFinanceRefundOrderItemBO> orderItemList, FscFinanceRefundInvoiceContractBO contractBO, FscRefundFinancePO refundFinancePO, Map<String, UocPebChildOrderAbilityBO> orderInfoMap) {
        BigDecimal settleAmt = BigDecimal.ZERO;
        BigDecimal settleAmtLocal = BigDecimal.ZERO;
        BigDecimal taxAmt = BigDecimal.ZERO;
        BigDecimal taxLocalAmt = BigDecimal.ZERO;
        FscInvoiceItemPO fscInvoiceItemPO = new FscInvoiceItemPO();
        fscInvoiceItemPO.setRefundId(refundFinancePO.getRefundId());
        List fscInvoiceItemPOList = this.fscInvoiceItemMapper.getList(fscInvoiceItemPO);
        Map<Object, Object> invoiceItemPOMap = CollectionUtils.isEmpty((Collection)fscInvoiceItemPOList) ? new HashMap() : fscInvoiceItemPOList.stream().collect(Collectors.toMap(FscInvoiceItemPO::getOrderItemId, Function.identity(), (k1, k2) -> k1));
        List ordItemIdList = orderItemPOList.stream().map(FscOrderItemPO::getOrdItemId).collect(Collectors.toList());
        FscUocOrdRhDetailPO fscUocOrdRhDetailPO = new FscUocOrdRhDetailPO();
        fscUocOrdRhDetailPO.setOrdItemIdList(ordItemIdList);
        List rhDetailPOList = this.fscUocOrdRhDetailMapper.getList(fscUocOrdRhDetailPO);
        Map<Object, Object> rhDetailPOMap = CollectionUtils.isEmpty((Collection)rhDetailPOList) ? new HashMap() : rhDetailPOList.stream().collect(Collectors.toMap(FscUocOrdRhDetailPO::getOrdItemId, Function.identity(), (k1, k2) -> k1));
        for (FscOrderItemPO orderItemPO : orderItemPOList) {
            if (!orderInfoMap.containsKey(String.valueOf(orderItemPO.getOrderId()))) {
                throw new FscBusinessException("198888", "\u5f53\u524d\u7ed3\u7b97\u660e\u7ec6\u672a\u5339\u914d\u5230\u8ba2\u5355\u4fe1\u606f\uff01\u7ed3\u7b97\u660e\u7ec6ID\uff1a" + orderItemPO.getId());
            }
            UocPebChildOrderAbilityBO orderInfo = orderInfoMap.get(String.valueOf(orderItemPO.getOrderId()));
            settleAmt = settleAmt.add(orderItemPO.getAmt());
            settleAmtLocal = settleAmtLocal.add(orderItemPO.getAmt().multiply(refundFinancePO.getExchangeRate()).setScale(2, RoundingMode.HALF_UP));
            taxAmt = taxAmt.add(orderItemPO.getTaxAmt());
            taxLocalAmt = taxLocalAmt.add(orderItemPO.getTaxAmt().multiply(refundFinancePO.getExchangeRate()).setScale(2, RoundingMode.HALF_UP));
            if (orderInfo.getIsPushErp() != null && orderInfo.getIsPushErp() == 1) {
                FscFinanceRefundErpOrderItemBO erpOrderItemBO = new FscFinanceRefundErpOrderItemBO();
                erpOrderItemBO.setGuid(String.valueOf(orderItemPO.getId()));
                erpOrderItemBO.setSegCompanyCode(null);
                erpOrderItemBO.setSegCompanyName(null);
                erpOrderItemBO.setSegProductCode(orderItemPO.getProductSegmentCode());
                erpOrderItemBO.setSegProductName(orderItemPO.getProductSegmentName());
                erpOrderItemBO.setSegProjectCode(orderItemPO.getProjectCode());
                erpOrderItemBO.setSegProjectName(orderItemPO.getProjectName());
                erpOrderItemBO.setSegContractCode(contractBO.getSegContractCode());
                erpOrderItemBO.setSegContractName(contractBO.getSegContractName());
                erpOrderItemBO.setSegMainSubjectCode(null);
                erpOrderItemBO.setSegMainSubjectName(null);
                erpOrderItemBO.setSegSubSubjectCode(null);
                erpOrderItemBO.setSegSubSubjectName(null);
                erpOrderItemBO.setSegCorrespondentCode(null);
                erpOrderItemBO.setSegCorrespondentName(null);
                erpOrderItemBO.setSegCalcCostCode(orderItemPO.getCostCenterCode());
                erpOrderItemBO.setSegCalcCostName(orderItemPO.getCostCenterName());
                erpOrderItemBO.setSegProduceStageCode(orderItemPO.getProductionLinkCode());
                erpOrderItemBO.setSegProduceStageName(orderItemPO.getProductionLinkName());
                erpOrderItemBO.setSegBakCode(null);
                erpOrderItemBO.setSegBakName(null);
                erpOrderItemBO.setIsErp(PecConstant.IsPushErp.YES);
                erpOrderItemBO.setPurchaseBillCode(orderItemPO.getOrderCode());
                erpOrderItemBO.setBudgetItemCode(orderItemPO.getBudgetItemCode());
                erpOrderItemBO.setBudgetItemName(orderItemPO.getBudgetItemName());
                erpOrderItemBO.setBudgetItemRemainAmt(orderItemPO.getBudgetLeaveAmt());
                erpOrderItemBO.setMaterialCode(orderItemPO.getSkuNo());
                erpOrderItemBO.setMaterialName(orderItemPO.getSkuName());
                erpOrderItemBO.setUnitCode(null);
                erpOrderItemBO.setUnitName(orderItemPO.getSettleUnit());
                erpOrderItemBO.setRemainNum(orderInfo.getDownTotalLeaveInvoiceNum());
                if (!CollectionUtils.isEmpty(invoiceItemPOMap) && invoiceItemPOMap.containsKey(orderItemPO.getOrderItemId())) {
                    BigDecimal diffNum = ((FscInvoiceItemPO)invoiceItemPOMap.get(orderItemPO.getOrderItemId())).getUntaxAmt().subtract(orderItemPO.getUntaxAmt());
                    erpOrderItemBO.setDiffNum(diffNum.stripTrailingZeros());
                } else {
                    erpOrderItemBO.setDiffNum(BigDecimal.ZERO);
                }
                erpOrderItemBO.setMatchAmt(orderItemPO.getUntaxAmt());
                erpOrderItemBO.setMatchLocalAmt(orderItemPO.getAmt().multiply(refundFinancePO.getExchangeRate()));
                erpOrderItemBO.setMatchNum(orderItemPO.getNum().setScale(6, RoundingMode.HALF_UP));
                if (Objects.isNull(orderItemPO.getTaxRate())) {
                    throw new FscBusinessException("198888", "\u7ed3\u7b97\u660e\u7ec6\u7a0e\u7387\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01\u7ed3\u7b97\u660e\u7ec6ID\uff1a" + orderItemPO.getId());
                }
                erpOrderItemBO.setUnitPrice(orderItemPO.getPrice().divide(BigDecimal.ONE.add(orderItemPO.getTaxRate()), 8, RoundingMode.HALF_UP));
                erpOrderItemBO.setUnitTaxPrice(orderItemPO.getPrice());
                erpOrderItemBO.setUnitLocalPrice(erpOrderItemBO.getUnitPrice().multiply(refundFinancePO.getExchangeRate()));
                erpOrderItemBO.setUnitLocalTaxPrice(orderItemPO.getPrice().multiply(refundFinancePO.getExchangeRate()));
                erpOrderItemBO.setAllAmt(orderItemPO.getUntaxAmt().negate());
                erpOrderItemBO.setAllTaxAmt(orderItemPO.getAmt().negate());
                erpOrderItemBO.setAllLocalAmt(orderItemPO.getUntaxAmt().multiply(refundFinancePO.getExchangeRate()).negate());
                erpOrderItemBO.setAllLocalTaxAmt(orderItemPO.getAmt().multiply(refundFinancePO.getExchangeRate()).negate());
                erpOrderItemBO.setTaxRateCode(Objects.nonNull(orderItemPO.getTaxRate()) ? String.valueOf(orderItemPO.getTaxRate().setScale(2, RoundingMode.HALF_UP)) : null);
                erpOrderItemBO.setTaxRateName(orderItemPO.getTaxRate().multiply(new BigDecimal(100)).setScale(0, RoundingMode.HALF_UP) + "%");
                erpOrderItemBO.setTaxRateVal(null);
                erpOrderItemBO.setTaxAmt(orderItemPO.getTaxAmt().negate());
                erpOrderItemBO.setTaxLocalAmt(orderItemPO.getTaxAmt().multiply(refundFinancePO.getExchangeRate()).negate());
                if (!CollectionUtils.isEmpty(rhDetailPOMap) && rhDetailPOMap.containsKey(orderItemPO.getOrdItemId())) {
                    erpOrderItemBO.setReceiveNum(((FscUocOrdRhDetailPO)rhDetailPOMap.get(orderItemPO.getOrdItemId())).getReceiveNum());
                    erpOrderItemBO.setReceiptNum(((FscUocOrdRhDetailPO)rhDetailPOMap.get(orderItemPO.getOrdItemId())).getReceiptNum());
                    erpOrderItemBO.setReceiveAreaCode(((FscUocOrdRhDetailPO)rhDetailPOMap.get(orderItemPO.getOrdItemId())).getRecvAddressCode());
                    erpOrderItemBO.setReceiveAreaName(((FscUocOrdRhDetailPO)rhDetailPOMap.get(orderItemPO.getOrdItemId())).getRecvAddressName());
                    erpOrderItemBO.setDistributeSubjectCode(((FscUocOrdRhDetailPO)rhDetailPOMap.get(orderItemPO.getOrdItemId())).getDistributeSubjectCode());
                    erpOrderItemBO.setDistributeSubjectName(((FscUocOrdRhDetailPO)rhDetailPOMap.get(orderItemPO.getOrdItemId())).getDistributeSubjectName());
                    erpOrderItemBO.setReceived(((FscUocOrdRhDetailPO)rhDetailPOMap.get(orderItemPO.getOrdItemId())).getQuantity());
                    erpOrderItemBO.setShipToOrgId(((FscUocOrdRhDetailPO)rhDetailPOMap.get(orderItemPO.getOrdItemId())).getShipToOrgId());
                }
                erpItemList.add(erpOrderItemBO);
                continue;
            }
            FscFinanceRefundOrderItemBO orderItemBO = new FscFinanceRefundOrderItemBO();
            orderItemBO.setGuid(String.valueOf(orderItemPO.getId()));
            orderItemBO.setSegCompanyCode(null);
            orderItemBO.setSegCompanyName(null);
            orderItemBO.setSegProductCode(orderItemPO.getProductSegmentCode());
            orderItemBO.setSegProductName(orderItemPO.getProductSegmentName());
            orderItemBO.setSegProjectCode(orderItemPO.getProjectCode());
            orderItemBO.setSegProjectName(orderItemPO.getProjectName());
            orderItemBO.setSegContractCode(contractBO.getSegContractCode());
            orderItemBO.setSegContractName(contractBO.getSegContractName());
            orderItemBO.setSegMainSubjectCode(null);
            orderItemBO.setSegMainSubjectName(null);
            orderItemBO.setSegSubSubjectCode(null);
            orderItemBO.setSegSubSubjectName(null);
            orderItemBO.setSegCorrespondentCode(null);
            orderItemBO.setSegCorrespondentName(null);
            orderItemBO.setSegCalcCostCode(orderItemPO.getCostCenterCode());
            orderItemBO.setSegCalcCostName(orderItemPO.getCostCenterName());
            orderItemBO.setSegProduceStageCode(orderItemPO.getProductionLinkCode());
            orderItemBO.setSegProduceStageName(orderItemPO.getProductionLinkName());
            orderItemBO.setSegBakCode(null);
            orderItemBO.setSegBakName(null);
            orderItemBO.setSettleItemCode(orderItemPO.getSettleItemCode());
            orderItemBO.setSettleItemName(orderItemPO.getSettleItemName());
            orderItemBO.setNum(orderItemPO.getNum().setScale(6, RoundingMode.HALF_UP));
            orderItemBO.setPrice(orderItemPO.getPrice());
            orderItemBO.setUnitPrice(orderItemPO.getPrice().divide(BigDecimal.ONE.add(orderItemPO.getTaxRate()), 8, RoundingMode.HALF_UP));
            orderItemBO.setUnitTaxPrice(orderItemPO.getPrice());
            orderItemBO.setUnitLocalPrice(orderItemBO.getUnitPrice().multiply(refundFinancePO.getExchangeRate()));
            orderItemBO.setUnitLocalTaxPrice(orderItemPO.getPrice().multiply(refundFinancePO.getExchangeRate()));
            orderItemBO.setAllAmt(orderItemPO.getUntaxAmt().negate());
            orderItemBO.setAllTaxAmt(orderItemPO.getAmt().negate());
            orderItemBO.setAllLocalAmt(orderItemPO.getUntaxAmt().multiply(refundFinancePO.getExchangeRate()).negate());
            orderItemBO.setAllLocalTaxAmt(orderItemPO.getAmt().multiply(refundFinancePO.getExchangeRate()).negate());
            orderItemBO.setTaxRateCode(Objects.nonNull(orderItemPO.getTaxRate()) ? String.valueOf(orderItemPO.getTaxRate().setScale(2, RoundingMode.HALF_UP)) : null);
            orderItemBO.setTaxRateName(orderItemPO.getTaxRate().multiply(new BigDecimal(100)).setScale(0, RoundingMode.HALF_UP) + "%");
            orderItemBO.setTaxRateVal(null);
            orderItemBO.setTaxAmt(orderItemPO.getTaxAmt().negate());
            orderItemBO.setTaxLocalAmt(orderItemPO.getTaxAmt().multiply(refundFinancePO.getExchangeRate()).negate());
            orderItemBO.setProjectCode(null);
            orderItemBO.setProjectName(null);
            orderItemBO.setTaskCode(null);
            orderItemBO.setTaskName(null);
            orderItemBO.setUnitCode(null);
            orderItemBO.setUnitName(orderItemPO.getSettleUnit());
            orderItemList.add(orderItemBO);
        }
        contractBO.setSettleAmt(settleAmt.negate());
        contractBO.setSettleLocalAmt(settleAmtLocal.negate());
        contractBO.setTaxAmt(taxAmt.negate());
        contractBO.setTaxLocalAmt(taxLocalAmt.negate());
    }

    private void sendMq(Long refundId) {
        FscComRefundSyncAbilityReqBO abilityReqBO = new FscComRefundSyncAbilityReqBO();
        abilityReqBO.setRefundIds(Collections.singletonList(refundId));
        this.fscComRefundSyncAbilityService.syncRefund(abilityReqBO);
    }

    private String getToken() {
        FscFinanceShareTokenRspBO shareToken = this.fscFinanceShareRelatedInterfacesAtomService.getFinanceShareToken();
        if (org.springframework.util.StringUtils.isEmpty((Object)shareToken.getToken())) {
            throw new FscBusinessException("198888", "\u83b7\u53d6\u8d22\u52a1\u5171\u4eabtoken\u4fe1\u606f\u5931\u8d25\uff1a" + shareToken.getRespDesc());
        }
        return shareToken.getToken();
    }

    private FscFinanceRefundInvoiceBaseBO buildInvoiceBaseBO(FscOrderRefundPO refundPO, FscRefundFinancePO refundFinancePO, FscOrderFinancePO orderFinancePO) {
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(refundPO.getFscOrderId());
        orderPO = this.fscOrderMapper.getModelBy(orderPO);
        FscFinanceRefundInvoiceBaseBO baseBO = new FscFinanceRefundInvoiceBaseBO();
        baseBO.setSrcSys("EB");
        baseBO.setSrcBillId(refundPO.getRefundId() + "");
        baseBO.setSrcBillCode(refundPO.getRefundNo());
        baseBO.setBillTypeCode(FscFundsclaimBillTypeEnum.REFUND_INVOICE_RED_CONTRACT.getName());
        baseBO.setBillTypeName(FscFundsclaimBillTypeEnum.REFUND_INVOICE_RED_CONTRACT.getDescription());
        baseBO.setFlow_node(null);
        baseBO.setDigitalSignatures(null);
        baseBO.setCreateUser(refundFinancePO.getCreateUserAccount());
        baseBO.setCreateUserName(refundPO.getCreateUserName());
        baseBO.setCreateDate(DateUtil.dateToStrLong((Date)refundPO.getCreateTime()));
        baseBO.setDeptCode(refundFinancePO.getFinanceDeptId());
        baseBO.setDeptName(refundFinancePO.getFinanceDeptName());
        baseBO.setOrgId(refundFinancePO.getFinanceOrgId());
        baseBO.setOrgName(refundFinancePO.getFinanceOrgName());
        baseBO.setBillDate(DateUtil.dateToStrYYYYMMdd((Date)refundPO.getCreateTime()));
        baseBO.setBizDeptCode(refundFinancePO.getBizDeptCode());
        baseBO.setBizDeptName(refundFinancePO.getBizDeptName());
        baseBO.setBizTypeCode(FscFundsclaimBillTypeEnum.REFUND_INVOICE_CONTRACT_BIZ.getName());
        baseBO.setBizTypeName(FscFundsclaimBillTypeEnum.REFUND_INVOICE_CONTRACT_BIZ.getDescription());
        baseBO.setBizItemCode(orderFinancePO.getBusinessItemCode());
        baseBO.setBizItemName(orderFinancePO.getBusinessItemName());
        baseBO.setNote(refundPO.getRefundNote());
        baseBO.setSegmentCode(refundFinancePO.getSegmentCode());
        baseBO.setSegmentName(refundFinancePO.getSegmentName());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(refundPO.getCreateTime());
        baseBO.setBillYear(calendar.get(1) + "");
        baseBO.setSegCompanyCode(refundFinancePO.getCompanySegmentCode());
        baseBO.setSegCompanyName(refundFinancePO.getCompanySegmentName());
        baseBO.setSegCalcCostCode(refundFinancePO.getIndependenceCostCode());
        baseBO.setSegCalcCostName(refundFinancePO.getIndependenceCostName());
        baseBO.setSegContractName(orderFinancePO.getContractSegmentName());
        baseBO.setSegContractCode(orderFinancePO.getContractSegmentCode());
        baseBO.setSegProductCode(null);
        baseBO.setSegProductName(null);
        baseBO.setSegMainSubjectName(null);
        baseBO.setSegMainSubjectCode(null);
        baseBO.setSegSubSubjectCode(null);
        baseBO.setSegSubSubjectName(null);
        baseBO.setSegCorrespondentCode(null);
        baseBO.setSegCorrespondentName(null);
        baseBO.setSegCalcCostCode(null);
        baseBO.setSegCalcCostName(null);
        baseBO.setSegProduceStageCode(null);
        baseBO.setSegProduceStageName(null);
        baseBO.setSegBakCode(null);
        baseBO.setSegBakName(null);
        baseBO.setSupplierCode(orderFinancePO.getExt1());
        baseBO.setSupplierName(refundPO.getPayeeName());
        baseBO.setSupplierAreaCode(orderFinancePO.getVendorSiteId() + "");
        baseBO.setSupplierAreaName(orderFinancePO.getVendorSiteName());
        baseBO.setSettleBillGuid(Convert.toStr((Object)refundPO.getFscOrderId()));
        baseBO.setSettleBillCode(refundPO.getFscOrderNo());
        baseBO.setSettleAmt(orderPO.getTotalCharge());
        if (FscConstants.RefundReasonType.ORDER_REFUND.equals(refundPO.getRefundReasonType())) {
            baseBO.setOffsetType("1");
        } else {
            baseBO.setOffsetType("0");
        }
        baseBO.setOffsetAmt(refundPO.getRefundAmount().negate());
        baseBO.setOffsetLocalAmt(refundPO.getRefundAmount().multiply(refundFinancePO.getExchangeRate()).negate());
        FscFinanceWriteOffPO fscFinanceWriteOffPO = this.fscFinanceWriteOffMapper.sumAmtByFscOrderId(orderPO.getFscOrderId());
        if (null == fscFinanceWriteOffPO) {
            fscFinanceWriteOffPO = new FscFinanceWriteOffPO();
            fscFinanceWriteOffPO.setWriteOffAmt(BigDecimal.ZERO);
            fscFinanceWriteOffPO.setWriteOffAmtLocal(BigDecimal.ZERO);
        } else {
            if (null == fscFinanceWriteOffPO.getWriteOffAmt()) {
                fscFinanceWriteOffPO.setWriteOffAmt(BigDecimal.ZERO);
            }
            if (null == fscFinanceWriteOffPO.getWriteOffAmtLocal()) {
                fscFinanceWriteOffPO.setWriteOffAmtLocal(BigDecimal.ZERO);
            }
        }
        BigDecimal shouldPayAmt = this.fscShouldPayMapper.sumShouldPayAmtByObjectId(orderPO.getFscOrderId());
        baseBO.setSettleUnpayAmt(orderPO.getTotalCharge().subtract(shouldPayAmt).subtract(fscFinanceWriteOffPO.getWriteOffAmt()));
        baseBO.setOriginNeedCheckAmt(refundPO.getTotalCharge().compareTo(baseBO.getSettleUnpayAmt()) > 0 ? baseBO.getSettleUnpayAmt() : refundPO.getTotalCharge());
        baseBO.setCurrencyCode(refundFinancePO.getCurrency());
        baseBO.setCurrencyName(refundFinancePO.getCurrencyName());
        baseBO.setRate(refundFinancePO.getExchangeRate());
        baseBO.setBizDate(DateUtil.dateToStrYYYYMMdd((Date)refundPO.getCreateTime()));
        baseBO.setIsExsettle(Integer.valueOf(0));
        baseBO.setSettleBizTypeCode(orderFinancePO.getBizTypeCode());
        baseBO.setSettleBizTypeName(orderFinancePO.getBizTypeName());
        baseBO.setPrintNum(0);
        baseBO.setCashItemCode(refundFinancePO.getCashItemCode());
        baseBO.setCashItemName(refundFinancePO.getCashItemName());
        baseBO.setCashItemDetailCode(refundFinancePO.getCashDetailCode());
        baseBO.setCashItemDetailName(refundFinancePO.getCashDetailName());
        baseBO.setOriginBillTypeCode(FscFundsclaimBillTypeEnum.SETTLE_TYPE_USED_CONTRACT.getName());
        baseBO.setOriginBillTypeName(FscFundsclaimBillTypeEnum.SETTLE_TYPE_USED_CONTRACT.getDescription());
        return baseBO;
    }
}

