/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl.finance;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscFinanceAttachmentBO;
import com.tydic.fsc.bo.FscFinanceRefundBankBO;
import com.tydic.fsc.bo.FscFinanceRefundDraftBO;
import com.tydic.fsc.bo.FscFinanceRefundPayBO;
import com.tydic.fsc.bo.FscFinanceRefundPaySettleBO;
import com.tydic.fsc.bo.FscFinanceRefundPaySettleRelationBO;
import com.tydic.fsc.bo.FscFinanceRefundPrePayBO;
import com.tydic.fsc.bo.FscPushFinanceAttachmentBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinanceShareTokenRspBO;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceShareRelatedInterfacesAtomService;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.api.finance.FscFinanceFileUploadAbilityService;
import com.tydic.fsc.common.ability.api.finance.FscFinancePushRefundPayAbilityService;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceFileUploadAbilityReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceFileUploadAbilityRspBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinancePushRefundPayAbilityReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinancePushRefundPayAbilityRspBO;
import com.tydic.fsc.common.busi.api.finance.FscFinancePushRefundPayBusiService;
import com.tydic.fsc.common.busi.bo.finance.FscFinancePushRefundPayBusiReqBO;
import com.tydic.fsc.common.busi.bo.finance.FscFinancePushRefundPayBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscFinanceBankStatementMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoMapper;
import com.tydic.fsc.dao.FscFinanceRefundItemMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscPayRefundDetailMapper;
import com.tydic.fsc.dao.FscPayShouldRefundMapper;
import com.tydic.fsc.dao.FscRefundFinanceMapper;
import com.tydic.fsc.enums.FscFundsclaimBillTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscFinanceBankStatementPO;
import com.tydic.fsc.po.FscFinanceDraftInfoPO;
import com.tydic.fsc.po.FscFinanceRefundItemPO;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscPayShouldRefundPO;
import com.tydic.fsc.po.FscRefundFinancePO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.finance.FscFinancePushRefundPayAbilityService"})
public class FscFinancePushRefundPayAbilityServiceImpl
implements FscFinancePushRefundPayAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscFinancePushRefundPayAbilityServiceImpl.class);
    @Autowired
    private FscPayShouldRefundMapper fscPayShouldRefundMapper;
    @Autowired
    private FscPayRefundDetailMapper fscPayRefundDetailMapper;
    @Autowired
    private FscFinanceRefundItemMapper fscFinanceRefundItemMapper;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscRefundFinanceMapper fscRefundFinanceMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Autowired
    private FscFinanceDraftInfoMapper fscFinanceDraftInfoMapper;
    @Autowired
    private FscFinanceBankStatementMapper fscFinanceBankStatementMapper;
    @Autowired
    private FscFinanceFileUploadAbilityService fscFinanceFileUploadAbilityService;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscFinanceShareRelatedInterfacesAtomService fscFinanceShareRelatedInterfacesAtomService;
    @Autowired
    private FscFinancePushRefundPayBusiService fscFinancePushRefundPayBusiService;
    @Autowired
    private FscComRefundSyncAbilityService fscComRefundSyncAbilityService;
    @Value(value="${fsc.finance.refund.pre.biz.code:100300080001}")
    private String preBizCode;
    @Value(value="${fsc.finance.refund.pre.biz.name:\u6709\u5408\u540c\u9884\u4ed8\u6b3e\u9000\u56de}")
    private String preBizName;
    @Value(value="${fsc.finance.refund.pre.biz.item.code:1003000800010001}")
    private String preBizItemCode;
    @Value(value="${fsc.finance.refund.pre.biz.item.name:\u6709\u5408\u540c\u9884\u4ed8\u6b3e\u9000\u56de}")
    private String preBizItemName;
    @Value(value="${fsc.finance.refund.biz.code:100300080003}")
    private String bizCode;
    @Value(value="${fsc.finance.refund.biz.name:\u6709\u5408\u540c\u4ed8\u6b3e\u9000\u56de\u7533\u8bf7\u5355}")
    private String bizName;
    @Value(value="${fsc.finance.refund.biz.item.code:1003000800030001}")
    private String bizItemCode;
    @Value(value="${fsc.finance.refund.biz.item.name:\u6709\u5408\u540c\u4ed8\u6b3e\u9000\u56de\u7533\u8bf7\u5355}")
    private String bizItemName;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealPushRefundPay"})
    public FscFinancePushRefundPayAbilityRspBO dealPushRefundPay(@RequestBody FscFinancePushRefundPayAbilityReqBO reqBO) {
        if (reqBO.getRefundId() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2[refundId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(reqBO.getRefundId());
        refundPO = this.fscOrderRefundMapper.getModelBy(refundPO);
        if (refundPO == null) {
            throw new FscBusinessException("190000", reqBO.getRefundId() + "\u5f53\u524d\u9000\u7968\u5355\u4e0d\u5b58\u5728!");
        }
        List refundPOList = this.fscPayShouldRefundMapper.getListByRefundId(reqBO.getRefundId());
        if (CollectionUtils.isEmpty((Collection)refundPOList)) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u5e94\u9000\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        FscRefundFinancePO financePO = new FscRefundFinancePO();
        financePO.setRefundId(refundPO.getRefundId());
        financePO = this.fscRefundFinanceMapper.getModelBy(financePO);
        if (financePO == null) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u5bf9\u63a5\u8d22\u52a1\u5171\u4eab\u8be6\u7ec6\u4e3a\u7a7a\uff01");
        }
        if (FscConstants.FscPushStatus.SUCCESS.equals(financePO.getPushFinanceStatus())) {
            throw new FscBusinessException("190000", "\u5df2\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u6210\u529f,\u8bf7\u52ff\u91cd\u590d\u63a8\u9001\uff01");
        }
        try {
            if (FscConstants.PaymentMethod.PRE_PAY.toString().equals(((FscPayShouldRefundPO)refundPOList.get(0)).getRefundMethod())) {
                return this.dealRefundPrePay(financePO, refundPO, refundPOList);
            }
            return this.dealRefundShouldPay(financePO, refundPO, refundPOList);
        }
        catch (Exception e) {
            log.error("\u6784\u5efa\u53c2\u6570\u5931\u8d25\uff1a{}", (Throwable)e);
            FscFinancePushRefundPayBusiReqBO busiReqBO = new FscFinancePushRefundPayBusiReqBO();
            busiReqBO.setRefundId(refundPO.getRefundId());
            busiReqBO.setFailRemark(e.getMessage());
            this.fscFinancePushRefundPayBusiService.updateFailLog(busiReqBO);
            FscFinancePushRefundPayAbilityRspBO rspBO = new FscFinancePushRefundPayAbilityRspBO();
            rspBO.setRespCode("190000");
            rspBO.setRespDesc("\u7ec4\u88c5\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u9000\u6b3e\u5355\u636e\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            this.sendMq(refundPO.getRefundId());
            return rspBO;
        }
    }

    @PostMapping(value={"dealPushRefundPayBatch"})
    public FscFinancePushRefundPayAbilityRspBO dealPushRefundPayBatch(@RequestBody FscFinancePushRefundPayAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getRefundIds())) {
            throw new FscBusinessException("190000", "\u5165\u53c2[refundIds]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        StringBuffer sb = new StringBuffer();
        for (Long refundId : reqBO.getRefundIds()) {
            FscFinancePushRefundPayAbilityReqBO abilityReqBO = new FscFinancePushRefundPayAbilityReqBO();
            abilityReqBO.setRefundId(refundId);
            FscFinancePushRefundPayAbilityRspBO abilityRspBO = this.dealPushRefundPay(abilityReqBO);
            if ("0000".equals(abilityRspBO.getRespCode())) continue;
            sb.append(refundId).append("\u63a8\u9001\u5931\u8d25\uff1a").append(abilityRspBO.getRespDesc());
        }
        FscFinancePushRefundPayAbilityRspBO rspBO = new FscFinancePushRefundPayAbilityRspBO();
        if (StringUtils.isEmpty((Object)sb.toString())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        } else {
            rspBO.setRespCode("190000");
            rspBO.setRespDesc(sb.toString());
        }
        return rspBO;
    }

    private FscFinancePushRefundPayAbilityRspBO dealRefundPrePay(FscRefundFinancePO financePO, FscOrderRefundPO refundPO, List<FscPayShouldRefundPO> refundPOList) {
        FscFinanceRefundPrePayBO prePayBO = this.buildPrePayBO(financePO, refundPO, refundPOList);
        List<FscFinanceRefundDraftBO> draftList = this.buildDraftInfo(prePayBO.getBillYear(), refundPO);
        List<FscFinanceRefundBankBO> bankPoList = this.buildBankInfo(financePO, refundPO);
        FscAttachmentPO attachmentPO = new FscAttachmentPO();
        attachmentPO.setObjId(refundPO.getRefundId());
        List attachmentPOList = this.fscAttachmentMapper.getList(attachmentPO);
        List<FscPushFinanceAttachmentBO> fileList = this.buildFileInfo(attachmentPOList, financePO);
        prePayBO.setAttachmentNum(attachmentPOList.size());
        JSONObject object = new JSONObject();
        object.put("baseInfoData", (Object)prePayBO);
        object.put("cmBankFlowList", bankPoList);
        object.put("cmBillFlowList", draftList);
        object.put("cmAttachmentList", fileList);
        return this.dealPush(object, refundPOList.get(0).getRefundMethod(), refundPO);
    }

    private FscFinancePushRefundPayAbilityRspBO dealPush(JSONObject object, String refundMethod, FscOrderRefundPO refundPO) {
        String token = this.getToken();
        FscFinancePushRefundPayBusiReqBO busiReqBO = new FscFinancePushRefundPayBusiReqBO();
        busiReqBO.setRefundId(refundPO.getRefundId());
        busiReqBO.setRefundNo(refundPO.getRefundNo());
        busiReqBO.setToken(token);
        busiReqBO.setRefundMethod(refundMethod);
        busiReqBO.setReqData(object);
        FscFinancePushRefundPayBusiRspBO busiRspBO = this.fscFinancePushRefundPayBusiService.dealPushRefundPay(busiReqBO);
        this.sendMq(refundPO.getRefundId());
        FscFinancePushRefundPayAbilityRspBO rspBO = new FscFinancePushRefundPayAbilityRspBO();
        rspBO.setRespCode(busiRspBO.getRespCode());
        rspBO.setRespDesc(busiRspBO.getRespDesc());
        return rspBO;
    }

    private List<FscPushFinanceAttachmentBO> buildFileInfo(List<FscAttachmentPO> attachmentPOList, FscRefundFinancePO financePO) {
        if (CollectionUtils.isEmpty(attachmentPOList)) {
            return new ArrayList<FscPushFinanceAttachmentBO>();
        }
        List boList = JSONObject.parseArray((String)JSONObject.toJSONString(attachmentPOList), AttachmentBO.class);
        FscFinanceFileUploadAbilityReqBO abilityReqBO = new FscFinanceFileUploadAbilityReqBO();
        abilityReqBO.setFileList(boList);
        FscFinanceFileUploadAbilityRspBO abilityRspBO = this.fscFinanceFileUploadAbilityService.dealFinanceUpload(abilityReqBO);
        if (!"0000".equals(abilityRspBO.getRespCode())) {
            throw new FscBusinessException("198888", "\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u9644\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a" + abilityRspBO.getRespDesc());
        }
        ArrayList<FscPushFinanceAttachmentBO> fileList = new ArrayList<FscPushFinanceAttachmentBO>(abilityRspBO.getFileList().size());
        for (FscFinanceAttachmentBO bo : abilityRspBO.getFileList()) {
            FscPushFinanceAttachmentBO pushBo = new FscPushFinanceAttachmentBO();
            pushBo.setFileId(bo.getFileId());
            pushBo.setFileName(bo.getFileName());
            pushBo.setFileSize(bo.getFileSize());
            pushBo.setCreateUserName(financePO.getCreateUserName());
            pushBo.setCreateUser(financePO.getCreateUserAccount());
            fileList.add(pushBo);
        }
        return fileList;
    }

    private List<FscFinanceRefundBankBO> buildBankInfo(FscRefundFinancePO financePO, FscOrderRefundPO refundPO) {
        FscFinanceBankStatementPO statementPO = new FscFinanceBankStatementPO();
        statementPO.setRefundId(refundPO.getRefundId());
        List statementPOList = this.fscFinanceBankStatementMapper.getList(statementPO);
        if (CollectionUtils.isEmpty((Collection)statementPOList)) {
            return new ArrayList<FscFinanceRefundBankBO>();
        }
        ArrayList<FscFinanceRefundBankBO> dataList = new ArrayList<FscFinanceRefundBankBO>(statementPOList.size());
        for (FscFinanceBankStatementPO po : statementPOList) {
            FscFinanceRefundBankBO bankBO = new FscFinanceRefundBankBO();
            bankBO.setGuid(po.getStatementId() + "");
            bankBO.setFlowNo(po.getBankFlowNum());
            bankBO.setFlowDate(DateUtil.dateToStrYYYYMMdd((Date)po.getBankFlowDate()));
            bankBO.setSummary(po.getExt1());
            bankBO.setCurrencyCode(po.getCurrencyCode());
            bankBO.setCurrencyName(po.getCurrencyName());
            bankBO.setOurAccountName(po.getOursidAccName());
            bankBO.setOurAccountNum(po.getOursidBankAcc());
            bankBO.setOurBankName(po.getOursidAccOpebnkName());
            bankBO.setOurOpeningBank(po.getOursidAccOpebnk());
            bankBO.setCounterpartyAccountName(po.getOppsidAccName());
            bankBO.setCounterpartyAccountNum(po.getOppsidBankAcc());
            bankBO.setCounterpartyBankName(po.getOppsidAccOpebnkName());
            bankBO.setBankFlowDirectionCode(po.getFlowDirFlag());
            bankBO.setBankFlowDirectionName(po.getFlowDirFlagName());
            bankBO.setCounterpartyOpeningBank(po.getOppsidAccOpebnk());
            bankBO.setTransactionAmt(po.getAmount());
            bankBO.setClaimableAmt(po.getAmountUnclaimed());
            bankBO.setClaimableLocalAmt(po.getAmountUnclaimedLocal());
            bankBO.setCurrentClaimOriginalAmt(po.getOccAmt());
            bankBO.setCurrentClaimOriginalLocalAmt(po.getOccAmtLocal());
            bankBO.setIsAgent(po.getIsAgent());
            bankBO.setBankFlowGuid(po.getGuid());
            bankBO.setFinancialDetailGuid(po.getExtId());
            dataList.add(bankBO);
        }
        return dataList;
    }

    private List<FscFinanceRefundDraftBO> buildDraftInfo(String billYear, FscOrderRefundPO refundPO) {
        FscFinanceDraftInfoPO draftInfoPO = new FscFinanceDraftInfoPO();
        draftInfoPO.setRefundId(refundPO.getRefundId());
        List draftList = this.fscFinanceDraftInfoMapper.getList(draftInfoPO);
        if (CollectionUtils.isEmpty((Collection)draftList)) {
            return new ArrayList<FscFinanceRefundDraftBO>();
        }
        ArrayList<FscFinanceRefundDraftBO> dataList = new ArrayList<FscFinanceRefundDraftBO>();
        for (FscFinanceDraftInfoPO po : draftList) {
            FscFinanceRefundDraftBO draftBO = new FscFinanceRefundDraftBO();
            draftBO.setGuid(po.getDraftId() + "");
            draftBO.setTicketCode(po.getBillNo());
            draftBO.setTicketStatus(null);
            draftBO.setTicketType(po.getBillType());
            if (!StringUtils.isEmpty((Object)po.getIssueDate()) && po.getIssueDate().contains("-")) {
                draftBO.setTicketingDate(po.getIssueDate().replace("-", "").substring(0, 8));
            } else {
                draftBO.setTicketingDate(po.getIssueDate());
            }
            if (!StringUtils.isEmpty((Object)po.getDueDate()) && po.getDueDate().contains("-")) {
                draftBO.setBillDueDate(po.getDueDate().replace("-", "").substring(0, 8));
            } else {
                draftBO.setBillDueDate(po.getDueDate());
            }
            draftBO.setIsTrans(null);
            draftBO.setTransNum(null);
            draftBO.setSubTicketIntervalks(null);
            draftBO.setSubTicketIntervaljs(null);
            draftBO.setHolderNow(po.getHolderName());
            draftBO.setHolderForehand(null);
            draftBO.setAcceptorBank(null);
            draftBO.setBizBlAmt(po.getBillAmount());
            draftBO.setDrawerName(po.getPayName());
            draftBO.setDrawerAcc(po.getDrawerAccountNo());
            draftBO.setDrawerOpebnkName(po.getDrawerOpebnkName());
            draftBO.setDrawerOpebnk(po.getDrawerOpebnkNo());
            draftBO.setRecUserName(po.getRecvName());
            draftBO.setDrawerOpebnk(po.getPayeeAccountOpebnkNo());
            draftBO.setRecBankAcc(po.getPayeeAccountNo());
            draftBO.setRecAccOpebnkName(po.getPayeeAccountOpebnkName());
            draftBO.setRecAccOpebnk(po.getPayeeAccountOpebnkNo());
            draftBO.setAcceptorName(po.getAcceptName());
            draftBO.setAcceptorAcc(po.getAcceptorAccountNo());
            draftBO.setAcceptorOpebnkName(po.getAcpterOpebnkName());
            draftBO.setAcceptorBankCode(po.getAcceptCnapsNo());
            draftBO.setAcceptorBank(po.getAcceptorBank());
            draftBO.setPlatformCode(po.getPlatformCode());
            draftBO.setPlatformName(po.getPlatformName());
            draftBO.setContractCode(null);
            draftBO.setBillMedia(null);
            draftBO.setUnitCode(po.getUnitCode());
            draftBO.setUnitName(po.getUnitName());
            if (FscConstants.FinanceDraftType.DRAFT.equals(po.getDraftType())) {
                draftBO.setFunctionType("1");
            } else {
                draftBO.setFunctionType("2");
            }
            draftBO.setBillYear(billYear);
            draftBO.setBillFlowGuid(po.getGuid());
            draftBO.setBillFlowClaimGuid(po.getExtId());
            draftBO.setBizBlAmt(po.getBillAmount());
            draftBO.setBizBlLocalAmt(null);
            draftBO.setCurrencyCode(null);
            draftBO.setCurrencyName(null);
            draftBO.setRate(null);
            draftBO.setClaimableAmt(po.getRemainingAmount());
            draftBO.setClaimableLocalAmt(null);
            draftBO.setCurrentClaimOriginalAmt(po.getOccAmt());
            draftBO.setCurrentClaimOriginalLoaclAmt(po.getOccAmtLocal());
            draftBO.setIsAgent(po.getIsAgent());
            dataList.add(draftBO);
        }
        return dataList;
    }

    private FscFinanceRefundPrePayBO buildPrePayBO(FscRefundFinancePO refundFinancePO, FscOrderRefundPO refundPO, List<FscPayShouldRefundPO> refundPOList) {
        FscOrderPayItemPO orderPayItemPO = this.fscOrderPayItemMapper.sumAmtByFscOrderId(refundPOList.get(0).getPayOrderId());
        FscFinanceRefundItemPO refundItemPO = this.fscFinanceRefundItemMapper.sumAmtByRefundId(refundPO.getRefundId());
        FscOrderFinancePO orderFinancePO = new FscOrderFinancePO();
        orderFinancePO.setFscOrderId(refundPOList.get(0).getPayOrderId());
        orderFinancePO = this.fscOrderFinanceMapper.getModelBy(orderFinancePO);
        FscFinanceRefundPrePayBO prePayBO = new FscFinanceRefundPrePayBO();
        prePayBO.setSrcSys("EB");
        prePayBO.setSrcBillId(refundPO.getRefundId() + "");
        prePayBO.setSrcBillCode(refundPO.getRefundNo());
        prePayBO.setCreateUser(refundFinancePO.getCreateUserAccount());
        prePayBO.setCreateUserName(refundFinancePO.getCreateUserName());
        prePayBO.setCreateDate(DateUtil.dateToStrLong((Date)refundPO.getCreateTime()));
        prePayBO.setDeptCode(refundFinancePO.getFinanceDeptId());
        prePayBO.setDeptName(refundFinancePO.getFinanceDeptName());
        prePayBO.setOrgId(refundFinancePO.getFinanceOrgId());
        prePayBO.setOrgName(refundFinancePO.getFinanceOrgName());
        prePayBO.setBillDate(DateUtil.dateToStrYYYYMMdd((Date)refundPO.getCreateTime()));
        prePayBO.setBizDeptCode(refundFinancePO.getBizDeptCode());
        prePayBO.setBizDeptName(refundFinancePO.getBizDeptName());
        prePayBO.setBizTypeCode(this.preBizCode);
        prePayBO.setBizTypeName(this.preBizName);
        prePayBO.setBizItemCode(this.preBizItemCode);
        prePayBO.setBizItemName(this.preBizItemName);
        prePayBO.setNote(refundFinancePO.getNote());
        prePayBO.setSegmentCode(refundFinancePO.getSegmentCode());
        prePayBO.setSegmentName(refundFinancePO.getSegmentName());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(refundPO.getCreateTime());
        prePayBO.setBillYear(calendar.get(1) + "");
        prePayBO.setBillTypeCode(FscFundsclaimBillTypeEnum.ADV_PAY_RE_BILL_TYPE_USED_CONTRACT.getName());
        prePayBO.setBillTypeName(FscFundsclaimBillTypeEnum.ADV_PAY_RE_BILL_TYPE_USED_CONTRACT.getDescription());
        prePayBO.setSegCompanyCode(refundFinancePO.getCompanySegmentCode());
        prePayBO.setSegCompanyName(refundFinancePO.getCompanySegmentName());
        prePayBO.setSegCalcCostCode(null);
        prePayBO.setSegCalcCostName(null);
        prePayBO.setContractCode(refundPOList.get(0).getContractNo());
        prePayBO.setContractName(refundPOList.get(0).getContractName());
        prePayBO.setSupplierCode(orderFinancePO.getExt1());
        prePayBO.setSupplierName(refundPO.getPayeeName());
        prePayBO.setSupplierAreaCode(orderFinancePO.getVendorSiteId() + "");
        prePayBO.setSupplierAreaName(orderFinancePO.getVendorSiteName());
        prePayBO.setApplyBillGuid(refundPOList.get(0).getPayOrderId() + "");
        prePayBO.setApplyBillCode(refundPOList.get(0).getPayOrderNo());
        prePayBO.setCurrencyCode(refundFinancePO.getCurrency());
        Map currencTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_MONEY_UNIT");
        prePayBO.setCurrencyName((String)currencTypeMap.get(refundFinancePO.getCurrency()));
        prePayBO.setRate(refundFinancePO.getExchangeRate());
        prePayBO.setAdvPayAmt(orderPayItemPO.getPayAmount());
        prePayBO.setAdvPayLocalAmt(orderPayItemPO.getPayAmountLocal());
        prePayBO.setRefundLocalAmt(refundItemPO.getRefundAmtLocal());
        prePayBO.setUncheckAdvAmt(orderPayItemPO.getPayAmount().subtract(orderPayItemPO.getPurWriteOffAmount()).setScale(2, RoundingMode.HALF_UP));
        prePayBO.setRefundAmt(refundItemPO.getRefundAmt());
        prePayBO.setIsAgent(refundFinancePO.getIsAgent());
        prePayBO.setAgentCompanyCode(refundFinancePO.getAgentCompanyCode());
        prePayBO.setAgentCompanyName(refundFinancePO.getAgentCompanyName());
        prePayBO.setRefundWayCode(refundFinancePO.getRefundPayMethod());
        Map methodMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_REFUND_PAY_METHOD");
        prePayBO.setRefundWayName((String)methodMap.get(refundFinancePO.getRefundPayMethod()));
        prePayBO.setApplyBillBizTypeName(FscFundsclaimBillTypeEnum.ADV_PAY_BILL_TYPE_USED_CONTRACT.getDescription());
        prePayBO.setApplyBillBizTypeCode(FscFundsclaimBillTypeEnum.ADV_PAY_BILL_TYPE_USED_CONTRACT.getName());
        prePayBO.setCashUnitCode(refundFinancePO.getCashUnitCode());
        prePayBO.setCashUnitName(refundFinancePO.getCashUnitName());
        prePayBO.setBizAccountant(refundFinancePO.getFinanceAuditAccount());
        prePayBO.setBizAccountantName(refundFinancePO.getFinanceAuditName());
        return prePayBO;
    }

    private String getToken() {
        FscFinanceShareTokenRspBO shareToken = this.fscFinanceShareRelatedInterfacesAtomService.getFinanceShareToken();
        if (StringUtils.isEmpty((Object)shareToken.getToken())) {
            throw new FscBusinessException("198888", "\u83b7\u53d6\u8d22\u52a1\u5171\u4eabtoken\u4fe1\u606f\u5931\u8d25\uff1a" + shareToken.getRespDesc());
        }
        return shareToken.getToken();
    }

    private void sendMq(Long refundId) {
        FscComRefundSyncAbilityReqBO abilityReqBO = new FscComRefundSyncAbilityReqBO();
        abilityReqBO.setRefundIds(Collections.singletonList(refundId));
        this.fscComRefundSyncAbilityService.syncRefund(abilityReqBO);
    }

    private FscFinancePushRefundPayAbilityRspBO dealRefundShouldPay(FscRefundFinancePO financePO, FscOrderRefundPO refundPO, List<FscPayShouldRefundPO> refundPOList) {
        FscFinanceRefundPayBO refundPayBO = this.buildRefundPayInfo(financePO, refundPO, refundPOList);
        List<FscFinanceRefundPaySettleBO> settleList = this.buildRefundSettleInfo(refundPO, refundPOList.get(0).getRefundId());
        List<FscFinanceRefundDraftBO> draftList = this.buildDraftInfo(refundPayBO.getBillYear(), refundPO);
        List<FscFinanceRefundBankBO> bankPoList = this.buildBankInfo(financePO, refundPO);
        List<FscFinanceRefundPaySettleRelationBO> relationList = this.buildRelationInfo(refundPO, settleList.get(0));
        FscAttachmentPO attachmentPO = new FscAttachmentPO();
        attachmentPO.setObjId(refundPO.getRefundId());
        List attachmentPOList = this.fscAttachmentMapper.getList(attachmentPO);
        List<FscPushFinanceAttachmentBO> fileList = this.buildFileInfo(attachmentPOList, financePO);
        refundPayBO.setAttachmentNum(attachmentPOList.size());
        JSONObject object = new JSONObject();
        object.put("baseInfoData", (Object)refundPayBO);
        object.put("cmBankFlowList", bankPoList);
        object.put("cmBillFlowList", draftList);
        object.put("payRefundSettleList", settleList);
        object.put("cmRpSettleList", relationList);
        object.put("cmAttachmentList", fileList);
        return this.dealPush(object, refundPOList.get(0).getRefundMethod(), refundPO);
    }

    private List<FscFinanceRefundPaySettleRelationBO> buildRelationInfo(FscOrderRefundPO refundPO, FscFinanceRefundPaySettleBO paySettleBO) {
        FscFinanceRefundPaySettleRelationBO relationBO;
        List draftList = this.fscFinanceDraftInfoMapper.getListWithRefund(refundPO.getRefundId());
        List bankList = this.fscFinanceBankStatementMapper.getListWithRefund(refundPO.getRefundId());
        ArrayList<FscFinanceRefundPaySettleRelationBO> relationList = new ArrayList<FscFinanceRefundPaySettleRelationBO>();
        for (FscFinanceDraftInfoPO draftInfoPO : draftList) {
            relationBO = new FscFinanceRefundPaySettleRelationBO();
            relationBO.setGuid(draftInfoPO.getDraftId() + "");
            relationBO.setSettleBillGuid(paySettleBO.getOffsetBillGuid());
            relationBO.setSettleBillCode(paySettleBO.getOffsetBillCode());
            relationBO.setContractCode(draftInfoPO.getContractNo());
            relationBO.setContractName(draftInfoPO.getContractName());
            relationBO.setPayAmt(draftInfoPO.getOccAmt());
            relationBO.setPayLocalAmt(draftInfoPO.getOccAmtLocal());
            relationBO.setCmRpGuid(draftInfoPO.getDraftId() + "");
            relationList.add(relationBO);
        }
        for (FscFinanceBankStatementPO statementPO : bankList) {
            relationBO = new FscFinanceRefundPaySettleRelationBO();
            relationBO.setGuid(statementPO.getStatementId() + "");
            relationBO.setSettleBillGuid(paySettleBO.getOffsetBillGuid());
            relationBO.setSettleBillCode(paySettleBO.getOffsetBillCode());
            relationBO.setContractCode(statementPO.getContractNo());
            relationBO.setContractName(statementPO.getContractName());
            relationBO.setPayAmt(statementPO.getOccAmt());
            relationBO.setPayLocalAmt(statementPO.getOccAmtLocal());
            relationBO.setCmRpGuid(statementPO.getStatementId() + "");
            relationList.add(relationBO);
        }
        return relationList;
    }

    private List<FscFinanceRefundPaySettleBO> buildRefundSettleInfo(FscOrderRefundPO refundPO, Long refundId) {
        FscFinanceRefundItemPO refundQueryVo = new FscFinanceRefundItemPO();
        refundQueryVo.setRefundId(refundPO.getRefundId());
        List refundList = this.fscFinanceRefundItemMapper.getList(refundQueryVo);
        FscOrderRefundPO settleRefundPO = new FscOrderRefundPO();
        settleRefundPO.setRefundId(refundId);
        settleRefundPO = this.fscOrderRefundMapper.getModelBy(settleRefundPO);
        ArrayList<FscFinanceRefundPaySettleBO> settleList = new ArrayList<FscFinanceRefundPaySettleBO>(refundList.size());
        for (FscFinanceRefundItemPO refundItemPO : refundList) {
            FscFinanceRefundPaySettleBO settleBO = new FscFinanceRefundPaySettleBO();
            settleBO.setGuid(refundItemPO.getFinanceRefundItemId() + "");
            settleBO.setOffsetBillGuid(settleRefundPO.getRefundId() + "");
            settleBO.setOffsetBillCode(settleRefundPO.getRefundNo());
            settleBO.setRefundAmt(refundItemPO.getRefundAmt());
            settleBO.setRefundLocalAmt(refundItemPO.getRefundAmtLocal());
            settleBO.setSettleBillCode(settleRefundPO.getFscOrderNo());
            settleBO.setSettleBillGuid(settleRefundPO.getFscOrderId() + "");
            settleBO.setContractCode(refundItemPO.getContractNo());
            settleBO.setContractName(refundItemPO.getContractName());
            settleBO.setSettleUnWriteOffAmt(refundItemPO.getRefundAmt());
            settleList.add(settleBO);
        }
        return settleList;
    }

    private FscFinanceRefundPayBO buildRefundPayInfo(FscRefundFinancePO refundFinancePO, FscOrderRefundPO refundPO, List<FscPayShouldRefundPO> refundPOList) {
        FscFinanceRefundItemPO refundItemPO = this.fscFinanceRefundItemMapper.sumAmtByRefundId(refundPO.getRefundId());
        FscOrderFinancePO orderFinancePO = new FscOrderFinancePO();
        orderFinancePO.setFscOrderId(refundPOList.get(0).getPayOrderId());
        orderFinancePO = this.fscOrderFinanceMapper.getModelBy(orderFinancePO);
        FscFinanceRefundPayBO payBO = new FscFinanceRefundPayBO();
        payBO.setSrcSys("EB");
        payBO.setSrcBillId(refundPO.getRefundId() + "");
        payBO.setSrcBillCode(refundPO.getRefundNo());
        payBO.setCreateUser(refundFinancePO.getCreateUserAccount());
        payBO.setCreateUserName(refundFinancePO.getCreateUserName());
        payBO.setCreateDate(DateUtil.dateToStrLong((Date)refundPO.getCreateTime()));
        payBO.setDeptCode(refundFinancePO.getFinanceDeptId());
        payBO.setDeptName(refundFinancePO.getFinanceDeptName());
        payBO.setOrgId(refundFinancePO.getFinanceOrgId());
        payBO.setOrgName(refundFinancePO.getFinanceOrgName());
        payBO.setBillDate(DateUtil.dateToStrYYYYMMdd((Date)refundPO.getCreateTime()));
        payBO.setBizDeptCode(refundFinancePO.getBizDeptCode());
        payBO.setBizDeptName(refundFinancePO.getBizDeptName());
        payBO.setBizTypeCode(this.bizCode);
        payBO.setBizTypeName(this.bizName);
        payBO.setBizItemCode(this.bizItemCode);
        payBO.setBizItemName(this.bizItemName);
        payBO.setNote(refundFinancePO.getNote());
        payBO.setSegmentCode(refundFinancePO.getSegmentCode());
        payBO.setSegmentName(refundFinancePO.getSegmentName());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(refundPO.getCreateTime());
        payBO.setBillYear(calendar.get(1) + "");
        payBO.setBillTypeCode(FscFundsclaimBillTypeEnum.PAY_RE_BILL_TYPE_USED_CONTRACT.getName());
        payBO.setBillTypeName(FscFundsclaimBillTypeEnum.PAY_RE_BILL_TYPE_USED_CONTRACT.getDescription());
        payBO.setSegCompanyCode(refundFinancePO.getCompanySegmentCode());
        payBO.setSegCompanyName(refundFinancePO.getCompanySegmentName());
        payBO.setSegCalcCostCode(null);
        payBO.setSegCalcCostName(null);
        payBO.setSupplierCode(orderFinancePO.getExt1());
        payBO.setSupplierName(refundPO.getPayeeName());
        payBO.setSupplierAreaCode(orderFinancePO.getVendorSiteId() + "");
        payBO.setSupplierAreaName(orderFinancePO.getVendorSiteName());
        payBO.setCurrencyCode(refundFinancePO.getCurrency());
        Map currencTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_MONEY_UNIT");
        payBO.setCurrencyName((String)currencTypeMap.get(refundFinancePO.getCurrency()));
        payBO.setRate(refundFinancePO.getExchangeRate());
        payBO.setRefundLocalAmt(refundItemPO.getRefundAmtLocal().setScale(2, RoundingMode.HALF_UP));
        payBO.setRefundAmt(refundItemPO.getRefundAmt().setScale(2, RoundingMode.HALF_UP));
        payBO.setIsAgent(refundFinancePO.getIsAgent());
        payBO.setAgentCompanyCode(refundFinancePO.getAgentCompanyCode());
        payBO.setAgentCompanyName(refundFinancePO.getAgentCompanyName());
        payBO.setRefundWayCode(refundFinancePO.getRefundPayMethod());
        Map methodMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_REFUND_PAY_METHOD");
        payBO.setRefundWayName((String)methodMap.get(refundFinancePO.getRefundPayMethod()));
        payBO.setCashUnitCode(refundFinancePO.getCashUnitCode());
        payBO.setCashUnitName(refundFinancePO.getCashUnitName());
        payBO.setBizAccountant(refundFinancePO.getFinanceAuditAccount());
        payBO.setBizAccountantName(refundFinancePO.getFinanceAuditName());
        return payBO;
    }
}

