/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl.finance;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.common.ability.api.finance.FscFinanceRefundTempAbnormalQryAbilityService;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceRefundTempAbnormalQryListRspBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceRefundTempAbnormalQryReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceRefundTempAbnormalQryRspBO;
import com.tydic.fsc.constants.FscOrderSourceEnum;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationTempMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationTempPO;
import com.tydic.uoc.common.ability.api.UocAbnormalSingleDetailsListQueryAbilityService;
import com.tydic.uoc.common.ability.bo.UocAbnormalSingleDetailsListQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocAbnormalSingleDetailsListQueryRspBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdShipAbnormalBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.finance.FscFinanceRefundTempAbnormalQryAbilityService"})
public class FscFinanceRefundTempAbnormalQryAbilityServiceImpl
implements FscFinanceRefundTempAbnormalQryAbilityService {
    private static final Integer ABNORMAL_ALL_TAB_ID = 41001;
    private static final String ABNORMAL_STATE_TWO = "2";
    private static final String ABNORMAL_STATE_THREE = "3";
    private static final Integer ABNORMAL_PAGE_SIZE = 999;
    @Autowired
    private FscOrderRelationTempMapper fscOrderRelationTempMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private UocAbnormalSingleDetailsListQueryAbilityService uocAbnormalSingleDetailsListQueryAbilityService;

    @PostMapping(value={"qryRefundInvoiceTempAbnormal"})
    public FscFinanceRefundTempAbnormalQryRspBO qryRefundInvoiceTempAbnormal(@RequestBody FscFinanceRefundTempAbnormalQryReqBO reqBo) {
        this.valid(reqBo);
        FscFinanceRefundTempAbnormalQryRspBO rspBO = new FscFinanceRefundTempAbnormalQryRspBO();
        FscOrderRelationTempPO fscOrderRelationTempPOReq = new FscOrderRelationTempPO();
        fscOrderRelationTempPOReq.setTempId(reqBo.getTempId());
        fscOrderRelationTempPOReq.setFscOrderId(reqBo.getFscOrderId());
        fscOrderRelationTempPOReq.setContractId(reqBo.getContractId());
        fscOrderRelationTempPOReq.setOrderNo(reqBo.getOrderCode());
        Page page = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        List listPage = this.fscOrderRelationTempMapper.getListPage(fscOrderRelationTempPOReq, page);
        if (CollectionUtils.isEmpty((Collection)listPage)) {
            rspBO.setPageNo(reqBo.getPageNo());
            rspBO.setTotal(Integer.valueOf(0));
            rspBO.setRecordsTotal(Integer.valueOf(0));
            rspBO.setRows(new ArrayList());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        List list = JSON.parseArray((String)JSON.toJSONString((Object)listPage), FscFinanceRefundTempAbnormalQryListRspBO.class);
        this.packagingAbnormalSingleDetailsData(list, reqBo);
        rspBO.setRows(list);
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void valid(FscFinanceRefundTempAbnormalQryReqBO reqBo) {
        if (reqBo == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getTempId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u4e34\u65f6ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getFscOrderId())) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u7ed3\u7b97\u5355ID[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void packagingAbnormalSingleDetailsData(List<FscFinanceRefundTempAbnormalQryListRspBO> fscFinanceRefundTempAbnormalQryListRspBOList, FscFinanceRefundTempAbnormalQryReqBO reqBO) {
        if (CollectionUtils.isEmpty(fscFinanceRefundTempAbnormalQryListRspBOList)) {
            return;
        }
        FscOrderPO qryFscOrder = new FscOrderPO();
        qryFscOrder.setFscOrderId(reqBO.getFscOrderId());
        FscOrderPO fscOrderPO = this.fscOrderMapper.getModelBy(qryFscOrder);
        if (ObjectUtil.isEmpty((Object)fscOrderPO)) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u4e3b\u5355\u4fe1\u606f");
        }
        List abnormalVoucherIdList = fscFinanceRefundTempAbnormalQryListRspBOList.stream().map(FscFinanceRefundTempAbnormalQryListRspBO::getAbnormalVoucherId).distinct().collect(Collectors.toList());
        UocAbnormalSingleDetailsListQueryReqBO uocAbnormalSingleDetailsListQueryReqBO = new UocAbnormalSingleDetailsListQueryReqBO();
        uocAbnormalSingleDetailsListQueryReqBO.setTabId(ABNORMAL_ALL_TAB_ID);
        uocAbnormalSingleDetailsListQueryReqBO.setPageSize(ABNORMAL_PAGE_SIZE.intValue());
        uocAbnormalSingleDetailsListQueryReqBO.setAbnormalVoucherIds(abnormalVoucherIdList);
        uocAbnormalSingleDetailsListQueryReqBO.setAbnormalState(FscOrderSourceEnum.ELECTRIC_MARKET.getCode().equals(fscOrderPO.getOrderSource()) ? ABNORMAL_STATE_TWO : ABNORMAL_STATE_THREE);
        UocAbnormalSingleDetailsListQueryRspBO uocAbnormalSingleDetailsListQueryRspBO = this.uocAbnormalSingleDetailsListQueryAbilityService.getAbnormalSingleDetailsListQuery(uocAbnormalSingleDetailsListQueryReqBO);
        if (!"0000".equals(uocAbnormalSingleDetailsListQueryRspBO.getRespCode())) {
            throw new FscBusinessException("198888", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3|\u67e5\u8be2\u8ba2\u5355\u5f02\u5e38\u5355\u8be6\u60c5\u6570\u636e\u5931\u8d25: " + uocAbnormalSingleDetailsListQueryRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)uocAbnormalSingleDetailsListQueryRspBO.getRows())) {
            throw new FscBusinessException("198888", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3|\u672a\u67e5\u8be2\u8ba2\u5355\u5f02\u5e38\u5355\u8be6\u60c5\u6570\u636e");
        }
        Map<String, UocPebOrdShipAbnormalBO> idVsAbnormalSingleListMap = uocAbnormalSingleDetailsListQueryRspBO.getRows().stream().collect(Collectors.toMap(UocPebOrdShipAbnormalBO::getAbnormalVoucherId, bo -> bo, (k1, k2) -> k1));
        for (FscFinanceRefundTempAbnormalQryListRspBO fscFinanceRefundTempAbnormalQryListRspBO : fscFinanceRefundTempAbnormalQryListRspBOList) {
            UocPebOrdShipAbnormalBO uocPebOrdShipAbnormalBO = idVsAbnormalSingleListMap.get(String.valueOf(fscFinanceRefundTempAbnormalQryListRspBO.getAbnormalVoucherId()));
            fscFinanceRefundTempAbnormalQryListRspBO.setSaleVoucherId(uocPebOrdShipAbnormalBO.getSaleVoucherId());
            fscFinanceRefundTempAbnormalQryListRspBO.setSaleVoucherNo(uocPebOrdShipAbnormalBO.getSaleVoucherNo());
            fscFinanceRefundTempAbnormalQryListRspBO.setSupplierId(Long.valueOf(uocPebOrdShipAbnormalBO.getSupNo()));
            fscFinanceRefundTempAbnormalQryListRspBO.setSupplierName(uocPebOrdShipAbnormalBO.getSupName());
        }
    }
}

