/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.common.busi.api.FscAccountCreditStatusChangeBusiService;
import com.tydic.fsc.common.busi.bo.FscAccountCreditStatusChangeBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscAccountCreditStatusChangeBusiRspBO;
import com.tydic.fsc.dao.FscAccountCreditMapper;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountCreditPO;
import com.tydic.fsc.po.FscMerchantPO;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscAccountCreditStatusChangeBusiServiceImpl
implements FscAccountCreditStatusChangeBusiService {
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private FscAccountCreditMapper fscAccountCreditMapper;

    @Override
    public FscAccountCreditStatusChangeBusiRspBO dealCreditStatusChange(FscAccountCreditStatusChangeBusiReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getOperationType())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u64cd\u4f5c\u7c7b\u578b[operationType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty(reqBO.getFscAccountCreditList())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5546\u6237id\u96c6\u5408[fscAccountCreditList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscMerchantPO fscMerchantPo = new FscMerchantPO();
        if (reqBO.getOperationType() == 0) {
            fscMerchantPo.setPayAllowExceptionFlag(Integer.valueOf(0));
        }
        if (reqBO.getOperationType() == 1) {
            fscMerchantPo.setPayAllowExceptionFlag(Integer.valueOf(1));
        }
        List fscAccountCreditPOList = JSON.parseArray((String)JSONObject.toJSONString(reqBO.getFscAccountCreditList()), FscAccountCreditPO.class);
        fscMerchantPo.setFscAccountCreditList(fscAccountCreditPOList);
        int count = this.fscMerchantMapper.updatePayAllowExceptionFlagByBatch(fscMerchantPo);
        if (count < 0) {
            throw new FscBusinessException("190000", "\u64cd\u4f5c\u5931\u8d25,\u8bf7\u91cd\u8bd5!");
        }
        fscAccountCreditPOList.stream().forEach(credit -> {
            credit.setCreditStatus(reqBO.getOperationType());
            if (this.fscAccountCreditMapper.selectCount(credit) == 0) {
                this.fscAccountCreditMapper.insert(credit);
            } else {
                this.fscAccountCreditMapper.update(credit);
            }
        });
        FscAccountCreditStatusChangeBusiRspBO busiRspBO = new FscAccountCreditStatusChangeBusiRspBO();
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u6210\u529f");
        return busiRspBO;
    }
}

