/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.common.busi.api.FscBillPayRefundBackBusiService;
import com.tydic.fsc.common.busi.bo.FscBillPayRefundBackBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscBillPayRefundBackBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscPayClaimRefundDetailMapper;
import com.tydic.fsc.dao.FscPayClaimRefundMapper;
import com.tydic.fsc.dao.FscPayRefundDetailMapper;
import com.tydic.fsc.dao.FscRecvClaimMapper;
import com.tydic.fsc.enums.FscClaimRecvStatusEnum;
import com.tydic.fsc.enums.FscClaimStatusEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscRecvClaimPO;
import java.math.BigDecimal;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscBillPayRefundBackBusiServiceImpl
implements FscBillPayRefundBackBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillPayRefundBackBusiServiceImpl.class);
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscRecvClaimMapper fscRecvClaimMapper;
    @Autowired
    private FscPayClaimRefundMapper fscPayClaimRefundMapper;
    @Autowired
    private FscPayClaimRefundDetailMapper fscPayClaimRefundDetailMapper;
    @Autowired
    private FscPayRefundDetailMapper fscPayRefundDetailMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    private static final String BUSI_NAME = "\u9000\u6b3e\u4e3b\u5355\u4e1a\u8d22\u9a73\u56de";

    @Override
    public FscBillPayRefundBackBusiRspBO dealPayRefundBack(FscBillPayRefundBackBusiReqBO reqBO) {
        FscBillPayRefundBackBusiRspBO rspBO = new FscBillPayRefundBackBusiRspBO();
        FscOrderRefundPO fscOrderRefundPO = new FscOrderRefundPO();
        fscOrderRefundPO.setRefundId(reqBO.getRefundId());
        fscOrderRefundPO = this.fscOrderRefundMapper.getModelBy(fscOrderRefundPO);
        if (fscOrderRefundPO == null) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u9000\u6b3e\u5355\u4fe1\u606f");
        }
        if (!FscConstants.RefundPushStatus.PUSH_SUCCESS.equals(fscOrderRefundPO.getPushStatus())) {
            throw new FscBusinessException("190000", "\u9000\u6b3e\u5355\u672a\u63a8\u9001");
        }
        if (!FscConstants.RefundPayOrderState.REFUND_COMFIR.equals(fscOrderRefundPO.getRefundStatus())) {
            throw new FscBusinessException("190000", "\u9000\u6b3e\u5355\u72b6\u6001\u5f02\u5e38");
        }
        FscClaimDetailPO fscClaimDetailPO = new FscClaimDetailPO();
        fscClaimDetailPO.setRefundId(reqBO.getRefundId());
        fscClaimDetailPO = this.fscClaimDetailMapper.queryByRefundId(fscClaimDetailPO);
        BigDecimal claimAmt = fscClaimDetailPO.getClaimAmt();
        fscClaimDetailPO.setClaimAmt(BigDecimal.ZERO);
        fscClaimDetailPO.setCancelClaimDate(new Date());
        fscClaimDetailPO.setStatus("0");
        this.fscClaimDetailMapper.update(fscClaimDetailPO);
        FscRecvClaimPO fscRecvClaimPO = this.fscRecvClaimMapper.queryById(fscClaimDetailPO.getClaimId());
        fscRecvClaimPO.setStatus(FscConstants.FscClaimPushStatus.NOT_PUSH);
        fscRecvClaimPO.setClaimStatus(FscClaimStatusEnum.PART_CLAIM.getCode());
        fscRecvClaimPO.setRecvStatus(FscClaimRecvStatusEnum.EFFECTIVE.getCode());
        fscRecvClaimPO.setNoClaimAmt(fscRecvClaimPO.getNoClaimAmt().add(claimAmt));
        this.fscRecvClaimMapper.update(fscRecvClaimPO);
        fscOrderRefundPO.setPushStatus(FscConstants.RefundPushStatus.PUSH_BACK);
        fscOrderRefundPO.setExt2(reqBO.getBackReason());
        this.fscOrderRefundMapper.updateById(fscOrderRefundPO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

