/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.common.busi.api.FscFinanceInvoiceRefundApprovalBusiService;
import com.tydic.fsc.common.busi.bo.FscFinanceInvoiceRefundApprovalBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscFinanceInvoiceRefundApprovalBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscRefundFinanceMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscRefundFinancePO;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscFinanceInvoiceRefundApprovalBusiServiceImpl
implements FscFinanceInvoiceRefundApprovalBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceInvoiceRefundApprovalBusiServiceImpl.class);
    @Autowired
    private FscRefundFinanceMapper fscRefundFinanceMapper;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    private static final String BUSI_NAME = "\u9000\u7968\u4e1a\u8d22\u5ba1\u6279";

    @Override
    public FscFinanceInvoiceRefundApprovalBusiRspBO dealFinanceInvoiceRefundApproval(FscFinanceInvoiceRefundApprovalBusiReqBO reqBO) {
        FscFinanceInvoiceRefundApprovalBusiRspBO rspBO = new FscFinanceInvoiceRefundApprovalBusiRspBO();
        ArrayList<Long> refundIds = new ArrayList<Long>();
        for (Long refundId : reqBO.getRefundIds()) {
            FscOrderRefundPO fscOrderRefundPO = this.getOrderRefund(refundId);
            FscRefundFinancePO fscRefundFinancePO = this.getRefundFinance(refundId);
            UacNoTaskAuditOrderAuditRspBO auditRspBO = this.processTaskApproval(reqBO, refundId, fscOrderRefundPO, fscRefundFinancePO);
            this.dealRefundStatusFlow(reqBO, fscOrderRefundPO, auditRspBO);
            if (auditRspBO.getNoneInstanceBO().getFinish().booleanValue() && reqBO.getAuditResult() == 0) {
                refundIds.add(refundId);
            }
            this.updateRefundFinance(reqBO, refundId, auditRspBO);
        }
        rspBO.setRefundIds(refundIds);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void updateRefundFinance(FscFinanceInvoiceRefundApprovalBusiReqBO reqBO, Long thisRefundId, UacNoTaskAuditOrderAuditRspBO auditRspBO) {
        FscRefundFinancePO updateFscRefundFinanceSet = new FscRefundFinancePO();
        updateFscRefundFinanceSet.setRefundId(thisRefundId);
        updateFscRefundFinanceSet.setCashItemCode(reqBO.getCashItemCode());
        updateFscRefundFinanceSet.setCashItemName(reqBO.getCashItemName());
        updateFscRefundFinanceSet.setCashDetailCode(reqBO.getCashDetailCode());
        updateFscRefundFinanceSet.setCashDetailName(reqBO.getCashDetailName());
        if (auditRspBO.getNoneInstanceBO().getFinish().booleanValue() && FscConstants.AuditResultStatus.PASS.equals(reqBO.getAuditResult())) {
            updateFscRefundFinanceSet.setFinanceAuditStatus(FscConstants.AuditStatus.AUDIT_PASS);
        }
        if (auditRspBO.getNoneInstanceBO().getFinish().booleanValue() && FscConstants.AuditResultStatus.REFUSE.equals(reqBO.getAuditResult())) {
            updateFscRefundFinanceSet.setFinanceAuditStatus(FscConstants.AuditStatus.AUDIT_REJECT);
        }
        FscRefundFinancePO updateFscRefundFinanceWhere = new FscRefundFinancePO();
        updateFscRefundFinanceWhere.setRefundId(thisRefundId);
        this.fscRefundFinanceMapper.updateBy(updateFscRefundFinanceSet, updateFscRefundFinanceWhere);
    }

    private UacNoTaskAuditOrderAuditRspBO processTaskApproval(FscFinanceInvoiceRefundApprovalBusiReqBO reqBO, Long thisRefundId, FscOrderRefundPO fscOrderRefundPO, FscRefundFinancePO fscRefundFinancePO) {
        String stepId = this.fscOrderMapper.selectRefundStepId(thisRefundId, FscConstants.AuditObjType.FINANCE_PURCHASE_REFUND_INVOICE_PROCESS, fscRefundFinancePO.getFinanceAuditStatus());
        UacNoTaskAuditOrderAuditReqBO auditReqBO = new UacNoTaskAuditOrderAuditReqBO();
        HashMap<String, Number> variables = new HashMap<String, Number>(1);
        variables.put("auditResult", reqBO.getAuditResult().equals(FscConstants.AuditResultStatus.PASS) ? FscConstants.AuditResultStatus.PASS : FscConstants.AuditResultStatus.REFUSE);
        variables.put("refundAmount", fscOrderRefundPO.getRefundAmount());
        auditReqBO.setObjId((List)CollectionUtil.newArrayList((Object[])new Long[]{thisRefundId}));
        auditReqBO.setStepId(stepId);
        auditReqBO.setVariables(variables);
        auditReqBO.setAuditResult(reqBO.getAuditResult());
        auditReqBO.setOperId(String.valueOf(reqBO.getUserId()));
        auditReqBO.setOperDept(reqBO.getOrgName());
        auditReqBO.setObjType(FscConstants.AuditObjType.FINANCE_PURCHASE_REFUND_INVOICE_PROCESS);
        auditReqBO.setUsername(reqBO.getName());
        if (ObjectUtil.isNotEmpty((Object)reqBO.getAuditAdvice())) {
            auditReqBO.setAuditAdvice(reqBO.getAuditAdvice());
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u6d41\u7a0b\u4efb\u52a1\u5ba1\u6279\u5165\u53c2: {}", (Object)JSON.toJSONString((Object)auditReqBO));
        }
        UacNoTaskAuditOrderAuditRspBO auditRspBO = this.uacNoTaskAuditOrderAuditAbilityService.dealAudit(auditReqBO);
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u6d41\u7a0b\u4efb\u52a1\u5ba1\u6279\u51fa\u53c2: {}", (Object)JSON.toJSONString((Object)auditRspBO));
        }
        if (!"0000".equals(auditRspBO.getRespCode())) {
            throw new FscBusinessException("193108", auditRspBO.getRespDesc());
        }
        return auditRspBO;
    }

    private void dealRefundStatusFlow(FscFinanceInvoiceRefundApprovalBusiReqBO reqBO, FscOrderRefundPO fscOrderRefundPO, UacNoTaskAuditOrderAuditRspBO auditRspBO) {
        if (!auditRspBO.getNoneInstanceBO().getFinish().booleanValue()) {
            return;
        }
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>(1);
        paramMap.put("auditResult", reqBO.getAuditResult());
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
        fscOrderStatusFlowAtomReqBO.setOrderId(fscOrderRefundPO.getRefundId());
        fscOrderStatusFlowAtomReqBO.setCurStatus(fscOrderRefundPO.getRefundStatus());
        fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealRefundStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!"0000".equals(fscOrderStatusFlowAtomRspBO.getRespCode())) {
            throw new FscBusinessException(fscOrderStatusFlowAtomRspBO.getRespCode(), fscOrderStatusFlowAtomRspBO.getRespDesc());
        }
    }

    private FscOrderRefundPO getOrderRefund(Long thisRefundId) {
        FscOrderRefundPO qryFscOrderRefund = new FscOrderRefundPO();
        qryFscOrderRefund.setRefundId(thisRefundId);
        return this.fscOrderRefundMapper.getModelBy(qryFscOrderRefund);
    }

    private FscRefundFinancePO getRefundFinance(Long refundId) {
        FscRefundFinancePO qryFscRefundFinance = new FscRefundFinancePO();
        qryFscRefundFinance.setRefundId(refundId);
        return this.fscRefundFinanceMapper.getModelBy(qryFscRefundFinance);
    }
}

