/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.tydic.contract.ability.bo.finance.ContractSyncSettlementAbilityReqBO;
import com.tydic.contract.ability.bo.finance.ContractSyncSettlementAbilityRspBO;
import com.tydic.contract.ability.bo.finance.ContractSyncSettlementItemBO;
import com.tydic.contract.ability.enums.ContractObjectTypeEnum;
import com.tydic.contract.ability.finance.ContractSyncSettlementAbilityService;
import com.tydic.fsc.busibase.atom.api.FscFinanceReleasePayInfoAtomService;
import com.tydic.fsc.busibase.atom.bo.FscFinanceReleasePayInfoAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceReleasePayInfoAtomRspBO;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceOccupyOrDraftService;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceOccupyOrReleaseBankService;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceOccupyOrReleaseCapitalService;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceOccupyOrReleaseSupplyService;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceReleasePayInfoReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceReleasePayInfoRspBO;
import com.tydic.fsc.common.busi.api.finance.FscFinanceReleasePayInfoBusiService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountChargeMapper;
import com.tydic.fsc.dao.FscContractRelationMapper;
import com.tydic.fsc.dao.FscFinanceBankStatementMapper;
import com.tydic.fsc.dao.FscFinanceCapitalPlanMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoMapper;
import com.tydic.fsc.dao.FscFinancePayReduceMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountChargePO;
import com.tydic.fsc.po.FscFinanceBankStatementPO;
import com.tydic.fsc.po.FscFinanceCapitalPlanPO;
import com.tydic.fsc.po.FscFinanceDraftInfoPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscFinanceReleasePayInfoBusiServiceImpl
implements FscFinanceReleasePayInfoBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceReleasePayInfoBusiServiceImpl.class);
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Autowired
    private FscFinanceCapitalPlanMapper fscFinanceCapitalPlanMapper;
    @Autowired
    private FscFinanceBankStatementMapper fscFinanceBankStatementMapper;
    @Autowired
    private FscFinanceDraftInfoMapper fscFinanceDraftInfoMapper;
    @Autowired
    private FscFinanceOccupyOrReleaseBankService fscFinanceOccupyOrReleaseBankService;
    @Autowired
    private FscFinanceOccupyOrDraftService fscFinanceOccupyOrDraftService;
    @Autowired
    private FscContractRelationMapper fscContractRelationMapper;
    @Autowired
    private FscFinancePayReduceMapper fscFinancePayReduceMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscAccountChargeMapper fscAccountChargeMapper;
    @Autowired
    private FscFinanceOccupyOrReleaseCapitalService fscFinanceOccupyOrReleaseCapitalService;
    @Autowired
    private FscFinanceOccupyOrReleaseSupplyService fscFinanceOccupyOrReleaseSupplyService;
    @Autowired
    private FscFinanceReleasePayInfoAtomService fscFinanceReleasePayInfoAtomService;
    @Autowired
    private ContractSyncSettlementAbilityService contractSyncSettlementAbilityService;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;

    @Override
    public FscFinanceReleasePayInfoRspBO dealReleasePayInfo(FscFinanceReleasePayInfoReqBO reqBO) {
        FscFinanceCapitalPlanPO planPO = new FscFinanceCapitalPlanPO();
        planPO.setFscOrderId(reqBO.getFscOrderId());
        List planList = this.fscFinanceCapitalPlanMapper.getList(planPO);
        FscFinanceDraftInfoPO draftInfoPO = new FscFinanceDraftInfoPO();
        draftInfoPO.setFscOrderId(reqBO.getFscOrderId());
        List draftList = this.fscFinanceDraftInfoMapper.getList(draftInfoPO);
        HashSet<String> supplyIds = new HashSet<String>();
        HashSet<String> recvDraftIds = new HashSet<String>();
        for (FscFinanceDraftInfoPO draftPO : draftList) {
            if (StringUtils.isEmpty((String)draftPO.getExtId())) continue;
            if (FscConstants.FinanceDraftType.RECEIVABLE_DRAFT.equals(draftPO.getDraftType())) {
                recvDraftIds.add(draftPO.getExtId());
                continue;
            }
            supplyIds.add(draftPO.getExtId());
        }
        FscFinanceBankStatementPO statementPO = new FscFinanceBankStatementPO();
        statementPO.setFscOrderId(reqBO.getFscOrderId());
        List bankList = this.fscFinanceBankStatementMapper.getList(statementPO);
        List bankExtIds = bankList.stream().map(FscFinanceBankStatementPO::getExtId).distinct().collect(Collectors.toList());
        FscFinanceReleasePayInfoAtomReqBO atomReqBO = new FscFinanceReleasePayInfoAtomReqBO();
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(reqBO.getFscOrderId());
        orderPO = this.fscOrderMapper.getModelBy(orderPO);
        if (orderPO == null) {
            FscAccountChargePO chargePO = new FscAccountChargePO();
            chargePO.setChargeId(reqBO.getFscOrderId());
            chargePO = this.fscAccountChargeMapper.getModelBy(chargePO);
            atomReqBO.setObjId(chargePO.getChargeId());
            atomReqBO.setObjNo(chargePO.getAdvanceDepositNo());
        } else {
            atomReqBO.setObjId(orderPO.getFscOrderId());
            if (reqBO.getPaySource() != null && reqBO.getPaySource() == 1) {
                atomReqBO.setObjNo(reqBO.getOrderNo());
            } else {
                atomReqBO.setObjNo(orderPO.getOrderNo());
            }
        }
        atomReqBO.setBankExtIds(new ArrayList());
        atomReqBO.setReleasePlanList(planList);
        atomReqBO.setSupplyExtIds(supplyIds);
        atomReqBO.setDraftExtIds(recvDraftIds);
        atomReqBO.setBankExtIds(bankExtIds);
        FscFinanceReleasePayInfoAtomRspBO atomRspBO = this.fscFinanceReleasePayInfoAtomService.dealReleasePayInfo(atomReqBO);
        if (FscConstants.OrderFlow.ENGINEERING_SERVICE_PAY.equals(orderPO.getOrderFlow())) {
            try {
                FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
                fscOrderPayItemPO.setFscOrderId(orderPO.getFscOrderId());
                List fscOrderPayItemPOList = this.fscOrderPayItemMapper.getListWithShouldPay(fscOrderPayItemPO);
                if (!CollectionUtils.isEmpty((Collection)fscOrderPayItemPOList)) {
                    this.syncContractInfo(orderPO, fscOrderPayItemPOList);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                log.error("\u5de5\u7a0b\u670d\u52a1\u4ed8\u6b3e\u9000\u56de\u540c\u6b65\u5408\u540c\u91ca\u653e\u5360\u7528\u5f02\u5e38\uff01");
            }
        }
        FscFinanceReleasePayInfoRspBO rspBO = new FscFinanceReleasePayInfoRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void syncContractInfo(FscOrderPO orderPO, List<FscOrderPayItemPO> fscOrderPayItemPOList) {
        ContractSyncSettlementAbilityReqBO contractSyncSettlementAbilityReqBO = new ContractSyncSettlementAbilityReqBO();
        contractSyncSettlementAbilityReqBO.setObjectId(orderPO.getFscOrderId());
        contractSyncSettlementAbilityReqBO.setObjectType(ContractObjectTypeEnum.PRE_PAY.getCode());
        contractSyncSettlementAbilityReqBO.setUserId(Long.valueOf(9999L));
        ArrayList contractList = new ArrayList();
        fscOrderPayItemPOList.forEach(e -> {
            ContractSyncSettlementItemBO syncSettlementItemBO = new ContractSyncSettlementItemBO();
            syncSettlementItemBO.setPayDetailId(e.getObjectId());
            syncSettlementItemBO.setAmt(e.getPayAmount());
            syncSettlementItemBO.setContractId(e.getContractId());
            contractList.add(syncSettlementItemBO);
        });
        contractSyncSettlementAbilityReqBO.setDeleteList(contractList);
        ContractSyncSettlementAbilityRspBO contractSyncSettlementAbilityRspBO = this.contractSyncSettlementAbilityService.modifySettlement(contractSyncSettlementAbilityReqBO);
        if (Objects.nonNull(contractSyncSettlementAbilityRspBO) && !"0000".equals(contractSyncSettlementAbilityRspBO.getRespCode())) {
            throw new FscBusinessException("8888", "\u540c\u6b65\u5408\u540c\u6a21\u5757\u7ed3\u7b97\u4fe1\u606f\u5931\u8d25\uff1a" + contractSyncSettlementAbilityRspBO.getRespDesc());
        }
    }
}

