/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.busibase.atom.api.FscCreditBalanceInsertAtomService;
import com.tydic.fsc.busibase.atom.bo.FscCreditBalanceInsertAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscCreditBalanceInsertAtomRspBO;
import com.tydic.fsc.common.busi.api.FscMerchantEditBusiService;
import com.tydic.fsc.common.busi.api.FscMerchantSubmitBusiService;
import com.tydic.fsc.common.busi.bo.FscMerchantEditBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscMerchantEditBusiRspBO;
import com.tydic.fsc.common.busi.bo.FscMerchantSubmitBusiServiceReqBO;
import com.tydic.fsc.common.busi.bo.FscMerchantSubmitBusiServiceRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscMerchantPO;
import com.tydic.fsc.util.FscRspUtil;
import com.tydic.umc.constants.UmcEnumConstant;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="fscMerchantEditBusiService")
public class FscMerchantEditBusiServiceImpl
implements FscMerchantEditBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscMerchantEditBusiServiceImpl.class);
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscMerchantSubmitBusiService fscMerchantSubmitBusiService;
    @Autowired
    private FscCreditBalanceInsertAtomService fscCreditBalanceInsertAtomService;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;

    @Override
    public FscMerchantEditBusiRspBO editMerchant(FscMerchantEditBusiReqBO reqBO) {
        FscAccountPO set;
        FscMerchantEditBusiRspBO retBo = (FscMerchantEditBusiRspBO)FscRspUtil.getSuccessRspBo(FscMerchantEditBusiRspBO.class);
        FscMerchantPO qryReqPo = new FscMerchantPO();
        qryReqPo.setMerchantId(reqBO.getMerchantId());
        FscMerchantPO merchantPo = this.fscMerchantMapper.getModelBy(qryReqPo);
        if (null == merchantPo) {
            log.error("\u672a\u67e5\u8be2\u5230\u5546\u6237[{}]\u7684\u4fe1\u606f", (Object)reqBO.getMerchantId());
            retBo.setRespCode("193122");
            retBo.setRespDesc("\u5931\u8d25");
            return retBo;
        }
        String payMerchantId = merchantPo.getPayMerchantId();
        if (FscConstants.MerchanCreateDealType.SUBMIT.equals(reqBO.getDealType())) {
            if (log.isDebugEnabled()) {
                log.debug("\u672c\u6b21\u6267\u884c\u7684\u662f\u5546\u6237\u7f16\u8f91\u63d0\u4ea4=========");
            }
            FscMerchantSubmitBusiServiceReqBO submitBusiReqBo = new FscMerchantSubmitBusiServiceReqBO();
            BeanUtils.copyProperties((Object)((Object)reqBO), (Object)((Object)submitBusiReqBo));
            submitBusiReqBo.setMerchantId(reqBO.getMerchantId());
            submitBusiReqBo.setPayMerchantId(payMerchantId);
            FscMerchantSubmitBusiServiceRspBO submitBusiRetBo = this.fscMerchantSubmitBusiService.submitMerchant(submitBusiReqBo);
            if (!"0000".equals(submitBusiRetBo.getRespCode())) {
                throw new FscBusinessException("193122", "\u63d0\u4ea4\u5546\u6237\u4fe1\u606f\u5931\u8d25\uff1a" + submitBusiRetBo.getRespDesc());
            }
        }
        Long accountId = merchantPo.getAccountId();
        Date nowTime = this.fscMerchantMapper.getDBDate();
        merchantPo = new FscMerchantPO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)merchantPo);
        merchantPo.setUpdateTime(nowTime);
        merchantPo.setUpdateOperId(reqBO.getUserId().toString());
        merchantPo.setUpdateOperName(reqBO.getName());
        merchantPo.setCreditExhaustion(reqBO.getCreditExhaustion());
        merchantPo.setLiquidatedDamages(reqBO.getLiquidatedDamages());
        if (FscConstants.MerchanCreateDealType.SUBMIT.equals(reqBO.getDealType())) {
            merchantPo.setStatus(FscConstants.MerchantStatus.VALID);
        }
        log.error("merchantPo\u5165\u53c2\uff1a", (Object)JSON.toJSONString((Object)merchantPo));
        int result = this.fscMerchantMapper.updateById(merchantPo);
        if (result < 1) {
            throw new FscBusinessException("193122", "\u66f4\u65b0\u8868\u5931\u8d25\uff0c\u8fd4\u56de\u503c\u5c0f\u4e8e1");
        }
        if (null != merchantPo.getPayCreditAmount()) {
            this.dealCreditBalance(merchantPo, reqBO);
        }
        FscAccountPO accountPo = new FscAccountPO();
        accountPo.setId(accountId);
        accountPo = this.fscAccountMapper.getModelBy(accountPo);
        if (null != accountPo) {
            retBo.setAccountNo(accountPo.getAccountNo());
        }
        if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PRE_STORE.equals(reqBO.getPayType())) {
            set = new FscAccountPO();
            set.setOverdraft(reqBO.getOverdraft());
            FscAccountPO where = new FscAccountPO();
            where.setBusiType(FscConstants.FscBusiType.ELECTRONIC.toString());
            where.setOrgId(merchantPo.getOrgId());
            this.fscAccountMapper.updateBy(set, where);
        }
        if (reqBO.getPayType() != null) {
            set = new FscAccountPO();
            if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PRE_STORE.equals(reqBO.getPayType())) {
                set.setUnionOverdraft(reqBO.getUnionOverdraft());
                set.setCompanyOverdraft(reqBO.getCompanyOverdraft());
                set.setCompanyCreditAmount(BigDecimal.ZERO);
                set.setUnionCreditAmount(BigDecimal.ZERO);
            } else if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(reqBO.getPayType())) {
                set.setUnionOverdraft(BigDecimal.ZERO);
                set.setCompanyOverdraft(BigDecimal.ZERO);
                set.setCompanyCreditAmount(reqBO.getCompanyCreditAmount());
                set.setUnionCreditAmount(reqBO.getUnionCreditAmount());
            } else {
                set.setUnionOverdraft(BigDecimal.ZERO);
                set.setCompanyOverdraft(BigDecimal.ZERO);
                set.setCompanyCreditAmount(BigDecimal.ZERO);
                set.setUnionCreditAmount(BigDecimal.ZERO);
            }
            if (this.operationOrgId.equals(reqBO.getOrgId()) && FscConstants.MerchantIsException.MERCHANT_NOT_EXCEPTION.equals(reqBO.getExceptionFlag())) {
                FscMerchantPO getExceptionPo = new FscMerchantPO();
                getExceptionPo.setParentId(reqBO.getMerchantId());
                getExceptionPo.setOrgId(this.operationOrgId);
                getExceptionPo.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION);
                getExceptionPo.setDelFlag(UmcEnumConstant.DelFlag.NOT_DELETE.getCode());
                getExceptionPo.setPayBusiSceneRange("4");
                getExceptionPo.setEnable(Integer.valueOf(1));
                List fscMerchantList = this.fscMerchantMapper.getFscMerchantList(getExceptionPo);
                List<Object> payObjIds = new ArrayList();
                if (!CollectionUtils.isEmpty((Collection)fscMerchantList)) {
                    payObjIds = fscMerchantList.stream().filter(e -> e.getPayObjId() != null).map(e -> e.getPayObjId()).collect(Collectors.toList());
                }
                set.setBusiType("4");
                set.setOrgIds(payObjIds);
                this.fscAccountMapper.updateCreditAndOverDraftByBusiType(set);
            } else if (FscConstants.MerchantIsException.MERCHANT_NOT_EXCEPTION.equals(reqBO.getExceptionFlag()) && reqBO.getOrgId() != null) {
                set.setOrgId(reqBO.getOrgId());
                set.setBusiType("4");
                this.fscAccountMapper.updateCreditAndOverDraftByBusiType(set);
            } else if (FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION.equals(reqBO.getExceptionFlag()) && reqBO.getPayObjId() != null) {
                set.setOrgId(reqBO.getPayObjId());
                set.setBusiType("4");
                this.fscAccountMapper.updateCreditAndOverDraftByBusiType(set);
            }
        }
        return retBo;
    }

    private void dealCreditBalance(FscMerchantPO merchantPo, FscMerchantEditBusiReqBO reqBO) {
        FscCreditBalanceInsertAtomRspBO rspBO;
        FscCreditBalanceInsertAtomReqBO creditBalanceInsertAtomReqBO = new FscCreditBalanceInsertAtomReqBO();
        creditBalanceInsertAtomReqBO.setMerchantId(merchantPo.getMerchantId());
        creditBalanceInsertAtomReqBO.setPayCreditAmount(merchantPo.getPayCreditAmount());
        creditBalanceInsertAtomReqBO.setUsedAmount(BigDecimal.ZERO);
        creditBalanceInsertAtomReqBO.setUpdateOper(reqBO.getName());
        creditBalanceInsertAtomReqBO.setPurOrgId(reqBO.getPurOrgId());
        if (!StringUtils.isEmpty((Object)reqBO.getPayBusiSceneRange()) && !reqBO.getPayBusiSceneRange().equals("0")) {
            creditBalanceInsertAtomReqBO.setPayBusiness(reqBO.getPayBusiSceneRange());
        }
        if (!"0000".equals((rspBO = this.fscCreditBalanceInsertAtomService.dealCreditBalanceInsert(creditBalanceInsertAtomReqBO)).getRespCode())) {
            throw new FscBusinessException("193122", "\u5904\u7406\u6388\u4fe1\u51fa\u9519");
        }
    }
}

