/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.AttachmentExtensionBO;
import com.tydic.fsc.common.busi.api.FscPayClaimCreateBusiService;
import com.tydic.fsc.common.busi.bo.FscPayClaimCreateBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscPayClaimCreateBusiRspBO;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscPayClaimDetailMapper;
import com.tydic.fsc.dao.FscPayClaimMapper;
import com.tydic.fsc.enums.FscClaimRecvStatusEnum;
import com.tydic.fsc.enums.FscClaimStatusEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscPayClaimPO;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscPayClaimCreateBusiServiceImpl
implements FscPayClaimCreateBusiService {
    @Autowired
    private FscPayClaimDetailMapper fscPayClaimDetailMapper;
    @Autowired
    private FscPayClaimMapper fscPayClaimMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;

    @Override
    public FscPayClaimCreateBusiRspBO dealCreate(FscPayClaimCreateBusiReqBO reqBO) {
        FscPayClaimCreateBusiRspBO rspBO = new FscPayClaimCreateBusiRspBO();
        FscPayClaimPO fscPayClaimPO = new FscPayClaimPO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)fscPayClaimPO);
        fscPayClaimPO.setMaintainUserId(reqBO.getUserId());
        fscPayClaimPO.setMaintainUserName(reqBO.getName());
        fscPayClaimPO.setMaintainDeptId(reqBO.getOrgId());
        fscPayClaimPO.setMaintainDeptName(reqBO.getOrgName());
        fscPayClaimPO.setPayType(reqBO.getRecvType());
        FscPayClaimPO queryVo = new FscPayClaimPO();
        queryVo.setClaimIdNot(reqBO.getClaimId());
        queryVo.setSerialNumber(reqBO.getSerialNumber());
        List list = this.fscPayClaimMapper.getList(queryVo);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            throw new FscBusinessException("190000", "\u94f6\u884c\u6d41\u6c34\u53f7\u4e0d\u80fd\u91cd\u590d\uff01");
        }
        if (reqBO.getOperationType() == 1) {
            if (reqBO.getClaimId() == null) {
                Long claimId = this.saveRecvClaim(reqBO, fscPayClaimPO, FscClaimRecvStatusEnum.EFFECTIVE);
                rspBO.setClaimId(claimId);
            } else {
                fscPayClaimPO.setUpdateTime(new Date());
                fscPayClaimPO.setPayStatus(FscClaimRecvStatusEnum.EFFECTIVE.getCode());
                this.fscPayClaimMapper.updateById(fscPayClaimPO);
                rspBO.setClaimId(fscPayClaimPO.getClaimId());
            }
            rspBO.setPushFlag(true);
        } else if (reqBO.getClaimId() == null) {
            this.saveRecvClaim(reqBO, fscPayClaimPO, FscClaimRecvStatusEnum.NEW);
        } else {
            fscPayClaimPO.setUpdateTime(new Date());
            this.fscPayClaimMapper.updateById(fscPayClaimPO);
        }
        if (!CollectionUtils.isEmpty(reqBO.getAttachmentList())) {
            this.dealFile(reqBO);
        }
        if (rspBO.getPushFlag().booleanValue()) {
            // empty if block
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private Long saveRecvClaim(FscPayClaimCreateBusiReqBO reqBO, FscPayClaimPO fscPayClaimPO, FscClaimRecvStatusEnum effective) {
        fscPayClaimPO.setClaimId(Long.valueOf(Sequence.getInstance().nextId()));
        reqBO.setClaimId(fscPayClaimPO.getClaimId());
        fscPayClaimPO.setCreateTime(new Date());
        fscPayClaimPO.setUpdateTime(new Date());
        fscPayClaimPO.setClaimStatus(FscClaimStatusEnum.NOT_CLAIM.getCode());
        fscPayClaimPO.setPayStatus(effective.getCode());
        int count = this.fscPayClaimMapper.insert(fscPayClaimPO);
        if (count < 0) {
            throw new FscBusinessException("190000", "\u65b0\u589e\u4ed8\u6b3e\u8ba4\u9886\u5355\u5931\u8d25\uff01");
        }
        return fscPayClaimPO.getClaimId();
    }

    private void dealFile(FscPayClaimCreateBusiReqBO reqBO) {
        int count;
        LinkedList<AttachmentExtensionBO> extensionAddList = new LinkedList<AttachmentExtensionBO>();
        LinkedList<Long> attachmentIdList = new LinkedList<Long>();
        for (AttachmentExtensionBO attachmentExtensionBO : reqBO.getAttachmentList()) {
            if (attachmentExtensionBO.getAttachmentId() != null) {
                attachmentIdList.add(attachmentExtensionBO.getAttachmentId());
            }
            attachmentExtensionBO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
            attachmentExtensionBO.setObjId(reqBO.getClaimId());
            attachmentExtensionBO.setAttachmentType(Integer.valueOf(3));
            attachmentExtensionBO.setCreateTime(new Date());
            attachmentExtensionBO.setCreateUser(reqBO.getName());
            attachmentExtensionBO.setCreateUserId(reqBO.getUserId());
            extensionAddList.add(attachmentExtensionBO);
        }
        if (!CollectionUtils.isEmpty(attachmentIdList)) {
            this.fscAttachmentMapper.deleteByAttachmentIds(attachmentIdList);
        }
        if (!CollectionUtils.isEmpty(extensionAddList) && (count = this.fscAttachmentMapper.insertExtensionByBatch(extensionAddList)) < 0) {
            throw new FscBusinessException("190000", "\u6dfb\u52a0\u9644\u4ef6\u4fe1\u606f\u5931\u8d25\uff01");
        }
    }
}

