/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushUnifyInvoiceBillReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushUnifyInvoiceBillRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscPushUnifyInvoiceBillService;
import com.tydic.fsc.busibase.external.api.esb.FscUnifySettleRelatedInterfacesAtomService;
import com.tydic.fsc.common.busi.api.FscPushUnifyInvoiceBillBusiCopyService;
import com.tydic.fsc.common.busi.bo.FscPushUnifyInvoiceBillBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscPushUnifyInvoiceBillBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscPayOrderStateTyEnum;
import com.tydic.fsc.dao.FscOrderExtMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscPurchasePushLogMapper;
import com.tydic.fsc.po.FscOrderExtPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscPurchasePushLogPo;
import com.tydic.uoc.common.ability.api.PebExtUnifySettleEncryptionAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleDecryptionAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleDecryptionAbilityRspBO;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscPushUnifyInvoiceBillBusiCopyServiceImpl
implements FscPushUnifyInvoiceBillBusiCopyService {
    private static final Logger log = LoggerFactory.getLogger(FscPushUnifyInvoiceBillBusiCopyServiceImpl.class);
    @Autowired
    private PebExtUnifySettleEncryptionAbilityService pebExtUnifySettleEncryptionAbilityService;
    @Autowired
    private FscPurchasePushLogMapper fscPurchasePushLogMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderExtMapper fscOrderExtMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscPushUnifyInvoiceBillService fscPushUnifyInvoiceBillService;
    @Autowired
    private FscUnifySettleRelatedInterfacesAtomService fscUnifySettleRelatedInterfacesAtomService;
    @Value(value="${UNIFY_PAY_TERMS:16}")
    private String payTerms;
    public static final String BUSI_NAME = "\u63a8\u9001\u7edf\u4e00\u7ed3\u7b97";
    public static final String BUSI_CODE = "1214";

    @Override
    public FscPushUnifyInvoiceBillBusiRspBO dealPushUnifyInvoiceBill(FscPushUnifyInvoiceBillBusiReqBO reqBO) {
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(reqBO.getFscOrderId());
        orderPO = this.fscOrderMapper.getModelBy(orderPO);
        FscPushUnifyInvoiceBillBusiRspBO rspBO = new FscPushUnifyInvoiceBillBusiRspBO();
        FscPushUnifyInvoiceBillReqBO pushUnifyInvoiceBillReqBO = new FscPushUnifyInvoiceBillReqBO();
        pushUnifyInvoiceBillReqBO.setData(reqBO.getParseData());
        pushUnifyInvoiceBillReqBO.setToken(reqBO.getToken());
        FscPushUnifyInvoiceBillRspBO pushUnifyInvoiceBillRspBO = this.fscPushUnifyInvoiceBillService.dealPushUnifyInvoiceBill(pushUnifyInvoiceBillReqBO);
        if (!pushUnifyInvoiceBillRspBO.getRespCode().equals("0000") || !"200".equals(pushUnifyInvoiceBillRspBO.getCode()) || Objects.nonNull(pushUnifyInvoiceBillRspBO.getState()) && !pushUnifyInvoiceBillRspBO.getState().booleanValue()) {
            PebExtUnifySettleDecryptionAbilityReqBO decryptionAbilityReqBO = new PebExtUnifySettleDecryptionAbilityReqBO();
            decryptionAbilityReqBO.setData(pushUnifyInvoiceBillRspBO.getMsg());
            PebExtUnifySettleDecryptionAbilityRspBO decryptionAbilityRspBO = this.pebExtUnifySettleEncryptionAbilityService.dealParamDecryption(decryptionAbilityReqBO);
            FscPurchasePushLogPo pushLogPo = this.buildPushLog(orderPO, FscConstants.FscPushStatus.FAIL, FscConstants.FscPurchasePushType.SETTLE);
            pushLogPo.setRespData(decryptionAbilityRspBO.getData());
            pushLogPo.setRespParseData(pushUnifyInvoiceBillRspBO.getRspData());
            pushLogPo.setPushData(reqBO.getReqData());
            pushLogPo.setPushParseData(reqBO.getParseData());
            this.fscPurchasePushLogMapper.insert(pushLogPo);
            FscOrderExtPO orderExtPO = new FscOrderExtPO();
            orderExtPO.setFscOrderId(orderPO.getFscOrderId());
            orderExtPO.setUnifyPushStatus(FscConstants.FscPushStatus.FAIL);
            orderExtPO.setFailReason(decryptionAbilityRspBO.getData());
            this.fscOrderExtMapper.updateById(orderExtPO);
            if (orderPO.getSettlePlatform() != null && orderPO.getSettlePlatform() == 2 && orderPO.getTradeMode() != null && orderPO.getTradeMode() == 2 && (orderPO.getOrderState().equals(FscConstants.FscInvoiceOrderState.BILLSIGNFAIL) || orderPO.getOrderState().equals(FscConstants.FscInvoiceOrderState.BILL_SIGN_PASS))) {
                this.dealStatusFlow(orderPO, FscConstants.UnifyPushResult.FAIL);
                FscOrderPO orderPO1 = new FscOrderPO();
                orderPO1.setFscOrderId(reqBO.getFscOrderId());
                orderPO1.setOrderState(FscConstants.FscInvoiceOrderState.SIGNED);
                this.fscOrderMapper.updateById(orderPO1);
            } else if (orderPO.getOrderState().equals(FscPayOrderStateTyEnum.TY_PUSHING.getCode())) {
                this.dealStatusFlow(orderPO, FscConstants.UnifyPushResult.FAIL);
            }
            rspBO.setRespCode("190000");
            rspBO.setRespDesc(decryptionAbilityRspBO.getData());
        } else {
            FscPurchasePushLogPo pushLogPo = this.buildPushLog(orderPO, FscConstants.FscPushStatus.SUCCESS, FscConstants.FscPurchasePushType.SETTLE);
            PebExtUnifySettleDecryptionAbilityReqBO decryptionAbilityReqBO = new PebExtUnifySettleDecryptionAbilityReqBO();
            decryptionAbilityReqBO.setData(pushUnifyInvoiceBillRspBO.getData());
            PebExtUnifySettleDecryptionAbilityRspBO decryptionAbilityRspBO = this.pebExtUnifySettleEncryptionAbilityService.dealParamDecryption(decryptionAbilityReqBO);
            pushLogPo.setRespData(decryptionAbilityRspBO.getData());
            pushLogPo.setPushData(reqBO.getReqData());
            pushLogPo.setPushParseData(reqBO.getParseData());
            pushLogPo.setRespParseData(JSONObject.toJSONString((Object)pushUnifyInvoiceBillRspBO));
            this.fscPurchasePushLogMapper.insert(pushLogPo);
            JSONObject object = JSONObject.parseObject((String)decryptionAbilityRspBO.getData());
            FscOrderExtPO orderExtPO = new FscOrderExtPO();
            orderExtPO.setFscOrderId(orderPO.getFscOrderId());
            orderExtPO.setUnifyPushStatus(FscConstants.FscPushStatus.SUCCESS);
            if (object.get((Object)"INST_ID") != null) {
                orderExtPO.setInstanceId(object.get((Object)"INST_ID").toString());
            }
            this.fscOrderExtMapper.updateById(orderExtPO);
            if (orderPO.getSettlePlatform() != null && orderPO.getSettlePlatform() == 2 && orderPO.getTradeMode() != null && orderPO.getTradeMode() == 2 && (orderPO.getOrderState().equals(FscConstants.FscInvoiceOrderState.BILLSIGNFAIL) || orderPO.getOrderState().equals(FscConstants.FscInvoiceOrderState.BILL_SIGN_PASS))) {
                this.dealStatusFlow(orderPO, FscConstants.UnifyPushResult.SUCCESS);
                FscOrderPO orderPO1 = new FscOrderPO();
                orderPO1.setFscOrderId(reqBO.getFscOrderId());
                orderPO1.setOrderState(FscConstants.FscInvoiceOrderState.SIGNED);
                this.fscOrderMapper.updateById(orderPO1);
            } else if (orderPO.getOrderState().equals(FscPayOrderStateTyEnum.TY_PUSHING.getCode()) || orderPO.getOrderState().equals(FscPayOrderStateTyEnum.TY_PUSH_FAIL.getCode())) {
                this.dealStatusFlow(orderPO, FscConstants.UnifyPushResult.SUCCESS);
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        return rspBO;
    }

    private FscPurchasePushLogPo buildPushLog(FscOrderPO orderPO, Integer pushStatus, Integer pushType) {
        FscPurchasePushLogPo pushLogPo = new FscPurchasePushLogPo();
        pushLogPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
        pushLogPo.setObjectId(orderPO.getFscOrderId());
        pushLogPo.setObjectNo(orderPO.getOrderNo());
        pushLogPo.setPushStatus(pushStatus);
        pushLogPo.setType(pushType);
        pushLogPo.setCreateTime(new Date());
        return pushLogPo;
    }

    private void dealStatusFlow(FscOrderPO fscOrderPo, Integer result) {
        FscOrderStatusFlowAtomReqBO flowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        flowAtomReqBO.setOrderId(fscOrderPo.getFscOrderId());
        flowAtomReqBO.setCurStatus(fscOrderPo.getOrderState());
        flowAtomReqBO.setBusiName(BUSI_NAME);
        flowAtomReqBO.setBusiCode(BUSI_CODE);
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>(1);
        if (fscOrderPo.getSettlePlatform() != null && fscOrderPo.getSettlePlatform() == 2 && fscOrderPo.getTradeMode() != null && fscOrderPo.getTradeMode() == 2) {
            paramMap.put("skigFlag", result);
        } else {
            paramMap.put("pushResult", result);
        }
        flowAtomReqBO.setParamMap(paramMap);
        FscOrderStatusFlowAtomRspBO flowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(flowAtomReqBO);
        if (!"0000".equals(flowAtomRspBO.getRespCode())) {
            log.error("\u8c03\u7528\u6d41\u7a0b\u6d41\u8f6c\u7ed3\u7b97\u5355\u72b6\u6001\u5931\u8d25\uff01");
        }
    }
}

