/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.external.api.bo.FscGetErpCustInfoReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetErpCustInfoRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushYcRecvClaimChangeBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushYcRecvClaimChangeLineBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushYcRecvClaimChangeReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushYcRecvClaimChangeRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscGetErpCustInfoService;
import com.tydic.fsc.busibase.external.api.esb.FscPushYcRecvClaimChangeService;
import com.tydic.fsc.common.busi.api.FscPushYcRecvClaimChangeBusiService;
import com.tydic.fsc.common.busi.bo.FscPushYcRecvClaimChangeBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscPushYcRecvClaimChangeBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscClaimDetailChangeMapper;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscDicDictionaryExernalMapper;
import com.tydic.fsc.dao.FscPushLogMapper;
import com.tydic.fsc.dao.FscRecvClaimChangeMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscClaimDetailChangePO;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscDicDictionaryExernalPO;
import com.tydic.fsc.po.FscPushLogPO;
import com.tydic.fsc.po.FscRecvClaimChangePO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscPushYcRecvClaimChangeBusiServiceImpl
implements FscPushYcRecvClaimChangeBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscPushYcRecvClaimChangeBusiServiceImpl.class);
    @Autowired
    private FscPushYcRecvClaimChangeService fscPushYcRecvClaimChangeService;
    @Autowired
    private FscClaimDetailChangeMapper fscClaimDetailChangeMapper;
    @Autowired
    private FscRecvClaimChangeMapper fscRecvClaimChangeMapper;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscDicDictionaryExernalMapper fscDicDictionaryExernalMapper;
    @Autowired
    private FscPushLogMapper fscPushLogMapper;
    @Autowired
    private FscGetErpCustInfoService fscGetErpCustInfoService;
    @Value(value="${OPER_ORG_ID}")
    private String operationOrgId;
    @Value(value="${OPER_ORG_NAME}")
    private String operationOrgName;

    @Override
    @Transactional(isolation=Isolation.READ_UNCOMMITTED)
    public FscPushYcRecvClaimChangeBusiRspBO pushYcRecvClaim(FscPushYcRecvClaimChangeBusiReqBO reqBO) {
        FscRecvClaimChangePO fscRecvClaimChangePO = this.fscRecvClaimChangeMapper.queryById(reqBO.getChangeId());
        if (fscRecvClaimChangePO == null) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u76f8\u5173\u8ba4\u9886\u53d8\u66f4\u5355\u4fe1\u606f\uff01" + reqBO.getChangeId());
        }
        if (!FscConstants.ChangeBillStatus.CONFIRMED.equals(fscRecvClaimChangePO.getBillStatus())) {
            throw new FscBusinessException("190000", "\u53d8\u66f4\u5355" + fscRecvClaimChangePO.getChangeNo() + "\u8fd8\u672a\u786e\u8ba4\u5b8c\u6210\uff01");
        }
        if (FscConstants.FscClaimChangePushStatus.SUCCESS.equals(fscRecvClaimChangePO.getPushStatus())) {
            throw new FscBusinessException("190000", "\u53d8\u66f4\u5355" + fscRecvClaimChangePO.getChangeNo() + "\u5df2\u63a8\u9001\uff01");
        }
        FscPushYcRecvClaimChangeBusiRspBO rspBO = new FscPushYcRecvClaimChangeBusiRspBO();
        FscClaimDetailChangePO fscClaimDetailChangePO = new FscClaimDetailChangePO();
        fscClaimDetailChangePO.setChangeId(reqBO.getChangeId());
        fscClaimDetailChangePO.setConfirmStatus(FscConstants.ChangeConfirmStatus.CONFIRMED);
        List changeDetailList = this.fscClaimDetailChangeMapper.queryAll(fscClaimDetailChangePO);
        if (CollectionUtils.isEmpty((Collection)changeDetailList)) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u76f8\u5173\u8ba4\u9886\u53d8\u66f4\u5355\u660e\u7ec6\u4fe1\u606f\uff01" + reqBO.getChangeId());
        }
        FscPushYcRecvClaimChangeReqBO pushReqBo = new FscPushYcRecvClaimChangeReqBO();
        try {
            FscGetErpCustInfoReqBO custInfoReqBO = new FscGetErpCustInfoReqBO();
            custInfoReqBO.setCustomerName(fscRecvClaimChangePO.getCustomerName());
            FscGetErpCustInfoRspBO custInfoRspBO = this.fscGetErpCustInfoService.getErpCustInfo(custInfoReqBO);
            if (!custInfoRspBO.getRespCode().equals("0000")) {
                throw new FscBusinessException(custInfoRspBO.getRespCode(), custInfoRspBO.getRespDesc());
            }
            FscPushYcRecvClaimChangeBO receivable = new FscPushYcRecvClaimChangeBO();
            receivable.setORG_ID(this.operationOrgId);
            receivable.setORG_NAME(this.operationOrgName);
            receivable.setCHARGEMAN_ID(fscRecvClaimChangePO.getChangeUserId().toString());
            receivable.setCHARGEMAN_NAME(fscRecvClaimChangePO.getChangeUserName());
            receivable.setDEPT_ID(fscRecvClaimChangePO.getChangeDeptId().toString());
            receivable.setDEPT_NAME(fscRecvClaimChangePO.getChangeDeptName());
            receivable.setRECEIVABLE_CLAIM_NUMBER(fscRecvClaimChangePO.getClaimNo());
            receivable.setRECEIVABLE_CHG_NUMBER(fscRecvClaimChangePO.getChangeNo());
            receivable.setRECEIVABLE_CLAIM_ID(fscRecvClaimChangePO.getClaimId().toString());
            receivable.setCHG_DATE(DateFormatUtils.format((Date)fscRecvClaimChangePO.getChangeDate(), (String)"yyyy-MM-dd"));
            receivable.setCOMMENTS(fscRecvClaimChangePO.getRemark());
            receivable.setTESCO_ID(fscRecvClaimChangePO.getChangeId());
            receivable.setCHG_AMT_OLD(fscRecvClaimChangePO.getChangeAmt().toPlainString());
            receivable.setAPP_STATUS("Y");
            receivable.setSTATUS("A");
            ArrayList<FscPushYcRecvClaimChangeLineBO> receivableClaim = new ArrayList<FscPushYcRecvClaimChangeLineBO>();
            FscDicDictionaryExernalPO eternal = new FscDicDictionaryExernalPO();
            eternal.setPCode("FSC_YC_CLAIM_TYPE");
            Map<String, String> dicMapE = this.getDicMap(eternal);
            BigDecimal CHG_AMT = BigDecimal.ZERO;
            int index = 1;
            boolean isWrite = Boolean.FALSE;
            for (Object po : changeDetailList) {
                FscPushYcRecvClaimChangeLineBO lineBO = new FscPushYcRecvClaimChangeLineBO();
                lineBO.setCLAIM_TYPE_CHG(dicMapE.get(po.getChangeClaimType().toString()));
                if (po.getChangeOrderId() != null) {
                    lineBO.setCONTRACT_ID_CHG(po.getChangeOrderId().toString());
                }
                lineBO.setCONTRACT_NUMBER_CHG(po.getChangeOrderCode());
                if (po.getChangeFscOrderId() != null) {
                    lineBO.setBILL_ID_CHG(po.getChangeFscOrderId().toString());
                    lineBO.setBILL_NUMBER_CHG(po.getChangeFscOrderNo());
                } else {
                    lineBO.setBILL_ID_CHG("");
                    lineBO.setBILL_NUMBER_CHG("");
                }
                lineBO.setCLAIM_AMT_CHG(po.getChangeAmt().toPlainString());
                lineBO.setTESCO_ID(po.getChangeDetailId().toString());
                lineBO.setCLAIM_INFO_ID(po.getClaimDetailId().toString());
                lineBO.setLINE_NUMBER(index + "");
                CHG_AMT = CHG_AMT.add(po.getChangeAmt());
                ++index;
                receivableClaim.add(lineBO);
                if (po.getBusiType() != null) continue;
                isWrite = true;
            }
            List claimDetailList = this.fscClaimDetailMapper.getByChangeId(reqBO.getChangeId());
            if (!CollectionUtils.isEmpty((Collection)claimDetailList)) {
                for (FscClaimDetailPO po : claimDetailList) {
                    FscPushYcRecvClaimChangeLineBO lineBO = new FscPushYcRecvClaimChangeLineBO();
                    lineBO.setCLAIM_TYPE_CHG(dicMapE.get(po.getClaimType()));
                    if (!StringUtils.isEmpty((Object)po.getFscOrderNo())) {
                        lineBO.setBILL_ID_CHG(po.getFscOrderId().toString());
                        lineBO.setBILL_NUMBER_CHG(po.getFscOrderNo());
                    } else {
                        lineBO.setBILL_ID_CHG("");
                        lineBO.setBILL_NUMBER_CHG("");
                    }
                    if (po.getOrderId() != null) {
                        lineBO.setCONTRACT_ID_CHG(po.getOrderId().toString());
                    }
                    lineBO.setCONTRACT_NUMBER_CHG(po.getOrderCode());
                    lineBO.setCLAIM_AMT_CHG(po.getChangedAmt().subtract(po.getWriteOffAmount()).toPlainString());
                    if (isWrite) {
                        if (po.getChangedAmt().subtract(po.getWriteOffAmount()).compareTo(BigDecimal.ZERO) <= FscConstants.COMPARE_ZERO) continue;
                        lineBO.setCLAIM_AMT_CHG(po.getChangedAmt().subtract(po.getWriteOffAmount()).toPlainString());
                    }
                    lineBO.setTESCO_ID(po.getClaimDetailId().toString());
                    lineBO.setCLAIM_INFO_ID(po.getClaimDetailId().toString());
                    lineBO.setLINE_NUMBER(index + "");
                    ++index;
                    receivableClaim.add(lineBO);
                }
            }
            receivable.setCHG_AMT(CHG_AMT.toPlainString());
            pushReqBo.setReceivable(receivable);
            pushReqBo.setReceivableClaim(receivableClaim);
            FscPushYcRecvClaimChangeRspBO pushRspBo = this.fscPushYcRecvClaimChangeService.pushRecvClaimChange(pushReqBo);
            if (!pushRspBo.getRespCode().equals("0000")) {
                this.saveLog(fscRecvClaimChangePO, FscConstants.FscPushStatus.FAIL, JSONObject.toJSONString((Object)pushReqBo));
                rspBO.setRespCode(pushRspBo.getRespCode());
                rspBO.setRespDesc(pushRspBo.getRespDesc());
                fscRecvClaimChangePO.setPushStatus(FscConstants.FscClaimChangePushStatus.FAIL);
                fscRecvClaimChangePO.setPushDate(new Date());
                fscRecvClaimChangePO.setFailReason(pushRspBo.getRespDesc());
                this.savePushStatus(fscRecvClaimChangePO);
                return rspBO;
            }
            fscRecvClaimChangePO.setPushStatus(FscConstants.FscClaimChangePushStatus.SUCCESS);
            fscRecvClaimChangePO.setPushDate(new Date());
            fscRecvClaimChangePO.setFailReason(null);
            this.savePushStatus(fscRecvClaimChangePO);
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u4e1a\u8d22\u8ba4\u9886\u53d8\u66f4\u5355\u5931\u8d25\uff01" + e);
            fscRecvClaimChangePO.setPushStatus(FscConstants.FscClaimChangePushStatus.FAIL);
            fscRecvClaimChangePO.setFailReason(e.getMessage());
            fscRecvClaimChangePO.setPushDate(new Date());
            this.savePushStatus(fscRecvClaimChangePO);
            rspBO.setRespCode("190000");
            rspBO.setRespDesc(e.getMessage());
            return rspBO;
        }
        this.saveLog(fscRecvClaimChangePO, FscConstants.FscPushStatus.SUCCESS, JSONObject.toJSONString((Object)pushReqBo));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void saveLog(FscRecvClaimChangePO fscRecvClaimChangePO, Integer status, String jsonStr) {
        try {
            FscPushLogPO fscPushLogPo = new FscPushLogPO();
            fscPushLogPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscPushLogPo.setObjectId(fscRecvClaimChangePO.getChangeId());
            fscPushLogPo.setObjectNo(fscRecvClaimChangePO.getChangeNo());
            fscPushLogPo.setType(FscConstants.FscPushType.CLAIM_CHANGE);
            fscPushLogPo.setCreateTime(new Date());
            fscPushLogPo.setStatus(status);
            fscPushLogPo.setObjData(jsonStr);
            this.fscPushLogMapper.insert(fscPushLogPo);
        }
        catch (Exception e) {
            log.error("\u5b58\u50a8\u6536\u6b3e\u8ba4\u9886\u63a8\u9001\u65e5\u5fd7\u5931\u8d25\uff01" + e);
        }
    }

    private void savePushStatus(FscRecvClaimChangePO fscRecvClaimChangePO) {
        int result = this.fscRecvClaimChangeMapper.updatePushStatus(fscRecvClaimChangePO);
        if (result != FscConstants.SINGLE_UPDATE_RESULT) {
            throw new FscBusinessException("190000", "\u66f4\u65b0\u53d8\u66f4\u5355\u63a8\u9001\u72b6\u6001\u5931\u8d25\uff01");
        }
    }

    private Map<String, String> getDicMap(FscDicDictionaryExernalPO eternalPo) {
        List listByCondition = this.fscDicDictionaryExernalMapper.getListByCondition(eternalPo);
        if (CollectionUtils.isEmpty((Collection)listByCondition)) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u7c7b\u578b\u5b57\u5178\uff01");
        }
        return listByCondition.stream().collect(Collectors.toMap(FscDicDictionaryExernalPO::getCode, FscDicDictionaryExernalPO::getExernalCode));
    }
}

