/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.AttachmentExtensionBO;
import com.tydic.fsc.bo.FscClaimDetailBO;
import com.tydic.fsc.bo.FscClaimDetailChangeBO;
import com.tydic.fsc.bo.FscOrderWriteDetailBO;
import com.tydic.fsc.common.ability.api.FscEncodedSerialGetPublicAbilityService;
import com.tydic.fsc.common.ability.bo.FscCreditDeductAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscEncodedSerialGetPublicAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscEncodedSerialGetPublicAbilityRspBO;
import com.tydic.fsc.common.busi.api.FscClaimChangeConfirmBusiService;
import com.tydic.fsc.common.busi.api.FscCreditDeductBatchBusiService;
import com.tydic.fsc.common.busi.api.FscRecvClaimChangeCreateBusiService;
import com.tydic.fsc.common.busi.bo.FscClaimChangeConfirmBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscClaimChangeConfirmBusiRspBO;
import com.tydic.fsc.common.busi.bo.FscCreditDeductBatchBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscCreditDeductBatchBusiRspBO;
import com.tydic.fsc.common.busi.bo.FscRecvClaimChangeCreateBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscRecvClaimChangeCreateBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountChargeDetailMapper;
import com.tydic.fsc.dao.FscAccountChargeMapper;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscClaimDetailChangeMapper;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscOrderWriteRelationMapper;
import com.tydic.fsc.dao.FscPushClaimDetailMapper;
import com.tydic.fsc.dao.FscRecvClaimChangeMapper;
import com.tydic.fsc.dao.FscRecvClaimMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.dao.FscWriteOffMapper;
import com.tydic.fsc.enums.FscClaimTypeEnum;
import com.tydic.fsc.enums.FscSystemSourceEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountChargeDetailPO;
import com.tydic.fsc.po.FscAccountChargePO;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscClaimDetailChangePO;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscOrderWriteRelationPO;
import com.tydic.fsc.po.FscPushClaimDetailPo;
import com.tydic.fsc.po.FscRecvClaimChangePO;
import com.tydic.fsc.po.FscRecvClaimPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.po.FscWriteOffPO;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQryDetailAbilityService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscRecvClaimChangeCreateBusiServiceImpl
implements FscRecvClaimChangeCreateBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscRecvClaimChangeCreateBusiServiceImpl.class);
    @Autowired
    private FscRecvClaimChangeMapper fscRecvClaimChangeMapper;
    @Autowired
    private FscClaimDetailChangeMapper fscClaimDetailChangeMapper;
    @Autowired
    private FscRecvClaimMapper fscRecvClaimMapper;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscAccountChargeMapper fscAccountChargeMapper;
    @Autowired
    private FscAccountChargeDetailMapper fscAccountChargeDetailMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscEncodedSerialGetPublicAbilityService fscEncodedSerialGetPublicAbilityService;
    @Autowired
    private FscCreditDeductBatchBusiService fscCreditDeductBatchBusiService;
    @Autowired
    private FscPushClaimDetailMapper fscPushClaimDetailMapper;
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService umcEnterpriseOrgQryDetailAbilityService;
    @Autowired
    private FscWriteOffMapper fscWriteOffMapper;
    @Autowired
    private FscOrderWriteRelationMapper fscOrderWriteRelationMapper;
    @Autowired
    private FscClaimChangeConfirmBusiService fscClaimChangeConfirmBusiService;

    @Override
    public FscRecvClaimChangeCreateBusiRspBO dealCreate(FscRecvClaimChangeCreateBusiReqBO reqBO) {
        FscRecvClaimPO fscRecvClaimPO;
        FscRecvClaimChangeCreateBusiRspBO rspBO = new FscRecvClaimChangeCreateBusiRspBO();
        if (reqBO.getChangeId() != null) {
            this.fscClaimDetailChangeMapper.deleteByChangeId(reqBO.getChangeId());
        }
        if ((fscRecvClaimPO = this.fscRecvClaimMapper.queryById(reqBO.getClaimId())) == null) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u6536\u6b3e\u8ba4\u9886\u5355\u4e0d\u5b58\u5728!");
        }
        List<FscClaimDetailChangeBO> detailChangeList = reqBO.getDetailChangeList();
        List<Long> claimDetailIdList = detailChangeList.stream().map(FscClaimDetailChangeBO::getClaimDetailId).distinct().collect(Collectors.toList());
        List claimDetailList = this.fscClaimDetailMapper.selectClaimInfoListByDetailIds(claimDetailIdList);
        Map<Long, FscClaimDetailBO> claimDetailMap = claimDetailList.stream().collect(Collectors.toMap(FscClaimDetailBO::getClaimDetailId, Function.identity()));
        this.validChangeAmt(detailChangeList, claimDetailMap);
        Map<Long, FscShouldPayPO> shouldPayMap = this.queryOrderInfo(claimDetailList);
        Map<Long, FscOrderPO> orderMap = this.queryFscOrderInfo(claimDetailList);
        HashMap<Long, FscAccountChargePO> chargePOMap = new HashMap();
        HashMap<Long, FscAccountChargeDetailPO> chargeDetailPOMap = new HashMap();
        HashMap<Long, FscAccountPO> fscAccountPOMap = new HashMap();
        if (FscClaimTypeEnum.ELECTRONIC_SUPERMARKET_SAVE_CLAIM.getCode().equals(((FscClaimDetailBO)claimDetailList.get(0)).getClaimType())) {
            ArrayList<Long> accountIds = new ArrayList<Long>();
            chargePOMap = this.queryChargeInfo(accountIds, claimDetailIdList);
            chargeDetailPOMap = this.queryChargeDetailInfo(accountIds, claimDetailIdList);
            if (!CollectionUtils.isEmpty(accountIds)) {
                fscAccountPOMap = this.queryAccountInfo(accountIds);
            }
        }
        Date now = new Date();
        FscRecvClaimChangePO fscRecvClaimChangePO = (FscRecvClaimChangePO)JSON.parseObject((String)JSONObject.toJSONString((Object)fscRecvClaimPO), FscRecvClaimChangePO.class);
        this.insertChange(fscRecvClaimChangePO, reqBO, now);
        Long changeId = fscRecvClaimChangePO.getChangeId();
        int confirmStatus = FscConstants.ChangeConfirmStatus.DRAFT;
        if (FscConstants.FscOrderOperType.commit.equals(reqBO.getOperationType())) {
            confirmStatus = FscConstants.ChangeConfirmStatus.CONFIRMING;
        }
        List accountIds = detailChangeList.stream().filter(detail -> detail.getChangeAccountId() != null).map(FscClaimDetailChangeBO::getChangeAccountId).collect(Collectors.toList());
        HashMap<Long, FscAccountPO> accountMap = new HashMap();
        ArrayList<String> advanceDepositNoList = new ArrayList<String>();
        if (!CollectionUtils.isEmpty(accountIds)) {
            FscAccountPO queryPo = new FscAccountPO();
            queryPo.setIds(accountIds);
            List accountList = this.fscAccountMapper.getList(queryPo);
            accountMap = accountList.stream().collect(Collectors.toMap(FscAccountPO::getId, Function.identity()));
            FscEncodedSerialGetPublicAbilityReqBO fscEncodedSerialGetPublicAbilityReqBO = new FscEncodedSerialGetPublicAbilityReqBO();
            fscEncodedSerialGetPublicAbilityReqBO.setCenter("FSC");
            fscEncodedSerialGetPublicAbilityReqBO.setEncodedRuleCode("ADVANCE_DEPOSIT_NO");
            fscEncodedSerialGetPublicAbilityReqBO.setNum(Integer.valueOf(accountIds.size()));
            fscEncodedSerialGetPublicAbilityReqBO.setOrgType("-1");
            FscEncodedSerialGetPublicAbilityRspBO fscEncodedSerialGetPublicAbilityRspBO = this.fscEncodedSerialGetPublicAbilityService.getEncodedSerialPublic(fscEncodedSerialGetPublicAbilityReqBO);
            if (!"0000".equals(fscEncodedSerialGetPublicAbilityRspBO.getRespCode())) {
                throw new FscBusinessException("190000", "\u751f\u6210\u9884\u5b58\u6b3e\u7f16\u53f7\u5f02\u5e38\uff01");
            }
            advanceDepositNoList.addAll(fscEncodedSerialGetPublicAbilityRspBO.getSerialNoList());
        }
        ArrayList<FscClaimDetailChangePO> fscClaimDetailChangePOS = new ArrayList<FscClaimDetailChangePO>();
        ArrayList<FscCreditDeductAbilityReqBO> deductList = new ArrayList<FscCreditDeductAbilityReqBO>();
        ArrayList<Long> changeDetailList = new ArrayList<Long>();
        this.insertChangeDetail(changeId, detailChangeList, fscClaimDetailChangePOS, deductList, claimDetailMap, orderMap, shouldPayMap, chargePOMap, chargeDetailPOMap, accountMap, reqBO, fscRecvClaimChangePO, confirmStatus, now, advanceDepositNoList, changeDetailList);
        if (FscConstants.FscOrderOperType.commit.equals(reqBO.getOperationType())) {
            fscRecvClaimPO.setChangedAmt(reqBO.getChangeAmt());
            int count = this.fscRecvClaimMapper.updateChangeAmtAdd(fscRecvClaimPO);
            if (count != FscConstants.SINGLE_UPDATE_RESULT) {
                throw new FscBusinessException("198888", "\u66f4\u65b0\u8ba4\u9886\u5355\u53d8\u66f4\u91d1\u989d\u5931\u8d25\uff01");
            }
            this.updateChangeAmt(fscClaimDetailChangePOS, claimDetailList, fscAccountPOMap, claimDetailIdList);
            this.updateFscOrderChangeAmt(detailChangeList);
            this.updateOrderChangeAmt(detailChangeList);
            if (!CollectionUtils.isEmpty(deductList)) {
                this.deductCredit(deductList);
            }
        }
        if (!CollectionUtils.isEmpty(reqBO.getAttachmentList())) {
            this.dealFile(reqBO);
        }
        if (!CollectionUtils.isEmpty(changeDetailList) && 1 == reqBO.getOperationType()) {
            try {
                FscClaimChangeConfirmBusiReqBO reqBO1 = new FscClaimChangeConfirmBusiReqBO();
                reqBO1.setChangeDetailIdList(changeDetailList);
                reqBO1.setConfirmReason("\u8d22\u52a1\u9884\u8ba4\u9886\u53d8\u66f4\u76f4\u63a5\u786e\u8ba4");
                FscClaimChangeConfirmBusiRspBO fscClaimChangeConfirmBusiRspBO = this.fscClaimChangeConfirmBusiService.dealClaimChangeConfirm(reqBO1);
                rspBO.setConfirmedList(fscClaimChangeConfirmBusiRspBO.getChangeIdList());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void validChangeAmt(List<FscClaimDetailChangeBO> detailChangeList, Map<Long, FscClaimDetailBO> claimDetailMap) {
        HashMap<Long, BigDecimal> changeAmtMap = new HashMap<Long, BigDecimal>();
        for (FscClaimDetailChangeBO bo : detailChangeList) {
            changeAmtMap.merge(bo.getClaimDetailId(), bo.getChangeAmt(), BigDecimal::add);
        }
        for (Long claimDetailId : changeAmtMap.keySet()) {
            FscClaimDetailBO fscClaimDetailBO = claimDetailMap.get(claimDetailId);
            if (fscClaimDetailBO.getClaimAmt().subtract(fscClaimDetailBO.getChangedAmt()).subtract((BigDecimal)changeAmtMap.get(claimDetailId)).compareTo(BigDecimal.ZERO) >= FscConstants.COMPARE_ZERO) continue;
            if ("14".equals(fscClaimDetailBO.getClaimType())) {
                throw new FscBusinessException("193149", "\u8d22\u52a1\u9884\u8ba4\u9886\u5355\u660e\u7ec6id\uff1a" + fscClaimDetailBO.getClaimDetailId() + "\u53d8\u66f4\u91d1\u989d\u8d85\u51fa\u8ba4\u9886\u91d1\u989d");
            }
            throw new FscBusinessException("193149", "\u8ba4\u9886\u660e\u7ec6\u5355\u53f7\uff1a" + fscClaimDetailBO.getDetailNo() + "\u53d8\u66f4\u91d1\u989d\u8d85\u51fa\u8ba4\u9886\u91d1\u989d");
        }
    }

    private Map<Long, FscShouldPayPO> queryOrderInfo(List<FscClaimDetailBO> claimDetailList) {
        Map<Long, Object> shouldPayMap = new HashMap<Long, FscShouldPayPO>();
        List shouldPayIdList = claimDetailList.stream().filter(detail -> detail.getFscOrderId() == null).map(FscClaimDetailBO::getObjectId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(shouldPayIdList)) {
            FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
            fscShouldPayPO.setShouldPayIds(shouldPayIdList);
            List fscShouldPayPOList = this.fscShouldPayMapper.getList(fscShouldPayPO);
            shouldPayMap = fscShouldPayPOList.stream().collect(Collectors.toMap(FscShouldPayPO::getShouldPayId, Function.identity()));
        }
        return shouldPayMap;
    }

    private Map<Long, FscOrderPO> queryFscOrderInfo(List<FscClaimDetailBO> claimDetailList) {
        Map<Long, Object> orderMap = new HashMap<Long, FscOrderPO>();
        List fscOrderIdList = claimDetailList.stream().filter(detail -> detail.getFscOrderId() != null).map(FscClaimDetailBO::getFscOrderId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(fscOrderIdList)) {
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setFscOrderIds(fscOrderIdList);
            List fscOrderPOList = this.fscOrderMapper.getList(fscOrderPO);
            orderMap = fscOrderPOList.stream().collect(Collectors.toMap(FscOrderPO::getFscOrderId, Function.identity()));
        }
        return orderMap;
    }

    private Map<Long, FscAccountChargePO> queryChargeInfo(List<Long> accountIds, List<Long> claimDetailIdList) {
        Map<Long, Object> chargePOMap = new HashMap<Long, FscAccountChargePO>();
        List chargeList = this.fscAccountChargeMapper.getByClaimDetailId(claimDetailIdList);
        if (!CollectionUtils.isEmpty((Collection)chargeList)) {
            accountIds.addAll(chargeList.stream().map(FscAccountChargePO::getAccountId).distinct().collect(Collectors.toList()));
            chargePOMap = chargeList.stream().collect(Collectors.toMap(FscAccountChargePO::getClaimDetailId, Function.identity()));
        }
        return chargePOMap;
    }

    private Map<Long, FscAccountChargeDetailPO> queryChargeDetailInfo(List<Long> accountIds, List<Long> claimDetailIdList) {
        Map<Long, Object> chargeDetailPOMap = new HashMap<Long, FscAccountChargeDetailPO>();
        List chargeDetailPOS = this.fscAccountChargeDetailMapper.getByClaimDetailId(claimDetailIdList);
        if (!CollectionUtils.isEmpty((Collection)chargeDetailPOS)) {
            accountIds.addAll(chargeDetailPOS.stream().map(FscAccountChargeDetailPO::getAccountId).distinct().collect(Collectors.toList()));
            chargeDetailPOMap = chargeDetailPOS.stream().collect(Collectors.toMap(FscAccountChargeDetailPO::getClaimDetailId, Function.identity()));
        }
        return chargeDetailPOMap;
    }

    private Map<Long, FscAccountPO> queryAccountInfo(List<Long> accountIds) {
        FscAccountPO fscAccountPO = new FscAccountPO();
        fscAccountPO.setIds(accountIds);
        List accountPOList = this.fscAccountMapper.getList(fscAccountPO);
        return accountPOList.stream().collect(Collectors.toMap(FscAccountPO::getId, Function.identity()));
    }

    private void insertChange(FscRecvClaimChangePO fscRecvClaimChangePO, FscRecvClaimChangeCreateBusiReqBO reqBO, Date now) {
        Long changeId;
        fscRecvClaimChangePO.setChangeAmt(reqBO.getChangeAmt());
        fscRecvClaimChangePO.setChangeNo(reqBO.getChangeNo());
        fscRecvClaimChangePO.setChangeDate(reqBO.getChangeDate());
        fscRecvClaimChangePO.setRemark(reqBO.getRemark());
        fscRecvClaimChangePO.setChangeDeptId(reqBO.getChangeDeptId());
        fscRecvClaimChangePO.setChangeDeptName(reqBO.getChangeDeptName());
        fscRecvClaimChangePO.setChangeUserId(reqBO.getChangeUserId());
        fscRecvClaimChangePO.setChangeUserName(reqBO.getChangeUserName());
        fscRecvClaimChangePO.setPushStatus(FscConstants.FscClaimChangePushStatus.NOT_PUSH);
        if (fscRecvClaimChangePO.getBillStatus() == null) {
            if (FscConstants.FscOrderOperType.save.equals(reqBO.getOperationType())) {
                fscRecvClaimChangePO.setBillStatus(FscConstants.ChangeBillStatus.DRAFT);
            } else {
                fscRecvClaimChangePO.setBillStatus(FscConstants.ChangeBillStatus.CONFIRMING);
            }
        }
        if ((changeId = reqBO.getChangeId()) == null) {
            changeId = Sequence.getInstance().nextId();
            reqBO.setChangeId(changeId);
            fscRecvClaimChangePO.setChangeId(changeId);
            fscRecvClaimChangePO.setCreateTime(now);
            fscRecvClaimChangePO.setCreateUserId(reqBO.getUserId());
            this.fscRecvClaimChangeMapper.insert(fscRecvClaimChangePO);
        } else {
            fscRecvClaimChangePO.setChangeId(changeId);
            fscRecvClaimChangePO.setUpdateTime(now);
            fscRecvClaimChangePO.setUpdateUserId(reqBO.getUserId());
            this.fscRecvClaimChangeMapper.update(fscRecvClaimChangePO);
        }
    }

    private void insertChangeDetail(Long changeId, List<FscClaimDetailChangeBO> detailChangeList, List<FscClaimDetailChangePO> fscClaimDetailChangePOS, List<FscCreditDeductAbilityReqBO> deductList, Map<Long, FscClaimDetailBO> claimDetailMap, Map<Long, FscOrderPO> orderMap, Map<Long, FscShouldPayPO> shouldPayMap, Map<Long, FscAccountChargePO> chargePOMap, Map<Long, FscAccountChargeDetailPO> chargeDetailPOMap, Map<Long, FscAccountPO> accountMap, FscRecvClaimChangeCreateBusiReqBO reqBO, FscRecvClaimChangePO fscRecvClaimChangePO, int confirmStatus, Date now, List<String> advanceDepositNoList, List<Long> changeDetailList) {
        int serialNumber = FscConstants.INDEX;
        int advanceIndex = FscConstants.INDEX;
        ArrayList<String> orgCodeList = new ArrayList<String>();
        if (!CollectionUtils.isEmpty(orderMap.keySet())) {
            for (Long key : orderMap.keySet()) {
                if (orgCodeList.contains(orderMap.get(key).getBuynerNo())) continue;
                orgCodeList.add(orderMap.get(key).getBuynerNo());
            }
        }
        if (!CollectionUtils.isEmpty(shouldPayMap.keySet())) {
            for (Long key : shouldPayMap.keySet()) {
                if (orgCodeList.contains(shouldPayMap.get(key).getBuyerNo())) continue;
                orgCodeList.add(shouldPayMap.get(key).getBuyerNo());
            }
        }
        HashMap<String, Long> orgMap = new HashMap<String, Long>();
        if (!CollectionUtils.isEmpty(orgCodeList)) {
            FscAccountPO fscAccountPO = new FscAccountPO();
            fscAccountPO.setOrgCodes(orgCodeList);
            List list = this.fscAccountMapper.getList(fscAccountPO);
            for (FscClaimDetailChangePO po : list) {
                orgMap.put(po.getOrgCode(), po.getOrgId());
            }
        }
        for (FscClaimDetailChangeBO bo : detailChangeList) {
            FscClaimDetailChangePO po;
            FscClaimDetailBO detailBO = claimDetailMap.get(bo.getClaimDetailId());
            po = new FscClaimDetailChangePO();
            po.setChangeDetailId(Long.valueOf(Sequence.getInstance().nextId()));
            po.setChangeId(changeId);
            po.setClaimDetailId(bo.getClaimDetailId());
            po.setHandleUserId(detailBO.getHandleUserId());
            po.setHandleUserName(detailBO.getHandleUserName());
            po.setHandleDeptId(detailBO.getHandleDeptId());
            po.setHandleDeptName(detailBO.getHandleDeptName());
            po.setClaimId(reqBO.getClaimId());
            po.setRemainingChangeAmt(bo.getRemainingChangeAmt());
            String changeDetailNo = fscRecvClaimChangePO.getChangeNo() + "-" + String.format("%02d", ++serialNumber);
            po.setChangeDetailNo(changeDetailNo);
            if (FscSystemSourceEnum.YG.getCode().equals(bo.getSysSource())) {
                ArrayList<String> orderNo;
                Long orgId;
                FscCreditDeductAbilityReqBO deductReqBO;
                if (detailBO.getFscOrderId() != null) {
                    po.setBusiType(FscConstants.ChangeBusiType.SETTLE);
                    po.setFscOrderId(detailBO.getFscOrderId());
                    po.setFscOrderNo(detailBO.getFscOrderNo());
                    po.setAcceptId(detailBO.getObjectId());
                    po.setAcceptCode(detailBO.getObjectNo());
                    FscOrderPO fscOrderPO = orderMap.get(detailBO.getFscOrderId());
                    if (fscOrderPO == null) {
                        throw new FscBusinessException("193149", "\u67e5\u8be2\u7ed3\u7b97\u5355" + detailBO.getFscOrderNo() + "\u4e0d\u5b58\u5728");
                    }
                    if (FscConstants.FscPayType.FSC_PAY_TYPE_PERIOD.equals(fscOrderPO.getPayType())) {
                        deductReqBO = new FscCreditDeductAbilityReqBO();
                        deductReqBO.setSupId(fscOrderPO.getPayeeId());
                        if ("1".equals(fscOrderPO.getOrderSource().toString())) {
                            deductReqBO.setPayBusiness("2");
                        } else if ("2".equals(fscOrderPO.getOrderSource().toString())) {
                            deductReqBO.setPayBusiness("1");
                        }
                        if (StringUtils.isEmpty((CharSequence)fscOrderPO.getBuynerNo())) {
                            throw new FscBusinessException("193149", "\u67e5\u8be2\u7ed3\u7b97\u5355" + fscOrderPO.getOrderNo() + "\u4e70\u53d7\u4eba\u4e3a\u7a7a");
                        }
                        deductReqBO.setCreditOrgCode(fscOrderPO.getBuynerNo());
                        orgId = (Long)orgMap.get(fscOrderPO.getBuynerNo());
                        if (orgId == null) {
                            throw new FscBusinessException("193149", "\u67e5\u8be2\u8ba2\u5355" + fscOrderPO.getOrderNo() + "\u4e70\u53d7\u4eba\u673a\u6784\u4e3a\u7a7a");
                        }
                        po.setOrgId(orgId);
                        deductReqBO.setCreditOrgId(orgId);
                        deductReqBO.setNoLog(Boolean.FALSE);
                        orderNo = new ArrayList<String>();
                        orderNo.add(po.getFscOrderNo());
                        deductReqBO.setOrderNo(orderNo);
                        deductReqBO.setAmount(bo.getChangeAmt());
                        deductList.add(deductReqBO);
                    }
                    po.setBuynerNo(fscOrderPO.getBuynerNo());
                    po.setBuynerName(fscOrderPO.getBuynerName());
                } else if (detailBO.getOrderId() != null) {
                    po.setBusiType(FscConstants.ChangeBusiType.ORDER);
                    po.setOrderId(detailBO.getOrderId());
                    po.setOrderCode(detailBO.getOrderCode());
                    po.setShouldPayId(detailBO.getObjectId());
                    po.setPayOrderId(detailBO.getPayOrderId());
                    po.setPayOrderNo(detailBO.getPayOrderNo());
                    FscShouldPayPO fscShouldPayPO = shouldPayMap.get(detailBO.getObjectId());
                    if (fscShouldPayPO == null) {
                        throw new FscBusinessException("193149", "\u67e5\u8be2\u8ba2\u5355" + detailBO.getOrderCode() + "\u9884\u6536\u8ba4\u9886\u4e0d\u5b58\u5728");
                    }
                    po.setBuynerNo(fscShouldPayPO.getBuyerNo());
                    po.setBuynerName(fscShouldPayPO.getBuyerName());
                    if (FscConstants.FscPayType.FSC_PAY_TYPE_PERIOD.equals(fscShouldPayPO.getPayType())) {
                        deductReqBO = new FscCreditDeductAbilityReqBO();
                        deductReqBO.setSupId(fscShouldPayPO.getPayeeId());
                        deductReqBO.setPayBusiness("2");
                        if (StringUtils.isEmpty((CharSequence)fscShouldPayPO.getBuyerNo())) {
                            throw new FscBusinessException("193149", "\u67e5\u8be2\u8ba2\u5355" + detailBO.getOrderCode() + "\u4e70\u53d7\u4eba\u4e3a\u7a7a");
                        }
                        deductReqBO.setCreditOrgCode(fscShouldPayPO.getBuyerNo());
                        orgId = (Long)orgMap.get(fscShouldPayPO.getBuyerNo());
                        if (orgId == null) {
                            throw new FscBusinessException("193149", "\u67e5\u8be2\u8ba2\u5355" + detailBO.getOrderCode() + "\u4e70\u53d7\u4eba\u673a\u6784\u4e3a\u7a7a");
                        }
                        po.setOrgId(orgId);
                        orderNo = new ArrayList();
                        orderNo.add(po.getOrderCode());
                        deductReqBO.setOrderNo(orderNo);
                        deductReqBO.setNoLog(Boolean.FALSE);
                        deductReqBO.setAmount(bo.getChangeAmt());
                        deductList.add(deductReqBO);
                    }
                } else if (FscClaimTypeEnum.ELECTRONIC_SUPERMARKET_SAVE_CLAIM.getCode().equals(detailBO.getClaimType())) {
                    po.setBusiType(FscConstants.ChangeBusiType.ADVANCE);
                    FscAccountChargePO fscAccountChargePO = chargePOMap.get(bo.getClaimDetailId());
                    if (fscAccountChargePO == null) {
                        FscAccountChargeDetailPO fscAccountChargeDetailPO = chargeDetailPOMap.get(bo.getClaimDetailId());
                        po.setChargeId(fscAccountChargeDetailPO.getChargeId());
                        po.setChargeNo(fscAccountChargeDetailPO.getAdvanceDepositNo());
                        po.setChargeDeptId(fscAccountChargeDetailPO.getChargeDeptId());
                        po.setChargeDeptName(fscAccountChargeDetailPO.getChargeDeptName());
                        po.setAccountId(fscAccountChargeDetailPO.getAccountId());
                        po.setAccountNo(fscAccountChargeDetailPO.getAccountNo());
                    } else {
                        po.setChargeId(fscAccountChargePO.getChargeId());
                        po.setChargeNo(fscAccountChargePO.getAdvanceDepositNo());
                        po.setChargeDeptId(fscAccountChargePO.getChargeDeptId());
                        po.setChargeDeptName(fscAccountChargePO.getChargeDeptName());
                        po.setAccountId(fscAccountChargePO.getAccountId());
                        po.setAccountNo(fscAccountChargePO.getAccountNo());
                    }
                } else if (FscClaimTypeEnum.PER_FEE_CLAIM.getCode().equals(detailBO.getClaimType())) {
                    po.setBusiType(FscConstants.ChangeBusiType.TREASURER);
                    changeDetailList.add(po.getChangeDetailId());
                }
            } else if (FscSystemSourceEnum.YC.getCode().equals(bo.getSysSource())) {
                if ("200".equals(FscClaimTypeEnum.getGroup((String)detailBO.getClaimType()))) {
                    po.setBusiType(FscConstants.ChangeBusiType.ORDER);
                    po.setOrderId(detailBO.getOrderId());
                    po.setOrderCode(detailBO.getOrderCode());
                } else if ("100".equals(FscClaimTypeEnum.getGroup((String)detailBO.getClaimType()))) {
                    po.setBusiType(FscConstants.ChangeBusiType.SETTLE);
                    po.setFscOrderId(detailBO.getFscOrderId());
                    po.setFscOrderNo(detailBO.getFscOrderNo());
                } else if ("300".equals(FscClaimTypeEnum.getGroup((String)detailBO.getClaimType()))) {
                    po.setBusiType(FscConstants.ChangeBusiType.ADVANCE);
                } else if ("400".equals(FscClaimTypeEnum.getGroup((String)detailBO.getClaimType()))) {
                    po.setBusiType(FscConstants.ChangeBusiType.TREASURER);
                    changeDetailList.add(po.getChangeDetailId());
                }
            }
            if (FscSystemSourceEnum.YG.getCode().equals(bo.getChangeSource())) {
                if (bo.getChangeFscOrderId() != null) {
                    po.setChangeBusiType(FscConstants.ChangeBusiType.SETTLE);
                    po.setChangeAcceptId(bo.getChangeAcceptId());
                } else if (bo.getChangeOrderId() != null) {
                    po.setChangeBusiType(FscConstants.ChangeBusiType.ORDER);
                    po.setChangePayOrderId(bo.getChangePayOrderId());
                    po.setChangeShouldPayId(bo.getChangeShouldPayId());
                } else if (bo.getChangeAccountId() != null) {
                    po.setChangeBusiType(FscConstants.ChangeBusiType.ADVANCE);
                    FscAccountPO account = accountMap.get(bo.getChangeAccountId());
                    po.setChangeAccountId(account.getId());
                    po.setChangeAccountNo(account.getAccountNo());
                    po.setChangeChargeId(Long.valueOf(Sequence.getInstance().nextId()));
                    po.setChangeChargeNo(advanceDepositNoList.get(advanceIndex++));
                }
            } else {
                po.setChangeBusiType(FscConstants.ChangeBusiType.SETTLE);
            }
            po.setClaimAmt(detailBO.getClaimAmt());
            po.setChangeAmt(bo.getChangeAmt());
            po.setChangeOrderId(bo.getChangeOrderId());
            po.setChangeOrderCode(bo.getChangeOrderCode());
            po.setChangeFscOrderId(bo.getChangeFscOrderId());
            po.setChangeFscOrderNo(bo.getChangeFscOrderNo());
            po.setSysSource(bo.getSysSource());
            po.setChangeSource(bo.getChangeSource());
            po.setOperationNo(bo.getOperationNo());
            po.setOperationName(bo.getOperationName());
            po.setConfirmStatus(Integer.valueOf(confirmStatus));
            po.setCreateTime(now);
            po.setCreateUserId(reqBO.getUserId());
            po.setClaimType(Integer.valueOf(Integer.parseInt(detailBO.getClaimType())));
            po.setChangeClaimType(bo.getChangeClaimType());
            po.setClaimCustomer(bo.getClaimCustomer());
            po.setClaimDate(detailBO.getClaimDate());
            po.setClaimNo(bo.getClaimNos());
            fscClaimDetailChangePOS.add(po);
        }
        this.fscClaimDetailChangeMapper.insertBatch(fscClaimDetailChangePOS);
    }

    private void deductCredit(List<FscCreditDeductAbilityReqBO> deductList) {
        HashMap<String, FscCreditDeductAbilityReqBO> deductMap = new HashMap<String, FscCreditDeductAbilityReqBO>();
        for (FscCreditDeductAbilityReqBO reqBO : deductList) {
            FscCreditDeductAbilityReqBO map = (FscCreditDeductAbilityReqBO)deductMap.get(reqBO.getCreditOrgId().toString() + reqBO.getPayBusiness());
            if (map == null) {
                map = reqBO;
            } else {
                map.setAmount(map.getAmount().add(reqBO.getAmount()));
            }
            deductMap.put(reqBO.getCreditOrgId().toString() + reqBO.getPayBusiness(), map);
        }
        FscCreditDeductBatchBusiReqBO fscCreditDeductBatchBusiReqBO = new FscCreditDeductBatchBusiReqBO();
        fscCreditDeductBatchBusiReqBO.setDeductList(new ArrayList<FscCreditDeductAbilityReqBO>(deductMap.values()));
        FscCreditDeductBatchBusiRspBO fscCreditDeductBatchBusiRspBO = this.fscCreditDeductBatchBusiService.dealAccountDeductBatch(fscCreditDeductBatchBusiReqBO);
        if (!"0000".equals(fscCreditDeductBatchBusiRspBO.getRespCode())) {
            throw new FscBusinessException(fscCreditDeductBatchBusiRspBO.getRespCode(), fscCreditDeductBatchBusiRspBO.getRespDesc());
        }
    }

    private void updateChangeAmt(List<FscClaimDetailChangePO> fscClaimDetailChangePOS, List<FscClaimDetailBO> claimDetailList, Map<Long, FscAccountPO> fscAccountPOMap, List<Long> claimDetailIdList) {
        int count;
        HashMap<Long, FscClaimDetailPO> detailMap = new HashMap<Long, FscClaimDetailPO>();
        if (FscClaimTypeEnum.ELECTRONIC_SUPERMARKET_SAVE_CLAIM.getCode().equals(claimDetailList.get(0).getClaimType())) {
            HashMap accountFreezeMap = new HashMap();
            for (FscClaimDetailChangePO po : fscClaimDetailChangePOS) {
                FscClaimDetailPO fscClaimDetailPO = (FscClaimDetailPO)detailMap.get(po.getClaimDetailId());
                if (fscClaimDetailPO == null) {
                    fscClaimDetailPO = new FscClaimDetailPO();
                    fscClaimDetailPO.setClaimDetailId(po.getClaimDetailId());
                    fscClaimDetailPO.setChangedAmt(po.getChangeAmt());
                } else {
                    fscClaimDetailPO.setChangedAmt(fscClaimDetailPO.getChangedAmt().add(po.getChangeAmt()));
                }
                detailMap.put(po.getClaimDetailId(), fscClaimDetailPO);
                if (!FscSystemSourceEnum.YG.getCode().equals(po.getSysSource())) continue;
                BigDecimal freezeAmt = (BigDecimal)accountFreezeMap.get(po.getAccountId());
                freezeAmt = freezeAmt == null ? po.getChangeAmt() : freezeAmt.add(po.getChangeAmt());
                accountFreezeMap.put(po.getAccountId(), freezeAmt);
            }
            if (!CollectionUtils.isEmpty(fscAccountPOMap.keySet())) {
                for (Long accountId : fscAccountPOMap.keySet()) {
                    BigDecimal freezeAmount;
                    FscAccountPO fscAccountPO = fscAccountPOMap.get(accountId);
                    BigDecimal advanceAmount = fscAccountPO.getAdvanceAmount().subtract(fscAccountPO.getFreezeAmount()).subtract(fscAccountPO.getUseAmount()).subtract(fscAccountPO.getDistributeAdvanceAmount());
                    if (advanceAmount.compareTo(freezeAmount = (BigDecimal)accountFreezeMap.get(accountId)) < 0) {
                        throw new FscBusinessException("194304", fscAccountPO.getOrgName() + "\u9884\u5b58\u6b3e\u989d\u5ea6\u4e0d\u8db3\uff0c\u8054\u7cfb\u8fd0\u8425\u4eba\u5458\u5904\u7406\uff01");
                    }
                    fscAccountPO.setOrderAmount(freezeAmount);
                    fscAccountPOMap.put(accountId, fscAccountPO);
                }
                int count2 = this.fscAccountMapper.updateFreezeAmtAddBatch(new ArrayList<FscAccountPO>(fscAccountPOMap.values()));
                if (count2 != fscAccountPOMap.values().size()) {
                    throw new FscBusinessException("198888", "\u66f4\u65b0\u8d26\u6237\u9884\u5b58\u6b3e\u51bb\u7ed3\u91d1\u989d\u5931\u8d25\uff01");
                }
            }
        } else {
            for (FscClaimDetailChangePO po : fscClaimDetailChangePOS) {
                FscClaimDetailPO fscClaimDetailPO = (FscClaimDetailPO)detailMap.get(po.getClaimDetailId());
                if (fscClaimDetailPO == null) {
                    fscClaimDetailPO = new FscClaimDetailPO();
                    fscClaimDetailPO.setClaimDetailId(po.getClaimDetailId());
                    fscClaimDetailPO.setChangedAmt(po.getChangeAmt());
                } else {
                    fscClaimDetailPO.setChangedAmt(fscClaimDetailPO.getChangedAmt().add(po.getChangeAmt()));
                }
                detailMap.put(po.getClaimDetailId(), fscClaimDetailPO);
            }
        }
        if ((count = this.fscClaimDetailMapper.updateChangeAmtAddBatch(new ArrayList(detailMap.values()))) != detailMap.values().size()) {
            throw new FscBusinessException("198888", "\u66f4\u65b0\u8ba4\u9886\u660e\u7ec6\u53d8\u66f4\u91d1\u989d\u5931\u8d25\uff01");
        }
    }

    private void updateFscOrderChangeAmt(List<FscClaimDetailChangeBO> detailChangeList) {
        List fscOrderChangeList = detailChangeList.stream().filter(detail -> detail.getChangeFscOrderId() != null && FscSystemSourceEnum.YG.getCode().equals(detail.getChangeSource())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(fscOrderChangeList)) {
            HashMap<String, FscOrderRelationPO> relationMap = new HashMap<String, FscOrderRelationPO>();
            for (FscClaimDetailChangeBO bo : fscOrderChangeList) {
                FscOrderRelationPO fscOrderRelationPO = (FscOrderRelationPO)relationMap.get(bo.getChangeFscOrderId() + bo.getChangeAcceptId() + "");
                if (fscOrderRelationPO == null) {
                    fscOrderRelationPO = new FscOrderRelationPO();
                    fscOrderRelationPO.setFscOrderId(bo.getChangeFscOrderId());
                    fscOrderRelationPO.setAcceptOrderId(bo.getChangeAcceptId());
                    fscOrderRelationPO.setOperationClaimAmt(bo.getChangeAmt());
                } else {
                    fscOrderRelationPO.setOperationClaimAmt(fscOrderRelationPO.getOperationClaimAmt().add(bo.getChangeAmt()));
                }
                relationMap.put(bo.getChangeFscOrderId() + bo.getChangeAcceptId() + "", fscOrderRelationPO);
            }
            int count = this.fscOrderRelationMapper.updateOperationClaimAmtAddBatchCancel(new ArrayList(relationMap.values()));
            if (count != relationMap.values().size()) {
                throw new FscBusinessException("198888", "\u66f4\u65b0\u6613\u8d2d\u7ed3\u7b97\u5355\u8ba4\u9886\u91d1\u989d\u5931\u8d25\uff01");
            }
        }
        if (!CollectionUtils.isEmpty(fscOrderChangeList = detailChangeList.stream().filter(detail -> detail.getChangeFscOrderId() != null && FscSystemSourceEnum.YC.getCode().equals(detail.getChangeSource())).collect(Collectors.toList()))) {
            HashMap<Long, FscPushClaimDetailPo> ycOrderMap = new HashMap<Long, FscPushClaimDetailPo>();
            for (FscClaimDetailChangeBO bo : fscOrderChangeList) {
                FscPushClaimDetailPo fscPushClaimDetailPo = (FscPushClaimDetailPo)ycOrderMap.get(bo.getChangeFscOrderId());
                if (fscPushClaimDetailPo == null) {
                    fscPushClaimDetailPo = new FscPushClaimDetailPo();
                    fscPushClaimDetailPo.setFscOrderId(bo.getChangeFscOrderId());
                    fscPushClaimDetailPo.setClaimAmt(bo.getChangeAmt());
                } else {
                    fscPushClaimDetailPo.setClaimAmt(fscPushClaimDetailPo.getClaimAmt().add(bo.getChangeAmt()));
                }
                ycOrderMap.put(bo.getChangeFscOrderId(), fscPushClaimDetailPo);
            }
            int count = this.fscPushClaimDetailMapper.updateClaimAmtAddBatch(new ArrayList(ycOrderMap.values()));
            if (count != ycOrderMap.values().size()) {
                throw new FscBusinessException("198888", "\u66f4\u65b0\u4e1a\u8d22\u7ed3\u7b97\u5355\u8ba4\u9886\u91d1\u989d\u5931\u8d25\uff01");
            }
        }
    }

    private void updateOrderChangeAmt(List<FscClaimDetailChangeBO> detailChangeList) {
        List orderChangeList = detailChangeList.stream().filter(detail -> detail.getChangeOrderId() != null && detail.getChangeBusiType() == 2).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(orderChangeList)) {
            int count;
            HashMap<Long, FscShouldPayPO> fscShouldPayMap = new HashMap<Long, FscShouldPayPO>();
            HashMap<Long, FscOrderPO> fscOrderMap = new HashMap<Long, FscOrderPO>();
            for (FscClaimDetailChangeBO bo : orderChangeList) {
                FscShouldPayPO fscShouldPayPO = (FscShouldPayPO)fscShouldPayMap.get(bo.getChangeShouldPayId());
                if (fscShouldPayPO == null) {
                    fscShouldPayPO = new FscShouldPayPO();
                    fscShouldPayPO.setShouldPayId(bo.getChangeShouldPayId());
                    fscShouldPayPO.setClaimAmt(bo.getChangeAmt());
                } else {
                    fscShouldPayPO.setClaimAmt(fscShouldPayPO.getClaimAmt().add(bo.getChangeAmt()));
                }
                fscShouldPayMap.put(bo.getChangeShouldPayId(), fscShouldPayPO);
                if (bo.getChangePayOrderId() == null) continue;
                FscOrderPO fscOrderPO = (FscOrderPO)fscOrderMap.get(bo.getChangePayOrderId());
                if (fscOrderPO == null) {
                    fscOrderPO = new FscOrderPO();
                    fscOrderPO.setFscOrderId(bo.getChangePayOrderId());
                    fscOrderPO.setShouldPayId(bo.getChangeShouldPayId());
                    fscOrderPO.setClaimAmount(bo.getChangeAmt());
                } else {
                    fscOrderPO.setClaimAmount(fscOrderPO.getClaimAmount().add(bo.getChangeAmt()));
                }
                fscOrderMap.put(bo.getChangePayOrderId(), fscOrderPO);
            }
            if (!CollectionUtils.isEmpty(fscShouldPayMap.values()) && (count = this.fscShouldPayMapper.updateClaimAmountAdd(new ArrayList(fscShouldPayMap.values()))) != fscShouldPayMap.values().size()) {
                throw new FscBusinessException("198888", "\u66f4\u65b0\u5e94\u4ed8\u5355\u8ba4\u9886\u91d1\u989d\u5931\u8d25\uff01");
            }
            if (!CollectionUtils.isEmpty(fscOrderMap.values()) && (count = this.fscOrderPayItemMapper.updateOperationClaimAmountAdd(new ArrayList(fscOrderMap.values()))) != fscOrderMap.values().size()) {
                throw new FscBusinessException("198888", "\u66f4\u65b0\u4ed8\u6b3e\u5355\u8ba4\u9886\u91d1\u989d\u5931\u8d25\uff01");
            }
        }
    }

    private void dealFile(FscRecvClaimChangeCreateBusiReqBO reqBO) {
        int count;
        LinkedList<AttachmentExtensionBO> extensionAddList = new LinkedList<AttachmentExtensionBO>();
        LinkedList<Long> attachmentIdList = new LinkedList<Long>();
        for (AttachmentExtensionBO attachmentExtensionBO : reqBO.getAttachmentList()) {
            if (FscConstants.AttachmentOperationType.ADD.equals(attachmentExtensionBO.getOperationType())) {
                attachmentExtensionBO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                attachmentExtensionBO.setObjId(reqBO.getChangeId());
                attachmentExtensionBO.setAttachmentType(FscConstants.AttachmentType.CLAIM_CHANGE);
                attachmentExtensionBO.setCreateTime(new Date());
                attachmentExtensionBO.setCreateUser(reqBO.getName());
                attachmentExtensionBO.setCreateUserId(reqBO.getUserId());
                extensionAddList.add(attachmentExtensionBO);
                continue;
            }
            if (!FscConstants.AttachmentOperationType.DEL.equals(attachmentExtensionBO.getOperationType())) continue;
            attachmentIdList.add(attachmentExtensionBO.getAttachmentId());
        }
        if (!CollectionUtils.isEmpty(extensionAddList) && (count = this.fscAttachmentMapper.insertExtensionByBatch(extensionAddList)) < FscConstants.SINGLE_UPDATE_RESULT) {
            throw new FscBusinessException("190000", "\u6dfb\u52a0\u9644\u4ef6\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (!CollectionUtils.isEmpty(attachmentIdList)) {
            this.fscAttachmentMapper.deleteByAttachmentIds(attachmentIdList);
        }
    }

    @Override
    public FscRecvClaimChangeCreateBusiRspBO dealCreateAdvanceWrite(FscRecvClaimChangeCreateBusiReqBO reqBO) {
        BigDecimal changeAmt;
        ArrayList<FscClaimDetailChangePO> fscClaimDetailChangePOS;
        HashMap<Long, BigDecimal> fscOrderWriteOffAmountMap;
        FscRecvClaimChangeCreateBusiRspBO rspBO = new FscRecvClaimChangeCreateBusiRspBO();
        FscRecvClaimPO fscRecvClaimPO = this.fscRecvClaimMapper.queryById(reqBO.getClaimId());
        if (fscRecvClaimPO == null) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u6536\u6b3e\u8ba4\u9886\u5355\u4e0d\u5b58\u5728!");
        }
        Date now = new Date();
        FscRecvClaimChangePO fscRecvClaimChangePO = (FscRecvClaimChangePO)JSON.parseObject((String)JSONObject.toJSONString((Object)fscRecvClaimPO), FscRecvClaimChangePO.class);
        fscRecvClaimChangePO.setBillStatus(FscConstants.ChangeBillStatus.CONFIRMED);
        this.insertChange(fscRecvClaimChangePO, reqBO, now);
        List<Object> detailChangeList = reqBO.getDetailChangeList();
        detailChangeList = detailChangeList.stream().filter(e -> !CollectionUtils.isEmpty((Collection)e.getWriteDetailList())).collect(Collectors.toList());
        HashSet<Long> claimDetailIdList = new HashSet<Long>();
        for (FscClaimDetailChangeBO fscClaimDetailChangeBO : detailChangeList) {
            for (Object fscOrderWriteDetailBO : fscClaimDetailChangeBO.getWriteDetailList()) {
                claimDetailIdList.add(fscOrderWriteDetailBO.getClaimDetailId());
            }
        }
        FscClaimDetailPO fscClaimDetail = new FscClaimDetailPO();
        fscClaimDetail.setClaimId(reqBO.getClaimId());
        fscClaimDetail.setClaimDetailIds(claimDetailIdList);
        List list = this.fscClaimDetailMapper.getWriteOffAdvanceById(fscClaimDetail);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            HashMap<Long, FscClaimDetailPO> claimDetailMap = new HashMap<Long, FscClaimDetailPO>();
            for (FscClaimDetailPO fscClaimDetailPO : list) {
                claimDetailMap.put(fscClaimDetailPO.getClaimDetailId(), fscClaimDetailPO);
            }
            ArrayList<FscWriteOffPO> orderWriteList = new ArrayList<FscWriteOffPO>();
            ArrayList<FscOrderWriteRelationPO> writeRelationList = new ArrayList<FscOrderWriteRelationPO>();
            fscOrderWriteOffAmountMap = new HashMap<Long, BigDecimal>();
            Date writeOffDate = new Date();
            fscClaimDetailChangePOS = new ArrayList<FscClaimDetailChangePO>();
            int serialNumber = 0;
            changeAmt = BigDecimal.ZERO;
            HashSet<Long> claimDetailIdSet = new HashSet<Long>();
            HashMap<Long, FscClaimDetailPO> claimWriteAmountMap = new HashMap<Long, FscClaimDetailPO>();
            for (FscClaimDetailChangeBO fscClaimDetailChangeBO : detailChangeList) {
                if (CollectionUtils.isEmpty((Collection)fscClaimDetailChangeBO.getWriteDetailList())) continue;
                for (FscOrderWriteDetailBO fscOrderWriteDetailBO : fscClaimDetailChangeBO.getWriteDetailList()) {
                    BigDecimal noWriteOffAmount;
                    FscClaimDetailPO claimDetailPO;
                    BigDecimal fscOrderWriteOffAmount = (BigDecimal)fscOrderWriteOffAmountMap.get(fscClaimDetailChangeBO.getChangeFscOrderId());
                    if (fscOrderWriteOffAmount == null) {
                        fscOrderWriteOffAmount = BigDecimal.ZERO;
                    }
                    if (null == (claimDetailPO = (FscClaimDetailPO)claimDetailMap.get(fscOrderWriteDetailBO.getClaimDetailId())).getWriteOffAmount()) {
                        claimDetailPO.setWriteOffAmount(new BigDecimal(0));
                    }
                    if ((noWriteOffAmount = claimDetailPO.getClaimAmt().subtract(claimDetailPO.getWriteOffAmount())).compareTo(BigDecimal.ZERO) <= 0) continue;
                    FscWriteOffPO fscWriteOffPO = new FscWriteOffPO();
                    fscWriteOffPO.setWriteOffId(Long.valueOf(Sequence.getInstance().nextId()));
                    fscWriteOffPO.setFscOrderId(fscClaimDetailChangeBO.getChangeFscOrderId());
                    fscWriteOffPO.setFscOrderNo(fscClaimDetailChangeBO.getChangeFscOrderNo());
                    fscWriteOffPO.setClaimId(claimDetailPO.getClaimId());
                    fscWriteOffPO.setHandleUserId(claimDetailPO.getHandleUserId());
                    fscWriteOffPO.setHandleUserName(claimDetailPO.getHandleUserName());
                    fscWriteOffPO.setHandleDeptId(claimDetailPO.getHandleDeptId());
                    fscWriteOffPO.setHandleDeptName(claimDetailPO.getHandleDeptName());
                    fscWriteOffPO.setClaimType(claimDetailPO.getClaimType());
                    fscWriteOffPO.setOrderId(fscClaimDetailChangeBO.getOrderId());
                    fscWriteOffPO.setOrderCode(fscClaimDetailChangeBO.getOrderCode());
                    fscWriteOffPO.setBuynerNo(fscClaimDetailChangeBO.getBuynerNo().toString());
                    fscWriteOffPO.setBuynerName(fscClaimDetailChangeBO.getBuynerName());
                    fscWriteOffPO.setTotalCharge(fscClaimDetailChangeBO.getTotalCharge());
                    fscWriteOffPO.setOrderAmount(fscClaimDetailChangeBO.getOrderAmount());
                    fscWriteOffPO.setPayerId(fscClaimDetailChangeBO.getPayerId());
                    fscWriteOffPO.setPayerName(fscClaimDetailChangeBO.getPayerName());
                    fscWriteOffPO.setWriteOffDate(writeOffDate);
                    fscWriteOffPO.setStatus(Integer.valueOf(1));
                    fscWriteOffPO.setWriteOffAmount(claimDetailPO.getClaimAmt().subtract(fscOrderWriteDetailBO.getRemainingWriteAmt()));
                    BigDecimal thisAmount = fscOrderWriteDetailBO.getThisAmount();
                    fscClaimDetailChangeBO.setChangeAmt(thisAmount);
                    fscWriteOffPO.setThisAmount(thisAmount);
                    fscWriteOffPO.setWriteOffAmount(fscWriteOffPO.getWriteOffAmount());
                    orderWriteList.add(fscWriteOffPO);
                    if (claimDetailPO.getClaimAmt().compareTo(claimDetailPO.getWriteOffAmount().add(thisAmount)) < 0) {
                        throw new FscBusinessException("191026", "\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u8ba4\u9886\u91d1\u989d\uff01");
                    }
                    fscOrderWriteOffAmount = fscOrderWriteOffAmount.add(thisAmount);
                    fscOrderWriteOffAmountMap.put(fscClaimDetailChangeBO.getChangeFscOrderId(), fscOrderWriteOffAmount);
                    FscOrderWriteRelationPO fscOrderWriteRelationPO = new FscOrderWriteRelationPO();
                    fscOrderWriteRelationPO.setFscOrderId(fscClaimDetailChangeBO.getChangeFscOrderId());
                    fscOrderWriteRelationPO.setClaimDetailId(claimDetailPO.getClaimDetailId());
                    fscOrderWriteRelationPO.setClaimId(claimDetailPO.getClaimId());
                    fscOrderWriteRelationPO.setClaimAmt(claimDetailPO.getClaimAmt());
                    fscOrderWriteRelationPO.setWriteOffAmount(thisAmount);
                    fscOrderWriteRelationPO.setWriteOffDate(writeOffDate);
                    fscOrderWriteRelationPO.setClaimNo(claimDetailPO.getClaimNo());
                    fscOrderWriteRelationPO.setOrderId(fscClaimDetailChangeBO.getOrderId());
                    fscOrderWriteRelationPO.setOrderCode(fscClaimDetailChangeBO.getOrderCode());
                    fscOrderWriteRelationPO.setBuynerNo(fscClaimDetailChangeBO.getBuynerNo().toString());
                    fscOrderWriteRelationPO.setBuynerName(fscClaimDetailChangeBO.getBuynerName());
                    fscOrderWriteRelationPO.setRemainAmount(fscOrderWriteDetailBO.getRemainingWriteAmt());
                    writeRelationList.add(fscOrderWriteRelationPO);
                    FscClaimDetailChangePO fscClaimDetailChangePO = (FscClaimDetailChangePO)JSON.parseObject((String)JSONObject.toJSONString((Object)fscClaimDetailChangeBO), FscClaimDetailChangePO.class);
                    fscClaimDetailChangePO.setClaimDetailId(claimDetailPO.getClaimDetailId());
                    fscClaimDetailChangePO.setClaimId(claimDetailPO.getClaimId());
                    fscClaimDetailChangePO.setChangeId(fscRecvClaimChangePO.getChangeId());
                    fscClaimDetailChangePO.setClaimAmt(claimDetailPO.getClaimAmt());
                    fscClaimDetailChangePO.setChangeAmt(thisAmount);
                    fscClaimDetailChangePO.setChangeDetailId(Long.valueOf(Sequence.getInstance().nextId()));
                    String changeDetailNo = fscRecvClaimChangePO.getChangeNo() + "-" + String.format("%02d", ++serialNumber);
                    fscClaimDetailChangePO.setChangeDetailNo(changeDetailNo);
                    fscClaimDetailChangePO.setConfirmStatus(FscConstants.ChangeConfirmStatus.CONFIRMED);
                    fscClaimDetailChangePO.setClaimType(Integer.valueOf(Integer.parseInt(FscClaimTypeEnum.ELECTRONIC_SUPERMARKET_SAVE_CLAIM.getCode())));
                    fscClaimDetailChangePO.setChangeClaimType(Integer.valueOf(Integer.parseInt(FscClaimTypeEnum.ELECTRONIC_SUPERMARKET_SETTLE_CLAIM.getCode())));
                    fscClaimDetailChangePO.setCreateTime(writeOffDate);
                    fscClaimDetailChangePO.setCreateUserId(reqBO.getUserId());
                    fscClaimDetailChangePO.setConfirmDate(writeOffDate);
                    fscClaimDetailChangePO.setFscOrderId(null);
                    fscClaimDetailChangePO.setFscOrderNo(null);
                    fscClaimDetailChangePOS.add(fscClaimDetailChangePO);
                    FscClaimDetailPO fscClaimDetailPO = (FscClaimDetailPO)claimWriteAmountMap.get(fscOrderWriteDetailBO.getClaimDetailId());
                    if (fscClaimDetailPO == null) {
                        fscClaimDetailPO = new FscClaimDetailPO();
                        fscClaimDetailPO.setClaimDetailId(fscOrderWriteDetailBO.getClaimDetailId());
                        fscClaimDetailPO.setWriteOffAmount(thisAmount);
                    } else {
                        fscClaimDetailPO.setWriteOffAmount(fscClaimDetailPO.getWriteOffAmount().add(thisAmount));
                    }
                    claimWriteAmountMap.put(fscOrderWriteDetailBO.getClaimDetailId(), fscClaimDetailPO);
                    if (claimDetailIdSet.contains(claimDetailPO.getClaimDetailId())) continue;
                    claimDetailIdSet.add(claimDetailPO.getClaimDetailId());
                    changeAmt = changeAmt.add(claimDetailPO.getClaimAmt());
                }
            }
            if (!CollectionUtils.isEmpty(orderWriteList)) {
                this.fscWriteOffMapper.insertBatch(orderWriteList);
            }
            if (!CollectionUtils.isEmpty(writeRelationList)) {
                this.fscOrderWriteRelationMapper.insertBatch(writeRelationList);
            }
            if (!CollectionUtils.isEmpty(claimWriteAmountMap.values())) {
                this.fscClaimDetailMapper.updateWriteOffAmountBatchById(new ArrayList(claimWriteAmountMap.values()));
            }
            if (!CollectionUtils.isEmpty(fscOrderWriteOffAmountMap.values())) {
                for (Long l : fscOrderWriteOffAmountMap.keySet()) {
                    FscOrderPO fscOrderPO = new FscOrderPO();
                    fscOrderPO.setWriteOffAmountAdd((BigDecimal)fscOrderWriteOffAmountMap.get(l));
                    fscOrderPO.setFscOrderId(l);
                    this.fscOrderMapper.updateById(fscOrderPO);
                }
            }
        } else {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u53ef\u6838\u9500\u8ba4\u9886\u660e\u7ec6\u4e3a\u7a7a");
        }
        this.fscClaimDetailChangeMapper.insertBatch(fscClaimDetailChangePOS);
        Long changeId = fscRecvClaimChangePO.getChangeId();
        fscRecvClaimChangePO = new FscRecvClaimChangePO();
        fscRecvClaimChangePO.setChangeId(changeId);
        fscRecvClaimChangePO.setChangeAmt(changeAmt);
        this.fscRecvClaimChangeMapper.update(fscRecvClaimChangePO);
        rspBO.setFscOrderIds(new ArrayList(fscOrderWriteOffAmountMap.keySet()));
        rspBO.setChangeId(fscRecvClaimChangePO.getChangeId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public FscRecvClaimChangeCreateBusiRspBO dealCreateOrderWrite(FscRecvClaimChangeCreateBusiReqBO reqBO) {
        BigDecimal changeAmt;
        ArrayList<FscClaimDetailChangePO> fscClaimDetailChangePOS;
        HashMap<Long, BigDecimal> fscOrderWriteOffAmountMap;
        FscRecvClaimChangeCreateBusiRspBO rspBO = new FscRecvClaimChangeCreateBusiRspBO();
        FscRecvClaimPO fscRecvClaimPO = this.fscRecvClaimMapper.queryById(reqBO.getClaimId());
        if (fscRecvClaimPO == null) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u6536\u6b3e\u8ba4\u9886\u5355\u4e0d\u5b58\u5728!");
        }
        Date now = new Date();
        FscRecvClaimChangePO fscRecvClaimChangePO = (FscRecvClaimChangePO)JSON.parseObject((String)JSONObject.toJSONString((Object)fscRecvClaimPO), FscRecvClaimChangePO.class);
        fscRecvClaimChangePO.setBillStatus(FscConstants.ChangeBillStatus.CONFIRMED);
        this.insertChange(fscRecvClaimChangePO, reqBO, now);
        List<FscClaimDetailChangeBO> detailChangeList = reqBO.getDetailChangeList();
        Set claimDetailIdList = detailChangeList.stream().map(FscClaimDetailChangeBO::getClaimDetailId).collect(Collectors.toSet());
        FscClaimDetailPO fscClaimDetail = new FscClaimDetailPO();
        fscClaimDetail.setClaimId(reqBO.getClaimId());
        fscClaimDetail.setClaimDetailIds(claimDetailIdList);
        List fscClaimDetailPOList = this.fscClaimDetailMapper.getWriteOffPayById(fscClaimDetail);
        if (!CollectionUtils.isEmpty((Collection)fscClaimDetailPOList)) {
            HashMap<Long, FscClaimDetailPO> claimDetailMap = new HashMap<Long, FscClaimDetailPO>();
            for (FscClaimDetailPO fscClaimDetailPO : fscClaimDetailPOList) {
                claimDetailMap.put(fscClaimDetailPO.getClaimDetailId(), fscClaimDetailPO);
            }
            ArrayList<FscWriteOffPO> orderWriteList = new ArrayList<FscWriteOffPO>();
            ArrayList<FscOrderWriteRelationPO> writeRelationList = new ArrayList<FscOrderWriteRelationPO>();
            ArrayList<FscClaimDetailPO> updateClaimList = new ArrayList<FscClaimDetailPO>();
            fscOrderWriteOffAmountMap = new HashMap<Long, BigDecimal>();
            Date writeOffDate = new Date();
            fscClaimDetailChangePOS = new ArrayList<FscClaimDetailChangePO>();
            int serialNumber = 0;
            changeAmt = BigDecimal.ZERO;
            HashSet<Long> claimDetailIdSet = new HashSet<Long>();
            for (FscClaimDetailChangeBO fscClaimDetailChangeBO : detailChangeList) {
                BigDecimal noWriteOffAmount;
                FscClaimDetailPO claimDetailPO;
                BigDecimal fscOrderWriteOffAmount = (BigDecimal)fscOrderWriteOffAmountMap.get(fscClaimDetailChangeBO.getChangeFscOrderId());
                if (fscOrderWriteOffAmount == null) {
                    fscOrderWriteOffAmount = BigDecimal.ZERO;
                }
                if (null == (claimDetailPO = (FscClaimDetailPO)claimDetailMap.get(fscClaimDetailChangeBO.getClaimDetailId())).getWriteOffAmount()) {
                    claimDetailPO.setWriteOffAmount(new BigDecimal(0));
                }
                if ((noWriteOffAmount = claimDetailPO.getClaimAmt().subtract(claimDetailPO.getWriteOffAmount())).compareTo(BigDecimal.ZERO) <= 0) continue;
                FscWriteOffPO fscWriteOffPO = new FscWriteOffPO();
                fscWriteOffPO.setWriteOffId(Long.valueOf(Sequence.getInstance().nextId()));
                fscWriteOffPO.setFscOrderId(fscClaimDetailChangeBO.getChangeFscOrderId());
                fscWriteOffPO.setFscOrderNo(fscClaimDetailChangeBO.getChangeFscOrderNo());
                fscWriteOffPO.setClaimId(claimDetailPO.getClaimId());
                fscWriteOffPO.setHandleUserId(claimDetailPO.getHandleUserId());
                fscWriteOffPO.setHandleUserName(claimDetailPO.getHandleUserName());
                fscWriteOffPO.setHandleDeptId(claimDetailPO.getHandleDeptId());
                fscWriteOffPO.setHandleDeptName(claimDetailPO.getHandleDeptName());
                fscWriteOffPO.setClaimType(claimDetailPO.getClaimType());
                fscWriteOffPO.setOrderId(claimDetailPO.getOrderId());
                fscWriteOffPO.setOrderCode(claimDetailPO.getOrderCode());
                fscWriteOffPO.setBuynerNo(fscClaimDetailChangeBO.getBuynerNo().toString());
                fscWriteOffPO.setBuynerName(fscClaimDetailChangeBO.getBuynerName());
                fscWriteOffPO.setTotalCharge(fscClaimDetailChangeBO.getTotalCharge());
                fscWriteOffPO.setOrderAmount(fscClaimDetailChangeBO.getOrderAmount());
                fscWriteOffPO.setPayerId(fscClaimDetailChangeBO.getPayerId());
                fscWriteOffPO.setPayerName(fscClaimDetailChangeBO.getPayerName());
                fscWriteOffPO.setWriteOffDate(writeOffDate);
                fscWriteOffPO.setStatus(Integer.valueOf(1));
                fscWriteOffPO.setWriteOffAmount(fscClaimDetailChangeBO.getWriteOffAmount());
                BigDecimal thisAmount = fscClaimDetailChangeBO.getChangeAmt();
                fscWriteOffPO.setThisAmount(thisAmount);
                fscWriteOffPO.setWriteOffAmount(fscWriteOffPO.getWriteOffAmount().add(thisAmount));
                orderWriteList.add(fscWriteOffPO);
                if (claimDetailPO.getClaimAmt().compareTo(claimDetailPO.getWriteOffAmount().add(thisAmount)) < 0) {
                    throw new FscBusinessException("191026", "\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u8ba4\u9886\u91d1\u989d\uff01");
                }
                fscOrderWriteOffAmount = fscOrderWriteOffAmount.add(thisAmount);
                fscOrderWriteOffAmountMap.put(fscClaimDetailChangeBO.getChangeFscOrderId(), fscOrderWriteOffAmount);
                FscOrderWriteRelationPO fscOrderWriteRelationPO = new FscOrderWriteRelationPO();
                fscOrderWriteRelationPO.setFscOrderId(fscClaimDetailChangeBO.getChangeFscOrderId());
                fscOrderWriteRelationPO.setClaimDetailId(claimDetailPO.getClaimDetailId());
                fscOrderWriteRelationPO.setClaimId(claimDetailPO.getClaimId());
                fscOrderWriteRelationPO.setClaimAmt(claimDetailPO.getClaimAmt());
                fscOrderWriteRelationPO.setWriteOffAmount(thisAmount);
                fscOrderWriteRelationPO.setWriteOffDate(writeOffDate);
                fscOrderWriteRelationPO.setClaimNo(claimDetailPO.getClaimNo());
                fscOrderWriteRelationPO.setOrderId(claimDetailPO.getOrderId());
                fscOrderWriteRelationPO.setOrderCode(claimDetailPO.getOrderCode());
                fscOrderWriteRelationPO.setBuynerNo(fscClaimDetailChangeBO.getBuynerNo().toString());
                fscOrderWriteRelationPO.setBuynerName(fscClaimDetailChangeBO.getBuynerName());
                fscOrderWriteRelationPO.setRemainAmount(claimDetailPO.getClaimAmt().subtract(claimDetailPO.getWriteOffAmount()).subtract(thisAmount));
                writeRelationList.add(fscOrderWriteRelationPO);
                FscClaimDetailChangePO fscClaimDetailChangePO = (FscClaimDetailChangePO)JSON.parseObject((String)JSONObject.toJSONString((Object)fscClaimDetailChangeBO), FscClaimDetailChangePO.class);
                fscClaimDetailChangePO.setClaimDetailId(claimDetailPO.getClaimDetailId());
                fscClaimDetailChangePO.setClaimId(claimDetailPO.getClaimId());
                fscClaimDetailChangePO.setChangeId(fscRecvClaimChangePO.getChangeId());
                fscClaimDetailChangePO.setClaimAmt(claimDetailPO.getClaimAmt());
                fscClaimDetailChangePO.setChangeAmt(thisAmount);
                fscClaimDetailChangePO.setChangeDetailId(Long.valueOf(Sequence.getInstance().nextId()));
                String changeDetailNo = fscRecvClaimChangePO.getChangeNo() + "-" + String.format("%02d", ++serialNumber);
                fscClaimDetailChangePO.setChangeDetailNo(changeDetailNo);
                fscClaimDetailChangePO.setConfirmStatus(FscConstants.ChangeConfirmStatus.CONFIRMED);
                fscClaimDetailChangePO.setClaimType(Integer.valueOf(Integer.parseInt(FscClaimTypeEnum.PROPRIETARY_RECV_CLAIM.getCode())));
                fscClaimDetailChangePO.setChangeClaimType(Integer.valueOf(Integer.parseInt(FscClaimTypeEnum.PROPRIETARY_SETTLE_CLAIM.getCode())));
                fscClaimDetailChangePO.setCreateTime(writeOffDate);
                fscClaimDetailChangePO.setCreateUserId(reqBO.getUserId());
                fscClaimDetailChangePO.setConfirmDate(writeOffDate);
                fscClaimDetailChangePO.setFscOrderId(null);
                fscClaimDetailChangePO.setFscOrderNo(null);
                fscClaimDetailChangePOS.add(fscClaimDetailChangePO);
                claimDetailPO.setWriteOffAmount(thisAmount);
                claimDetailPO.setWriteOffDate(writeOffDate);
                updateClaimList.add(claimDetailPO);
                if (claimDetailIdSet.contains(claimDetailPO.getClaimDetailId())) continue;
                claimDetailIdSet.add(claimDetailPO.getClaimDetailId());
                changeAmt = changeAmt.add(claimDetailPO.getClaimAmt());
            }
            if (!CollectionUtils.isEmpty(orderWriteList)) {
                this.fscWriteOffMapper.insertBatch(orderWriteList);
            }
            if (!CollectionUtils.isEmpty(writeRelationList)) {
                this.fscOrderWriteRelationMapper.insertBatch(writeRelationList);
            }
            if (!CollectionUtils.isEmpty(updateClaimList)) {
                this.fscClaimDetailMapper.updateWriteOffAmountBatchById(updateClaimList);
            }
            if (!CollectionUtils.isEmpty(fscOrderWriteOffAmountMap.values())) {
                for (Long fscOrderId : fscOrderWriteOffAmountMap.keySet()) {
                    FscOrderPO fscOrderPO = new FscOrderPO();
                    fscOrderPO.setWriteOffAmountAdd((BigDecimal)fscOrderWriteOffAmountMap.get(fscOrderId));
                    fscOrderPO.setFscOrderId(fscOrderId);
                    this.fscOrderMapper.updateById(fscOrderPO);
                }
            }
        } else {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u53ef\u6838\u9500\u8ba4\u9886\u660e\u7ec6\u4e3a\u7a7a");
        }
        this.fscClaimDetailChangeMapper.insertBatch(fscClaimDetailChangePOS);
        Long changeId = fscRecvClaimChangePO.getChangeId();
        fscRecvClaimChangePO = new FscRecvClaimChangePO();
        fscRecvClaimChangePO.setChangeId(changeId);
        fscRecvClaimChangePO.setChangeAmt(changeAmt);
        this.fscRecvClaimChangeMapper.update(fscRecvClaimChangePO);
        rspBO.setFscOrderIds(new ArrayList(fscOrderWriteOffAmountMap.keySet()));
        rspBO.setChangeId(fscRecvClaimChangePO.getChangeId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

