/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.fsc.bo.FscApprovalTaskQueryBO;
import com.tydic.fsc.common.busi.api.FscRefundChargeConfirmBusiService;
import com.tydic.fsc.common.busi.bo.FscRefundChargeConfirmBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscRefundChargeConfirmBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountChargeMapper;
import com.tydic.fsc.dao.FscFinanceBankStatementMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoMapper;
import com.tydic.fsc.dao.FscTaskCandidateMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountChargePO;
import com.tydic.fsc.po.FscFinanceBankStatementPO;
import com.tydic.fsc.po.FscFinanceDraftInfoPO;
import com.tydic.fsc.po.FscTaskCandidatePO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscRefundChargeConfirmBusiServiceImpl
implements FscRefundChargeConfirmBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscRefundChargeConfirmBusiServiceImpl.class);
    @Autowired
    private FscAccountChargeMapper fscAccountChargeMapper;
    @Autowired
    private FscFinanceBankStatementMapper fscFinanceBankStatementMapper;
    @Autowired
    private FscFinanceDraftInfoMapper fscFinanceDraftInfoMapper;
    @Autowired
    private FscTaskCandidateMapper fscTaskCandidateMapper;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;

    @Override
    public FscRefundChargeConfirmBusiRspBO dealRefundChargeConfirm(FscRefundChargeConfirmBusiReqBO reqBo) {
        FscRefundChargeConfirmBusiRspBO rspBO = new FscRefundChargeConfirmBusiRspBO();
        this.addFinanceBankStatement(reqBo);
        this.addFinanceDraftInfo(reqBo);
        this.updateAccountCharge(reqBo);
        this.initiateFlowApprove(reqBo);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void addFinanceBankStatement(FscRefundChargeConfirmBusiReqBO reqBo) {
        FscFinanceBankStatementPO deleteFscFinanceBankStatement = new FscFinanceBankStatementPO();
        deleteFscFinanceBankStatement.setRefundId(reqBo.getChargeId());
        this.fscFinanceBankStatementMapper.deleteBy(deleteFscFinanceBankStatement);
        if (CollectionUtils.isEmpty(reqBo.getBankStatementList())) {
            return;
        }
        List addBankStatementList = JUtil.jsl(reqBo.getBankStatementList(), FscFinanceBankStatementPO.class);
        for (FscFinanceBankStatementPO bankStatement : addBankStatementList) {
            bankStatement.setStatementId(Long.valueOf(Sequence.getInstance().nextId()));
            bankStatement.setRefundId(reqBo.getChargeId());
            bankStatement.setCreateTime(new Date());
        }
        this.fscFinanceBankStatementMapper.insertBatch(addBankStatementList);
    }

    private void addFinanceDraftInfo(FscRefundChargeConfirmBusiReqBO reqBo) {
        FscFinanceDraftInfoPO deleteFscFinanceDraftInfo = new FscFinanceDraftInfoPO();
        deleteFscFinanceDraftInfo.setRefundId(reqBo.getChargeId());
        this.fscFinanceDraftInfoMapper.deleteBy(deleteFscFinanceDraftInfo);
        if (CollectionUtils.isEmpty(reqBo.getDraftInfoList())) {
            return;
        }
        List addDraftInfoList = JUtil.jsl(reqBo.getDraftInfoList(), FscFinanceDraftInfoPO.class);
        for (FscFinanceDraftInfoPO draftInfo : addDraftInfoList) {
            draftInfo.setDraftId(Long.valueOf(Sequence.getInstance().nextId()));
            draftInfo.setRefundId(reqBo.getChargeId());
            draftInfo.setCreateTime(new Date());
        }
        this.fscFinanceDraftInfoMapper.insertBatch(addDraftInfoList);
    }

    private void updateAccountCharge(FscRefundChargeConfirmBusiReqBO reqBO) {
        FscAccountChargePO updateFscAccountCharge = new FscAccountChargePO();
        updateFscAccountCharge.setChargeId(reqBO.getChargeId());
        updateFscAccountCharge.setAuditStatus(FscConstants.AuditStatus.AUDITING);
        this.fscAccountChargeMapper.update(updateFscAccountCharge);
    }

    private void initiateFlowApprove(FscRefundChargeConfirmBusiReqBO reqBO) {
        this.invokeUacNoTask(reqBO);
        this.updateAccountChargeTaskOperator(reqBO);
    }

    private void invokeUacNoTask(FscRefundChargeConfirmBusiReqBO reqBO) {
        UacNoTaskAuditCreateReqBO uacNoTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        uacNoTaskAuditCreateReqBO.setCreateOperId(reqBO.getUserId().toString());
        uacNoTaskAuditCreateReqBO.setCreateOperName(reqBO.getName());
        uacNoTaskAuditCreateReqBO.setCreateOperDept(reqBO.getOrgName());
        uacNoTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        uacNoTaskAuditCreateReqBO.setMenuId("M001006");
        uacNoTaskAuditCreateReqBO.setOrgId(String.valueOf(reqBO.getOrgId()));
        ArrayList<UacNoTaskAuditCreateInfoReqBO> createBusiReqBO = new ArrayList<UacNoTaskAuditCreateInfoReqBO>(1);
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(FscConstants.AuditObjType.ACCOUNT_CHARGE_APPROVAL);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(reqBO.getChargeId());
        createBusiReqBO.add(uacNoTaskAuditCreateInfoReqBO);
        ArrayList<ApprovalObjBO> approvalObjInfo = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjId(String.valueOf(reqBO.getChargeId()));
        approvalObjBO.setObjName("\u9884\u5b58\u9000\u6b3e\u7533\u8bf7\u5355");
        approvalObjBO.setObjType(FscConstants.AuditObjType.ACCOUNT_CHARGE_APPROVAL);
        approvalObjInfo.add(approvalObjBO);
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjInfo);
        uacNoTaskAuditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
        log.info("\u5ba1\u6279\u5165\u53c2================" + JSON.toJSONString((Object)uacNoTaskAuditCreateReqBO));
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(uacNoTaskAuditCreateReqBO);
        log.info("\u5ba1\u6279\u51fa\u53c2================" + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
        if (uacNoTaskAuditCreateRspBO.getNotFindFlag().booleanValue()) {
            throw new FscBusinessException("194203", "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u5ba1\u6279\u6d41");
        }
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new FscBusinessException("194203", uacNoTaskAuditCreateRspBO.getRespDesc());
        }
    }

    private void updateAccountChargeTaskOperator(FscRefundChargeConfirmBusiReqBO reqBO) {
        FscTaskCandidatePO qryFscTaskCandidate = new FscTaskCandidatePO();
        qryFscTaskCandidate.setFscOrderId(reqBO.getChargeId());
        List fscApprovalTaskQueryList = this.fscTaskCandidateMapper.getPendAuditPostIdList(qryFscTaskCandidate);
        if (!CollectionUtils.isEmpty((Collection)fscApprovalTaskQueryList)) {
            StringBuilder taskOperatorIdBuilder = new StringBuilder();
            taskOperatorIdBuilder.append(",");
            for (FscApprovalTaskQueryBO fscApprovalTaskQueryBO : fscApprovalTaskQueryList) {
                taskOperatorIdBuilder.append(fscApprovalTaskQueryBO.getTaskOperId()).append(",");
            }
            FscAccountChargePO updateTaskOperator = new FscAccountChargePO();
            updateTaskOperator.setTaskOperId(String.valueOf(taskOperatorIdBuilder));
            this.fscAccountChargeMapper.updateTaskOperById(updateTaskOperator);
        }
    }
}

