/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscFinanceRefundInvoiceTempInvoiceBO;
import com.tydic.fsc.common.ability.bo.FscRefundInvoiceTempAddAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscRefundInvoiceTempAddAbilityRspBO;
import com.tydic.fsc.common.busi.api.FscRefundInvoiceTempAddBusiService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentTempMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscInvoiceRefundRelationTempMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderRelationTempMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentTempPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscInvoiceRefundRelationTempPo;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderRelationTempPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscRefundInvoiceTempAddBusiServiceImpl
implements FscRefundInvoiceTempAddBusiService {
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscOrderRelationTempMapper fscOrderRelationTempMapper;
    @Autowired
    private FscInvoiceRefundRelationTempMapper fscInvoiceRefundRelationTempMapper;
    @Autowired
    private FscAttachmentTempMapper fscAttachmentTempMapper;

    @Override
    public FscRefundInvoiceTempAddAbilityRspBO refundInvoiceTempAdd(FscRefundInvoiceTempAddAbilityReqBO reqBO) {
        if (reqBO.getRefundId() == null) {
            reqBO.setRefundId(Long.valueOf(Sequence.getInstance().nextId()));
        }
        if (Objects.nonNull(reqBO.getRefundId()) && Objects.nonNull(reqBO.getContractId())) {
            FscAttachmentTempPO fscAttachmentTempPO = new FscAttachmentTempPO();
            fscAttachmentTempPO.setFscOrderId(reqBO.getRefundId());
            fscAttachmentTempPO.setObjId(reqBO.getContractId());
            fscAttachmentTempPO.setObjType(FscConstants.AttachmentObjType.REFUND_INVOICE);
            fscAttachmentTempPO.setAttachmentType(FscConstants.AttachmentType.REFUND_INVOICE);
            this.fscAttachmentTempMapper.deleteBy(fscAttachmentTempPO);
            FscOrderRelationTempPO fscOrderRelationTempPO = new FscOrderRelationTempPO();
            fscOrderRelationTempPO.setRefundId(reqBO.getRefundId());
            fscOrderRelationTempPO.setContractId(reqBO.getContractId());
            this.fscOrderRelationTempMapper.deleteBy(fscOrderRelationTempPO);
            FscInvoiceRefundRelationTempPo fscInvoiceRefundRelationTempPo = new FscInvoiceRefundRelationTempPo();
            fscInvoiceRefundRelationTempPo.setRefundId(reqBO.getRefundId());
            fscInvoiceRefundRelationTempPo.setContractId(reqBO.getContractId());
            this.fscInvoiceRefundRelationTempMapper.deleteBy(fscInvoiceRefundRelationTempPo);
        }
        Set invoiceIds = reqBO.getRows().stream().map(FscFinanceRefundInvoiceTempInvoiceBO::getInvoiceId).collect(Collectors.toSet());
        FscInvoicePO qryPO = new FscInvoicePO();
        qryPO.setInvoiceIds(new ArrayList(invoiceIds));
        List invoicePOS = this.fscInvoiceMapper.getList(qryPO);
        if (CollectionUtils.isEmpty((Collection)invoicePOS) || invoicePOS.size() != invoiceIds.size()) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u5230\u5bf9\u5e94\u7684\u53d1\u7968\u4fe1\u606f");
        }
        TreeMap<Long, BigDecimal> invoiceRateMap = new TreeMap<Long, BigDecimal>();
        for (FscInvoicePO each : invoicePOS) {
            BigDecimal rate = each.getAmt().divide(each.getUntaxAmt(), 2, 4).subtract(BigDecimal.ONE);
            invoiceRateMap.put(each.getInvoiceId(), rate);
        }
        ArrayList<FscOrderRelationTempPO> fscOrderRelationTempPOS = new ArrayList<FscOrderRelationTempPO>();
        ArrayList<FscInvoiceRefundRelationTempPo> invoiceRefundRelationTempPos = new ArrayList<FscInvoiceRefundRelationTempPo>();
        Map<Long, List<FscFinanceRefundInvoiceTempInvoiceBO>> collect = reqBO.getRows().stream().collect(Collectors.groupingBy(FscFinanceRefundInvoiceTempInvoiceBO::getOrderPayItemId));
        for (Long orderPayItemId : collect.keySet()) {
            FscOrderRelationTempPO fscOrderRelationTempPO = new FscOrderRelationTempPO();
            fscOrderRelationTempPO.setContractSegmentName(reqBO.getContractSegmentName());
            fscOrderRelationTempPO.setContractSegmentCode(reqBO.getContractSegmentCode());
            fscOrderRelationTempPO.setEstimateBillGuid(reqBO.getEstimateBillGuid());
            fscOrderRelationTempPO.setEstimateBillCode(reqBO.getEstimateBillCode());
            fscOrderRelationTempPO.setEstimateBizTypeCode(reqBO.getEstimateBizTypeCode());
            fscOrderRelationTempPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscOrderRelationTempPO.setOrderId(orderPayItemId);
            fscOrderRelationTempPO.setAcceptOrderId(orderPayItemId);
            fscOrderRelationTempPO.setRefundId(reqBO.getRefundId());
            fscOrderRelationTempPO.setContractId(reqBO.getContractId());
            fscOrderRelationTempPO.setContractNo(reqBO.getContractNo());
            fscOrderRelationTempPO.setContractName(reqBO.getContractName());
            fscOrderRelationTempPO.setContractType("2");
            fscOrderRelationTempPO.setContractCategory(reqBO.getContractCategory());
            fscOrderRelationTempPO.setBusinessType(reqBO.getBusinessType());
            BigDecimal refundAmtCount = collect.get(orderPayItemId).stream().map(FscFinanceRefundInvoiceTempInvoiceBO::getRefundAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            fscOrderRelationTempPO.setSettleAmt(refundAmtCount);
            fscOrderRelationTempPO.setAmount(refundAmtCount);
            fscOrderRelationTempPO.setContractRemark(reqBO.getContractRemark());
            fscOrderRelationTempPOS.add(fscOrderRelationTempPO);
        }
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderItemPO.setOrderIds(new ArrayList<Long>(collect.keySet()));
        List byOrderIdList = this.fscOrderItemMapper.getByOrderIdList(fscOrderItemPO);
        Map<Long, BigDecimal> amtMap = byOrderIdList.stream().collect(Collectors.toMap(FscOrderItemPO::getOrderId, FscOrderItemPO::getAmt));
        for (FscFinanceRefundInvoiceTempInvoiceBO each : reqBO.getRows()) {
            if (amtMap.get(each.getOrderPayItemId()).compareTo(each.getRefundAmt()) < 0) {
                throw new FscBusinessException("198888", "\u60a8\u7684\u7533\u8bf7\u9000\u6b3e\u91d1\u989d\u5927\u4e8e\u60a8\u7684\u53ef\u9000\u6b3e\u91d1\u989d\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u63d0\u4ea4\u3002");
            }
            FscInvoiceRefundRelationTempPo orderItemTempPO = new FscInvoiceRefundRelationTempPo();
            BeanUtils.copyProperties((Object)each, (Object)orderItemTempPO);
            orderItemTempPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            orderItemTempPO.setDetailId(each.getOrderPayItemId());
            orderItemTempPO.setFscOrderId(reqBO.getFscOrderId());
            orderItemTempPO.setRefundId(reqBO.getRefundId());
            orderItemTempPO.setContractId(reqBO.getContractId());
            orderItemTempPO.setCreateTime(new Date(System.currentTimeMillis()));
            orderItemTempPO.setRefundAmt(each.getRefundAmt());
            orderItemTempPO.setRefundType(each.getRefundType());
            orderItemTempPO.setUntaxAmt(each.getRefundAmt().divide(BigDecimal.ONE.add((BigDecimal)invoiceRateMap.get(each.getInvoiceId())), 2, 4));
            orderItemTempPO.setTaxAmt(orderItemTempPO.getRefundAmt().subtract(orderItemTempPO.getUntaxAmt()));
            invoiceRefundRelationTempPos.add(orderItemTempPO);
        }
        this.fscOrderRelationTempMapper.insertBatch(fscOrderRelationTempPOS);
        this.fscInvoiceRefundRelationTempMapper.insertBatch(invoiceRefundRelationTempPos);
        if (!CollectionUtils.isEmpty((Collection)reqBO.getAttachmentList())) {
            ArrayList<FscAttachmentTempPO> fscAttachmentPOS = new ArrayList<FscAttachmentTempPO>();
            for (AttachmentBO attachmentBO : reqBO.getAttachmentList()) {
                FscAttachmentTempPO fscAttachmentPO = new FscAttachmentTempPO();
                BeanUtils.copyProperties((Object)attachmentBO, (Object)fscAttachmentPO);
                fscAttachmentPO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                fscAttachmentPO.setAttachmentType(FscConstants.AttachmentType.REFUND_INVOICE);
                fscAttachmentPO.setObjId(reqBO.getContractId());
                fscAttachmentPO.setObjType(FscConstants.AttachmentObjType.REFUND_INVOICE);
                fscAttachmentPO.setFscOrderId(reqBO.getRefundId());
                fscAttachmentPOS.add(fscAttachmentPO);
            }
            this.fscAttachmentTempMapper.insertBatch(fscAttachmentPOS);
        }
        FscRefundInvoiceTempAddAbilityRspBO rspBO = new FscRefundInvoiceTempAddAbilityRspBO();
        rspBO.setRefundId(reqBO.getRefundId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

