/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderFailLogUpdateBusiReqBO;
import com.tydic.fsc.common.ability.api.FscClaimChangeConfirmAbilityService;
import com.tydic.fsc.common.ability.bo.FscClaimChangeConfirmAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscClaimChangeConfirmAbilityRspBO;
import com.tydic.fsc.common.busi.api.FscClaimChangeConfirmBusiService;
import com.tydic.fsc.common.busi.bo.FscClaimChangeConfirmBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscClaimChangeConfirmBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import java.util.Collection;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscClaimChangeConfirmAbilityService"})
public class FscClaimChangeConfirmAbilityServiceImpl
implements FscClaimChangeConfirmAbilityService {
    @Autowired
    private FscClaimChangeConfirmBusiService fscClaimChangeConfirmBusiService;
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;
    @Resource(name="fscPushYcRecvClaimChangeMqServiceProvider")
    private ProxyMessageProducer fscPushYcRecvClaimChangeMqServiceProvider;
    @Value(value="${es.FSC_PUSH_YC_RECV_CLAIM_CHANGE_TOPIC:FSC_PUSH_YC_RECV_CLAIM_CHANGE_TOPIC}")
    private String pushTopic;
    @Value(value="${es.FSC_PUSH_YC_RECV_CLAIM_CHANGE_TAG:FSC_PUSH_YC_RECV_CLAIM_CHANGE_TAG}")
    private String pushTag;

    @PostMapping(value={"dealClaimChangeConfirm"})
    public FscClaimChangeConfirmAbilityRspBO dealClaimChangeConfirm(@RequestBody FscClaimChangeConfirmAbilityReqBO reqBO) {
        this.valid(reqBO);
        String reqString = JSONObject.toJSONString((Object)reqBO);
        FscClaimChangeConfirmBusiReqBO busiReqBO = (FscClaimChangeConfirmBusiReqBO)((Object)JSONObject.parseObject((String)reqString, FscClaimChangeConfirmBusiReqBO.class));
        FscClaimChangeConfirmBusiRspBO busiRspBO = this.fscClaimChangeConfirmBusiService.dealClaimChangeConfirm(busiReqBO);
        if ("0000".equals(busiRspBO.getRespCode()) && !CollectionUtils.isEmpty(busiRspBO.getChangeIdList())) {
            this.sendMq(busiRspBO);
        }
        String respString = JSONObject.toJSONString((Object)((Object)busiRspBO));
        return (FscClaimChangeConfirmAbilityRspBO)JSONObject.parseObject((String)respString, FscClaimChangeConfirmAbilityRspBO.class);
    }

    private void valid(FscClaimChangeConfirmAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getChangeDetailIdList())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u53d8\u66f4\u660e\u7ec6id\u96c6\u5408[changeDetailIdList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void sendMq(FscClaimChangeConfirmBusiRspBO busiRspBO) {
        ProxySendResult proxySendResult = this.fscPushYcRecvClaimChangeMqServiceProvider.send(new ProxyMessage(this.pushTopic, this.pushTag, JSONObject.toJSONString(busiRspBO.getChangeIdList())));
        if (!"SEND_OK".equals(proxySendResult.getStatus())) {
            this.writeStateFailLog(JSONObject.toJSONString(busiRspBO.getChangeIdList()));
        }
    }

    private void writeStateFailLog(String objNo) {
        FscOrderFailLogUpdateBusiReqBO fscOrderFailLogUpdateBusiReqBO = new FscOrderFailLogUpdateBusiReqBO();
        fscOrderFailLogUpdateBusiReqBO.setObjNo(objNo);
        fscOrderFailLogUpdateBusiReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.FSC_CLAIM_CHANGE_SETTLE_PUSH_YC_FAIL);
        this.fscOrderFailLogUpdateBusiService.dealInsert(fscOrderFailLogUpdateBusiReqBO);
    }
}

