/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.tydic.fsc.common.ability.api.FscClaimDetailPushYcTaskService;
import com.tydic.fsc.common.ability.api.FscPushYcRecvClaimBillAbilityService;
import com.tydic.fsc.common.ability.bo.FscClaimDetailPushYcTaskServiceReqBO;
import com.tydic.fsc.common.ability.bo.FscClaimDetailPushYcTaskServiceRspBO;
import com.tydic.fsc.common.ability.bo.FscPushYcRecvClaimBillAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushYcRecvClaimBillAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscRecvClaimMapper;
import com.tydic.fsc.enums.FscClaimRecvStatusEnum;
import com.tydic.fsc.po.FscRecvClaimPO;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscClaimDetailPushYcTaskService"})
public class FscClaimDetailPushYcTaskServiceImpl
implements FscClaimDetailPushYcTaskService {
    private static final Logger log = LoggerFactory.getLogger(FscClaimDetailPushYcTaskServiceImpl.class);
    @Autowired
    private FscRecvClaimMapper fscRecvClaimMapper;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscPushYcRecvClaimBillAbilityService fscPushYcRecvClaimBillAbilityService;

    @PostMapping(value={"claimDetailPushYcTask"})
    public FscClaimDetailPushYcTaskServiceRspBO claimDetailPushYcTask(@RequestBody FscClaimDetailPushYcTaskServiceReqBO reqBO) {
        List claimDetailList;
        List fscRecvClaimPOS;
        FscRecvClaimPO fscRecvClaimPO = new FscRecvClaimPO();
        fscRecvClaimPO.setExcludeRecvStatus(FscClaimRecvStatusEnum.DELETE.getCode());
        if (!CollectionUtils.isEmpty((Collection)reqBO.getClaimIds())) {
            fscRecvClaimPO.setClaimIds(reqBO.getClaimIds());
        }
        if (CollectionUtils.isEmpty((Collection)(fscRecvClaimPOS = this.fscRecvClaimMapper.queryAll(fscRecvClaimPO)))) {
            return new FscClaimDetailPushYcTaskServiceRspBO();
        }
        List allIds = fscRecvClaimPOS.stream().map(e -> e.getClaimId()).collect(Collectors.toList());
        HashSet<Long> reRecvClaimIds = new HashSet<Long>();
        for (FscRecvClaimPO po : fscRecvClaimPOS) {
            if (po.getStatus() == null || po.getStatus() != 0 || !FscClaimRecvStatusEnum.EFFECTIVE.getCode().equals(po.getRecvStatus()) || !"0".equals(po.getClaimStatus())) continue;
            reRecvClaimIds.add(po.getClaimId());
        }
        allIds.removeAll(reRecvClaimIds);
        Map<Object, Object> reClaimDetailIds = new HashMap();
        if (!CollectionUtils.isEmpty(allIds) && !CollectionUtils.isEmpty((Collection)(claimDetailList = this.fscClaimDetailMapper.queryByClaimIdList(allIds)))) {
            reClaimDetailIds = claimDetailList.stream().filter(e -> e.getPushStatus() != null && FscConstants.FscPushStatus.FAIL.equals(e.getPushStatus())).collect(Collectors.groupingBy(e -> e.getClaimId()));
            List cliamIds = claimDetailList.stream().filter(e -> e.getPushStatus() != null && FscConstants.FscPushStatus.FAIL.equals(e.getPushStatus())).map(e -> e.getClaimId()).collect(Collectors.toList());
            reRecvClaimIds.addAll(cliamIds);
        }
        if (CollectionUtils.isEmpty(reRecvClaimIds)) {
            return new FscClaimDetailPushYcTaskServiceRspBO();
        }
        for (Long claimId : reRecvClaimIds) {
            FscRecvClaimPO updateVo;
            FscPushYcRecvClaimBillAbilityReqBO abilityReqBO = new FscPushYcRecvClaimBillAbilityReqBO();
            abilityReqBO.setClaimId(claimId);
            if (reClaimDetailIds != null && reClaimDetailIds.containsKey(claimId)) {
                List fscClaimDetailPOS = (List)reClaimDetailIds.get(claimId);
                List reDetailIds = fscClaimDetailPOS.stream().map(e -> e.getClaimDetailId()).collect(Collectors.toList());
                if (reDetailIds.size() > 10) {
                    for (int i = 0; i < reDetailIds.size(); i += 10) {
                        List ids;
                        if (i + 10 > reDetailIds.size()) {
                            ids = reDetailIds.subList(i, reDetailIds.size());
                            abilityReqBO.setDetailIdList(ids);
                        } else {
                            ids = reDetailIds.subList(i, i + 10);
                            abilityReqBO.setDetailIdList(ids);
                        }
                        FscPushYcRecvClaimBillAbilityRspBO fscPushYcRecvClaimBillAbilityRspBO = this.fscPushYcRecvClaimBillAbilityService.pushYcRecvClaimBill(abilityReqBO);
                    }
                    continue;
                }
                abilityReqBO.setDetailIdList(reDetailIds);
                FscPushYcRecvClaimBillAbilityRspBO fscPushYcRecvClaimBillAbilityRspBO = this.fscPushYcRecvClaimBillAbilityService.pushYcRecvClaimBill(abilityReqBO);
                continue;
            }
            FscPushYcRecvClaimBillAbilityRspBO fscPushYcRecvClaimBillAbilityRspBO = this.fscPushYcRecvClaimBillAbilityService.pushYcRecvClaimBill(abilityReqBO);
            if (!fscPushYcRecvClaimBillAbilityRspBO.getRespCode().equals("0000")) {
                updateVo = new FscRecvClaimPO();
                updateVo.setClaimId(claimId);
                updateVo.setStatus(Integer.valueOf(0));
                this.fscRecvClaimMapper.update(updateVo);
                log.error("\u8ba4\u9886\u5355\u5b9a\u65f6\u91cd\u65b0\u63a8\u9001\u4e1a\u8d22\u5931\u8d25\uff0cID\uff1a" + claimId + ",\u539f\u56e0\uff1a" + fscPushYcRecvClaimBillAbilityRspBO.getRespDesc());
                continue;
            }
            updateVo = new FscRecvClaimPO();
            updateVo.setClaimId(claimId);
            updateVo.setStatus(Integer.valueOf(1));
            this.fscRecvClaimMapper.update(updateVo);
        }
        return new FscClaimDetailPushYcTaskServiceRspBO();
    }
}

