/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.contract.ability.FscFinanceSelectContractAmountAbilityService;
import com.tydic.contract.ability.bo.FscFinanceSelectContractAmountReqBO;
import com.tydic.contract.ability.bo.FscFinanceSelectContractAmountRspBo;
import com.tydic.contract.ability.bo.FscFinanceSelectContractAmountRspBoList;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscUnifyInvoiceAccessBO;
import com.tydic.fsc.bo.OrderInvoiceBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.FscComRefundDetailAbilityService;
import com.tydic.fsc.common.ability.bo.FscComRefundDetailAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComRefundDetailAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscContractInfoBO;
import com.tydic.fsc.common.ability.bo.FscDetailOrderRefundQualityBO;
import com.tydic.fsc.common.ability.bo.FscRefundChangeBO;
import com.tydic.fsc.common.ability.bo.FscRefundFinanceBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscInvoiceRefundRelationMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscRefundChangeMapper;
import com.tydic.fsc.dao.FscRefundFinanceMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscInvoiceRefundRelationPO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscRefundFinancePO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscComRefundDetailAbilityService"})
public class FscComRefundDetailAbilityServiceImpl
implements FscComRefundDetailAbilityService {
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscRefundChangeMapper fscRefundChangeMapper;
    @Autowired
    private FscRefundFinanceMapper fscRefundFinanceMapper;
    @Autowired
    private FscFinanceSelectContractAmountAbilityService fscFinanceSelectContractAmountAbilityService;
    @Autowired
    private FscInvoiceRefundRelationMapper fscInvoiceRefundRelationMapper;

    @PostMapping(value={"qryRefundDetail"})
    public FscComRefundDetailAbilityRspBO qryRefundDetail(@RequestBody FscComRefundDetailAbilityReqBO reqBO) {
        this.valid(reqBO);
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(reqBO.getRefundId());
        refundPO = this.fscOrderRefundMapper.getModelBy(refundPO);
        if (refundPO == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u9000\u7968\u4e3b\u5355\u4fe1\u606f\uff01");
        }
        FscComRefundDetailAbilityRspBO rspBO = (FscComRefundDetailAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)refundPO), FscComRefundDetailAbilityRspBO.class);
        if (refundPO.getOrderFlow().equals(FscConstants.OrderFlow.REFUND_INVOICE) || refundPO.getOrderFlow().equals(FscConstants.OrderFlow.TRAFFIC_REFUND_INVOICE)) {
            this.qryRefundInvoice(rspBO, refundPO);
        } else {
            this.qryRefundPay(rspBO, refundPO);
        }
        if (refundPO.getIsQuality() != null && FscConstants.IsQuality.YES.equals(refundPO.getIsQuality())) {
            this.qryQuality(reqBO, rspBO);
        }
        if (rspBO.getIsQuality() != null) {
            Map qualityMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_IS_EQUIP_PURCHASE");
            rspBO.setIsQualityStr((String)qualityMap.get(rspBO.getIsQuality() + ""));
        }
        this.qryRefundInfo(rspBO, refundPO);
        this.qryContract(rspBO, refundPO);
        this.qryInvoiceRefundRelation(rspBO, refundPO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void qryInvoiceRefundRelation(FscComRefundDetailAbilityRspBO rspBO, FscOrderRefundPO refundPO) {
        FscInvoiceRefundRelationPO invoiceRefundRelationPO = new FscInvoiceRefundRelationPO();
        invoiceRefundRelationPO.setRefundId(refundPO.getRefundId());
        List invoiceList = this.fscInvoiceRefundRelationMapper.getInvoiceList(invoiceRefundRelationPO);
        if (!CollectionUtils.isEmpty((Collection)invoiceList)) {
            Set invoiceStatus = invoiceList.stream().map(FscInvoiceRefundRelationPO::getInvoiceStatus).collect(Collectors.toSet());
            rspBO.setInvoiceStatusList(invoiceStatus);
        }
    }

    private void qryContract(FscComRefundDetailAbilityRspBO rspBO, FscOrderRefundPO refundPO) {
        if (refundPO.getFscOrderId() == null) {
            return;
        }
        FscOrderRelationPO relationPO = new FscOrderRelationPO();
        relationPO.setRefundId(refundPO.getRefundId());
        List contractInfoList = this.fscOrderRelationMapper.getList(relationPO);
        if (!CollectionUtils.isEmpty((Collection)contractInfoList)) {
            HashMap<Long, FscOrderRelationPO> fscOrderRelationPOMap = new HashMap<Long, FscOrderRelationPO>();
            ArrayList<Long> contractIds = new ArrayList<Long>();
            for (FscOrderRelationPO orderRelationPO : contractInfoList) {
                fscOrderRelationPOMap.put(orderRelationPO.getContractId(), orderRelationPO);
                contractIds.add(orderRelationPO.getContractId());
            }
            ArrayList contractAmountList = new ArrayList();
            if (!CollectionUtils.isEmpty(contractIds)) {
                FscFinanceSelectContractAmountReqBO selectContractAmountReqBO = new FscFinanceSelectContractAmountReqBO();
                selectContractAmountReqBO.setContractIds(contractIds);
                FscFinanceSelectContractAmountRspBo contractAmountRspBo = this.fscFinanceSelectContractAmountAbilityService.selectContractAmount(selectContractAmountReqBO);
                contractAmountList.addAll(contractAmountRspBo.getRows());
                if (!contractAmountRspBo.getRespCode().equals("0000")) {
                    throw new FscBusinessException("198888", contractAmountRspBo.getRespDesc());
                }
            }
            if (!CollectionUtils.isEmpty(fscOrderRelationPOMap)) {
                ArrayList contractList = new ArrayList();
                fscOrderRelationPOMap.forEach((key, val) -> {
                    FscContractInfoBO fscContractInfoBO = new FscContractInfoBO();
                    BeanUtils.copyProperties((Object)val, (Object)fscContractInfoBO);
                    fscContractInfoBO.setContractId(key);
                    fscContractInfoBO.setContractCode(val.getContractNo());
                    FscFinanceSelectContractAmountRspBoList contractAmountRspBo = contractAmountList.stream().filter(item -> Objects.equals(item.getContractId(), key)).findFirst().orElse(new FscFinanceSelectContractAmountRspBoList());
                    fscContractInfoBO.setContractAmount(contractAmountRspBo.getContractAmount());
                    fscContractInfoBO.setOrderNum(Integer.valueOf((int)contractInfoList.stream().filter(item -> Objects.equals(item.getContractId(), key)).count()));
                    contractList.add(fscContractInfoBO);
                });
                rspBO.setContractList(contractList);
            }
        }
    }

    private void qryQuality(FscComRefundDetailAbilityReqBO reqBO, FscComRefundDetailAbilityRspBO rspBO) {
        FscOrderRelationPO qryFscOrderRelationPO = new FscOrderRelationPO();
        qryFscOrderRelationPO.setRefundId(reqBO.getRefundId());
        List qryFscOrderRelationPOList = this.fscOrderRelationMapper.getListNoPage(qryFscOrderRelationPO);
        if (!CollectionUtils.isEmpty((Collection)qryFscOrderRelationPOList)) {
            ArrayList<FscDetailOrderRefundQualityBO> qualityBOS = new ArrayList<FscDetailOrderRefundQualityBO>();
            for (FscOrderRelationPO fscOrderRelationPO : qryFscOrderRelationPOList) {
                if (fscOrderRelationPO.getQualityDate() == null || fscOrderRelationPO.getQualityAmt() == null) continue;
                FscDetailOrderRefundQualityBO qualityBO = new FscDetailOrderRefundQualityBO();
                qualityBO.setAbnormalId(fscOrderRelationPO.getAbnormalVoucherId());
                qualityBO.setAbnormalVoucherNo(fscOrderRelationPO.getAbnormalVoucherNo());
                qualityBO.setOrderNo(fscOrderRelationPO.getOrderNo());
                qualityBO.setQualityAmt(fscOrderRelationPO.getQualityAmt());
                qualityBO.setQualityDate(fscOrderRelationPO.getQualityDate());
                qualityBOS.add(qualityBO);
            }
            rspBO.setQualityBOS(qualityBOS);
        }
    }

    private void qryRefundInvoice(FscComRefundDetailAbilityRspBO rspBO, FscOrderRefundPO refundPO) {
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(refundPO.getFscOrderId());
        orderPO = this.fscOrderMapper.getModelBy(orderPO);
        if (orderPO == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u4fe1\u606f\uff01");
        }
        rspBO.setCreateOperId(orderPO.getCreateOperId());
        rspBO.setCreateUserName(orderPO.getCreateOperName());
        FscOrderRelationPO relationPO = new FscOrderRelationPO();
        relationPO.setFscOrderId(refundPO.getFscOrderId());
        int orderNum = this.fscOrderRelationMapper.getCheckBy(relationPO);
        rspBO.setOrderNum(Integer.valueOf(orderNum));
        FscOrderItemPO orderItemPO = this.fscOrderItemMapper.getSumAmt(refundPO.getFscOrderId());
        rspBO.setTaxAmt(orderItemPO.getTaxAmt());
        rspBO.setUntaxAmt(orderItemPO.getAmt().subtract(orderItemPO.getTaxAmt()));
        FscOrderInvoicePO orderInvoicePO = new FscOrderInvoicePO();
        orderInvoicePO.setFscOrderId(refundPO.getFscOrderId());
        orderInvoicePO = this.fscOrderInvoiceMapper.getModelBy(orderInvoicePO);
        OrderInvoiceBO orderInvoiceBO = (OrderInvoiceBO)JSON.parseObject((String)JSON.toJSONString((Object)orderInvoicePO), OrderInvoiceBO.class);
        Map InvoiceCategoryMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_INVOICE_CATEGORY");
        Map invoiceTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_INVOICE_TYPE");
        if (!StringUtils.isEmpty((Object)orderInvoicePO.getInvoiceCategory())) {
            orderInvoiceBO.setInvoiceCategoryStr((String)InvoiceCategoryMap.get(String.valueOf(orderInvoicePO.getInvoiceCategory())));
        }
        if (!StringUtils.isEmpty((Object)orderInvoicePO.getInvoiceType())) {
            orderInvoiceBO.setInvoiceTypeStr((String)invoiceTypeMap.get(orderInvoicePO.getInvoiceType()));
        }
        rspBO.setOrderInvoiceInfo(orderInvoiceBO);
        rspBO.setSignOperName(orderInvoicePO.getSignOperName());
        rspBO.setSignTime(orderInvoicePO.getSignTime());
        Map pushStatusMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_REFUND_PUSH_STATUS");
        Map certificationMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_CERTIFICATION_STATUS");
        Map refundStatusMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_REFUND_STATUS");
        Map orderTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_TYPE");
        rspBO.setPushStatusStr((String)pushStatusMap.get(refundPO.getPushStatus() + ""));
        rspBO.setRefundStatusStr((String)refundStatusMap.get(refundPO.getRefundStatus() + ""));
        rspBO.setCertificationStr((String)certificationMap.get(refundPO.getCertification() + ""));
        rspBO.setOrderTypeStr((String)orderTypeMap.get(refundPO.getOrderType() + ""));
        rspBO.setPostingStatus(refundPO.getPostStatus() + "");
        rspBO.setPostingStatusStr(Objects.nonNull(refundPO.getPostStatus()) && refundPO.getPostStatus() == 1 ? "\u5df2\u8fc7\u8d26" : "\u672a\u8fc7\u8d26");
        List fscInvoiceList = this.fscInvoiceMapper.getInvoiceByRefundId(refundPO.getRefundId());
        ArrayList<FscUnifyInvoiceAccessBO> unifyInvoiceAccessList = new ArrayList<FscUnifyInvoiceAccessBO>();
        if (!CollectionUtils.isEmpty((Collection)fscInvoiceList)) {
            StringBuilder invoiceNo = new StringBuilder();
            StringBuilder invoiceCode = new StringBuilder();
            ArrayList invoiceIds = new ArrayList();
            for (FscInvoicePO fscInvoicePO : fscInvoiceList) {
                invoiceNo.append(fscInvoicePO.getInvoiceNo()).append(",");
                invoiceCode.append(fscInvoicePO.getInvoiceCode()).append(",");
                invoiceIds.add(fscInvoicePO.getInvoiceId());
            }
            if (!StringUtils.isEmpty((Object)invoiceNo.toString())) {
                if (invoiceNo.toString().endsWith(",")) {
                    rspBO.setInvoiceNo(invoiceNo.substring(0, invoiceNo.toString().length() - 1));
                } else {
                    rspBO.setInvoiceNo(invoiceNo.toString());
                }
            }
            if (!StringUtils.isEmpty((Object)invoiceCode.toString())) {
                if (invoiceCode.toString().endsWith(",")) {
                    rspBO.setInvoiceCode(invoiceCode.substring(0, invoiceCode.toString().length() - 1));
                } else {
                    rspBO.setInvoiceCode(invoiceCode.toString());
                }
            }
            rspBO.setHaveInvoiceIds((List)invoiceIds);
        }
        FscInvoicePO fscInvoicePO = new FscInvoicePO();
        fscInvoicePO.setRefundId(refundPO.getRefundId());
        List listNoStatus = this.fscInvoiceMapper.getListNoStatus(fscInvoicePO);
        if (!CollectionUtils.isEmpty((Collection)listNoStatus)) {
            for (FscInvoicePO invoicePO : listNoStatus) {
                FscUnifyInvoiceAccessBO invoiceAccessBO = new FscUnifyInvoiceAccessBO();
                invoiceAccessBO.setAttachmentName(invoicePO.getUnifyInvoiceAccessName());
                invoiceAccessBO.setAttachmentUrl(invoicePO.getUnifyInvoiceAccessUrl());
                invoiceAccessBO.setInvoiceId(invoicePO.getInvoiceId());
                invoiceAccessBO.setInvoiceNum(invoicePO.getInvoiceNo());
                invoiceAccessBO.setUnifyInvoiceId(invoicePO.getUnifyInvoiceId());
                unifyInvoiceAccessList.add(invoiceAccessBO);
            }
        }
        rspBO.setUnifyInvoiceAccessList(unifyInvoiceAccessList);
        FscAttachmentPO attachmentPO = new FscAttachmentPO();
        attachmentPO.setFscOrderId(refundPO.getRefundId());
        attachmentPO.setObjType(FscConstants.AttachmentObjType.REFUND_INVOICE);
        List list = this.fscAttachmentMapper.getList(attachmentPO);
        ArrayList<AttachmentBO> fileList = new ArrayList<AttachmentBO>(list.size());
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (FscAttachmentPO fscAttachmentPO : list) {
                AttachmentBO attachmentBO = new AttachmentBO();
                BeanUtils.copyProperties((Object)fscAttachmentPO, (Object)attachmentBO);
                fileList.add(attachmentBO);
            }
        }
        rspBO.setAttachmentList(fileList);
        List fscRefundChangePOS = this.fscRefundChangeMapper.queryByRefundId(refundPO.getRefundId());
        if (!CollectionUtils.isEmpty((Collection)fscRefundChangePOS)) {
            rspBO.setClaimChangeBOS(JSONArray.parseArray((String)JSONObject.toJSONString((Object)fscRefundChangePOS), FscRefundChangeBO.class));
        }
    }

    private void qryRefundPay(FscComRefundDetailAbilityRspBO rspBO, FscOrderRefundPO refundPO) {
    }

    private void qryRefundInfo(FscComRefundDetailAbilityRspBO rspBO, FscOrderRefundPO refundPO) {
        Map refundTypeMap = Objects.equals(refundPO.getSettlePlatform(), FscConstants.SettlePlatform.FINANCE) ? this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_REFUND_REASON_TYPE") : this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_REFUND_REASON");
        rspBO.setRefundNo(refundPO.getRefundNo());
        rspBO.setAgentUserId(String.valueOf(refundPO.getAgentUserId()));
        rspBO.setAgentUserName(refundPO.getAgentUserName());
        rspBO.setCertification(refundPO.getCertification());
        rspBO.setRefundReason(refundPO.getRefundReason());
        rspBO.setRefundReasonType(refundPO.getRefundReasonType());
        rspBO.setRefundReasonTypeStr((String)refundTypeMap.get(refundPO.getRefundReasonType() + ""));
        rspBO.setRefundNote(refundPO.getRefundNote());
        FscRefundFinancePO refundFinancePO = new FscRefundFinancePO();
        refundFinancePO.setRefundId(refundPO.getRefundId());
        FscRefundFinancePO modelBy = this.fscRefundFinanceMapper.getModelBy(refundFinancePO);
        if (Objects.nonNull(modelBy)) {
            FscRefundFinanceBO refundFinanceBO = new FscRefundFinanceBO();
            BeanUtils.copyProperties((Object)modelBy, (Object)refundFinanceBO);
            rspBO.setRefundFinanceBO(refundFinanceBO);
        }
    }

    private void valid(FscComRefundDetailAbilityReqBO reqBO) {
        if (reqBO.getRefundId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

