/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.tydic.fsc.common.ability.api.FscContractBackPushAbilityService;
import com.tydic.fsc.common.ability.bo.FscContractBackPushAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscContractBackPushAbilityRspBO;
import com.tydic.fsc.common.busi.api.FscPushContractBusiService;
import com.tydic.fsc.common.busi.bo.FscPushContractBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscPushContractPayBusiReqBO;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscContractBackPushAbilityService"})
public class FscContractBackPushAbilityServiceImpl
implements FscContractBackPushAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscContractBackPushAbilityServiceImpl.class);
    @Resource
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscPushContractBusiService fscPushContractBusiService;
    @Resource
    private FscOrderItemMapper fscOrderItemMapper;
    @Resource
    private FscShouldPayMapper fscShouldPayMapper;

    @PostMapping(value={"dealContractBackPush"})
    public FscContractBackPushAbilityRspBO dealContractBackPush(@RequestBody FscContractBackPushAbilityReqBO reqBO) {
        List fscOrderIds;
        if (!CollectionUtils.isEmpty((Collection)reqBO.getOrderIdList()) && !CollectionUtils.isEmpty((Collection)(fscOrderIds = this.fscOrderMapper.getAlreadyHtNodeFscOrderId(reqBO.getOrderIdList())))) {
            for (Long fscOrderId : fscOrderIds) {
                FscPushContractBusiReqBO busiReqBO = new FscPushContractBusiReqBO();
                busiReqBO.setFscOrderId(fscOrderId);
                busiReqBO.setIsContractBack(1);
                try {
                    this.fscPushContractBusiService.dealPushContract(busiReqBO);
                }
                catch (Exception e) {
                    log.error("\u5408\u540c\u56de\u8c03\u63a8\u9001\u7ed3\u7b97\u5355\u63a5\u53e3\u5f02\u5e38" + e.getMessage());
                }
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getOrderIdList())) {
            List payFscByOrderIds;
            List payFscOrderIds;
            HashSet payFscOrderIdSet = new HashSet();
            List fscOrderIds2 = this.fscOrderItemMapper.getFscByOrderIds(reqBO.getOrderIdList());
            if (!CollectionUtils.isEmpty((Collection)fscOrderIds2) && !CollectionUtils.isEmpty((Collection)(payFscOrderIds = this.fscShouldPayMapper.getShouldPayFscByFscOrderIds(fscOrderIds2)))) {
                payFscOrderIdSet.addAll(payFscOrderIds);
            }
            if (!CollectionUtils.isEmpty((Collection)(payFscByOrderIds = this.fscShouldPayMapper.getPayFscByOrderIds(reqBO.getOrderIdList())))) {
                payFscOrderIdSet.addAll(payFscByOrderIds);
            }
            if (!CollectionUtils.isEmpty(payFscOrderIdSet)) {
                for (Long fscOrderId : payFscOrderIdSet) {
                    FscPushContractPayBusiReqBO busiReqBO = new FscPushContractPayBusiReqBO();
                    busiReqBO.setFscOrderId(fscOrderId);
                    busiReqBO.setIsContractBack(1);
                    try {
                        this.fscPushContractBusiService.dealPushContractPay(busiReqBO);
                    }
                    catch (Exception e) {
                        log.error("\u5408\u540c\u56de\u8c03\u63a8\u9001\u4ed8\u6b3e\u5355\u63a5\u53e3\u5f02\u5e38" + e.getMessage());
                    }
                }
            }
        }
        FscContractBackPushAbilityRspBO rspBO = new FscContractBackPushAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

