/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.bo.FscComOrderListBO;
import com.tydic.fsc.common.ability.api.FscDownPayVerificationAbilityService;
import com.tydic.fsc.common.ability.bo.FscPayVerificationAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPayVerificationAbilityRspBO;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.payVerificationSelectedPO;
import com.tydic.fsc.utils.BigDecimalConvert;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscDownPayVerificationAbilityService"})
public class FscDownPayVerificationAbilityServiceImpl
implements FscDownPayVerificationAbilityService {
    @Autowired
    private FscOrderMapper fscOrderMapper;

    @BigDecimalConvert(value=2)
    @PostMapping(value={"queryDownPayVerificationPageList"})
    public FscPayVerificationAbilityRspBO queryDownPayVerificationPageList(@RequestBody FscPayVerificationAbilityReqBO reqBO) {
        if (reqBO.getFscOrderId() == null && CollectionUtils.isEmpty((Collection)reqBO.getOrderIdList())) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u7ed3\u7b97\u5355id[fscOrderId]\u548c\u8ba2\u5355id\u96c6\u5408[orderIdList]\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getPageNo() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2[pageNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getPageSize() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2[pageSize]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscPayVerificationAbilityRspBO rspBO = new FscPayVerificationAbilityRspBO();
        List orderIds = reqBO.getOrderIdList();
        if (CollectionUtils.isEmpty((Collection)orderIds) && CollectionUtils.isEmpty((Collection)(orderIds = this.fscOrderMapper.selectOrderIds(reqBO.getFscOrderId(), reqBO.getContractId())))) {
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setRecordsTotal(Integer.valueOf(0));
            rspBO.setTotal(Integer.valueOf(0));
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        FscOrderPO queryVo = new FscOrderPO();
        queryVo.setPayTimeStart(reqBO.getPayTimeStart());
        queryVo.setPayTimeEnd(reqBO.getPayTimeEnd());
        queryVo.setOrderNo(reqBO.getOrderNo());
        queryVo.setPayOperName(reqBO.getPayOperName());
        queryVo.setPayAmountStart(reqBO.getPayAmountStart());
        queryVo.setPayAmountEnd(reqBO.getPayAmountEnd());
        queryVo.setOrderIds(orderIds);
        queryVo.setSelectedOrderNos(reqBO.getSelectedOrderNos());
        queryVo.setPayerName(reqBO.getPayerName());
        queryVo.setOrderCodeStr(reqBO.getOrderCode());
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSelectedBos())) {
            List collect = reqBO.getSelectedBos().stream().map(e -> {
                payVerificationSelectedPO po = new payVerificationSelectedPO();
                po.setShouldPayId(e.getShouldPayId());
                po.setFscOrderId(e.getFscOrderId());
                return po;
            }).collect(Collectors.toList());
            queryVo.setPayVerificationSelectedPOS(collect);
        }
        List orderList = this.fscOrderMapper.selectDownPrePayVerification(queryVo, page);
        ArrayList<FscComOrderListBO> orderInfoList = new ArrayList<FscComOrderListBO>(orderList.size());
        for (FscOrderPO fscOrderPo : orderList) {
            FscComOrderListBO infoBo = new FscComOrderListBO();
            BeanUtils.copyProperties((Object)fscOrderPo, (Object)infoBo);
            infoBo.setShouldPaidAmount(BigDecimal.ZERO);
            if (fscOrderPo.getPaidAmount() != null && fscOrderPo.getPaidAmount().compareTo(fscOrderPo.getPayAmount()) >= 0) {
                infoBo.setShouldPaidAmount(fscOrderPo.getPayAmount());
            }
            infoBo.setPaidAmount((fscOrderPo.getPaidAmount() != null ? fscOrderPo.getPaidAmount() : BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP));
            infoBo.setShouldPayAmount((fscOrderPo.getShouldPayAmount() != null ? fscOrderPo.getShouldPayAmount() : BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP));
            orderInfoList.add(infoBo);
        }
        rspBO.setRows(orderInfoList);
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @BigDecimalConvert(value=2)
    @PostMapping(value={"queryDownPayVerificationEgPageList"})
    public FscPayVerificationAbilityRspBO queryDownPayVerificationEgPageList(@RequestBody FscPayVerificationAbilityReqBO reqBO) {
        if (reqBO.getContractId() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u5408\u540cid[contractId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getPageNo() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2[pageNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getPageSize() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2[pageSize]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscPayVerificationAbilityRspBO rspBO = new FscPayVerificationAbilityRspBO();
        List orderIds = reqBO.getOrderIdList();
        if (CollectionUtils.isEmpty((Collection)orderIds) && CollectionUtils.isEmpty((Collection)(orderIds = this.fscOrderMapper.selectOrderIdsEg(reqBO.getContractId())))) {
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setRecordsTotal(Integer.valueOf(0));
            rspBO.setTotal(Integer.valueOf(0));
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        FscOrderPO queryVo = new FscOrderPO();
        queryVo.setPayTimeStart(reqBO.getPayTimeStart());
        queryVo.setPayTimeEnd(reqBO.getPayTimeEnd());
        queryVo.setOrderNo(reqBO.getOrderNo());
        queryVo.setPayOperName(reqBO.getPayOperName());
        queryVo.setPayAmountStart(reqBO.getPayAmountStart());
        queryVo.setPayAmountEnd(reqBO.getPayAmountEnd());
        queryVo.setOrderIds(orderIds);
        queryVo.setSelectedOrderNos(reqBO.getSelectedOrderNos());
        queryVo.setPayerName(reqBO.getPayerName());
        queryVo.setOrderCodeStr(reqBO.getOrderCode());
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSelectedBos())) {
            List collect = reqBO.getSelectedBos().stream().map(e -> {
                payVerificationSelectedPO po = new payVerificationSelectedPO();
                po.setShouldPayId(e.getShouldPayId());
                po.setFscOrderId(e.getFscOrderId());
                return po;
            }).collect(Collectors.toList());
            queryVo.setPayVerificationSelectedPOS(collect);
        }
        List orderList = this.fscOrderMapper.selectDownPrePayVerificationEg(queryVo, page);
        ArrayList<FscComOrderListBO> orderInfoList = new ArrayList<FscComOrderListBO>(orderList.size());
        for (FscOrderPO fscOrderPo : orderList) {
            FscComOrderListBO infoBo = new FscComOrderListBO();
            BeanUtils.copyProperties((Object)fscOrderPo, (Object)infoBo);
            infoBo.setShouldPaidAmount(BigDecimal.ZERO);
            if (fscOrderPo.getPaidAmount() != null && fscOrderPo.getPaidAmount().compareTo(fscOrderPo.getPayAmount()) >= 0) {
                infoBo.setShouldPaidAmount(fscOrderPo.getPayAmount());
            }
            infoBo.setPaidAmount((fscOrderPo.getPaidAmount() != null ? fscOrderPo.getPaidAmount() : BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP));
            infoBo.setShouldPayAmount((fscOrderPo.getShouldPayAmount() != null ? fscOrderPo.getShouldPayAmount() : BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP));
            orderInfoList.add(infoBo);
        }
        rspBO.setRows(orderInfoList);
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

