/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscEngineeringRefundPayApprovalAbilityService;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscEngineeringRefundPayApprovalAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscEngineeringRefundPayApprovalAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscFinancePayRefundApprovalReqBankStatementAbilityBO;
import com.tydic.fsc.common.ability.bo.FscFinancePayRefundApprovalReqDraftInfoAbilityBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinancePushRefundPayAbilityReqBO;
import com.tydic.fsc.common.busi.api.FscEngineeringRefundPayApprovalBusiService;
import com.tydic.fsc.common.busi.bo.FscEngineeringRefundPayApprovalBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscEngineeringRefundPayApprovalBusiRspBO;
import com.tydic.fsc.dao.FscFinanceBankStatementTempMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoTempMapper;
import com.tydic.fsc.dao.FscFinanceRefundItemMapper;
import com.tydic.fsc.dao.FscRefundFinanceMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscFinanceBankStatementTempPO;
import com.tydic.fsc.po.FscFinanceDraftInfoTempPO;
import com.tydic.fsc.po.FscFinanceRefundItemPO;
import com.tydic.fsc.po.FscRefundFinancePO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscEngineeringRefundPayApprovalAbilityService"})
public class FscEngineeringRefundPayApprovalAbilityServiceImpl
implements FscEngineeringRefundPayApprovalAbilityService {
    @Autowired
    private FscRefundFinanceMapper fscRefundFinanceMapper;
    @Autowired
    private FscFinanceRefundItemMapper fscFinanceRefundItemMapper;
    @Autowired
    private FscFinanceDraftInfoTempMapper fscFinanceDraftInfoTempMapper;
    @Autowired
    private FscFinanceBankStatementTempMapper fscFinanceBankStatementTempMapper;
    @Autowired
    private FscEngineeringRefundPayApprovalBusiService fscEngineeringRefundPayApprovalBusiService;
    @Autowired
    private FscComRefundSyncAbilityService fscComRefundSyncAbilityService;
    @Value(value="${es.FSC_PUSH_FINANCE_REFUND_PAY_TOPIC:FSC_PUSH_FINANCE_REFUND_PAY_TOPIC}")
    private String fscPushFinanceRefundPayTopic;
    @Value(value="${es.FSC_PUSH_FINANCE_REFUND_PAY_TAG:FSC_PUSH_FINANCE_REFUND_PAY_TAG}")
    private String fscPushFinanceRefundPayTag;
    @Resource(name="fscPushFinanceRefundPayListMqServiceProvider")
    private ProxyMessageProducer fscPushFinanceRefundPayListMqServiceProvider;

    @PostMapping(value={"dealEngineeringRefundPayApproval"})
    public FscEngineeringRefundPayApprovalAbilityRspBO dealEngineeringRefundPayApproval(@RequestBody FscEngineeringRefundPayApprovalAbilityReqBO reqBO) {
        FscEngineeringRefundPayApprovalAbilityRspBO rspBO = new FscEngineeringRefundPayApprovalAbilityRspBO();
        this.verifyParam(reqBO);
        for (Long thisRefundId : reqBO.getRefundIds()) {
            this.thisRefundVerifyParam(thisRefundId, reqBO);
            FscEngineeringRefundPayApprovalBusiReqBO fscFinancePayRefundApprovalBusiReqBO = (FscEngineeringRefundPayApprovalBusiReqBO)((Object)JUtil.js((Object)reqBO, FscEngineeringRefundPayApprovalBusiReqBO.class));
            fscFinancePayRefundApprovalBusiReqBO.setRefundId(thisRefundId);
            FscEngineeringRefundPayApprovalBusiRspBO fscEngineeringRefundPayApprovalBusiRspBO = this.fscEngineeringRefundPayApprovalBusiService.dealEngineeringRefundPayApproval(fscFinancePayRefundApprovalBusiReqBO);
            if (!"0000".equals(fscEngineeringRefundPayApprovalBusiRspBO.getRespCode())) {
                return (FscEngineeringRefundPayApprovalAbilityRspBO)JUtil.js((Object)((Object)fscEngineeringRefundPayApprovalBusiRspBO), FscEngineeringRefundPayApprovalAbilityRspBO.class);
            }
            if (!CollectionUtils.isEmpty(fscEngineeringRefundPayApprovalBusiRspBO.getRefundIds())) {
                for (Long refundId : fscEngineeringRefundPayApprovalBusiRspBO.getRefundIds()) {
                    FscFinancePushRefundPayAbilityReqBO abilityReqBO = new FscFinancePushRefundPayAbilityReqBO();
                    abilityReqBO.setRefundId(refundId);
                    this.fscPushFinanceRefundPayListMqServiceProvider.send(new ProxyMessage(this.fscPushFinanceRefundPayTopic, this.fscPushFinanceRefundPayTag, JSONObject.toJSONString((Object)abilityReqBO)));
                }
            }
            this.syncEs(thisRefundId);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void syncEs(Long thisRefundId) {
        ArrayList<Long> refundIds = new ArrayList<Long>(1);
        refundIds.add(thisRefundId);
        FscComRefundSyncAbilityReqBO refundSyncAbilityReqBO = new FscComRefundSyncAbilityReqBO();
        refundSyncAbilityReqBO.setRefundIds(refundIds);
        this.fscComRefundSyncAbilityService.syncRefund(refundSyncAbilityReqBO);
    }

    private FscRefundFinancePO getRefundFinanceInfo(Long thisRefundId) {
        FscRefundFinancePO qryFscRefundFinance = new FscRefundFinancePO();
        qryFscRefundFinance.setRefundId(thisRefundId);
        FscRefundFinancePO fscRefundFinancePO = this.fscRefundFinanceMapper.getModelBy(qryFscRefundFinance);
        if (ObjectUtil.isEmpty((Object)fscRefundFinancePO)) {
            throw new FscBusinessException("198888", "\u9006\u5411\u51b2\u9500\u5bf9\u63a5\u8d22\u52a1\u5171\u4eab\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        return fscRefundFinancePO;
    }

    private void verifyParam(FscEngineeringRefundPayApprovalAbilityReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getRefundIds())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[refundIds]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getAuditResult())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[auditResult]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getRefundFlag())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[refundFlag]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getRefundFlag() != 1 && reqBO.getRefundFlag() != 2) {
            throw new FscBusinessException("191000", "\u5165\u53c2[refundFlag]\u53c2\u6570\u7c7b\u578b\u9519\u8bef");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getBankStatementList()) || !CollectionUtils.isEmpty((Collection)reqBO.getDraftInfoList())) {
            if (ObjectUtil.isEmpty((Object)reqBO.getCashItemCode())) {
                throw new FscBusinessException("191000", "\u5165\u53c2[cashItemCode]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBO.getCashItemName())) {
                throw new FscBusinessException("191000", "\u5165\u53c2[cashItemName]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBO.getIsAgent())) {
                throw new FscBusinessException("191000", "\u5165\u53c2[isAgent]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (reqBO.getIsAgent() != 0 && reqBO.getIsAgent() != 1) {
                throw new FscBusinessException("191000", "\u5165\u53c2[isAgent]\u53c2\u6570\u7c7b\u578b\u9519\u8bef");
            }
            if (1 == reqBO.getIsAgent()) {
                if (ObjectUtil.isEmpty((Object)reqBO.getAgentCompanyCode())) {
                    throw new FscBusinessException("191000", "\u5165\u53c2[agentCompanyCode]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (ObjectUtil.isEmpty((Object)reqBO.getAgentCompanyName())) {
                    throw new FscBusinessException("191000", "\u5165\u53c2[agentCompanyName]\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
        }
    }

    private void thisRefundVerifyParam(Long thisRefundId, FscEngineeringRefundPayApprovalAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getBankStatementList()) && CollectionUtils.isEmpty((Collection)reqBO.getDraftInfoList())) {
            return;
        }
        FscRefundFinancePO refundFinanceInfo = this.getRefundFinanceInfo(thisRefundId);
        if (reqBO.getRefundFlag() == 1) {
            if ("TKLX0001".equals(refundFinanceInfo.getRefundPayMethod())) {
                if (CollectionUtils.isEmpty((Collection)reqBO.getBankStatementList())) {
                    throw new FscBusinessException("191000", "\u5165\u53c2[bankStatementList]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                for (FscFinancePayRefundApprovalReqBankStatementAbilityBO bankStatementBO : reqBO.getBankStatementList()) {
                    if (ObjectUtil.isEmpty((Object)bankStatementBO.getRefundId())) {
                        throw new FscBusinessException("191000", "\u5165\u53c2[bankStatementList]\u4e2d[refundId]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (ObjectUtil.isEmpty((Object)bankStatementBO.getRefundDetailId())) {
                        throw new FscBusinessException("191000", "\u5165\u53c2[bankStatementList]\u4e2d[refundDetailId]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (ObjectUtil.isEmpty((Object)bankStatementBO.getRefundShouldPayId())) {
                        throw new FscBusinessException("191000", "\u5165\u53c2[bankStatementList]\u4e2d[refundShouldPayId]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (ObjectUtil.isEmpty((Object)bankStatementBO.getFinanceRefundItemId())) {
                        throw new FscBusinessException("191000", "\u5165\u53c2[bankStatementList]\u4e2d[financeRefundItemId]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (ObjectUtil.isEmpty((Object)bankStatementBO.getOccAmt())) {
                        throw new FscBusinessException("191000", "\u5165\u53c2[bankStatementList]\u4e2d[occAmt]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (!ObjectUtil.isEmpty((Object)bankStatementBO.getOccAmtLocal())) continue;
                    throw new FscBusinessException("191000", "\u5165\u53c2[bankStatementList]\u4e2d[occAmtLocal]\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
            if ("TKLX0002".equals(refundFinanceInfo.getRefundPayMethod()) || "TKLX0003".equals(refundFinanceInfo.getRefundPayMethod())) {
                if (CollectionUtils.isEmpty((Collection)reqBO.getDraftInfoList())) {
                    throw new FscBusinessException("191000", "\u5165\u53c2[draftInfoList]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                for (FscFinancePayRefundApprovalReqDraftInfoAbilityBO draftInfoBO : reqBO.getDraftInfoList()) {
                    if (ObjectUtil.isEmpty((Object)draftInfoBO.getRefundId())) {
                        throw new FscBusinessException("191000", "\u5165\u53c2[draftInfoList]\u4e2d[refundId]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (ObjectUtil.isEmpty((Object)draftInfoBO.getRefundDetailId())) {
                        throw new FscBusinessException("191000", "\u5165\u53c2[draftInfoList]\u4e2d[refundDetailId]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (ObjectUtil.isEmpty((Object)draftInfoBO.getRefundShouldPayId())) {
                        throw new FscBusinessException("191000", "\u5165\u53c2[draftInfoList]\u4e2d[refundShouldPayId]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (ObjectUtil.isEmpty((Object)draftInfoBO.getFinanceRefundItemId())) {
                        throw new FscBusinessException("191000", "\u5165\u53c2[draftInfoList]\u4e2d[financeRefundItemId]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (ObjectUtil.isEmpty((Object)draftInfoBO.getOccAmt())) {
                        throw new FscBusinessException("191000", "\u5165\u53c2[draftInfoList]\u4e2d[occAmt]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (!ObjectUtil.isEmpty((Object)draftInfoBO.getOccAmtLocal())) continue;
                    throw new FscBusinessException("191000", "\u5165\u53c2[draftInfoList]\u4e2d[occAmtLocal]\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
            this.prepaidVerifyParam(thisRefundId, refundFinanceInfo.getRefundPayMethod(), reqBO);
        }
        if (reqBO.getRefundFlag() == 2) {
            if ("TKLX0001".equals(refundFinanceInfo.getRefundPayMethod())) {
                if (CollectionUtils.isEmpty((Collection)reqBO.getBankStatementList())) {
                    throw new FscBusinessException("191000", "\u5165\u53c2[bankStatementList]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                for (FscFinancePayRefundApprovalReqBankStatementAbilityBO bankStatementBO : reqBO.getBankStatementList()) {
                    if (!ObjectUtil.isEmpty((Object)bankStatementBO.getTempId())) continue;
                    throw new FscBusinessException("191000", "\u5165\u53c2[bankStatementList]\u4e2d[tempId]\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
            if ("TKLX0002".equals(refundFinanceInfo.getRefundPayMethod()) || "TKLX0003".equals(refundFinanceInfo.getRefundPayMethod())) {
                if (CollectionUtils.isEmpty((Collection)reqBO.getDraftInfoList())) {
                    throw new FscBusinessException("191000", "\u5165\u53c2[draftInfoList]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                for (FscFinancePayRefundApprovalReqDraftInfoAbilityBO draftInfoBO : reqBO.getDraftInfoList()) {
                    if (!ObjectUtil.isEmpty((Object)draftInfoBO.getTempId())) continue;
                    throw new FscBusinessException("191000", "\u5165\u53c2[draftInfoList]\u4e2d[tempId]\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
            this.payableVerifyParam(thisRefundId, refundFinanceInfo.getRefundPayMethod(), reqBO);
        }
    }

    private List<FscFinanceRefundItemPO> getFinanceRefundItem(Long thisRefundId) {
        FscFinanceRefundItemPO qryFscFinanceRefundItem = new FscFinanceRefundItemPO();
        qryFscFinanceRefundItem.setRefundId(thisRefundId);
        List fscFinanceRefundItemPOList = this.fscFinanceRefundItemMapper.getList(qryFscFinanceRefundItem);
        if (CollectionUtil.isEmpty((Collection)fscFinanceRefundItemPOList)) {
            throw new FscBusinessException("198888", "\u8d22\u52a1\u5171\u4eab\u9000\u6b3e\u660e\u7ec6\u4e0d\u5b58\u5728");
        }
        return fscFinanceRefundItemPOList;
    }

    private void prepaidVerifyParam(Long thisRefundId, String refundPayMethod, FscEngineeringRefundPayApprovalAbilityReqBO reqBO) {
        FscFinanceRefundItemPO fscFinanceRefundItemPO;
        BigDecimal occupyTotalOccAmt;
        List<FscFinanceRefundItemPO> financeRefundItemPOList = this.getFinanceRefundItem(thisRefundId);
        Map<Long, FscFinanceRefundItemPO> financeRefundItemMap = financeRefundItemPOList.stream().collect(Collectors.toMap(FscFinanceRefundItemPO::getFinanceRefundItemId, po -> po, (k1, k2) -> k2));
        if (!CollectionUtil.isEmpty((Collection)reqBO.getBankStatementList())) {
            Map<Long, List<FscFinancePayRefundApprovalReqBankStatementAbilityBO>> bankStatementGroupMap = reqBO.getBankStatementList().stream().collect(Collectors.groupingBy(FscFinancePayRefundApprovalReqBankStatementAbilityBO::getFinanceRefundItemId));
            for (Map.Entry<Long, List<FscFinancePayRefundApprovalReqBankStatementAbilityBO>> entry : bankStatementGroupMap.entrySet()) {
                occupyTotalOccAmt = entry.getValue().stream().map(FscFinancePayRefundApprovalReqBankStatementAbilityBO::getOccAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                fscFinanceRefundItemPO = financeRefundItemMap.get(entry.getKey());
                if (fscFinanceRefundItemPO.getRefundAmt().compareTo(occupyTotalOccAmt) == 0) continue;
                throw new FscBusinessException("198888", "\u6d41\u6c34\u8ba4\u9886\u660e\u7ec6\u5360\u7528\u91d1\u989d\u603b\u548c\u4e0e\u9000\u6b3e\u91d1\u989d\u4e0d\u4e00\u81f4");
            }
        }
        if (!CollectionUtil.isEmpty((Collection)reqBO.getDraftInfoList())) {
            Map<Long, List<FscFinancePayRefundApprovalReqDraftInfoAbilityBO>> draftInfoGroupMap = reqBO.getDraftInfoList().stream().collect(Collectors.groupingBy(FscFinancePayRefundApprovalReqDraftInfoAbilityBO::getFinanceRefundItemId));
            for (Map.Entry<Long, List<FscFinancePayRefundApprovalReqBankStatementAbilityBO>> entry : draftInfoGroupMap.entrySet()) {
                occupyTotalOccAmt = entry.getValue().stream().map(FscFinancePayRefundApprovalReqDraftInfoAbilityBO::getOccAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                fscFinanceRefundItemPO = financeRefundItemMap.get(entry.getKey());
                if (fscFinanceRefundItemPO.getRefundAmt().compareTo(occupyTotalOccAmt) == 0) continue;
                if ("TKLX0002".equals(refundPayMethod)) {
                    throw new FscBusinessException("198888", "\u7968\u636e\u8ba4\u9886\u660e\u7ec6\u5360\u7528\u91d1\u989d\u603b\u548c\u4e0e\u9000\u6b3e\u91d1\u989d\u4e0d\u4e00\u81f4");
                }
                if ("TKLX0003".equals(refundPayMethod)) {
                    throw new FscBusinessException("198888", "\u4f9b\u5e94\u94fe\u8ba4\u9886\u660e\u7ec6\u5360\u7528\u91d1\u989d\u603b\u548c\u4e0e\u9000\u6b3e\u91d1\u989d\u4e0d\u4e00\u81f4");
                }
                throw new FscBusinessException("198888", "\u8ba4\u9886\u660e\u7ec6\u5360\u7528\u91d1\u989d\u603b\u548c\u4e0e\u9000\u6b3e\u91d1\u989d\u4e0d\u4e00\u81f4");
            }
        }
    }

    private List<FscFinanceBankStatementTempPO> getFinanceBankStatementTempList(FscEngineeringRefundPayApprovalAbilityReqBO reqBO) {
        List tempIdList = reqBO.getBankStatementList().stream().map(FscFinancePayRefundApprovalReqBankStatementAbilityBO::getTempId).filter(ObjectUtil::isNotEmpty).distinct().collect(Collectors.toList());
        FscFinanceBankStatementTempPO qryFscFinanceBankStatementTemp = new FscFinanceBankStatementTempPO();
        qryFscFinanceBankStatementTemp.setTempIdList(tempIdList);
        List fscFinanceBankStatementTempPOList = this.fscFinanceBankStatementTempMapper.getList(qryFscFinanceBankStatementTemp);
        if (CollectionUtil.isEmpty((Collection)fscFinanceBankStatementTempPOList)) {
            throw new FscBusinessException("198888", "\u8d22\u52a1\u5171\u4eab\u6d41\u6c34\u4fe1\u606f\u4e34\u65f6\u6570\u636e\u4e0d\u5b58\u5728");
        }
        return fscFinanceBankStatementTempPOList;
    }

    private List<FscFinanceDraftInfoTempPO> getFinanceDraftTempList(FscEngineeringRefundPayApprovalAbilityReqBO reqBO) {
        List tempIdList = reqBO.getDraftInfoList().stream().map(FscFinancePayRefundApprovalReqDraftInfoAbilityBO::getTempId).filter(ObjectUtil::isNotEmpty).distinct().collect(Collectors.toList());
        FscFinanceDraftInfoTempPO qryFscFinanceDraftInfoTemp = new FscFinanceDraftInfoTempPO();
        qryFscFinanceDraftInfoTemp.setTempIdList(tempIdList);
        List fscFinanceDraftInfoTempPOList = this.fscFinanceDraftInfoTempMapper.getList(qryFscFinanceDraftInfoTemp);
        if (CollectionUtil.isEmpty((Collection)fscFinanceDraftInfoTempPOList)) {
            throw new FscBusinessException("198888", "\u8d22\u52a1\u5171\u4eab\u7968\u636e\u53f0\u8d26\u4fe1\u606f\u4e34\u65f6\u6570\u636e\u4e0d\u5b58\u5728");
        }
        return fscFinanceDraftInfoTempPOList;
    }

    private void payableVerifyParam(Long thisRefundId, String refundPayMethod, FscEngineeringRefundPayApprovalAbilityReqBO reqBO) {
        FscFinanceRefundItemPO fscFinanceRefundItemPO;
        BigDecimal occupyTotalOccAmt;
        List<FscFinanceRefundItemPO> financeRefundItemPOList = this.getFinanceRefundItem(thisRefundId);
        Map<Long, FscFinanceRefundItemPO> financeRefundItemMap = financeRefundItemPOList.stream().collect(Collectors.toMap(FscFinanceRefundItemPO::getFinanceRefundItemId, po -> po, (k1, k2) -> k2));
        if ("TKLX0001".equals(refundPayMethod)) {
            List<FscFinanceBankStatementTempPO> financeBankStatementTempList = this.getFinanceBankStatementTempList(reqBO);
            for (FscFinanceBankStatementTempPO fscFinanceBankStatementTempPO : financeBankStatementTempList) {
                if (ObjectUtil.isEmpty((Object)fscFinanceBankStatementTempPO.getRefundId())) {
                    throw new FscBusinessException("191000", "\u8d22\u52a1\u5171\u4eab\u6d41\u6c34\u4e2d[bankStatementList]\u4e2d[refundId]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (ObjectUtil.isEmpty((Object)fscFinanceBankStatementTempPO.getRefundDetailId())) {
                    throw new FscBusinessException("191000", "\u8d22\u52a1\u5171\u4eab\u6d41\u6c34\u4e2d[bankStatementList]\u4e2d[refundDetailId]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (ObjectUtil.isEmpty((Object)fscFinanceBankStatementTempPO.getRefundShouldPayId())) {
                    throw new FscBusinessException("191000", "\u8d22\u52a1\u5171\u4eab\u6d41\u6c34\u4e2d[bankStatementList]\u4e2d[refundShouldPayId]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (ObjectUtil.isEmpty((Object)fscFinanceBankStatementTempPO.getFinanceRefundItemId())) {
                    throw new FscBusinessException("191000", "\u8d22\u52a1\u5171\u4eab\u6d41\u6c34\u4e2d[bankStatementList]\u4e2d[financeRefundItemId]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (ObjectUtil.isEmpty((Object)fscFinanceBankStatementTempPO.getOccAmt())) {
                    throw new FscBusinessException("191000", "\u8d22\u52a1\u5171\u4eab\u6d41\u6c34\u4e2d[bankStatementList]\u4e2d[occAmt]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!ObjectUtil.isEmpty((Object)fscFinanceBankStatementTempPO.getOccAmtLocal())) continue;
                throw new FscBusinessException("191000", "\u8d22\u52a1\u5171\u4eab\u6d41\u6c34\u4e2d[bankStatementList]\u4e2d[occAmtLocal]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!CollectionUtil.isEmpty(financeBankStatementTempList)) {
                Map<Long, List<FscFinanceBankStatementTempPO>> bankStatementGroupMap = financeBankStatementTempList.stream().collect(Collectors.groupingBy(FscFinanceBankStatementTempPO::getFinanceRefundItemId));
                for (Map.Entry entry : bankStatementGroupMap.entrySet()) {
                    occupyTotalOccAmt = ((List)entry.getValue()).stream().map(FscFinanceBankStatementTempPO::getOccAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                    fscFinanceRefundItemPO = financeRefundItemMap.get(entry.getKey());
                    if (fscFinanceRefundItemPO.getRefundAmt().compareTo(occupyTotalOccAmt) == 0) continue;
                    throw new FscBusinessException("198888", "\u8ba4\u9886\u660e\u7ec6\u5360\u7528\u91d1\u989d\u603b\u548c\u4e0e\u9000\u6b3e\u91d1\u989d\u4e0d\u4e00\u81f4");
                }
            }
        }
        if ("TKLX0002".equals(refundPayMethod) || "TKLX0003".equals(refundPayMethod)) {
            List<FscFinanceDraftInfoTempPO> financeDraftTempList = this.getFinanceDraftTempList(reqBO);
            for (FscFinanceDraftInfoTempPO fscFinanceDraftInfoTempPO : financeDraftTempList) {
                if (ObjectUtil.isEmpty((Object)fscFinanceDraftInfoTempPO.getRefundId())) {
                    throw new FscBusinessException("191000", "\u8d22\u52a1\u5171\u4eab\u7968\u636e\u53f0\u8d26\u4e2d[refundId]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (ObjectUtil.isEmpty((Object)fscFinanceDraftInfoTempPO.getRefundDetailId())) {
                    throw new FscBusinessException("191000", "\u8d22\u52a1\u5171\u4eab\u7968\u636e\u53f0\u8d26\u4e2d[refundDetailId]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (ObjectUtil.isEmpty((Object)fscFinanceDraftInfoTempPO.getRefundShouldPayId())) {
                    throw new FscBusinessException("191000", "\u8d22\u52a1\u5171\u4eab\u7968\u636e\u53f0\u8d26\u4e2d[refundShouldPayId]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (ObjectUtil.isEmpty((Object)fscFinanceDraftInfoTempPO.getFinanceRefundItemId())) {
                    throw new FscBusinessException("191000", "\u8d22\u52a1\u5171\u4eab\u7968\u636e\u53f0\u8d26\u4e2d[financeRefundItemId]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (ObjectUtil.isEmpty((Object)fscFinanceDraftInfoTempPO.getOccAmt())) {
                    throw new FscBusinessException("191000", "\u8d22\u52a1\u5171\u4eab\u7968\u636e\u53f0\u8d26\u4e2d[occAmt]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!ObjectUtil.isEmpty((Object)fscFinanceDraftInfoTempPO.getOccAmtLocal())) continue;
                throw new FscBusinessException("191000", "\u8d22\u52a1\u5171\u4eab\u7968\u636e\u53f0\u8d26\u4e2d[occAmtLocal]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!CollectionUtil.isEmpty(financeDraftTempList)) {
                Map<Long, List<FscFinanceDraftInfoTempPO>> draftInfoGroupMap = financeDraftTempList.stream().collect(Collectors.groupingBy(FscFinanceDraftInfoTempPO::getFinanceRefundItemId));
                for (Map.Entry<Long, List<FscFinanceDraftInfoTempPO>> entry : draftInfoGroupMap.entrySet()) {
                    occupyTotalOccAmt = entry.getValue().stream().map(FscFinanceDraftInfoTempPO::getOccAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                    fscFinanceRefundItemPO = financeRefundItemMap.get(entry.getKey());
                    if (fscFinanceRefundItemPO.getRefundAmt().compareTo(occupyTotalOccAmt) == 0) continue;
                    throw new FscBusinessException("198888", "\u8ba4\u9886\u660e\u7ec6\u5360\u7528\u91d1\u989d\u603b\u548c\u4e0e\u9000\u6b3e\u91d1\u989d\u4e0d\u4e00\u81f4");
                }
            }
        }
    }
}

