/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.common.ability.api.FscMerchantEditAbilityService;
import com.tydic.fsc.common.ability.bo.FscMerchantEditAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscMerchantEditAbilityRspBO;
import com.tydic.fsc.common.busi.api.FscMerchantEditBusiService;
import com.tydic.fsc.common.busi.bo.FscMerchantEditBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscMerchantEditBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscMerchantEditAbilityService"})
public class FscMerchantEditAbilityServiceImpl
implements FscMerchantEditAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscMerchantEditAbilityServiceImpl.class);
    @Autowired
    private FscMerchantEditBusiService fscMerchantEditBusiService;
    private static final Integer merchantType = 1;

    @PostMapping(value={"editMerchant"})
    public FscMerchantEditAbilityRspBO editMerchant(@RequestBody FscMerchantEditAbilityReqBO reqBO) {
        if (log.isDebugEnabled()) {
            log.debug("===\u7ed3\u7b97\u5546\u6237\u7f16\u8f91\u5f00\u59cb\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        }
        FscMerchantEditAbilityRspBO retBo = new FscMerchantEditAbilityRspBO();
        String validateStr = this.validateArgs(reqBO);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            log.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a{}", (Object)validateStr);
            retBo.setRespCode("191000");
            retBo.setRespDesc(validateStr);
            return retBo;
        }
        FscMerchantEditBusiReqBO busiReqBo = new FscMerchantEditBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)busiReqBo));
        if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(busiReqBo.getPayType())) {
            if (FscConstants.MerchantPayRule.Merchant_PAY_RULE_BUSIESS_NODE.equals(busiReqBo.getPayRule())) {
                busiReqBo.setPayAccountDay(0);
            }
            if (FscConstants.MerchantPayRule.MERCHANT_PAY_RULE_SPECIFY.equals(busiReqBo.getPayRule())) {
                busiReqBo.setPayNodeAccountDays(0);
            }
        }
        FscMerchantEditBusiRspBO busiRetBo = this.fscMerchantEditBusiService.editMerchant(busiReqBo);
        BeanUtils.copyProperties((Object)((Object)busiRetBo), (Object)retBo);
        if (log.isDebugEnabled()) {
            log.debug("===\u7ed3\u7b97\u5546\u6237\u7f16\u8f91\u7ed3\u675f\uff0c\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)retBo));
        }
        return retBo;
    }

    private String validateArgs(FscMerchantEditAbilityReqBO reqBo) {
        if (null == reqBo) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getName())) {
            return "\u7528\u6237\u540d\u79f0[name]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getUserId())) {
            return "\u7528\u6237ID[userId]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == reqBo.getDealType()) {
            return "\u5904\u7406\u7c7b\u578b[dealType]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == reqBo.getOrgId()) {
            return "\u673a\u6784ID[orgId]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getOrgName())) {
            return "\u673a\u6784\u540d\u79f0[orgName]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == reqBo.getMerchantId()) {
            return "\u5546\u6237ID[merchantId]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBo.getPayFlag() != null && reqBo.getPayFlag() == 0) {
            reqBo.setPayAllowExceptionFlag(Integer.valueOf(0));
            reqBo.setPayType(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD);
            reqBo.setPayCreditAmount(new BigDecimal(0));
            reqBo.setPayBreakScale(new BigDecimal(0));
            reqBo.setPayRule(FscConstants.MerchantPayRule.Merchant_PAY_RULE_BUSIESS_NODE);
            reqBo.setPayNodeAccountDays(Integer.valueOf(90));
            reqBo.setPayNodeRule(FscConstants.MerchantPayNodeRule.SIGN);
        }
        if (null == reqBo.getExceptionFlag() || FscConstants.MerchantIsException.MERCHANT_NOT_EXCEPTION.equals(reqBo.getExceptionFlag())) {
            reqBo.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_NOT_EXCEPTION);
            return this.validateMerchantArgs(reqBo);
        }
        if (FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION.equals(reqBo.getExceptionFlag())) {
            return this.validateException(reqBo);
        }
        return "\u662f\u5426\u4f8b\u5916\u914d\u7f6e[exceptionFlag]\uff0c\u4f20\u503c\u975e\u6cd5";
    }

    private String validateException(FscMerchantEditAbilityReqBO reqBo) {
        if (null == reqBo.getParentId()) {
            return "\u7236\u8282\u70b9[parentId]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == reqBo.getExceptionUserLatitude()) {
            return "\u4f8b\u5916\u7528\u6237\u7ef4\u5ea6[exceptionUserLatitude]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == reqBo.getExceptionCategory()) {
            return "\u4f8b\u5916\u914d\u7f6e\u7c7b\u522b[exceptionCategory]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (FscConstants.MerchantExceptionType.MERCHANT_EXCEPTION_TYPE_PAY.equals(reqBo.getExceptionCategory())) {
            if (null == reqBo.getPayObjId() || StringUtils.isEmpty((Object)reqBo.getPayObjName())) {
                return "\u652f\u4ed8\u4f8b\u5916\u914d\u7f6e\u65f6\uff0c[payObjId]\u548c[payObjName]\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (null == reqBo.getPayBusiSceneRange()) {
                return "\u4e1a\u52a1\u573a\u666f\u8303\u56f4[payBusiSceneRange]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (FscConstants.MerchantExceptionLatitude.BY_TYPE.equals(reqBo.getExceptionUserLatitude())) {
                reqBo.setPayUserIdentity(Integer.valueOf(reqBo.getPayObjId().intValue()));
            }
            return this.validatePayTypePeriod(reqBo);
        }
        if (FscConstants.MerchantExceptionType.MERCHANT_EXCEPTION_TYPE_MODEL.equals(reqBo.getExceptionCategory())) {
            if (null == reqBo.getModelSceneRange()) {
                return "\u6a21\u5f0f\u9002\u7528\u8303\u56f4[modelSceneRange]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (StringUtils.isEmpty((Object)reqBo.getModelObjId())) {
                return "\u6a21\u5f0f\u5bf9\u8c61ID[modelObjId]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (StringUtils.isEmpty((Object)reqBo.getModelObjName())) {
                return "\u6a21\u5f0f\u914d\u7f6e\u5bf9\u8c61\u540d\u79f0[modelObjName]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (FscConstants.MerchantExceptionLatitude.BY_TYPE.equals(reqBo.getExceptionUserLatitude())) {
                reqBo.setModelUserIdentity(Integer.valueOf(reqBo.getModelObjId().intValue()));
            }
            if (FscConstants.MerchantModelSceneRange.CONTRACT.equals(reqBo.getModelSceneRange()) && StringUtils.isEmpty((Object)reqBo.getModelContractNo())) {
                return "\u5408\u540c\u7f16\u53f7[modelContractNo]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (null == reqBo.getModelSettle()) {
                return "\u7ed3\u7b97\u6a21\u5f0f\u914d\u7f6e-\u7ed3\u7b97\u6a21\u5f0f[modelSettle]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
            }
        }
        return null;
    }

    private String validateMerchantArgs(FscMerchantEditAbilityReqBO reqBo) {
        if (null == reqBo.getMerchantType()) {
            return "\u5546\u6237\u7c7b\u578b[merchantType]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == reqBo.getMerchantCategory()) {
            return "\u5546\u6237\u7c7b\u522b[merchantCategory]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getContactName())) {
            return "\u8054\u7cfb\u4eba\u540d\u79f0[contactName]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getContactPhone())) {
            return "\u8054\u7cfb\u7535\u8bdd[contactPhone]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getContactPhoneBak())) {
            return "\u5907\u7528\u8054\u7cfb\u7535\u8bdd[contactPhoneBak],\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!StringUtils.isEmpty((Object)reqBo.getPayBusiSceneRange())) {
            if (null == reqBo.getPayUserIdentity()) {
                return "\u652f\u4ed8\u914d\u7f6e\u9002\u7528\u5e73\u53f0\u8eab\u4efd[payUserIdentity]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (null == reqBo.getPayAllowExceptionFlag()) {
                return "\u652f\u4ed8\u914d\u7f6e\u662f\u5426\u5141\u8bb8\u4f8b\u5916[payAllowExceptionFlag]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
            }
            return this.validatePayTypePeriod(reqBo);
        }
        if (null != reqBo.getModelSceneRange()) {
            if (null == reqBo.getModelUserIdentity()) {
                return "\u7ed3\u7b97\u6a21\u5f0f\u914d\u7f6e-\u9002\u7528\u5e73\u53f0\u8eab\u4efd[modelUserIdentity]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (null == reqBo.getModelAllowExceptionFlag()) {
                return "\u7ed3\u7b97\u6a21\u5f0f\u914d\u7f6e-\u662f\u5426\u5141\u8bb8\u4f8b\u5916[modelAllowExceptionFlag]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (null == reqBo.getModelSettle()) {
                return "\u7ed3\u7b97\u6a21\u5f0f\u914d\u7f6e-\u7ed3\u7b97\u6a21\u5f0f[modelSettle]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
            }
        }
        return null;
    }

    private String validatePayTypePeriod(FscMerchantEditAbilityReqBO reqBo) {
        if (null == reqBo.getPayType() && !reqBo.getMerchantType().equals(merchantType)) {
            return "\u652f\u4ed8\u914d\u7f6e\u4ed8\u6b3e\u65b9\u5f0f[payType]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(reqBo.getPayType())) {
            if (null == reqBo.getPayCreditAmount()) {
                return "\u6388\u4fe1\u989d\u5ea6[payCreditAmount]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (null == reqBo.getPayBreakScale()) {
                return "\u8fdd\u7ea6\u91d1\u989d\u6bd4\u4f8b[payBreakScale]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (reqBo.getMerchantType().equals(FscConstants.FscMerchantType.ARGEE)) {
                return null;
            }
            if (null == reqBo.getPayRule()) {
                return "\u8d26\u671f\u652f\u4ed8\u7ed3\u7b97\u89c4\u5219[payRule]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (FscConstants.MerchantPayRule.MERCHANT_PAY_RULE_SPECIFY.equals(reqBo.getPayRule())) {
                if (null == reqBo.getPayAccountDay()) {
                    return "\u6307\u5b9a\u8d26\u671f\u65e5[payAccountDay]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
                }
                if (null == reqBo.getPayAccountDayRule()) {
                    return "\u8d26\u671f\u65e5\u7ed3\u7b97\u8ba2\u5355\u89c4\u5219[payAccountDayRule]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
                }
            } else if (FscConstants.MerchantPayRule.Merchant_PAY_RULE_BUSIESS_NODE.equals(reqBo.getPayRule())) {
                if (null == reqBo.getPayNodeAccountDays()) {
                    return "\u8d26\u671f\u5929\u6570[payNodeAccountDays]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
                }
                if (null == reqBo.getPayNodeRule()) {
                    return "\u8d26\u671f\u8d77\u7b97\u7279\u5b9a\u4e1a\u52a1\u8282\u70b9[payNodeRule]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
                }
            }
        }
        return null;
    }
}

