/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscPushUnifyRefundInvoiceAbilityService;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushUnifyRefundInvoiceAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushUnifyRefundInvoiceAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscUnifyAttachmentBO;
import com.tydic.fsc.common.ability.bo.FscUnifyRefundBillBO;
import com.tydic.fsc.common.ability.bo.FscUnifyRefundInvoiceBO;
import com.tydic.fsc.common.ability.bo.FscUnifyRefundInvoicePushBO;
import com.tydic.fsc.common.ability.bo.FscUnifyRefundInvoiceSettleBO;
import com.tydic.fsc.common.busi.api.FscPushUnifyRefundInvoiceBusiService;
import com.tydic.fsc.common.busi.bo.FscPushUnifyRefundInvoiceBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscPushUnifyRefundInvoiceBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscDicDictionaryExernalMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderExtMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.enums.FscPayTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscDicDictionaryExernalPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscOrderExtPO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.PebExtUnifyFileUploadAbilityService;
import com.tydic.uoc.common.ability.api.PebExtUnifySettleEncryptionAbilityService;
import com.tydic.uoc.common.ability.api.PebExtUnifySettlePersonQryAbilityService;
import com.tydic.uoc.common.ability.api.PebUocUnifyContractQryAbilityService;
import com.tydic.uoc.common.ability.api.UocSalesSingleDetailsListQueryAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtUnifyFileUploadAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifyFileUploadAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleEncryptionAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleEncryptionAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebUocUnifyContractQryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebUocUnifyContractQryAbilityRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdContractBO;
import com.tydic.uoc.common.ability.bo.UocPebChildOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocPebUpperOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocPhasePayListBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryRspBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscPushUnifyRefundInvoiceAbilityService"})
public class FscPushUnifyRefundInvoiceAbilityServiceImpl
implements FscPushUnifyRefundInvoiceAbilityService {
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscPushUnifyRefundInvoiceBusiService fscPushUnifyRefundInvoiceBusiService;
    @Autowired
    private PebUocUnifyContractQryAbilityService pebUocUnifyContractQryAbilityService;
    @Autowired
    private UocSalesSingleDetailsListQueryAbilityService uocSalesSingleDetailsListQueryAbilityService;
    @Autowired
    private PebExtUnifyFileUploadAbilityService pebExtUnifyFileUploadAbilityService;
    @Autowired
    private PebExtUnifySettlePersonQryAbilityService pebExtUnifySettlePersonQryAbilityService;
    @Autowired
    private PebExtUnifySettleEncryptionAbilityService pebExtUnifySettleEncryptionAbilityService;
    @Autowired
    private FscDicDictionaryExernalMapper fscDicDictionaryExernalMapper;
    @Autowired
    private FscComRefundSyncAbilityService fscComRefundSyncAbilityService;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderExtMapper fscOrderExtMapper;
    @Value(value="${saleOrderTabId:30001}")
    private Integer SALE_ORDER_TAB_ID;
    @Value(value="${UNIFY_PAY_TERMS:16}")
    private String payTerms;
    @Value(value="${UNIFY_EXP_TYPE:\u8bbe\u5907\u91c7\u8d2d}")
    private String expType;
    @Value(value="${UNIFY_EXP_TYPE_ID:161}")
    private String expTypeId;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealPushUnifyRefundInvoice"})
    public FscPushUnifyRefundInvoiceAbilityRspBO dealPushUnifyRefundInvoice(@RequestBody FscPushUnifyRefundInvoiceAbilityReqBO reqBO) {
        if (reqBO.getRefundId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(reqBO.getRefundId());
        refundPO = this.fscOrderRefundMapper.getModelBy(refundPO);
        if (refundPO == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u9000\u7968\u5355\u76f8\u5173\u4fe1\u606f\uff01");
        }
        if (refundPO.getIsPushUnify() != null && refundPO.getIsPushUnify().equals(FscConstants.IsPushUnify.UN_PUSH)) {
            throw new FscBusinessException("198888", "\u5f53\u524d\u5355\u636e\u672a\u5bf9\u63a5\u7edf\u4e00\u7ed3\u7b97\u5e73\u53f0\uff01");
        }
        if (refundPO.getPushUnifyStatus() != null && refundPO.getPushUnifyStatus().equals(FscConstants.FscPushStatus.SUCCESS)) {
            throw new FscBusinessException("198888", "\u5f53\u524d\u5355\u636e\u5df2\u63a8\u9001\u6210\u529f,\u8bf7\u52ff\u91cd\u590d\u63a8\u9001\uff01");
        }
        FscOrderExtPO extPO = new FscOrderExtPO();
        extPO.setFscOrderId(refundPO.getFscOrderId());
        extPO = this.fscOrderExtMapper.getModelBy(extPO);
        if (extPO == null) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u539f\u7ed3\u7b97\u5355\u6269\u5c55\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        if (extPO.getUnifyPushStatus() == null || !extPO.getUnifyPushStatus().equals(FscConstants.FscPushStatus.SUCCESS)) {
            throw new FscBusinessException("198888", "\u5f53\u524d\u9000\u7968\u7ed3\u7b97\u5355\u672a\u63a8\u9001\u7edf\u4e00\u7ed3\u7b97\u6210\u529f,\u6b64\u9000\u7968\u5355\u65e0\u9700\u63a8\u9001\u81f3\u7edf\u4e00\u7ed3\u7b97\u5e73\u53f0\uff01");
        }
        FscPushUnifyRefundInvoiceBusiReqBO busiReqBO = this.buildPushData(reqBO, refundPO, extPO);
        FscPushUnifyRefundInvoiceBusiRspBO busiRspBO = this.fscPushUnifyRefundInvoiceBusiService.dealPushUnifyRefundInvoice(busiReqBO);
        this.sendMq(reqBO);
        return (FscPushUnifyRefundInvoiceAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBO)), FscPushUnifyRefundInvoiceAbilityRspBO.class);
    }

    private FscPushUnifyRefundInvoiceBusiReqBO buildPushData(FscPushUnifyRefundInvoiceAbilityReqBO reqBO, FscOrderRefundPO refundPO, FscOrderExtPO extPO) {
        FscUnifyRefundBillBO head = this.buildRefundBillInfo(refundPO);
        List<FscUnifyRefundInvoiceSettleBO> settleList = this.buildRefundSettleInfo(refundPO, head, extPO);
        head.setCONTRACT_NUM(settleList.get(0).getCONTRACT_NUM());
        head.setCONTRACT_NAME(settleList.get(0).getCONTRACT_NAME());
        List<FscUnifyRefundInvoiceBO> invoiceList = this.buildRefundInvoiceInfo(refundPO, head);
        ArrayList<FscUnifyAttachmentBO> fileList = new ArrayList<FscUnifyAttachmentBO>();
        FscAttachmentPO attachmentPO = new FscAttachmentPO();
        attachmentPO.setObjId(refundPO.getRefundId());
        attachmentPO.setObjType(FscConstants.AttachmentObjType.REFUND_INVOICE);
        List list = this.fscAttachmentMapper.getList(attachmentPO);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (FscAttachmentPO fscAttachmentPO : list) {
                PebExtUnifyFileUploadAbilityReqBO uploadAbilityReqBO = new PebExtUnifyFileUploadAbilityReqBO();
                uploadAbilityReqBO.setFileName(fscAttachmentPO.getAttachmentName());
                uploadAbilityReqBO.setFileUrl(fscAttachmentPO.getAttachmentUrl());
                PebExtUnifyFileUploadAbilityRspBO uploadAbilityRspBO = this.pebExtUnifyFileUploadAbilityService.dealUnifyUpload(uploadAbilityReqBO);
                if (!uploadAbilityRspBO.getRespCode().equals("0000")) {
                    throw new UocProBusinessException(uploadAbilityRspBO.getRespCode(), "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25:" + uploadAbilityRspBO.getRespDesc());
                }
                FscUnifyAttachmentBO attachmentBO = new FscUnifyAttachmentBO();
                attachmentBO.setFILE_URL(uploadAbilityRspBO.getUrl());
                attachmentBO.setDOC_NAME(uploadAbilityRspBO.getFileName());
                attachmentBO.setDOC_SIZE(uploadAbilityRspBO.getSize());
                attachmentBO.setDOC_FORMAT(fscAttachmentPO.getAttachmentName().substring(fscAttachmentPO.getAttachmentName().lastIndexOf(".") + 1));
                attachmentBO.setEG_BILL_NUM(refundPO.getRefundNo());
                attachmentBO.setUUID("zjht");
                attachmentBO.setDOC_TYPE("8037");
                attachmentBO.setLAST_UPDATE_DATE(DateUtil.dateToStr((Date)new Date(), (String)"yyyyMMdd"));
                attachmentBO.setUSER_NAME(head.getUSER_NAME());
                attachmentBO.setUPLOAD_TIME(DateUtil.dateToStr((Date)new Date(), (String)"yyyyMMdd"));
                fileList.add(attachmentBO);
            }
        }
        PebExtUnifySettleTokenQryAbilityReqBO tokenQryAbilityReqBO = new PebExtUnifySettleTokenQryAbilityReqBO();
        tokenQryAbilityReqBO.setUserId(refundPO.getAgentAccount());
        PebExtUnifySettleTokenQryAbilityRspBO tokenQryAbilityRspBO = this.pebExtUnifySettlePersonQryAbilityService.qryUnifyPersonToken(tokenQryAbilityReqBO);
        if (!tokenQryAbilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(tokenQryAbilityRspBO.getRespCode(), "\u83b7\u53d6\u7edf\u4e00\u7ed3\u7b97token\u4fe1\u606f\u5931\u8d25:" + tokenQryAbilityRspBO.getRespDesc());
        }
        ArrayList<FscUnifyRefundInvoicePushBO> pushData = new ArrayList<FscUnifyRefundInvoicePushBO>();
        FscUnifyRefundInvoicePushBO refundInvoicePushBO = new FscUnifyRefundInvoicePushBO();
        refundInvoicePushBO.setHead(head);
        refundInvoicePushBO.setConLine(settleList);
        refundInvoicePushBO.setInvline(invoiceList);
        refundInvoicePushBO.setFileList(fileList);
        pushData.add(refundInvoicePushBO);
        PebExtUnifySettleEncryptionAbilityReqBO encryptionAbilityReqBO = new PebExtUnifySettleEncryptionAbilityReqBO();
        encryptionAbilityReqBO.setData(JSONObject.toJSONString(pushData));
        PebExtUnifySettleEncryptionAbilityRspBO encryptionAbilityRspBO = this.pebExtUnifySettleEncryptionAbilityService.dealParamEncryption(encryptionAbilityReqBO);
        if (!encryptionAbilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(encryptionAbilityRspBO.getRespCode(), "\u8c03\u7528\u7edf\u4e00\u7ed3\u7b97\u52a0\u5bc6\u8bf7\u6c42\u53c2\u6570\u5931\u8d25:" + encryptionAbilityRspBO.getRespDesc());
        }
        FscPushUnifyRefundInvoiceBusiReqBO busiReqBO = new FscPushUnifyRefundInvoiceBusiReqBO();
        busiReqBO.setPushData(pushData);
        busiReqBO.setRefundId(refundPO.getRefundId());
        busiReqBO.setRefundNo(refundPO.getRefundNo());
        busiReqBO.setToken(tokenQryAbilityRspBO.getData());
        busiReqBO.setType(FscConstants.FscPurchasePushType.REFUND_INVOICE);
        busiReqBO.setData(encryptionAbilityRspBO.getData());
        return busiReqBO;
    }

    private List<FscUnifyRefundInvoiceBO> buildRefundInvoiceInfo(FscOrderRefundPO refundPO, FscUnifyRefundBillBO head) {
        List invoicePoList = new ArrayList();
        ArrayList<FscUnifyRefundInvoiceBO> invoiceBOList = new ArrayList<FscUnifyRefundInvoiceBO>();
        FscInvoicePO invoicePO = new FscInvoicePO();
        invoicePO.setRefundId(refundPO.getRefundId());
        invoicePoList = refundPO.getInvoiceStatus().equals(FscConstants.FscInvoiceStatus.RED) ? this.fscInvoiceMapper.getListNoStatus(invoicePO) : this.fscInvoiceMapper.getInvoiceByRefundId(refundPO.getRefundId());
        if (CollectionUtils.isEmpty(invoicePoList)) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7ea2\u51b2\u53d1\u7968\u4fe1\u606f\uff01");
        }
        FscDicDictionaryExernalPO dicExternalPo = new FscDicDictionaryExernalPO();
        dicExternalPo.setPCode("FSC_UNIFY_TAX_RATE_ID");
        List taxIdList = this.fscDicDictionaryExernalMapper.getListByCondition(dicExternalPo);
        Map<String, String> taxIdMap = taxIdList.stream().collect(Collectors.toMap(FscDicDictionaryExernalPO::getCode, FscDicDictionaryExernalPO::getExernalCode));
        for (FscInvoicePO fscInvoicePO : invoicePoList) {
            FscUnifyRefundInvoiceBO invoiceBO = new FscUnifyRefundInvoiceBO();
            invoiceBO.setORG_ID(head.getORG_ID());
            invoiceBO.setORG_NAME(head.getORG_NAME());
            invoiceBO.setUSER_ID(head.getUSER_ID());
            invoiceBO.setEG_HCBALANCE_ID(head.getEG_HCBALANCE_ID());
            invoiceBO.setEG_HCBALANCE_NUM(head.getEG_HCBALANCE_NUM());
            invoiceBO.setINVOICE_NUM(fscInvoicePO.getInvoiceNo());
            invoiceBO.setINVOICE_DATE(fscInvoicePO.getBillDate());
            invoiceBO.setAMOUNT_INTAX(fscInvoicePO.getAmt());
            invoiceBO.setTAX_AMOUNT(fscInvoicePO.getTaxAmt());
            invoiceBO.setTAX_RATE(taxIdMap.get(BigDecimal.ZERO.toString()));
            invoiceBO.setAMOUNT_NOTAX(fscInvoicePO.getUntaxAmt());
            invoiceBO.setINVOICE_ID(fscInvoicePO.getUnifyInvoiceId());
            invoiceBOList.add(invoiceBO);
        }
        return invoiceBOList;
    }

    private List<FscUnifyRefundInvoiceSettleBO> buildRefundSettleInfo(FscOrderRefundPO refundPO, FscUnifyRefundBillBO head, FscOrderExtPO extPO) {
        FscOrderRelationPO relationPO = new FscOrderRelationPO();
        relationPO.setRefundId(refundPO.getRefundId());
        List relationList = this.fscOrderRelationMapper.getListNoPage(relationPO);
        if (CollectionUtils.isEmpty((Collection)relationList)) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u7ed3\u7b97\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        ArrayList<FscUnifyRefundInvoiceSettleBO> settleList = new ArrayList<FscUnifyRefundInvoiceSettleBO>(relationList.size());
        ArrayList<Long> orderIds = new ArrayList<Long>();
        ArrayList<Long> acceptOrderIds = new ArrayList<Long>();
        for (FscOrderRelationPO orderRelationPO : relationList) {
            orderIds.add(orderRelationPO.getOrderId());
            acceptOrderIds.add(orderRelationPO.getAcceptOrderId());
        }
        PebUocUnifyContractQryAbilityReqBO contractQryAbilityReqBO = new PebUocUnifyContractQryAbilityReqBO();
        contractQryAbilityReqBO.setOrderIdList(orderIds);
        PebUocUnifyContractQryAbilityRspBO rspBO = this.pebUocUnifyContractQryAbilityService.qryOrderContractInfo(contractQryAbilityReqBO);
        if (CollectionUtils.isEmpty((Map)rspBO.getContractMap())) {
            throw new FscBusinessException(rspBO.getRespCode(), "\u67e5\u8be2\u8ba2\u5355\u5408\u540c\u4fe1\u606f\u8fd4\u56de\u4e3a\u7a7a\uff01");
        }
        Map contractMap = rspBO.getContractMap();
        FscDicDictionaryExernalPO dicExternalPo = new FscDicDictionaryExernalPO();
        dicExternalPo.setPCode("FSC_UNIFY_TAX_RATE_ID");
        List taxIdList = this.fscDicDictionaryExernalMapper.getListByCondition(dicExternalPo);
        Map<String, String> taxIdMap = taxIdList.stream().collect(Collectors.toMap(FscDicDictionaryExernalPO::getCode, FscDicDictionaryExernalPO::getExernalCode));
        UocSalesSingleDetailsListQueryReqBO salesSingleDetailsListQueryReqBO = new UocSalesSingleDetailsListQueryReqBO();
        salesSingleDetailsListQueryReqBO.setOrderId((Long)orderIds.get(0));
        salesSingleDetailsListQueryReqBO.setTabId(this.SALE_ORDER_TAB_ID);
        salesSingleDetailsListQueryReqBO.setIsAfterSales(Boolean.valueOf(false));
        UocSalesSingleDetailsListQueryRspBO salesSingleDetailsListQueryRspBO = this.uocSalesSingleDetailsListQueryAbilityService.getUocSalesSingleDetailsListQuery(salesSingleDetailsListQueryReqBO);
        if (!salesSingleDetailsListQueryRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(salesSingleDetailsListQueryRspBO.getRespCode(), "\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff1a" + salesSingleDetailsListQueryRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)salesSingleDetailsListQueryRspBO.getRows())) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        BigDecimal quality = BigDecimal.ZERO;
        UocPebChildOrderAbilityBO childOrderAbilityBO = (UocPebChildOrderAbilityBO)((UocPebUpperOrderAbilityBO)salesSingleDetailsListQueryRspBO.getRows().get(0)).getChildOrderList().get(0);
        if (!CollectionUtils.isEmpty((Collection)childOrderAbilityBO.getPayList())) {
            for (UocPhasePayListBO uocPhasePayListBO : childOrderAbilityBO.getPayList()) {
                if (!uocPhasePayListBO.getPayType().equals(FscPayTypeEnum.WARRANTY.getCode())) continue;
                quality = quality.add(uocPhasePayListBO.getNodePayRatio());
            }
        }
        FscOrderItemPO orderItemPO = new FscOrderItemPO();
        orderItemPO.setFscOrderId(refundPO.getFscOrderId());
        orderItemPO.setAcceptOrderIds(acceptOrderIds);
        List itemPOList = this.fscOrderItemMapper.sumOrderAmtByTax(orderItemPO);
        for (FscOrderItemPO itemPO : itemPOList) {
            UocOrdContractBO contractBO = (UocOrdContractBO)contractMap.get(itemPO.getOrderId());
            if (contractBO == null) {
                throw new FscBusinessException("198888", "\u83b7\u53d6\u5408\u540c\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            FscUnifyRefundInvoiceSettleBO settleBO = new FscUnifyRefundInvoiceSettleBO();
            settleBO.setCONTRACT_AMT(contractBO.getContractAmt());
            settleBO.setCONTRACT_NAME(contractBO.getContractName());
            settleBO.setCONTRACT_NUM(contractBO.getContractNo());
            settleBO.setORG_ID(head.getORG_ID());
            settleBO.setORG_NAME(head.getORG_NAME());
            settleBO.setUSER_ID(head.getUSER_ID());
            settleBO.setEXP_TYPE(extPO.getExt2());
            settleBO.setEXP_TYPE_ID(extPO.getExt3());
            settleBO.setTAX_AMOUNT(itemPO.getTaxAmt().negate());
            settleBO.setAMOUNT_INTAX(itemPO.getAmt().negate());
            settleBO.setAMOUNT_NOTAX(itemPO.getAmt().subtract(itemPO.getTaxAmt()).negate());
            settleBO.setTAX_RATE(itemPO.getTaxRate().multiply(new BigDecimal(100)));
            settleBO.setTAX_RATE_ID(taxIdMap.get(itemPO.getTaxRate().multiply(new BigDecimal(100)).stripTrailingZeros().toString()));
            FscShouldPayPO fscShouldPayPo = new FscShouldPayPO();
            fscShouldPayPo.setObjectId(refundPO.getFscOrderId());
            BigDecimal paidAmt = this.fscShouldPayMapper.sumPayPaidAmt(fscShouldPayPo);
            settleBO.setTOTAL_PAY(paidAmt);
            settleBO.setPAY_TERMS(this.payTerms);
            if (quality.compareTo(BigDecimal.ZERO) == 0) {
                settleBO.setDEPOSIT_AMT(BigDecimal.ZERO);
            } else {
                settleBO.setDEPOSIT_AMT(itemPO.getAmt().multiply(quality).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP));
            }
            if (refundPO.getOrderSource().toString().equals("2")) {
                if (!StringUtils.isEmpty((Object)extPO.getIsEquipPurchase()) && extPO.getIsEquipPurchase().equals(FscConstants.IsEquipPurchase.YES)) {
                    settleBO.setEXP_TYPE(this.expType);
                    settleBO.setEXP_TYPE_ID(this.expTypeId);
                }
            } else if (itemPO.getUnifyContractType().equals("EQUIPMENT")) {
                settleBO.setEXP_TYPE(this.expType);
                settleBO.setEXP_TYPE_ID(this.expTypeId);
            }
            settleList.add(settleBO);
        }
        return settleList;
    }

    private FscUnifyRefundBillBO buildRefundBillInfo(FscOrderRefundPO refundPO) {
        FscUnifyRefundBillBO refundBillBO = new FscUnifyRefundBillBO();
        refundBillBO.setORG_ID(refundPO.getUnifyOrgId());
        refundBillBO.setORG_NAME(refundPO.getUnifyOrgName());
        refundBillBO.setUSER_ID(refundPO.getUnifyUserId());
        refundBillBO.setUSER_NAME(refundPO.getUnifyPersonName());
        refundBillBO.setCOM_CODE(refundPO.getUnifyComCode());
        refundBillBO.setEG_HCBALANCE_ID(refundPO.getRefundId());
        refundBillBO.setEG_HCBALANCE_NUM(refundPO.getRefundNo());
        refundBillBO.setEG_BALANCE_ID(refundPO.getFscOrderId());
        refundBillBO.setEG_BALANCE_NUM(refundPO.getFscOrderNo());
        refundBillBO.setBILL_DATE(DateUtil.dateToStr((Date)refundPO.getCreateTime()));
        refundBillBO.setDESCRIPTIONS(refundPO.getRefundNote());
        refundBillBO.setSTATUS("N");
        refundBillBO.setSTATUS_DIS("\u65b0\u5efa");
        return refundBillBO;
    }

    @PostMapping(value={"dealPushUnifyRefundInvoiceBatch"})
    public FscPushUnifyRefundInvoiceAbilityRspBO dealPushUnifyRefundInvoiceBatch(@RequestBody FscPushUnifyRefundInvoiceAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getRefundIds())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundIds]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        StringBuilder sb = new StringBuilder();
        for (Long refundId : reqBO.getRefundIds()) {
            reqBO.setRefundId(refundId);
            FscPushUnifyRefundInvoiceAbilityRspBO abilityRspBO = this.dealPushUnifyRefundInvoice(reqBO);
            if (abilityRspBO.getRespCode().equals("0000")) continue;
            sb.append("[").append(refundId).append("]\u63a8\u9001\u5931\u8d25\uff1a").append(abilityRspBO.getRespDesc());
        }
        FscPushUnifyRefundInvoiceAbilityRspBO rspBO = new FscPushUnifyRefundInvoiceAbilityRspBO();
        if (StringUtils.isEmpty((Object)sb.toString())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        } else {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc(sb.toString());
        }
        return rspBO;
    }

    private void sendMq(FscPushUnifyRefundInvoiceAbilityReqBO reqBO) {
        FscComRefundSyncAbilityReqBO syncAbilityReqBO = new FscComRefundSyncAbilityReqBO();
        syncAbilityReqBO.setRefundIds(Collections.singletonList(reqBO.getRefundId()));
        this.fscComRefundSyncAbilityService.syncRefund(syncAbilityReqBO);
    }
}

