/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl.finance;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinanceShareTokenRspBO;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceShareRelatedInterfacesAtomService;
import com.tydic.fsc.common.ability.api.finance.FscFinanceRecvBankListQryAbilityService;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceRecvBankDetailRspBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceRecvBankListQryReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceRecvBankListQryRspBO;
import com.tydic.fsc.common.ability.vo.FscFinanceRecvBankListResultVO;
import com.tydic.fsc.common.config.FscShareFinanceServiceConfiguration;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.utils.EntityToMapUtil;
import com.tydic.fsc.utils.SSLClient;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.finance.FscFinanceRecvBankListQryAbilityService"})
public class FscFinanceRecvBankListQryAbilityServiceImpl
implements FscFinanceRecvBankListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceRecvBankListQryAbilityServiceImpl.class);
    @Autowired
    private FscShareFinanceServiceConfiguration fscShareFinanceServiceConfiguration;
    @Autowired
    private FscFinanceShareRelatedInterfacesAtomService fscFinanceShareRelatedInterfacesAtomService;

    @PostMapping(value={"qryFinanceRecvBankList"})
    public FscFinanceRecvBankListQryRspBO qryFinanceRecvBankList(@RequestBody FscFinanceRecvBankListQryReqBO reqBO) {
        this.valid(reqBO);
        FscFinanceRecvBankListQryRspBO rspBO = null;
        String domainUrl = this.fscShareFinanceServiceConfiguration.getDomainUrl();
        FscFinanceShareTokenRspBO financeShareTokenRspBO = this.fscFinanceShareRelatedInterfacesAtomService.getFinanceShareToken();
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Authorization", financeShareTokenRspBO.getToken());
        log.info("\u83b7\u53d6Token\u4fe1\u606f\uff1a{}", (Object)financeShareTokenRspBO.getToken());
        HashMap paramMap = EntityToMapUtil.entityToMap((Object)reqBO);
        String param = EntityToMapUtil.transferParam((HashMap)paramMap);
        log.info("\u83b7\u53d6\u6536\u6b3e\u94f6\u884c\u8d26\u6237\u67e5\u8be2\u63a5\u53e3\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)(domainUrl + this.fscShareFinanceServiceConfiguration.getCm102() + param));
        String respStr = SSLClient.doGet((String)(domainUrl + this.fscShareFinanceServiceConfiguration.getCm102() + param), headerMap);
        log.info("\u83b7\u53d6\u6536\u6b3e\u94f6\u884c\u8d26\u6237\u4fe1\u606f\u62a5\u6587\uff1a{}", (Object)respStr);
        if (StringUtils.isEmpty((Object)respStr)) {
            throw new FscBusinessException("191138", "\u83b7\u53d6\u6536\u6b3e\u94f6\u884c\u8d26\u6237\u4fe1\u606f\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
        }
        try {
            rspBO = this.resolveRreRsp(respStr);
        }
        catch (Exception e) {
            throw new FscBusinessException("198888", "\u89e3\u6790\u6536\u6b3e\u94f6\u884c\u8d26\u6237\u8fd4\u56de\u62a5\u6587\u5931\u8d25\uff01[" + respStr + "]");
        }
        return rspBO;
    }

    private void valid(FscFinanceRecvBankListQryReqBO reqBO) {
        if (reqBO == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getUnitCode())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u8d44\u91d1\u7ec4\u7ec7\u7f16\u7801[unitCode]\u4e3a\u7a7a");
        }
    }

    private FscFinanceRecvBankListQryRspBO resolveRreRsp(String respStr) {
        if (StringUtils.isEmpty((Object)respStr)) {
            throw new FscBusinessException("198888", "\u8c03\u7528\u6536\u6b3e\u94f6\u884c\u8d26\u6237\u4fe1\u606fdata\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        FscFinanceRecvBankListQryRspBO rspBO = new FscFinanceRecvBankListQryRspBO();
        JSONObject jsonObject = JSONObject.parseObject((String)respStr);
        if (!Objects.equals(jsonObject.getString("code"), "0")) {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc("\u67e5\u8be2\u6536\u6b3e\u94f6\u884c\u8d26\u6237\u4fe1\u606f\u5931\u8d25\uff01" + jsonObject.getString("msg"));
            return rspBO;
        }
        JSONObject data = jsonObject.getJSONObject("data");
        JSONArray records = data.getJSONArray("records");
        List resultVOList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)records), FscFinanceRecvBankListResultVO.class);
        List detailList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)resultVOList), FscFinanceRecvBankDetailRspBO.class);
        rspBO.setBankList(detailList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        log.info("\u89e3\u6790\u6536\u6b3e\u94f6\u884c\u8d26\u6237\u4fe1\u606f\u6570\u636e\u96c6\u5408\uff1a{}", (Object)detailList);
        return rspBO;
    }
}

