/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.fsc.busibase.atom.api.FscFinanceOccupyRefundInfoAtomService;
import com.tydic.fsc.busibase.atom.api.FscFinanceReleaseRefundInfoAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscFinanceOccupyRefundInfoAtomBankBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceOccupyRefundInfoAtomDraftBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceOccupyRefundInfoAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceOccupyRefundInfoAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceOccupyRefundInfoAtomSupplyBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceReleaseRefundInfoAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceReleaseRefundInfoAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.common.busi.api.FscFinancePayRefundApprovalBusiService;
import com.tydic.fsc.common.busi.bo.FscFinancePayRefundApprovalBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscFinancePayRefundApprovalBusiRspBO;
import com.tydic.fsc.common.busi.bo.FscFinancePayRefundApprovalReqBankStatementBusiBO;
import com.tydic.fsc.common.busi.bo.FscFinancePayRefundApprovalReqDraftInfoBusiBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscFinanceBankStatementMapper;
import com.tydic.fsc.dao.FscFinanceBankStatementTempMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoTempMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscPayRefundDetailMapper;
import com.tydic.fsc.dao.FscRefundFinanceMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscFinanceBankStatementPO;
import com.tydic.fsc.po.FscFinanceBankStatementTempPO;
import com.tydic.fsc.po.FscFinanceDraftInfoPO;
import com.tydic.fsc.po.FscFinanceDraftInfoTempPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscPayRefundDetailPO;
import com.tydic.fsc.po.FscRefundFinancePO;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import com.tydic.uac.constant.UacCommConstant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscFinancePayRefundApprovalBusiServiceImpl
implements FscFinancePayRefundApprovalBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscFinancePayRefundApprovalBusiServiceImpl.class);
    @Autowired
    private FscFinanceBankStatementMapper fscFinanceBankStatementMapper;
    @Autowired
    private FscFinanceDraftInfoMapper fscFinanceDraftInfoMapper;
    @Autowired
    private FscFinanceBankStatementTempMapper fscFinanceBankStatementTempMapper;
    @Autowired
    private FscFinanceDraftInfoTempMapper fscFinanceDraftInfoTempMapper;
    @Autowired
    private FscRefundFinanceMapper fscRefundFinanceMapper;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscPayRefundDetailMapper fscPayRefundDetailMapper;
    @Autowired
    private FscFinanceOccupyRefundInfoAtomService fscFinanceOccupyRefundInfoAtomService;
    @Autowired
    private FscFinanceReleaseRefundInfoAtomService fscFinanceReleaseRefundInfoAtomService;
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    private static final String BUSI_NAME = "\u5bf9\u63a5\u5171\u4eab\u5ba1\u6279";

    @Override
    public FscFinancePayRefundApprovalBusiRspBO dealFinancePayRefundApproval(FscFinancePayRefundApprovalBusiReqBO reqBO) {
        FscFinancePayRefundApprovalBusiRspBO rspBO = new FscFinancePayRefundApprovalBusiRspBO();
        ArrayList<Long> refundIds = new ArrayList<Long>();
        FscOrderRefundPO fscOrderRefundPO = this.getOrderRefund(reqBO.getRefundId());
        FscPayRefundDetailPO fscPayRefundDetailPO = this.getPayRefundDetail(reqBO.getRefundId());
        FscRefundFinancePO fscRefundFinancePO = this.getRefundFinance(reqBO.getRefundId());
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        UacNoTaskAuditOrderAuditRspBO auditRspBO = this.processTaskApproval(reqBO, reqBO.getRefundId(), fscOrderRefundPO);
        if (auditRspBO.getNoneInstanceBO().getFinish().booleanValue() && reqBO.getAuditResult() == 0) {
            refundIds.add(reqBO.getRefundId());
            paramMap.put("auditFlag", "0");
            this.dealRefundStatusFlow(fscOrderRefundPO, paramMap);
        } else if (auditRspBO.getNoneInstanceBO().getFinish().booleanValue() && reqBO.getAuditResult() == 1) {
            paramMap.put("auditFlag", "1");
            this.dealRefundStatusFlow(fscOrderRefundPO, paramMap);
        }
        if (!CollectionUtils.isEmpty(reqBO.getBankStatementList()) || !CollectionUtils.isEmpty(reqBO.getDraftInfoList())) {
            this.updateRefundFinance(reqBO, reqBO.getRefundId(), auditRspBO);
            this.releaseRefundInfo(reqBO.getRefundId(), fscOrderRefundPO);
            this.dealAddFinanceBankStatement(reqBO, fscPayRefundDetailPO);
            this.dealAddFinanceDraftInfo(reqBO, fscPayRefundDetailPO);
            if (reqBO.getAuditResult() == 0) {
                this.occupyRefundInfo(reqBO, fscOrderRefundPO, fscRefundFinancePO);
            }
        }
        if (CollectionUtils.isEmpty(reqBO.getBankStatementList()) && CollectionUtils.isEmpty(reqBO.getDraftInfoList()) && reqBO.getAuditResult() == 1) {
            this.releaseRefundInfo(reqBO.getRefundId(), fscOrderRefundPO);
        }
        rspBO.setRefundIds(refundIds);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealAddFinanceBankStatement(FscFinancePayRefundApprovalBusiReqBO reqBO, FscPayRefundDetailPO fscPayRefundDetailPO) {
        if (reqBO.getRefundFlag() == 1) {
            this.addFinanceBankStatement(reqBO, fscPayRefundDetailPO);
        }
        if (reqBO.getRefundFlag() == 2) {
            this.addFinanceBankStatementByTemp(reqBO, fscPayRefundDetailPO);
        }
    }

    private void addFinanceBankStatement(FscFinancePayRefundApprovalBusiReqBO reqBO, FscPayRefundDetailPO fscPayRefundDetailPO) {
        FscFinanceBankStatementPO deleteFscFinanceBankStatement = new FscFinanceBankStatementPO();
        deleteFscFinanceBankStatement.setRefundId(reqBO.getRefundId());
        this.fscFinanceBankStatementMapper.deleteBy(deleteFscFinanceBankStatement);
        if (CollectionUtils.isEmpty(reqBO.getBankStatementList())) {
            return;
        }
        List addBankStatementList = JUtil.jsl(reqBO.getBankStatementList(), FscFinanceBankStatementPO.class);
        for (FscFinanceBankStatementPO bankStatement : addBankStatementList) {
            bankStatement.setStatementId(Long.valueOf(Sequence.getInstance().nextId()));
            bankStatement.setCreateTime(new Date());
        }
        this.fscFinanceBankStatementMapper.insertBatch(addBankStatementList);
    }

    private void addFinanceBankStatementByTemp(FscFinancePayRefundApprovalBusiReqBO reqBO, FscPayRefundDetailPO fscPayRefundDetailPO) {
        FscFinanceBankStatementPO deleteFscFinanceBankStatement = new FscFinanceBankStatementPO();
        deleteFscFinanceBankStatement.setRefundId(reqBO.getRefundId());
        this.fscFinanceBankStatementMapper.deleteBy(deleteFscFinanceBankStatement);
        List<FscFinanceBankStatementTempPO> financeBankStatementTempList = this.getFinanceBankStatementTempList(reqBO);
        if (CollectionUtils.isEmpty(financeBankStatementTempList)) {
            return;
        }
        List addBankStatementList = JUtil.jsl(financeBankStatementTempList, FscFinanceBankStatementPO.class);
        for (FscFinanceBankStatementPO bankStatement : addBankStatementList) {
            bankStatement.setStatementId(Long.valueOf(Sequence.getInstance().nextId()));
            bankStatement.setCreateTime(new Date());
        }
        this.fscFinanceBankStatementMapper.insertBatch(addBankStatementList);
    }

    private void dealAddFinanceDraftInfo(FscFinancePayRefundApprovalBusiReqBO reqBO, FscPayRefundDetailPO fscPayRefundDetailPO) {
        if (reqBO.getRefundFlag() == 1) {
            this.addFinanceDraftInfo(reqBO, fscPayRefundDetailPO);
        }
        if (reqBO.getRefundFlag() == 2) {
            this.addFinanceDraftInfoByTemp(reqBO, fscPayRefundDetailPO);
        }
    }

    private void addFinanceDraftInfo(FscFinancePayRefundApprovalBusiReqBO reqBO, FscPayRefundDetailPO fscPayRefundDetailPO) {
        FscFinanceDraftInfoPO deleteFscFinanceDraftInfo = new FscFinanceDraftInfoPO();
        deleteFscFinanceDraftInfo.setRefundId(reqBO.getRefundId());
        this.fscFinanceDraftInfoMapper.deleteBy(deleteFscFinanceDraftInfo);
        if (CollectionUtils.isEmpty(reqBO.getDraftInfoList())) {
            return;
        }
        List addDraftInfoList = JUtil.jsl(reqBO.getDraftInfoList(), FscFinanceDraftInfoPO.class);
        for (FscFinanceDraftInfoPO draftInfo : addDraftInfoList) {
            draftInfo.setDraftId(Long.valueOf(Sequence.getInstance().nextId()));
            draftInfo.setCreateTime(new Date());
        }
        this.fscFinanceDraftInfoMapper.insertBatch(addDraftInfoList);
    }

    private void addFinanceDraftInfoByTemp(FscFinancePayRefundApprovalBusiReqBO reqBO, FscPayRefundDetailPO fscPayRefundDetailPO) {
        FscFinanceDraftInfoPO deleteFscFinanceDraftInfo = new FscFinanceDraftInfoPO();
        deleteFscFinanceDraftInfo.setRefundId(reqBO.getRefundId());
        this.fscFinanceDraftInfoMapper.deleteBy(deleteFscFinanceDraftInfo);
        List<FscFinanceDraftInfoTempPO> financeDraftTempList = this.getFinanceDraftTempList(reqBO);
        if (CollectionUtils.isEmpty(financeDraftTempList)) {
            return;
        }
        List addDraftInfoList = JUtil.jsl(financeDraftTempList, FscFinanceDraftInfoPO.class);
        for (FscFinanceDraftInfoPO draftInfo : addDraftInfoList) {
            draftInfo.setDraftId(Long.valueOf(Sequence.getInstance().nextId()));
            draftInfo.setCreateTime(new Date());
        }
        this.fscFinanceDraftInfoMapper.insertBatch(addDraftInfoList);
    }

    private void updateRefundFinance(FscFinancePayRefundApprovalBusiReqBO reqBO, Long thisRefundId, UacNoTaskAuditOrderAuditRspBO auditRspBO) {
        FscRefundFinancePO refundFinancePO = new FscRefundFinancePO();
        refundFinancePO.setRefundId(thisRefundId);
        refundFinancePO = this.fscRefundFinanceMapper.getModelBy(refundFinancePO);
        FscRefundFinancePO updateFscRefundFinanceSet = new FscRefundFinancePO();
        updateFscRefundFinanceSet.setCashItemCode(reqBO.getCashItemCode());
        updateFscRefundFinanceSet.setCashItemName(reqBO.getCashItemName());
        updateFscRefundFinanceSet.setCashDetailCode(reqBO.getCashDetailCode());
        updateFscRefundFinanceSet.setCashDetailName(reqBO.getCashDetailName());
        updateFscRefundFinanceSet.setIsAgent(reqBO.getIsAgent());
        updateFscRefundFinanceSet.setAgentCompanyCode(reqBO.getAgentCompanyCode());
        updateFscRefundFinanceSet.setAgentCompanyName(reqBO.getAgentCompanyName());
        if (StringUtils.isEmpty((CharSequence)refundFinancePO.getFinanceAuditAccount())) {
            updateFscRefundFinanceSet.setFinanceAuditName(reqBO.getName());
            updateFscRefundFinanceSet.setFinanceAuditAccount(reqBO.getUserName());
        } else if (!refundFinancePO.getFinanceAuditAccount().contains(reqBO.getUserName())) {
            updateFscRefundFinanceSet.setFinanceAuditName(refundFinancePO.getFinanceAuditName() + "," + reqBO.getName());
            updateFscRefundFinanceSet.setFinanceAuditAccount(refundFinancePO.getFinanceAuditAccount() + "," + reqBO.getUserName());
        }
        if (auditRspBO.getNoneInstanceBO().getFinish().booleanValue() && FscConstants.AuditResultStatus.PASS.equals(reqBO.getAuditResult())) {
            updateFscRefundFinanceSet.setFinanceAuditStatus(FscConstants.AuditStatus.AUDIT_PASS);
        }
        if (auditRspBO.getNoneInstanceBO().getFinish().booleanValue() && FscConstants.AuditResultStatus.REFUSE.equals(reqBO.getAuditResult())) {
            updateFscRefundFinanceSet.setFinanceAuditStatus(FscConstants.AuditStatus.AUDIT_REJECT);
        }
        FscRefundFinancePO updateFscRefundFinanceWhere = new FscRefundFinancePO();
        updateFscRefundFinanceWhere.setRefundId(thisRefundId);
        this.fscRefundFinanceMapper.updateBy(updateFscRefundFinanceSet, updateFscRefundFinanceWhere);
    }

    private UacNoTaskAuditOrderAuditRspBO processTaskApproval(FscFinancePayRefundApprovalBusiReqBO reqBO, Long thisRefundId, FscOrderRefundPO fscOrderRefundPO) {
        UacNoTaskAuditOrderAuditReqBO auditReqBO = new UacNoTaskAuditOrderAuditReqBO();
        HashMap<String, Number> variables = new HashMap<String, Number>(1);
        variables.put("auditResult", reqBO.getAuditResult().equals(FscConstants.AuditResultStatus.PASS) ? FscConstants.AuditResultStatus.PASS : FscConstants.AuditResultStatus.REFUSE);
        variables.put("refundAmount", fscOrderRefundPO.getRefundAmount());
        auditReqBO.setObjId((List)CollectionUtil.newArrayList((Object[])new Long[]{thisRefundId}));
        String stepId = this.fscOrderRefundMapper.selectStepId(fscOrderRefundPO.getRefundId(), FscConstants.AuditObjType.FINANCE_PAY_REFUND_APPROVAL, UacCommConstant.STATUS.UNDER_REVIEW);
        auditReqBO.setStepId(stepId);
        auditReqBO.setVariables(variables);
        auditReqBO.setAuditResult(reqBO.getAuditResult());
        auditReqBO.setOperId(String.valueOf(reqBO.getUserId()));
        auditReqBO.setOperDept(reqBO.getOrgName());
        auditReqBO.setObjType(FscConstants.AuditObjType.FINANCE_PAY_REFUND_APPROVAL);
        auditReqBO.setUsername(reqBO.getName());
        if (ObjectUtil.isNotEmpty((Object)reqBO.getAuditAdvice())) {
            auditReqBO.setAuditAdvice(reqBO.getAuditAdvice());
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u6d41\u7a0b\u4efb\u52a1\u5ba1\u6279\u5165\u53c2: {}", (Object)JSON.toJSONString((Object)auditReqBO));
        }
        UacNoTaskAuditOrderAuditRspBO auditRspBO = this.uacNoTaskAuditOrderAuditAbilityService.dealAudit(auditReqBO);
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u6d41\u7a0b\u4efb\u52a1\u5ba1\u6279\u51fa\u53c2: {}", (Object)JSON.toJSONString((Object)auditRspBO));
        }
        if (!"0000".equals(auditRspBO.getRespCode())) {
            throw new FscBusinessException("193108", auditRspBO.getRespDesc());
        }
        return auditRspBO;
    }

    private FscPayRefundDetailPO getPayRefundDetail(Long thisRefundId) {
        FscPayRefundDetailPO qryFscPayRefundDetail = new FscPayRefundDetailPO();
        qryFscPayRefundDetail.setRefundId(thisRefundId);
        return this.fscPayRefundDetailMapper.getModelBy(qryFscPayRefundDetail);
    }

    private FscOrderRefundPO getOrderRefund(Long thisRefundId) {
        FscOrderRefundPO qryFscOrderRefund = new FscOrderRefundPO();
        qryFscOrderRefund.setRefundId(thisRefundId);
        return this.fscOrderRefundMapper.getModelBy(qryFscOrderRefund);
    }

    private FscRefundFinancePO getRefundFinance(Long thisRefundId) {
        FscRefundFinancePO qryFscRefundFinance = new FscRefundFinancePO();
        qryFscRefundFinance.setRefundId(thisRefundId);
        return this.fscRefundFinanceMapper.getModelBy(qryFscRefundFinance);
    }

    private List<FscFinanceDraftInfoPO> getFinanceDraftList(Long refundId) {
        FscFinanceDraftInfoPO qryFscFinanceDraftInfo = new FscFinanceDraftInfoPO();
        qryFscFinanceDraftInfo.setRefundId(refundId);
        return this.fscFinanceDraftInfoMapper.getList(qryFscFinanceDraftInfo);
    }

    private List<FscFinanceBankStatementPO> getFinanceBankStatementList(Long refundId) {
        FscFinanceBankStatementPO qryFscFinanceBankStatement = new FscFinanceBankStatementPO();
        qryFscFinanceBankStatement.setRefundId(refundId);
        return this.fscFinanceBankStatementMapper.getList(qryFscFinanceBankStatement);
    }

    private List<FscFinanceBankStatementTempPO> getFinanceBankStatementTempList(FscFinancePayRefundApprovalBusiReqBO reqBO) {
        if (CollectionUtils.isEmpty(reqBO.getBankStatementList())) {
            return null;
        }
        List tempIdList = reqBO.getBankStatementList().stream().map(FscFinancePayRefundApprovalReqBankStatementBusiBO::getTempId).filter(ObjectUtil::isNotEmpty).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(tempIdList)) {
            return null;
        }
        FscFinanceBankStatementTempPO qryFscFinanceBankStatementTemp = new FscFinanceBankStatementTempPO();
        qryFscFinanceBankStatementTemp.setTempIdList(tempIdList);
        return this.fscFinanceBankStatementTempMapper.getList(qryFscFinanceBankStatementTemp);
    }

    private List<FscFinanceDraftInfoTempPO> getFinanceDraftTempList(FscFinancePayRefundApprovalBusiReqBO reqBO) {
        if (CollectionUtils.isEmpty(reqBO.getDraftInfoList())) {
            return null;
        }
        List tempIdList = reqBO.getDraftInfoList().stream().map(FscFinancePayRefundApprovalReqDraftInfoBusiBO::getTempId).filter(ObjectUtil::isNotEmpty).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(tempIdList)) {
            return null;
        }
        FscFinanceDraftInfoTempPO qryFscFinanceDraftInfoTemp = new FscFinanceDraftInfoTempPO();
        qryFscFinanceDraftInfoTemp.setTempIdList(tempIdList);
        return this.fscFinanceDraftInfoTempMapper.getList(qryFscFinanceDraftInfoTemp);
    }

    private void occupyRefundInfo(FscFinancePayRefundApprovalBusiReqBO reqBO, FscOrderRefundPO fscOrderRefundPO, FscRefundFinancePO fscRefundFinancePO) {
        ArrayList<FscFinanceOccupyRefundInfoAtomDraftBO> draftList = new ArrayList<FscFinanceOccupyRefundInfoAtomDraftBO>(1);
        ArrayList<FscFinanceOccupyRefundInfoAtomBankBO> bankList = new ArrayList<FscFinanceOccupyRefundInfoAtomBankBO>(1);
        ArrayList<FscFinanceOccupyRefundInfoAtomSupplyBO> supplyList = new ArrayList<FscFinanceOccupyRefundInfoAtomSupplyBO>(1);
        this.packageOccupyRefundInfo(reqBO.getRefundId(), draftList, bankList, supplyList);
        FscFinanceOccupyRefundInfoAtomReqBO fscFinanceOccupyRefundInfoAtomReqBO = new FscFinanceOccupyRefundInfoAtomReqBO();
        fscFinanceOccupyRefundInfoAtomReqBO.setObjId(fscOrderRefundPO.getRefundId());
        fscFinanceOccupyRefundInfoAtomReqBO.setObjNo(fscOrderRefundPO.getRefundNo());
        fscFinanceOccupyRefundInfoAtomReqBO.setFinanceOrgId(fscRefundFinancePO.getFinanceOrgId());
        fscFinanceOccupyRefundInfoAtomReqBO.setFinanceOrgName(fscRefundFinancePO.getFinanceOrgName());
        fscFinanceOccupyRefundInfoAtomReqBO.setDraftList(draftList);
        fscFinanceOccupyRefundInfoAtomReqBO.setBankList(bankList);
        fscFinanceOccupyRefundInfoAtomReqBO.setSupplyList(supplyList);
        fscFinanceOccupyRefundInfoAtomReqBO.setRefundFlag(reqBO.getRefundFlag());
        fscFinanceOccupyRefundInfoAtomReqBO.setName(reqBO.getName());
        fscFinanceOccupyRefundInfoAtomReqBO.setUserName(reqBO.getUserName());
        FscFinanceOccupyRefundInfoAtomRspBO fscFinanceOccupyRefundInfoAtomRspBO = this.fscFinanceOccupyRefundInfoAtomService.dealOccupyRefundInfo(fscFinanceOccupyRefundInfoAtomReqBO);
        if (!fscFinanceOccupyRefundInfoAtomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(fscFinanceOccupyRefundInfoAtomRspBO.getRespCode(), fscFinanceOccupyRefundInfoAtomRspBO.getRespDesc());
        }
    }

    private void packageOccupyRefundInfo(Long thisRefundId, List<FscFinanceOccupyRefundInfoAtomDraftBO> draftList, List<FscFinanceOccupyRefundInfoAtomBankBO> bankList, List<FscFinanceOccupyRefundInfoAtomSupplyBO> supplyList) {
        List<FscFinanceDraftInfoPO> fscFinanceDraftInfoList = this.getFinanceDraftList(thisRefundId);
        List<FscFinanceBankStatementPO> financeBankStatementList = this.getFinanceBankStatementList(thisRefundId);
        for (FscFinanceDraftInfoPO fscFinanceDraftInfoPO : fscFinanceDraftInfoList) {
            if (FscConstants.FinanceDraftType.SUPPLY.equals(fscFinanceDraftInfoPO.getDraftType())) {
                FscFinanceOccupyRefundInfoAtomSupplyBO fscFinanceOccupyRefundInfoAtomSupplyBO = (FscFinanceOccupyRefundInfoAtomSupplyBO)JSON.parseObject((String)JSON.toJSONString((Object)fscFinanceDraftInfoPO), FscFinanceOccupyRefundInfoAtomSupplyBO.class);
                supplyList.add(fscFinanceOccupyRefundInfoAtomSupplyBO);
                continue;
            }
            FscFinanceOccupyRefundInfoAtomDraftBO fscFinanceOccupyRefundInfoAtomDraftBO = (FscFinanceOccupyRefundInfoAtomDraftBO)JSON.parseObject((String)JSON.toJSONString((Object)fscFinanceDraftInfoPO), FscFinanceOccupyRefundInfoAtomDraftBO.class);
            draftList.add(fscFinanceOccupyRefundInfoAtomDraftBO);
        }
        for (FscFinanceBankStatementPO fscFinanceBankStatementPO : financeBankStatementList) {
            FscFinanceOccupyRefundInfoAtomBankBO fscFinanceOccupyRefundInfoAtomBankBO = (FscFinanceOccupyRefundInfoAtomBankBO)JSON.parseObject((String)JSON.toJSONString((Object)fscFinanceBankStatementPO), FscFinanceOccupyRefundInfoAtomBankBO.class);
            bankList.add(fscFinanceOccupyRefundInfoAtomBankBO);
        }
    }

    private void releaseRefundInfo(Long thisRefundId, FscOrderRefundPO fscOrderRefundPO) {
        FscFinanceReleaseRefundInfoAtomReqBO fscFinanceReleaseRefundInfoAtomReqBO = new FscFinanceReleaseRefundInfoAtomReqBO();
        fscFinanceReleaseRefundInfoAtomReqBO.setRefundId(thisRefundId);
        fscFinanceReleaseRefundInfoAtomReqBO.setRefundNo(fscOrderRefundPO.getRefundNo());
        FscFinanceReleaseRefundInfoAtomRspBO fscFinanceReleaseRefundInfoAtomRspBO = this.fscFinanceReleaseRefundInfoAtomService.dealReleaseRefundInfo(fscFinanceReleaseRefundInfoAtomReqBO);
        if (!fscFinanceReleaseRefundInfoAtomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(fscFinanceReleaseRefundInfoAtomRspBO.getRespCode(), fscFinanceReleaseRefundInfoAtomRspBO.getRespDesc());
        }
    }

    private void dealRefundStatusFlow(FscOrderRefundPO fscOrderRefundPO, Map<String, Object> paramMap) {
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
        fscOrderStatusFlowAtomReqBO.setOrderId(fscOrderRefundPO.getRefundId());
        fscOrderStatusFlowAtomReqBO.setCurStatus(fscOrderRefundPO.getRefundStatus());
        fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealRefundStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!fscOrderStatusFlowAtomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(fscOrderStatusFlowAtomRspBO.getRespCode(), fscOrderStatusFlowAtomRspBO.getRespDesc());
        }
    }
}

