/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.tydic.fsc.bo.FscForOrderStatisticalClaimBO;
import com.tydic.fsc.bo.FscForOrderStatisticalInvoiceBO;
import com.tydic.fsc.bo.FscForOrderStatisticalPayBO;
import com.tydic.fsc.bo.FscForOrderStatisticalShipBO;
import com.tydic.fsc.common.busi.api.FscForOrderStatisticalBusiService;
import com.tydic.fsc.common.busi.bo.FscForOrderStatisticalBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscForOrderStatisticalBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.uoc.common.ability.api.PebExtOrderForFscStatisticalAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtOrderForFscStatisticalAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtOrderForFscStatisticalAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebExtOrderForFscStatisticalArrivalBO;
import com.tydic.uoc.common.ability.bo.PebExtOrderForFscStatisticalInspectionBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscForOrderStatisticalBusiServiceImpl
implements FscForOrderStatisticalBusiService {
    @Autowired
    private PebExtOrderForFscStatisticalAbilityService pebExtOrderForFscStatisticalAbilityService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;

    @Override
    public FscForOrderStatisticalBusiRspBO qryForOrderStatistical(FscForOrderStatisticalBusiReqBO reqBO) {
        FscForOrderStatisticalBusiRspBO rspBO = new FscForOrderStatisticalBusiRspBO();
        PebExtOrderForFscStatisticalAbilityReqBO orderReqBO = new PebExtOrderForFscStatisticalAbilityReqBO();
        orderReqBO.setOrderId(reqBO.getOrderId());
        Integer num = 1;
        PebExtOrderForFscStatisticalAbilityRspBO orderRspBO = this.pebExtOrderForFscStatisticalAbilityService.qryOrderForFscStatistical(orderReqBO);
        if (!orderRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(orderRspBO.getRespCode(), orderRspBO.getRespDesc());
        }
        BeanUtils.copyProperties((Object)orderRspBO, (Object)((Object)rspBO));
        ArrayList<FscForOrderStatisticalShipBO> shipList = new ArrayList<FscForOrderStatisticalShipBO>();
        if (!CollectionUtils.isEmpty((Collection)orderRspBO.getArrivalList())) {
            for (PebExtOrderForFscStatisticalArrivalBO arrivalBO : orderRspBO.getArrivalList()) {
                FscForOrderStatisticalShipBO shipBO = new FscForOrderStatisticalShipBO();
                BeanUtils.copyProperties((Object)arrivalBO, (Object)shipBO);
                shipList.add(shipBO);
            }
            num = shipList.size();
        }
        rspBO.setShipList(shipList);
        ArrayList<FscForOrderStatisticalInvoiceBO> invoiceList = new ArrayList<FscForOrderStatisticalInvoiceBO>();
        if (!CollectionUtils.isEmpty((Collection)orderRspBO.getInspectionList())) {
            FscForOrderStatisticalInvoiceBO invoiceBO;
            num = this.comparison(num, orderRspBO.getInspectionList().size());
            HashMap<Long, Object> invoiceMap = new HashMap<Long, Object>(orderRspBO.getInspectionList().size());
            ArrayList<Long> inspectionVoucherIds = new ArrayList<Long>(orderRspBO.getInspectionList().size());
            for (PebExtOrderForFscStatisticalInspectionBO inspectionBO : orderRspBO.getInspectionList()) {
                inspectionVoucherIds.add(inspectionBO.getInspectionVoucherId());
                FscForOrderStatisticalInvoiceBO invoiceBO2 = new FscForOrderStatisticalInvoiceBO();
                BeanUtils.copyProperties((Object)inspectionBO, (Object)invoiceBO2);
                invoiceMap.put(inspectionBO.getInspectionVoucherId(), invoiceBO2);
            }
            FscOrderPO querVo = new FscOrderPO();
            querVo.setReceiveType(FscConstants.FscOrderReceiveType.OPERATION);
            querVo.setOrderIds(inspectionVoucherIds);
            List orderInvoiceList = this.fscOrderMapper.getInvoiceStatistical(querVo);
            for (FscOrderPO fscOrderPO : orderInvoiceList) {
                invoiceBO = (FscForOrderStatisticalInvoiceBO)invoiceMap.get(fscOrderPO.getAcceptOrderId());
                invoiceBO.setUpDealTime(fscOrderPO.getCreateTime());
                invoiceBO.setUpFscOrderNo(fscOrderPO.getOrderNo());
                invoiceBO.setUpInvoiceAmt(fscOrderPO.getInvoiceAmt());
                invoiceBO.setUpOrderAmt(fscOrderPO.getOrderAmt());
                invoiceBO.setUpTotalCharge(fscOrderPO.getTotalCharge());
            }
            querVo.setReceiveType(FscConstants.FscOrderReceiveType.PURCHASE);
            orderInvoiceList = this.fscOrderMapper.getInvoiceStatistical(querVo);
            for (FscOrderPO fscOrderPO : orderInvoiceList) {
                invoiceBO = (FscForOrderStatisticalInvoiceBO)invoiceMap.get(fscOrderPO.getAcceptOrderId());
                invoiceBO.setDownDealTime(fscOrderPO.getCreateTime());
                invoiceBO.setDownFscOrderNo(fscOrderPO.getOrderNo());
                invoiceBO.setDownInvoiceAmt(fscOrderPO.getInvoiceAmt());
                invoiceBO.setDownOrderAmt(fscOrderPO.getOrderAmt());
                invoiceBO.setDownTotalCharge(fscOrderPO.getTotalCharge());
            }
            for (Long key : invoiceMap.keySet()) {
                invoiceList.add((FscForOrderStatisticalInvoiceBO)invoiceMap.get(key));
            }
        }
        rspBO.setInvoiceList(invoiceList);
        ArrayList<FscForOrderStatisticalPayBO> payList = new ArrayList<FscForOrderStatisticalPayBO>();
        List payOrderList = this.fscOrderMapper.getPayStatisticalInfo(orderRspBO.getOrderId(), this.operationOrgId);
        for (FscOrderPO fscOrderPO : payOrderList) {
            FscForOrderStatisticalPayBO payBO = new FscForOrderStatisticalPayBO();
            BeanUtils.copyProperties((Object)fscOrderPO, (Object)payBO);
            payList.add(payBO);
        }
        num = this.comparison(num, payList.size());
        rspBO.setPayList(payList);
        ArrayList<FscForOrderStatisticalClaimBO> claimList = new ArrayList<FscForOrderStatisticalClaimBO>();
        List claimDetailList = this.fscClaimDetailMapper.getClaimStatisticalInfo(orderRspBO.getOrderId());
        for (FscClaimDetailPO fscClaimDetailPO : claimDetailList) {
            FscForOrderStatisticalClaimBO claimBO = new FscForOrderStatisticalClaimBO();
            BeanUtils.copyProperties((Object)fscClaimDetailPO, (Object)claimBO);
            claimList.add(claimBO);
        }
        num = this.comparison(num, claimList.size());
        rspBO.setClaimList(claimList);
        rspBO.setMergeTotalNum(num);
        rspBO.setMergeShipNum(num - rspBO.getShipList().size() + 1);
        rspBO.setMergeInvoiceNum(num - rspBO.getInvoiceList().size() + 1);
        rspBO.setMergePayNum(num - payList.size() + 1);
        rspBO.setMergeClaimNum(num - claimList.size() + 1);
        rspBO.setAbortTime(new Date());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private Integer comparison(Integer old, Integer news) {
        return old > news ? old : news;
    }
}

